/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.types;

import org.apache.axis.utils.Messages;

public class Duration {
    boolean isNegative = false;
    int years;
    int months;
    int days;
    int hours;
    int minutes;
    double seconds;

    public Duration() {
    }

    public Duration(boolean negative, int aYears, int aMonths, int aDays, int aHours, int aMinutes, double aSeconds) {
        this.isNegative = negative;
        this.years = aYears;
        this.months = aMonths;
        this.days = aDays;
        this.hours = aHours;
        this.minutes = aMinutes;
        this.seconds = aSeconds;
    }

    public Duration(String duration) throws IllegalArgumentException {
        int position = 1;
        int timePosition = duration.indexOf("T");
        if (duration.indexOf("P") == -1) {
            throw new IllegalArgumentException(Messages.getMessage("badDuration"));
        }
        if (duration.startsWith("-")) {
            this.isNegative = true;
            ++position;
        }
        if (timePosition != -1) {
            this.parseTime(duration.substring(timePosition + 1));
        } else {
            timePosition = duration.length();
        }
        this.parseDate(duration.substring(position, timePosition));
    }

    public void parseTime(String time) {
        int start = 0;
        int end = time.indexOf("H");
        if (end != -1) {
            this.hours = Integer.parseInt(time.substring(0, end));
            start = end + 1;
        }
        if ((end = time.indexOf("M")) != -1) {
            this.minutes = Integer.parseInt(time.substring(start, end));
            start = end + 1;
        }
        if ((end = time.indexOf("S")) != -1) {
            this.seconds = Double.parseDouble(time.substring(start, end));
        }
    }

    public void parseDate(String date) {
        int start = 0;
        int end = date.indexOf("Y");
        if (end != -1) {
            this.years = Integer.parseInt(date.substring(0, end));
            start = end + 1;
        }
        if ((end = date.indexOf("M")) != -1) {
            this.months = Integer.parseInt(date.substring(start, end));
            start = end + 1;
        }
        if ((end = date.indexOf("D")) != -1) {
            this.days = Integer.parseInt(date.substring(start, end));
        }
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public void setNegative(boolean negative) {
        this.isNegative = negative;
    }

    public void setYears(int years) {
        this.years = years;
    }

    public void setMonths(int months) {
        this.months = months;
    }

    public void setDays(int days) {
        this.days = days;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public String toString() {
        StringBuffer duration = new StringBuffer();
        duration.append("P");
        if (this.years != 0) {
            duration.append(this.years + "Y");
        }
        if (this.months != 0) {
            duration.append(this.months + "M");
        }
        if (this.days != 0) {
            duration.append(this.days + "D");
        }
        if (this.hours != 0 || this.minutes != 0 || this.seconds != 0.0) {
            duration.append("T");
            if (this.hours != 0) {
                duration.append(this.hours + "H");
            }
            if (this.minutes != 0) {
                duration.append(this.minutes + "M");
            }
            if (this.seconds != 0.0) {
                if (this.seconds == (double)((int)this.seconds)) {
                    duration.append((int)this.seconds + "S");
                } else {
                    duration.append(this.seconds + "S");
                }
            }
        }
        if (duration.length() == 1) {
            duration.append("T0S");
        }
        if (this.isNegative) {
            duration.insert(0, "-");
        }
        return duration.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Duration)) {
            return false;
        }
        Duration duration = (Duration)object;
        int totalMonthsInTime = this.years * 12 + this.months;
        int totalMonthsToCompare = duration.years * 12 + duration.months;
        double totalSecondsInTime = (double)(((this.days * 24 + this.hours) * 60 + this.minutes) * 60) + this.seconds;
        double totalSecondsToCompare = (double)(((duration.days * 24 + duration.hours) * 60 + duration.minutes) * 60) + duration.seconds;
        return this.isNegative == duration.isNegative && totalMonthsInTime == totalMonthsToCompare && totalSecondsInTime == totalSecondsToCompare;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.isNegative) {
            ++hashCode;
        }
        hashCode += this.years;
        hashCode += this.months;
        hashCode += this.days;
        hashCode += this.hours;
        hashCode += this.minutes;
        hashCode = (int)((double)hashCode + this.seconds);
        return hashCode;
    }
}

