/*
 * Decompiled with CFR 0.152.
 */
package com.actional.axis;

import com.actional.APICredential;
import com.actional.APIException;
import com.actional.APISession;
import com.actional.APISessionHandler;
import com.actional.APISessionHandlerFactory;
import com.actional.BaseUtil;
import com.actional.CallContext;
import com.actional.CommonSettings;
import com.actional.ConnectionException;
import com.actional.axis.Constants;
import com.actional.axis.WSDDgen;
import com.actional.catalog.ApplicationMessages;
import com.actional.catalog.SoapMessages;
import com.actional.util.Cache;
import com.actional.util.ICacheEvents;
import com.actional.util.IResource;
import com.actional.util.IResourcePoolEvents;
import com.actional.util.Resource;
import com.actional.util.ResourcePool;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.client.AxisClient;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.client.Transport;
import org.apache.axis.configuration.EngineConfigurationFactoryFinder;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.SOAPHeaderElement;

public class AxisClientSession
implements APISessionHandlerFactory,
Constants {
    private static HashMap itsServices = new HashMap();
    private static final String itsURLPrefix;
    private static HashSet itsSpecializedExceptions;
    private APICredential itsCredentials;
    private String itsURL;
    private boolean itMustLeaveURLIntact;

    public AxisClientSession(String string, APICredential aPICredential) throws APIException {
        this.itsCredentials = aPICredential;
        this.itsURL = string;
        if (this.itsURL.endsWith("@@@")) {
            this.itMustLeaveURLIntact = true;
            this.itsURL = this.itsURL.substring(0, this.itsURL.length() - "@@@".length());
        } else {
            this.itsURL = this.itsURL.endsWith("/") ? this.itsURL + itsURLPrefix : this.itsURL + "/" + itsURLPrefix;
        }
    }

    public void close() throws APIException {
    }

    public Object create(APISession aPISession, Class clazz) throws APIException {
        return new Stub(clazz);
    }

    static {
        itsSpecializedExceptions = new HashSet();
        String string = System.getProperty("com.actional.axis.AxisClientSession.urlPrefix", "api");
        if (string.startsWith("/")) {
            string = string.length() == 1 ? "" : string.substring(1);
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        itsURLPrefix = string;
        itsSpecializedExceptions.add(ConnectException.class);
        itsSpecializedExceptions.add(NoRouteToHostException.class);
        itsSpecializedExceptions.add(SocketTimeoutException.class);
        itsSpecializedExceptions.add(SocketException.class);
    }

    static class AxisJmsTransport
    extends Transport {
        AxisJmsTransport() {
            this.transportName = "jms";
        }
    }

    static class CallResource
    extends Resource {
        Call itsCall;

        public CallResource(ResourcePool resourcePool, Call call) {
            super(resourcePool);
            this.itsCall = call;
        }

        public Call getCall() throws IOException {
            return this.itsCall;
        }
    }

    static class AxisService
    extends Service {
        static volatile AxisClient TheAxisClient;
        static volatile InputStream TheInputStream;
        SOAPService itsSoapService;

        public AxisService(String string) throws APIException {
            super(new QName(string));
            try {
                this.itsSoapService = this.getEngine().getService(string);
                if (this.itsSoapService == null) {
                    throw new APIException(SoapMessages.UNSUPPORTED_REMOTE_INTERFACE, new Object[]{string});
                }
            }
            catch (AxisFault axisFault) {
                throw new APIException(SoapMessages.UNSUPPORTED_REMOTE_INTERFACE, new Object[]{new Object[]{string}, axisFault});
            }
        }

        public SOAPService getSoapService() {
            return this.itsSoapService;
        }

        public ServiceDesc getServiceDesc() {
            return this.itsSoapService.getServiceDescription();
        }

        @Override
        protected AxisClient getAxisClient() {
            return AxisService._getAxisClient();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static AxisClient _getAxisClient() {
            AxisClient axisClient = TheAxisClient;
            if (axisClient != null) {
                return axisClient;
            }
            Class<AxisService> clazz = AxisService.class;
            synchronized (AxisService.class) {
                axisClient = TheAxisClient;
                if (axisClient != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return axisClient;
                }
                if (TheInputStream == null) {
                    axisClient = new AxisClient(EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig());
                } else {
                    axisClient = new AxisClient(new FileProvider(TheInputStream));
                    TheInputStream = null;
                }
                TheAxisClient = axisClient;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return axisClient;
            }
        }
    }

    class Stub
    extends Cache
    implements ICacheEvents,
    APISessionHandler {
        AxisService itsService;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Stub(Class clazz) throws APIException {
            super(null);
            this.itsEvents = this;
            String string = WSDDgen._getShortClassName(clazz);
            HashMap hashMap = itsServices;
            synchronized (hashMap) {
                this.itsService = (AxisService)itsServices.get(clazz);
                if (this.itsService == null) {
                    this.itsService = new AxisService(string);
                    itsServices.put(clazz, this.itsService);
                }
            }
        }

        public Object invoke(APISessionHandler.Context context) throws Throwable {
            Method method = context.getMethod();
            Object[] objectArray = context.getArgs();
            String string = AxisClientSession.this.itsURL;
            CallPool callPool = (CallPool)((Object)this.lookup(method));
            CallResource callResource = (CallResource)callPool.acquire();
            try {
                Object[] objectArray2;
                Call call = callResource.getCall();
                string = (String)call.getProperty("com.actional.targetEndpoint");
                call.clearHeaders();
                if (BaseUtil.length((Object[])objectArray) > 0 && objectArray[0] instanceof CallContext) {
                    objectArray2 = ((CallContext)objectArray[0])._getAllHeaders();
                    int n = BaseUtil.length((Object[])objectArray2);
                    for (int i = 0; i < n; ++i) {
                        Object object = objectArray2[i];
                        call.addHeader(new SOAPHeaderElement(((CallContext.Header)object).itsXmlns, ((CallContext.Header)object).itsLocalName, ((CallContext.Header)object).itsValue));
                    }
                }
                Object[] objectArray3 = objectArray2 = call.invoke(objectArray);
                return objectArray3;
            }
            catch (AxisFault axisFault) {
                throw this.processInvokeAxisFault(method, axisFault, string);
            }
            finally {
                callResource.release();
            }
        }

        private Throwable processInvokeAxisFault(Method method, AxisFault axisFault, String string) {
            Throwable throwable = axisFault.getCause();
            if (throwable != null && itsSpecializedExceptions.contains(throwable.getClass())) {
                return new ConnectionException(string, throwable);
            }
            return axisFault;
        }

        public Object getKey(Object object) {
            return ((Method)object).getName();
        }

        public Object createCacheItem(Object object) throws APIException {
            return new CallPool((Method)object);
        }

        public void releaseCacheItem(Object object) {
            ResourcePool resourcePool = (ResourcePool)object;
            try {
                resourcePool.terminate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public boolean canReleaseCacheItem(Object object) {
            ResourcePool resourcePool = (ResourcePool)object;
            return !resourcePool.hasResourcesInUse();
        }

        class CallPool
        extends ResourcePool
        implements IResourcePoolEvents {
            Method itsMethod;
            Integer itsTimeout;

            public CallPool(Method method) {
                super(null, 60000L);
                this.setEventHandler(this);
                this.itsMethod = method;
                this.itsTimeout = "ping".equals(this.itsMethod.getName()) ? Integer.valueOf(CommonSettings.PING_TIMEOUT._getValue()) : Integer.valueOf(CommonSettings.CALL_TIMEOUT._getValue());
            }

            public IResource create() throws APIException {
                Serializable serializable;
                QName qName;
                Call call;
                try {
                    call = (Call)Stub.this.itsService.createCall();
                }
                catch (ServiceException serviceException) {
                    throw new APIException(ApplicationMessages.SERVICE_EX, new Object[]{serviceException});
                }
                String string = AxisClientSession.this.itsURL;
                if (!AxisClientSession.this.itMustLeaveURLIntact) {
                    string = string + Stub.this.itsService.getServiceName().getLocalPart() + ".aapi";
                }
                call.setProperty("com.actional.targetEndpoint", string);
                if (string.startsWith("jms://")) {
                    call.setTransport(new AxisJmsTransport());
                } else {
                    try {
                        call.setTargetEndpointAddress(new URL(string));
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new APIException(ApplicationMessages.MALFORMED_URL_EX, new Object[]{new Object[]{string}, malformedURLException});
                    }
                }
                call.setSOAPService(Stub.this.itsService.getSoapService());
                call.setTimeout(this.itsTimeout);
                if (AxisClientSession.this.itsCredentials != null) {
                    call.setProperty("javax.xml.rpc.security.auth.username", AxisClientSession.this.itsCredentials.getUser());
                    call.setProperty("javax.xml.rpc.security.auth.password", AxisClientSession.this.itsCredentials.getPassword());
                }
                String string2 = this.itsMethod.getName();
                String string3 = WSDDgen._getXmlns(this.itsMethod.getDeclaringClass(), true);
                ServiceDesc serviceDesc = Stub.this.itsService.getServiceDesc();
                OperationDesc operationDesc = serviceDesc.getOperationByElementQName(qName = new QName(string3, string2));
                if (operationDesc == null) {
                    throw new APIException(SoapMessages.INVALID_METHOD, new Object[]{string2, serviceDesc.getName()});
                }
                ArrayList arrayList = operationDesc.getParameters();
                int n = arrayList.size();
                TypeMapping typeMapping = call.getTypeMapping();
                call.removeAllParameters();
                call.setOperationName(qName);
                for (int i = 0; i < n; ++i) {
                    serializable = (ParameterDesc)arrayList.get(i);
                    QName qName2 = ((ParameterDesc)serializable).getTypeQName();
                    Class<?> clazz = ((ParameterDesc)serializable).getJavaType();
                    if (clazz == null) {
                        clazz = this.itsMethod.getParameterTypes()[i];
                    }
                    if (qName2 == null) {
                        qName2 = typeMapping.getTypeQName(clazz);
                    }
                    call.addParameter(((ParameterDesc)serializable).getQName(), qName2, clazz, ParameterMode.IN);
                }
                QName qName3 = operationDesc.getReturnType();
                serializable = operationDesc.getReturnClass();
                if (serializable == null) {
                    serializable = this.itsMethod.getReturnType();
                }
                if (qName3 == null) {
                    qName3 = typeMapping.getTypeQName((Class)serializable);
                }
                if (qName3 == null && Void.TYPE.equals(serializable)) {
                    qName3 = XMLType.AXIS_VOID;
                }
                call.setReturnType(qName3, (Class)serializable);
                call.setReturnQName(operationDesc.getReturnQName());
                return new CallResource(this, call);
            }

            public void allResourcesAreUnused() {
            }

            public void allResourcesAreClosed() {
            }
        }
    }
}

