/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.apache.axis.AxisFault;
import org.apache.axis.Part;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.BoundaryDelimitedStream;
import org.apache.axis.attachments.ManagedMemoryDataSource;
import org.apache.axis.attachments.MultiPartInputStream;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.IOUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class MultiPartRelatedInputStream
extends MultiPartInputStream {
    private static final Log LOGGER = LogFactory.getLog(MultiPartRelatedInputStream.class.getName());
    public static final String MIME_MULTIPART_RELATED = "multipart/related";
    protected Map parts = new HashMap();
    protected List orderedParts = new LinkedList();
    protected int rootPartLength = 0;
    protected boolean closed = false;
    protected boolean eos = false;
    protected BoundaryDelimitedStream boundaryDelimitedStream = null;
    protected InputStream soapStream = null;
    protected InputStream soapStreamBDS = null;
    protected byte[] boundary = null;
    protected ByteArrayInputStream cachedSOAPEnvelope = null;
    protected String contentLocation = null;
    protected String contentId = null;
    private static final String[] NON_MATCHING_HEADERS = new String[]{"Content-Id", "Content-Location", "Content-Type"};
    private static final String[] READ_ALL = new String[]{" * \u0000 ".intern()};

    public MultiPartRelatedInputStream(String string, InputStream inputStream) throws AxisFault {
        super(null);
        try {
            Object object;
            ContentType contentType = new ContentType(string);
            String string2 = contentType.getParameter("start");
            if (string2 != null) {
                if ((string2 = string2.trim()).startsWith("<")) {
                    string2 = string2.substring(1);
                }
                if (string2.endsWith(">")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
            }
            if (contentType.getParameter("boundary") != null) {
                String string3 = "--" + contentType.getParameter("boundary");
                object = new byte[2][string3.length() + 2];
                IOUtils.readFully(inputStream, object[0]);
                this.boundary = (string3 + "\r\n").getBytes("US-ASCII");
                int n = 0;
                boolean bl = false;
                while (!bl) {
                    bl = Arrays.equals(object[n & 1], this.boundary);
                    if (!bl) {
                        System.arraycopy(object[n & 1], 1, object[n + 1 & 1], 0, object[0].length - 1);
                        if (inputStream.read(object[n + 1 & 1], object[0].length - 1, 1) < 1) {
                            throw new AxisFault(Messages.getMessage("mimeErrorNoBoundary", new String(this.boundary)));
                        }
                    }
                    ++n;
                }
                string3 = "\r\n" + string3;
                this.boundary = string3.getBytes("US-ASCII");
            } else {
                boolean bl = false;
                while (!bl) {
                    this.boundary = this.readLine(inputStream);
                    if (this.boundary == null) {
                        throw new AxisFault(Messages.getMessage("mimeErrorNoBoundary", "--"));
                    }
                    bl = this.boundary.length > 4 && this.boundary[2] == 45 && this.boundary[3] == 45;
                }
            }
            this.boundaryDelimitedStream = new BoundaryDelimitedStream(inputStream, this.boundary, 1024);
            String string4 = null;
            do {
                this.contentId = null;
                this.contentLocation = null;
                string4 = null;
                object = new InternetHeaders((InputStream)this.boundaryDelimitedStream);
                this.contentId = object.getHeader("Content-Id", null);
                if (this.contentId != null) {
                    this.contentId = this.contentId.trim();
                    if (this.contentId.startsWith("<")) {
                        this.contentId = this.contentId.substring(1);
                    }
                    if (this.contentId.endsWith(">")) {
                        this.contentId = this.contentId.substring(0, this.contentId.length() - 1);
                    }
                    this.contentId = this.contentId.trim();
                }
                this.contentLocation = object.getHeader("Content-Location", null);
                if (this.contentLocation != null) {
                    this.contentLocation = this.contentLocation.trim();
                    if (this.contentLocation.startsWith("<")) {
                        this.contentLocation = this.contentLocation.substring(1);
                    }
                    if (this.contentLocation.endsWith(">")) {
                        this.contentLocation = this.contentLocation.substring(0, this.contentLocation.length() - 1);
                    }
                    this.contentLocation = this.contentLocation.trim();
                }
                if ((string = object.getHeader("Content-Type", null)) != null) {
                    string = string.trim();
                }
                if ((string4 = object.getHeader("Content-Transfer-Encoding", null)) != null) {
                    string4 = string4.trim();
                }
                InputStream inputStream2 = this.boundaryDelimitedStream;
                if (string4 != null && 0 != string4.length()) {
                    inputStream2 = MimeUtility.decode((InputStream)inputStream2, (String)string4);
                }
                if (string2 == null || string2.equals(this.contentId)) continue;
                DataHandler dataHandler = new DataHandler((DataSource)new ManagedMemoryDataSource(inputStream2, ManagedMemoryDataSource.MAX_CACHED_DEFAULT, string, true));
                AttachmentPart attachmentPart = new AttachmentPart(dataHandler);
                if (this.contentId != null) {
                    attachmentPart.setMimeHeader("Content-Id", this.contentId);
                }
                if (this.contentLocation != null) {
                    attachmentPart.setMimeHeader("Content-Location", this.contentLocation);
                }
                Enumeration enumeration = object.getNonMatchingHeaders(NON_MATCHING_HEADERS);
                while (enumeration.hasMoreElements()) {
                    Header header = (Header)enumeration.nextElement();
                    String string5 = header.getName();
                    String string6 = header.getValue();
                    if (string5 == null || string6 == null || (string5 = string5.trim()).length() == 0) continue;
                    attachmentPart.addMimeHeader(string5, string6);
                }
                this.addPart(this.contentId, this.contentLocation, attachmentPart);
                this.boundaryDelimitedStream = this.boundaryDelimitedStream.getNextStream();
            } while (null != this.boundaryDelimitedStream && string2 != null && !string2.equals(this.contentId));
            if (this.boundaryDelimitedStream == null) {
                throw new AxisFault(Messages.getMessage("noRoot", string2));
            }
            this.soapStreamBDS = this.boundaryDelimitedStream;
            this.soapStream = string4 != null && 0 != string4.length() ? MimeUtility.decode((InputStream)this.boundaryDelimitedStream, (String)string4) : this.boundaryDelimitedStream;
        }
        catch (ParseException parseException) {
            throw new AxisFault(Messages.getMessage("mimeErrorParsing", parseException.getMessage()));
        }
        catch (IOException iOException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Constructing MultiPartRelatedInputStream failed.", (Throwable)iOException);
            }
            throw new AxisFault(Messages.getMessage("readError", iOException.getMessage()));
        }
        catch (MessagingException messagingException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Constructing MultiPartRelatedInputStream failed.", (Throwable)messagingException);
            }
            throw new AxisFault(Messages.getMessage("readError", messagingException.getMessage()));
        }
    }

    private final byte[] readLine(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byteArrayOutputStream.write(13);
        byteArrayOutputStream.write(10);
        int n = 0;
        int n2 = -1;
        block4: while (n != -1) {
            n = -1 != n2 ? n2 : inputStream.read();
            n2 = -1;
            switch (n) {
                case -1: {
                    continue block4;
                }
                case 13: {
                    n2 = inputStream.read();
                    if (n2 == 10) {
                        return byteArrayOutputStream.toByteArray();
                    }
                    if (n2 != -1) break;
                    return null;
                }
            }
            byteArrayOutputStream.write((byte)n);
        }
        return null;
    }

    @Override
    public Part getAttachmentByReference(String[] stringArray) throws AxisFault {
        Part part = null;
        for (int i = stringArray.length - 1; part == null && i > -1; --i) {
            part = (AttachmentPart)this.parts.get(stringArray[i]);
        }
        if (null == part) {
            part = this.readTillFound(stringArray);
        }
        LOGGER.debug((Object)Messages.getMessage("return02", "getAttachmentByReference(\"" + stringArray + "\"", part == null ? "null" : part.toString()));
        return part;
    }

    protected void addPart(String string, String string2, AttachmentPart attachmentPart) {
        if (string != null && string.trim().length() != 0) {
            this.parts.put(string, attachmentPart);
        }
        if (string2 != null && string2.trim().length() != 0) {
            this.parts.put(string2, attachmentPart);
        }
        this.orderedParts.add(attachmentPart);
    }

    protected void readAll() throws AxisFault {
        this.readTillFound(READ_ALL);
    }

    @Override
    public Collection getAttachments() throws AxisFault {
        this.readAll();
        return this.orderedParts;
    }

    protected Part readTillFound(String[] stringArray) throws AxisFault {
        if (this.boundaryDelimitedStream == null) {
            return null;
        }
        AttachmentPart attachmentPart = null;
        try {
            Object object;
            Object object2;
            if (this.soapStreamBDS == this.boundaryDelimitedStream) {
                if (!this.eos) {
                    object2 = new ByteArrayOutputStream(8192);
                    object = new byte[16384];
                    int n = 0;
                    do {
                        if ((n = this.soapStream.read((byte[])object)) <= 0) continue;
                        ((ByteArrayOutputStream)object2).write((byte[])object, 0, n);
                    } while (n > -1);
                    ((ByteArrayOutputStream)object2).close();
                    this.soapStream = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
                }
                this.boundaryDelimitedStream = this.boundaryDelimitedStream.getNextStream();
            }
            if (null != this.boundaryDelimitedStream) {
                do {
                    object2 = null;
                    object = null;
                    String string = null;
                    String string2 = null;
                    InternetHeaders internetHeaders = new InternetHeaders((InputStream)this.boundaryDelimitedStream);
                    object = internetHeaders.getHeader("Content-Id", null);
                    if (object != null) {
                        if (((String)(object = ((String)object).trim())).startsWith("<")) {
                            object = ((String)object).substring(1);
                        }
                        if (((String)object).endsWith(">")) {
                            object = ((String)object).substring(0, ((String)object).length() - 1);
                        }
                        object = ((String)object).trim();
                    }
                    if ((object2 = internetHeaders.getHeader("Content-Type", null)) != null) {
                        object2 = ((String)object2).trim();
                    }
                    if ((string2 = internetHeaders.getHeader("Content-Location", null)) != null) {
                        string2 = string2.trim();
                    }
                    if ((string = internetHeaders.getHeader("Content-Transfer-Encoding", null)) != null) {
                        string = string.trim();
                    }
                    InputStream inputStream = this.boundaryDelimitedStream;
                    if (string != null && 0 != string.length()) {
                        inputStream = MimeUtility.decode((InputStream)inputStream, (String)string);
                    }
                    ManagedMemoryDataSource managedMemoryDataSource = new ManagedMemoryDataSource(inputStream, ManagedMemoryDataSource.MAX_CACHED_DEFAULT, (String)object2, true);
                    DataHandler dataHandler = new DataHandler((DataSource)managedMemoryDataSource);
                    AttachmentPart attachmentPart2 = new AttachmentPart(dataHandler);
                    if (object != null) {
                        attachmentPart2.setMimeHeader("Content-Id", (String)object);
                    }
                    if (string2 != null) {
                        attachmentPart2.setMimeHeader("Content-Location", string2);
                    }
                    Enumeration enumeration = internetHeaders.getNonMatchingHeaders(NON_MATCHING_HEADERS);
                    while (enumeration.hasMoreElements()) {
                        Header header = (Header)enumeration.nextElement();
                        String string3 = header.getName();
                        String string4 = header.getValue();
                        if (string3 == null || string4 == null || (string3 = string3.trim()).length() == 0) continue;
                        attachmentPart2.addMimeHeader(string3, string4);
                    }
                    this.addPart((String)object, string2, attachmentPart2);
                    for (int i = stringArray.length - 1; attachmentPart == null && i > -1; --i) {
                        if (object != null && stringArray[i].equals(object)) {
                            attachmentPart = attachmentPart2;
                            continue;
                        }
                        if (string2 == null || !stringArray[i].equals(string2)) continue;
                        attachmentPart = attachmentPart2;
                    }
                    this.boundaryDelimitedStream = this.boundaryDelimitedStream.getNextStream();
                } while (null == attachmentPart && null != this.boundaryDelimitedStream);
            }
        }
        catch (Exception exception) {
            throw AxisFault.makeFault(exception);
        }
        return attachmentPart;
    }

    @Override
    public String getContentLocation() {
        return this.contentLocation;
    }

    @Override
    public String getContentId() {
        return this.contentId;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException(Messages.getMessage("streamClosed"));
        }
        if (this.eos) {
            return -1;
        }
        int n3 = this.soapStream.read(byArray, n, n2);
        if (n3 < 0) {
            this.eos = true;
        }
        return n3;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(Messages.getMessage("streamClosed"));
        }
        if (this.eos) {
            return -1;
        }
        int n = this.soapStream.read();
        if (n < 0) {
            this.eos = true;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.soapStream.close();
    }

    @Override
    public int available() throws IOException {
        return this.closed || this.eos ? 0 : this.soapStream.available();
    }
}

