/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.holders.QNameHolder;
import org.apache.axis.AxisEngine;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.SimpleValueSerializer;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingImpl;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.enum.Style;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.schema.SchemaVersion;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.types.HexBinary;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Mapping;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.NSStack;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SerializationContextImpl
implements SerializationContext {
    private static final Log LOGGER = LogFactory.getLog(SerializationContextImpl.class.getName());
    private NSStack nsStack = new NSStack();
    private boolean writingStartTag = false;
    private boolean onlyXML = true;
    private int indent = 0;
    private boolean startOfDocument = true;
    private Stack elementStack = new Stack();
    private Writer writer;
    private int lastPrefixIndex = 1;
    private MessageContext msgContext;
    private QName currentXMLType;
    private SOAPConstants soapConstants = SOAPConstants.SOAP11_CONSTANTS;
    private boolean pretty = false;
    private static QName multirefQName = new QName("", "multiRef");
    private boolean doMultiRefs = false;
    private boolean sendXMLDecl = true;
    private boolean sendXSIType = true;
    private Map multiRefValues = null;
    private int multiRefIndex = -1;
    private Set secondLevelObjects = null;
    private Object forceSer = null;
    private boolean outputMultiRefsFlag = false;
    SchemaVersion schemaVersion = SchemaVersion.SCHEMA_2001;
    Map preferredPrefixes = new HashMap();

    public SerializationContextImpl(Writer writer) {
        this.writer = writer;
        this.initialize();
    }

    private void initialize() {
        this.preferredPrefixes.put(this.soapConstants.getEncodingURI(), "soapenc");
        this.preferredPrefixes.put("http://www.w3.org/XML/1998/namespace", "xml");
        this.preferredPrefixes.put(this.schemaVersion.getXsdURI(), "xsd");
        this.preferredPrefixes.put(this.schemaVersion.getXsiURI(), "xsi");
    }

    public SerializationContextImpl(Writer writer, MessageContext messageContext) {
        this.writer = writer;
        this.msgContext = messageContext;
        AxisEngine axisEngine = null;
        if (messageContext != null) {
            SOAPService sOAPService;
            Boolean bl;
            Boolean bl2;
            this.soapConstants = messageContext.getSOAPConstants();
            if (axisEngine == null) {
                axisEngine = messageContext.getAxisEngine();
            }
            this.schemaVersion = messageContext.getSchemaVersion();
            Boolean bl3 = (Boolean)axisEngine.getOption("sendXMLDeclaration");
            if (bl3 != null) {
                this.sendXMLDecl = bl3;
            }
            if ((bl2 = (Boolean)messageContext.getProperty("sendMultiRefs")) == null) {
                bl2 = (Boolean)axisEngine.getOption("sendMultiRefs");
            }
            if (bl2 != null) {
                this.doMultiRefs = bl2;
            }
            if (!messageContext.isPropertyTrue("send_type_attr", true)) {
                this.sendXSIType = false;
            }
            if ((bl = (Boolean)axisEngine.getOption("sendXsiTypes")) != null && bl.equals(Boolean.FALSE)) {
                this.sendXSIType = false;
            }
            if ((sOAPService = messageContext.getService()) != null && sOAPService.getStyle() != Style.RPC) {
                this.sendXSIType = false;
                this.doMultiRefs = false;
            }
        }
        this.initialize();
    }

    @Override
    public boolean getPretty() {
        return this.pretty;
    }

    @Override
    public void setPretty(boolean bl) {
        this.pretty = bl;
    }

    @Override
    public void setDoMultiRefs(boolean bl) {
        this.doMultiRefs = bl;
    }

    @Override
    public void setSendDecl(boolean bl) {
        this.sendXMLDecl = bl;
    }

    @Override
    public boolean shouldSendXSIType() {
        return this.sendXSIType;
    }

    @Override
    public TypeMapping getTypeMapping() {
        if (this.msgContext == null) {
            return DefaultTypeMappingImpl.getSingleton();
        }
        String string = this.msgContext.getEncodingStyle();
        if (string == null) {
            string = this.soapConstants.getEncodingURI();
        }
        return (TypeMapping)this.msgContext.getTypeMappingRegistry().getTypeMapping(string);
    }

    @Override
    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getTypeMappingRegistry();
    }

    @Override
    public String getPrefixForURI(String string) {
        return this.getPrefixForURI(string, null, false);
    }

    @Override
    public String getPrefixForURI(String string, String string2) {
        return this.getPrefixForURI(string, string2, false);
    }

    public String getPrefixForURI(String string, String string2, boolean bl) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string3 = this.nsStack.getPrefix(string, bl);
        if (string3 == null) {
            string3 = (String)this.preferredPrefixes.get(string);
            if (string3 == null) {
                string3 = string2 == null ? "ns" + this.lastPrefixIndex++ : string2;
            }
            this.registerPrefixForURI(string3, string);
        }
        return string3;
    }

    @Override
    public void registerPrefixForURI(String string, String string2) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)Messages.getMessage("register00", string, string2));
        }
        if (string2 != null && string != null) {
            this.nsStack.add(string2, string);
        }
    }

    @Override
    public Message getCurrentMessage() {
        if (this.msgContext == null) {
            return null;
        }
        return this.msgContext.getCurrentMessage();
    }

    @Override
    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public String qName2String(QName qName, boolean bl) {
        CharSequence charSequence;
        String string = null;
        String string2 = qName.getNamespaceURI();
        if (string2.length() == 0) {
            if (bl && (charSequence = this.nsStack.getNamespaceURI("")) != null && ((String)charSequence).length() > 0) {
                this.registerPrefixForURI("", "");
            }
        } else {
            string = this.getPrefixForURI(string2);
        }
        if (string == null || string.length() == 0) {
            return qName.getLocalPart();
        }
        charSequence = new StringBuilder(string);
        ((StringBuilder)charSequence).append(':');
        ((StringBuilder)charSequence).append(qName.getLocalPart());
        return ((StringBuilder)charSequence).toString();
    }

    @Override
    public String qName2String(QName qName) {
        return this.qName2String(qName, false);
    }

    @Override
    public String attributeQName2String(QName qName) {
        String string = null;
        if (qName.getNamespaceURI().length() > 0) {
            string = this.getPrefixForURI(qName.getNamespaceURI(), null, true);
        }
        if (string == null || string.length() == 0) {
            return qName.getLocalPart();
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(':');
        stringBuilder.append(qName.getLocalPart());
        return stringBuilder.toString();
    }

    @Override
    public QName getQNameForClass(Class clazz) {
        return this.getTypeMapping().getTypeQName(clazz);
    }

    @Override
    public boolean isPrimitive(Object object) {
        if (object == null) {
            return true;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz == String.class) {
            return true;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (HexBinary.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Element.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz == byte[].class) {
            return true;
        }
        if (clazz.isArray()) {
            return true;
        }
        if (JavaUtils.isEnumClass(clazz)) {
            return true;
        }
        QName qName = this.getQNameForClass(clazz);
        return qName != null && Constants.isSchemaXSD(qName.getNamespaceURI()) && SchemaUtils.isSimpleSchemaType(qName);
    }

    @Override
    public void serialize(QName qName, Attributes attributes, Object object) throws IOException {
        this.serialize(qName, attributes, object, null, true, null);
    }

    @Override
    public void serialize(QName qName, Attributes attributes, Object object, QName qName2, boolean bl, Boolean bl2) throws IOException {
        Object object2;
        boolean bl3;
        boolean bl4 = bl3 = bl2 == null ? this.shouldSendXSIType() : bl2.booleanValue();
        if (object == null) {
            if (bl) {
                AttributesImpl attributesImpl = new AttributesImpl();
                if (attributes != null && 0 < attributes.getLength()) {
                    attributesImpl.setAttributes(attributes);
                }
                if (bl3) {
                    attributesImpl = (AttributesImpl)this.setTypeAttribute(attributesImpl, qName2);
                }
                String string = this.schemaVersion.getNilQName().getLocalPart();
                attributesImpl.addAttribute(this.schemaVersion.getXsiURI(), string, "xsi:" + string, "CDATA", "true");
                this.startElement(qName, attributesImpl);
                this.endElement();
            }
            return;
        }
        Message message = this.getCurrentMessage();
        if (null != message && null != (object2 = this.getCurrentMessage().getAttachmentsImpl()) && object2.isAttachment(object)) {
            this.serializeActual(qName, attributes, object, qName2, bl2);
            return;
        }
        if (this.doMultiRefs && object != this.forceSer && !this.isPrimitive(object)) {
            MultiRefItem multiRefItem;
            if (this.multiRefIndex == -1) {
                this.multiRefValues = new HashMap();
            }
            if ((multiRefItem = (MultiRefItem)this.multiRefValues.get(this.getIdentityKey(object))) == null) {
                ++this.multiRefIndex;
                object2 = "id" + this.multiRefIndex;
                multiRefItem = new MultiRefItem((String)object2, qName2, bl2, object);
                this.multiRefValues.put(this.getIdentityKey(object), multiRefItem);
                if (this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
                    AttributesImpl attributesImpl = new AttributesImpl();
                    if (attributes != null && 0 < attributes.getLength()) {
                        attributesImpl.setAttributes(attributes);
                    }
                    attributesImpl.addAttribute("", "id", "id", "CDATA", (String)object2);
                    this.serializeActual(qName, attributesImpl, object, qName2, bl2);
                    return;
                }
                if (this.outputMultiRefsFlag) {
                    if (this.secondLevelObjects == null) {
                        this.secondLevelObjects = new HashSet();
                    }
                    this.secondLevelObjects.add(this.getIdentityKey(object));
                }
            } else {
                object2 = multiRefItem.id;
            }
            AttributesImpl attributesImpl = new AttributesImpl();
            if (attributes != null && 0 < attributes.getLength()) {
                attributesImpl.setAttributes(attributes);
            }
            attributesImpl.addAttribute("", "href", "href", "CDATA", '#' + (String)object2);
            this.startElement(qName, attributesImpl);
            this.endElement();
            return;
        }
        if (object == this.forceSer) {
            this.forceSer = null;
        }
        this.serializeActual(qName, attributes, object, qName2, bl2);
    }

    private IDKey getIdentityKey(Object object) {
        return new IDKey(object);
    }

    @Override
    public void outputMultiRefs() throws IOException {
        if (!this.doMultiRefs || this.multiRefValues == null || this.soapConstants == SOAPConstants.SOAP12_CONSTANTS) {
            return;
        }
        this.outputMultiRefsFlag = true;
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", "", "", "");
        String string = this.soapConstants.getEncodingURI();
        String string2 = this.getPrefixForURI(string);
        String string3 = string2 + ":root";
        attributesImpl.addAttribute(string, "root", string3, "CDATA", "0");
        String string4 = this.msgContext != null ? this.msgContext.getEncodingStyle() : this.soapConstants.getEncodingURI();
        String string5 = this.getPrefixForURI(this.soapConstants.getEnvelopeURI()) + ':' + "encodingStyle";
        attributesImpl.addAttribute(this.soapConstants.getEnvelopeURI(), "encodingStyle", string5, "CDATA", string4);
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.multiRefValues.keySet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                MultiRefItem multiRefItem = (MultiRefItem)this.multiRefValues.get(e);
                attributesImpl.setAttribute(0, "", "id", "id", "CDATA", multiRefItem.id);
                this.forceSer = multiRefItem.value;
                this.serialize(multirefQName, attributesImpl, multiRefItem.value, multiRefItem.xmlType, true, Boolean.TRUE);
            }
            if (this.secondLevelObjects == null) continue;
            iterator = this.secondLevelObjects.iterator();
            this.secondLevelObjects = null;
        }
        this.forceSer = null;
        this.outputMultiRefsFlag = false;
        this.multiRefValues = null;
        this.multiRefIndex = -1;
        this.secondLevelObjects = null;
    }

    @Override
    public void startElement(QName qName, Attributes attributes) throws IOException {
        CharSequence charSequence;
        ArrayList<CharSequence> arrayList = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)Messages.getMessage("startElem00", "[" + qName.getNamespaceURI() + "]:" + qName.getLocalPart()));
        }
        if (this.startOfDocument && this.sendXMLDecl) {
            this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this.startOfDocument = false;
        }
        if (this.writingStartTag) {
            this.writer.write(62);
            if (this.pretty) {
                this.writer.write(10);
            }
            ++this.indent;
        }
        if (this.pretty) {
            for (int i = 0; i < this.indent; ++i) {
                this.writer.write(32);
            }
        }
        String string = this.qName2String(qName, true);
        this.writer.write(60);
        this.writer.write(string);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                charSequence = attributes.getQName(i);
                this.writer.write(32);
                String string2 = "";
                String string3 = attributes.getURI(i);
                if (string3 != null && string3.length() > 0) {
                    if (((String)charSequence).length() == 0) {
                        string2 = this.getPrefixForURI(string3);
                    } else {
                        int n = ((String)charSequence).indexOf(58);
                        if (n > -1) {
                            string2 = ((String)charSequence).substring(0, n);
                            string2 = this.getPrefixForURI(string3, string2, true);
                        }
                    }
                    charSequence = string2.length() > 0 ? string2 + ':' + attributes.getLocalName(i) : attributes.getLocalName(i);
                } else {
                    charSequence = attributes.getQName(i);
                    if (((String)charSequence).length() == 0) {
                        charSequence = attributes.getLocalName(i);
                    }
                }
                if (((String)charSequence).startsWith("xmlns")) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<CharSequence>();
                    }
                    arrayList.add(charSequence);
                }
                this.writer.write((String)charSequence);
                this.writer.write("=\"");
                this.writer.write(XMLUtils.xmlEncodeString(attributes.getValue(i)));
                this.writer.write(34);
            }
        }
        Mapping mapping = this.nsStack.topOfFrame();
        while (mapping != null) {
            charSequence = new StringBuilder("xmlns");
            if (mapping.getPrefix().length() > 0) {
                ((StringBuilder)charSequence).append(':');
                ((StringBuilder)charSequence).append(mapping.getPrefix());
            }
            if (arrayList == null || arrayList.indexOf(((StringBuilder)charSequence).toString()) == -1) {
                this.writer.write(32);
                ((StringBuilder)charSequence).append("=\"");
                ((StringBuilder)charSequence).append(mapping.getNamespaceURI());
                ((StringBuilder)charSequence).append('\"');
                this.writer.write(((StringBuilder)charSequence).toString());
            }
            mapping = this.nsStack.next();
        }
        this.writingStartTag = true;
        this.elementStack.push(string);
        this.nsStack.push();
        this.onlyXML = true;
    }

    @Override
    public void endElement() throws IOException {
        String string = (String)this.elementStack.pop();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)Messages.getMessage("endElem00", "" + string));
        }
        this.nsStack.pop();
        this.nsStack.clearFrame();
        if (this.writingStartTag) {
            this.writer.write("/>");
            if (this.pretty) {
                this.writer.write(10);
            }
            this.writingStartTag = false;
            return;
        }
        if (this.onlyXML) {
            --this.indent;
            if (this.pretty) {
                for (int i = 0; i < this.indent; ++i) {
                    this.writer.write(32);
                }
            }
        }
        this.writer.write("</");
        this.writer.write(string);
        this.writer.write(62);
        if (this.pretty && this.indent > 0) {
            this.writer.write(10);
        }
        this.onlyXML = true;
    }

    @Override
    public void writeChars(char[] cArray, int n, int n2) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.writeSafeString(String.valueOf(cArray, n, n2));
        this.onlyXML = false;
    }

    @Override
    public void writeString(String string) throws IOException {
        if (this.writingStartTag) {
            this.writer.write(62);
            this.writingStartTag = false;
        }
        this.writer.write(string);
        this.onlyXML = false;
    }

    @Override
    public void writeSafeString(String string) throws IOException {
        this.writeString(XMLUtils.xmlEncodeString(string));
    }

    @Override
    public void writeDOMElement(Element element) throws IOException {
        Object object;
        Object object2;
        Object object3;
        AttributesImpl attributesImpl = null;
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap.getLength() > 0) {
            attributesImpl = new AttributesImpl();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                object3 = (Attr)namedNodeMap.item(i);
                object2 = object3.getNamespaceURI();
                if (object2 != null && ((String)object2).equals("http://www.w3.org/2000/xmlns/")) {
                    object = object3.getLocalName();
                    if (object == null) continue;
                    if ("xmlns".equals(object)) {
                        object = "";
                    }
                    String string = object3.getValue();
                    this.registerPrefixForURI((String)object, string);
                    continue;
                }
                attributesImpl.addAttribute(object3.getNamespaceURI(), object3.getLocalName(), object3.getName(), "CDATA", object3.getValue());
            }
        }
        String string = element.getNamespaceURI();
        object3 = element.getLocalName();
        if (string == null || string.length() == 0) {
            object3 = element.getNodeName();
        }
        object2 = new QName(string, (String)object3);
        this.startElement((QName)object2, attributesImpl);
        object = element.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node = object.item(i);
            if (node instanceof Element) {
                this.writeDOMElement((Element)node);
                continue;
            }
            if (node instanceof CDATASection) {
                this.writeString("<![CDATA[");
                this.writeString(((Text)node).getData());
                this.writeString("]]>");
                continue;
            }
            if (node instanceof Comment) {
                this.writeString("<!--");
                this.writeString(((CharacterData)node).getData());
                this.writeString("-->");
                continue;
            }
            if (!(node instanceof Text)) continue;
            this.writeSafeString(((Text)node).getData());
        }
        this.endElement();
    }

    @Override
    public final Serializer getSerializerForJavaType(Class clazz) {
        Serializer serializer;
        block3: {
            SerializerFactory serializerFactory = null;
            serializer = null;
            try {
                serializerFactory = (SerializerFactory)this.getTypeMapping().getSerializer(clazz);
                if (serializerFactory != null) {
                    serializer = (Serializer)serializerFactory.getSerializerAs("Axis SAX Mechanism");
                }
            }
            catch (JAXRPCException jAXRPCException) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug((Object)"Method getSerializerForJavaType caught exception.", (Throwable)jAXRPCException);
            }
        }
        return serializer;
    }

    @Override
    public Attributes setTypeAttribute(Attributes attributes, QName qName) {
        if (qName == null || qName.getLocalPart().indexOf(">") >= 0 || attributes != null && attributes.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type") != -1) {
            return attributes;
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        if (attributes != null && 0 < attributes.getLength()) {
            attributesImpl.setAttributes(attributes);
        }
        String string = this.getPrefixForURI("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        attributesImpl.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", string + ":type", "CDATA", this.attributeQName2String(qName));
        return attributesImpl;
    }

    private void serializeActual(QName qName, Attributes attributes, Object object, QName qName2, Boolean bl) throws IOException {
        boolean bl2;
        boolean bl3 = bl2 = bl == null ? this.shouldSendXSIType() : bl.booleanValue();
        if (object != null) {
            QNameHolder qNameHolder;
            Serializer serializer;
            Class<?> clazz = object.getClass();
            TypeMapping typeMapping = this.getTypeMapping();
            if (typeMapping == null) {
                throw new IOException(Messages.getMessage("noSerializer00", object.getClass().getName(), "" + this));
            }
            this.currentXMLType = qName2;
            if (Constants.equals(Constants.XSD_ANYTYPE, qName2)) {
                qName2 = null;
                bl2 = true;
            }
            if ((serializer = this.getSerializer(clazz, qName2, qNameHolder = new QNameHolder())) != null) {
                if (bl2 || qName2 != null && !qName2.equals(qNameHolder.value)) {
                    attributes = this.setTypeAttribute(attributes, qNameHolder.value);
                }
                serializer.serialize(qName, attributes, object, this);
                return;
            }
            throw new IOException(Messages.getMessage("noSerializer00", object.getClass().getName(), "" + typeMapping));
        }
    }

    @Override
    public QName getCurrentXMLType() {
        return this.currentXMLType;
    }

    private SerializerFactory getSerializerFactoryFromInterface(Class clazz, QName qName, TypeMapping typeMapping) {
        SerializerFactory serializerFactory = null;
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz2 = classArray[i];
                serializerFactory = (SerializerFactory)typeMapping.getSerializer(clazz2, qName);
                if (serializerFactory == null) {
                    serializerFactory = this.getSerializerFactoryFromInterface(clazz2, qName, typeMapping);
                }
                if (serializerFactory != null) break;
            }
        }
        return serializerFactory;
    }

    private Serializer getSerializer(Class clazz, QName qName, QNameHolder qNameHolder) {
        SerializerFactory serializerFactory = null;
        TypeMapping typeMapping = this.getTypeMapping();
        if (qNameHolder != null) {
            qNameHolder.value = null;
        }
        while (clazz != null && (serializerFactory = (SerializerFactory)typeMapping.getSerializer(clazz, qName)) == null && (serializerFactory = this.getSerializerFactoryFromInterface(clazz, qName, typeMapping)) == null) {
            clazz = clazz.getSuperclass();
        }
        Serializer serializer = null;
        if (serializerFactory != null) {
            serializer = (Serializer)serializerFactory.getSerializerAs("Axis SAX Mechanism");
            if (qNameHolder != null) {
                if (serializerFactory instanceof BaseSerializerFactory) {
                    qNameHolder.value = ((BaseSerializerFactory)serializerFactory).getXMLType();
                }
                if (qNameHolder.value == null) {
                    qNameHolder.value = ((TypeMappingImpl)typeMapping).getXMLType(clazz, qName);
                }
            }
        }
        return serializer;
    }

    @Override
    public String getValueAsString(Object object, QName qName) throws IOException {
        Serializer serializer = this.getSerializer(object.getClass(), qName, null);
        if (!(serializer instanceof SimpleValueSerializer)) {
            throw new IOException(Messages.getMessage("needSimpleValueSer", serializer.getClass().getName()));
        }
        SimpleValueSerializer simpleValueSerializer = (SimpleValueSerializer)serializer;
        return simpleValueSerializer.getValueAsString(object, this);
    }

    class IDKey {
        private Object value = null;
        private int id = 0;

        public IDKey(Object object) {
            this.id = System.identityHashCode(object);
            this.value = object;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object object) {
            if (!(object instanceof IDKey)) {
                return false;
            }
            IDKey iDKey = (IDKey)object;
            if (this.id != iDKey.id) {
                return false;
            }
            return this.value == iDKey.value;
        }
    }

    class MultiRefItem {
        String id;
        QName xmlType;
        Boolean sendType;
        Object value;

        MultiRefItem(String string, QName qName, Boolean bl, Object object) {
            this.id = string;
            this.xmlType = qName;
            this.sendType = bl;
            this.value = object;
        }
    }
}

