/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.MethodTarget;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RPCHandler
extends SOAPHandler {
    private static final Log LOGGER = LogFactory.getLog(RPCHandler.class.getName());
    private RPCElement rpcElem;
    private RPCParam currentParam = null;
    private boolean isResponse;
    private OperationDesc operation;

    public RPCHandler(RPCElement rPCElement, boolean bl) throws SAXException {
        this.rpcElem = rPCElement;
        this.isResponse = bl;
    }

    public void setOperation(OperationDesc operationDesc) {
        this.operation = operationDesc;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        super.startElement(string, string2, string3, attributes, deserializationContext);
        this.currentParam = null;
    }

    @Override
    public SOAPHandler onStartChild(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Enter: RPCHandler.onStartChild()");
        }
        if (!deserializationContext.isDoneParsing()) {
            deserializationContext.pushNewElement(new MessageElement(string, string2, string3, attributes, deserializationContext));
        }
        MessageElement messageElement = deserializationContext.getCurElement();
        QName qName = null;
        QName qName2 = new QName(string, string2);
        ParameterDesc parameterDesc = null;
        Vector vector = this.rpcElem.getParams();
        if (qName2.equals(Constants.QNAME_RPC_RESULT)) {
            return this;
        }
        if (this.currentParam == null || !this.currentParam.getQName().getNamespaceURI().equals(string) || !this.currentParam.getQName().getLocalPart().equals(string2)) {
            this.currentParam = new RPCParam(string, string2, null);
            this.rpcElem.addParam(this.currentParam);
        }
        if ((qName = messageElement.getType()) == null) {
            qName = deserializationContext.getTypeFromAttributes(string, string2, attributes);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)Messages.getMessage("typeFromAttr00", "" + qName));
        }
        Class clazz = null;
        if (this.operation != null) {
            parameterDesc = this.isResponse ? this.operation.getOutputParamByQName(qName2) : this.operation.getInputParamByQName(qName2);
            if (parameterDesc == null) {
                parameterDesc = this.isResponse ? this.operation.getReturnParamDesc() : this.operation.getParameter(vector.size() - 1);
            }
            if (parameterDesc == null) {
                throw new SAXException(Messages.getMessage("noParmDesc"));
            }
            clazz = parameterDesc.getJavaType();
            this.currentParam.setParamDesc(parameterDesc);
            if (qName == null) {
                qName = parameterDesc.getTypeQName();
            }
            if (qName == null && clazz != null) {
                qName = deserializationContext.getTypeMapping().getTypeQName(clazz);
            }
        }
        if (deserializationContext.isNil(attributes)) {
            DeserializerImpl deserializerImpl = new DeserializerImpl();
            deserializerImpl.registerValueTarget(new MethodTarget((Object)this.currentParam, RPCParam.getValueSetMethod()));
            return deserializerImpl;
        }
        Deserializer deserializer = null;
        deserializer = qName == null && string != null && !"".equals(string) ? deserializationContext.getDeserializerForType(qName2) : deserializationContext.getDeserializer(clazz, qName);
        if (deserializer == null) {
            if (qName != null) {
                Class clazz2;
                deserializer = deserializationContext.getDeserializerForType(qName);
                if (null != clazz && deserializer == null && clazz.isAssignableFrom(Element.class)) {
                    deserializer = deserializationContext.getDeserializer(clazz, Constants.SOAP_ELEMENT);
                }
                if (deserializer == null) {
                    throw new SAXException(Messages.getMessage("noDeser01", string2, "" + qName));
                }
                if (parameterDesc != null && parameterDesc.getJavaType() != null && null != (clazz2 = deserializationContext.getTypeMapping().getClassForQName(qName)) && !JavaUtils.isConvertable(clazz2, clazz)) {
                    throw new SAXException("Bad types (" + clazz2 + " -> " + clazz + ")");
                }
            } else {
                deserializer = new DeserializerImpl();
                if (deserializer == null) {
                    throw new SAXException(Messages.getMessage("noDeser01", string2, "" + qName));
                }
            }
        }
        deserializer.setDefaultType(qName);
        deserializer.registerValueTarget(new MethodTarget((Object)this.currentParam, RPCParam.getValueSetMethod()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exit: RPCHandler.onStartChild()");
        }
        return (SOAPHandler)((Object)deserializer);
    }

    @Override
    public void endElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)Messages.getMessage("setProp00", "MessageContext", "RPCHandler.endElement()."));
        }
        deserializationContext.getMessageContext().setProperty("RPC", this.rpcElem);
    }
}

