/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.symbolTable;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import org.apache.axis.Constants;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.URLHashSet;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.symbolTable.BaseType;
import org.apache.axis.wsdl.symbolTable.BaseTypeMapping;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionElement;
import org.apache.axis.wsdl.symbolTable.CollectionTE;
import org.apache.axis.wsdl.symbolTable.CollectionType;
import org.apache.axis.wsdl.symbolTable.DefinedElement;
import org.apache.axis.wsdl.symbolTable.DefinedType;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.symbolTable.Undefined;
import org.apache.axis.wsdl.symbolTable.UndefinedElement;
import org.apache.axis.wsdl.symbolTable.UndefinedType;
import org.apache.axis.wsdl.symbolTable.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SymbolTable {
    private boolean addImports;
    private HashMap symbolTable = new HashMap();
    private Vector types = new Vector();
    private boolean verbose;
    private BaseTypeMapping btm = null;
    private boolean nowrap;
    private boolean wrapped = false;
    public static final String ANON_TOKEN = ">";
    public HashMap derivedSets = new HashMap();
    private Definition def = null;
    private String wsdlURI = null;
    private URLHashSet importedFiles = new URLHashSet();
    private static final int ABOVE_SCHEMA_LEVEL = -1;
    private static final int SCHEMA_LEVEL = 0;

    public SymbolTable(BaseTypeMapping baseTypeMapping, boolean bl, boolean bl2, boolean bl3) {
        this.btm = baseTypeMapping;
        this.addImports = bl;
        this.verbose = bl2;
        this.nowrap = bl3;
    }

    public HashMap getHashMap() {
        return this.symbolTable;
    }

    public Vector getSymbols(QName qName) {
        return (Vector)this.symbolTable.get(qName);
    }

    public SymTabEntry get(QName qName, Class clazz) {
        Vector vector = (Vector)this.symbolTable.get(qName);
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(i);
            if (!clazz.isInstance(symTabEntry)) continue;
            return symTabEntry;
        }
        return null;
    }

    public TypeEntry getTypeEntry(QName qName, boolean bl) {
        if (bl) {
            return this.getElement(qName);
        }
        return this.getType(qName);
    }

    public Type getType(QName qName) {
        for (int i = 0; i < this.types.size(); ++i) {
            TypeEntry typeEntry = (TypeEntry)this.types.get(i);
            if (!typeEntry.getQName().equals(qName) || !(typeEntry instanceof Type)) continue;
            return (Type)typeEntry;
        }
        return null;
    }

    public Element getElement(QName qName) {
        for (int i = 0; i < this.types.size(); ++i) {
            TypeEntry typeEntry = (TypeEntry)this.types.get(i);
            if (!typeEntry.getQName().equals(qName) || !(typeEntry instanceof Element)) continue;
            return (Element)typeEntry;
        }
        return null;
    }

    public MessageEntry getMessageEntry(QName qName) {
        return (MessageEntry)this.get(qName, MessageEntry.class);
    }

    public PortTypeEntry getPortTypeEntry(QName qName) {
        return (PortTypeEntry)this.get(qName, PortTypeEntry.class);
    }

    public BindingEntry getBindingEntry(QName qName) {
        return (BindingEntry)this.get(qName, BindingEntry.class);
    }

    public ServiceEntry getServiceEntry(QName qName) {
        return (ServiceEntry)this.get(qName, ServiceEntry.class);
    }

    public Vector getTypes() {
        return this.types;
    }

    public Definition getDefinition() {
        return this.def;
    }

    public String getWSDLURI() {
        return this.wsdlURI;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public void setWrapped(boolean bl) {
        this.wrapped = bl;
    }

    public void dump(PrintStream printStream) {
        printStream.println();
        printStream.println(Messages.getMessage("symbolTable00"));
        printStream.println("-----------------------");
        for (Vector vector : this.symbolTable.values()) {
            for (int i = 0; i < vector.size(); ++i) {
                printStream.println(vector.elementAt(i).getClass().getName());
                printStream.println(vector.elementAt(i));
            }
        }
        printStream.println("-----------------------");
    }

    public void populate(String string) throws IOException, WSDLException {
        this.populate(string, null, null);
    }

    public void populate(String string, String string2, String string3) throws IOException, WSDLException {
        Document document;
        if (this.verbose) {
            System.out.println(Messages.getMessage("parsing00", string));
        }
        if ((document = XMLUtils.newDocument(string, string2, string3)) == null) {
            throw new IOException(Messages.getMessage("cantGetDoc00", string));
        }
        this.wsdlURI = string;
        try {
            File file = new File(string);
            if (file.exists()) {
                string = file.toURL().toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.populate(string, document);
    }

    public void populate(String string, Document document) throws IOException, WSDLException {
        WSDLReader wSDLReader = WSDLFactory.newInstance().newWSDLReader();
        wSDLReader.setFeature("javax.wsdl.verbose", this.verbose);
        this.def = wSDLReader.readWSDL(string, document);
        this.add(string, this.def, document);
    }

    private void add(String string, Definition definition, Document document) throws IOException {
        URL uRL = string == null ? null : SymbolTable.getURL(null, string);
        this.populate(uRL, definition, document, null);
        this.checkForUndefined();
        this.populateParameters();
        this.setReferences(definition, document);
    }

    private void checkForUndefined(Definition definition, String string) throws IOException {
        if (definition != null) {
            for (Object object : definition.getBindings().values()) {
                if (!object.isUndefined()) continue;
                if (string == null) {
                    throw new IOException(Messages.getMessage("emitFailtUndefinedBinding01", object.getQName().getLocalPart()));
                }
                throw new IOException(Messages.getMessage("emitFailtUndefinedBinding02", object.getQName().getLocalPart(), string));
            }
            for (PortType portType : definition.getPortTypes().values()) {
                if (!portType.isUndefined()) continue;
                if (string == null) {
                    throw new IOException(Messages.getMessage("emitFailtUndefinedPort01", portType.getQName().getLocalPart()));
                }
                throw new IOException(Messages.getMessage("emitFailtUndefinedPort02", portType.getQName().getLocalPart(), string));
            }
        }
    }

    private void checkForUndefined() throws IOException {
        for (Vector vector : this.symbolTable.values()) {
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.get(i);
                if (symTabEntry instanceof UndefinedType) {
                    QName qName = symTabEntry.getQName();
                    if ("dateTime".equals(qName.getLocalPart()) && !qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || "timeInstant".equals(qName.getLocalPart()) && qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                        throw new IOException(Messages.getMessage("wrongNamespace00", qName.getLocalPart(), qName.getNamespaceURI()));
                    }
                    if (SchemaUtils.isSimpleSchemaType(symTabEntry.getQName())) {
                        throw new IOException(Messages.getMessage("unsupportedSchemaType00", qName.getLocalPart()));
                    }
                    throw new IOException(Messages.getMessage("undefined00", symTabEntry.getQName().toString()));
                }
                if (!(symTabEntry instanceof UndefinedElement)) continue;
                throw new IOException(Messages.getMessage("undefinedElem00", symTabEntry.getQName().toString()));
            }
        }
    }

    private void populate(URL uRL, Definition definition, Document document, String string) throws IOException {
        if (document != null) {
            this.populateTypes(uRL, document);
            if (this.addImports) {
                this.lookForImports(uRL, document);
            }
        }
        if (definition != null) {
            this.checkForUndefined(definition, string);
            if (this.addImports) {
                Map map = definition.getImports();
                Object[] objectArray = map.keySet().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    Vector vector = (Vector)map.get(objectArray[i]);
                    for (int j = 0; j < vector.size(); ++j) {
                        Import import_ = (Import)vector.get(j);
                        if (this.importedFiles.contains(import_.getLocationURI())) continue;
                        this.importedFiles.add(import_.getLocationURI());
                        URL uRL2 = SymbolTable.getURL(uRL, import_.getLocationURI());
                        this.populate(uRL2, import_.getDefinition(), XMLUtils.newDocument(uRL2.toString()), uRL2.toString());
                    }
                }
            }
            this.populateMessages(definition);
            this.populatePortTypes(definition);
            this.populateBindings(definition);
            this.populateServices(definition);
        }
    }

    private static URL getURL(URL uRL, String string) throws IOException {
        String string2 = string.replace('\\', '/');
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string2);
            if (uRL != null && "file".equals(uRL2.getProtocol()) && "file".equals(uRL.getProtocol())) {
                uRL2 = SymbolTable.getFileURL(uRL, string2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            uRL2 = SymbolTable.getFileURL(uRL, string2);
        }
        return uRL2;
    }

    private static URL getFileURL(URL uRL, String string) throws IOException {
        String string2;
        URL uRL2;
        if (uRL != null && (uRL2 = new File(string2 = uRL.getFile()).getParentFile().toURL()) != null) {
            return new URL(uRL2, string);
        }
        return new URL("file", "", string);
    }

    private void lookForImports(URL uRL, Node node) throws IOException {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if ("import".equals(node2.getLocalName())) {
                URL uRL2;
                NamedNodeMap namedNodeMap = node2.getAttributes();
                Node node3 = namedNodeMap.getNamedItem("namespace");
                if (node3 != null && Constants.isSOAP_ENC(node3.getNodeValue())) continue;
                Node node4 = namedNodeMap.getNamedItem("schemaLocation");
                if (node4 != null && !this.importedFiles.contains(uRL2 = SymbolTable.getURL(uRL, node4.getNodeValue()))) {
                    this.importedFiles.add(uRL2);
                    String string = uRL2.toString();
                    this.populate(uRL, null, XMLUtils.newDocument(string), string);
                }
            }
            this.lookForImports(uRL, node2);
        }
    }

    private void populateTypes(URL uRL, Document document) throws IOException {
        this.addTypes(uRL, document, -1);
    }

    private void addTypes(URL uRL, Node node, int n) throws IOException {
        int n2;
        Object object;
        if (node == null) {
            return;
        }
        QName qName = Utils.getNodeQName(node);
        if (qName != null) {
            Object object2;
            Serializable serializable;
            Object object3;
            object = qName.getLocalPart();
            n2 = Constants.isSchemaXSD(qName.getNamespaceURI());
            if (n2 != 0 && "complexType".equals(object) || "simpleType".equals(object)) {
                object3 = SchemaUtils.getRestrictionOrExtensionNode(node);
                if (object3 != null && Utils.getAttribute((Node)object3, "base") != null) {
                    this.createTypeFromRef((Node)object3);
                }
                this.createTypeFromDef(node, false, false);
            } else if (n2 != 0 && "element".equals(object)) {
                this.createTypeFromRef(node);
                object3 = SchemaUtils.getRestrictionOrExtensionNode(node);
                if (object3 != null && Utils.getAttribute((Node)object3, "base") != null) {
                    this.createTypeFromRef((Node)object3);
                }
                this.createTypeFromDef(node, true, n > 0);
            } else if (n2 != 0 && "attribute".equals(object)) {
                object3 = new BooleanHolder();
                serializable = Utils.getTypeQName(node, (BooleanHolder)object3, false);
                if (serializable != null && !((BooleanHolder)object3).value) {
                    this.createTypeFromRef(node);
                    if (serializable != null) {
                        object2 = this.getTypeEntry((QName)serializable, false);
                        if (object2 != null && object2 instanceof Undefined) {
                            ((TypeEntry)object2).setSimpleType(true);
                        } else if (object2 == null || !(object2 instanceof BaseType) && !((TypeEntry)object2).isSimpleType()) {
                            throw new IOException(Messages.getMessage("AttrNotSimpleType01", ((QName)serializable).toString()));
                        }
                    }
                }
            } else if (n2 != 0 && "any".equals(object)) {
                if (this.getType(Constants.XSD_ANY) == null) {
                    object3 = new BaseType(Constants.XSD_ANY);
                    this.symbolTablePut((SymTabEntry)object3);
                }
            } else if ("part".equals(object) && Constants.isWSDL(qName.getNamespaceURI())) {
                this.createTypeFromRef(node);
            } else if (n2 != 0 && "include".equals(object) && (object3 = Utils.getAttribute(node, "schemaLocation")) != null) {
                serializable = SymbolTable.getURL(uRL, (String)object3);
                object2 = XMLUtils.newDocument(((URL)serializable).toString());
                this.populate((URL)serializable, null, (Document)object2, ((URL)serializable).toString());
            }
        }
        if (n == -1) {
            if (qName != null && "schema".equals(qName.getLocalPart())) {
                n = 0;
            }
        } else {
            ++n;
        }
        object = node.getChildNodes();
        for (n2 = 0; n2 < object.getLength(); ++n2) {
            this.addTypes(uRL, object.item(n2), n);
        }
    }

    private void createTypeFromDef(Node node, boolean bl, boolean bl2) throws IOException {
        QName qName = Utils.getNodeNameQName(node);
        if (qName != null) {
            if (!bl && this.btm.getBaseName(qName) != null) {
                return;
            }
            BooleanHolder booleanHolder = new BooleanHolder();
            QName qName2 = Utils.getTypeQName(node, booleanHolder, false);
            if (qName2 != null) {
                if (qName.getLocalPart().length() == 0) {
                    String string = Utils.getAttribute(node, "name");
                    if (string == null) {
                        string = "unknown";
                    }
                    throw new IOException(Messages.getMessage("emptyref00", string));
                }
                TypeEntry typeEntry = this.getTypeEntry(qName2, booleanHolder.value);
                if (!bl2) {
                    this.symbolTablePut(new DefinedElement(qName, typeEntry, node, ""));
                }
            } else {
                IntHolder intHolder = new IntHolder();
                intHolder.value = 0;
                QName qName3 = SchemaUtils.getArrayComponentQName(node, intHolder);
                if (qName3 != null) {
                    String string;
                    qName2 = qName3;
                    TypeEntry typeEntry = this.getTypeEntry(qName2, false);
                    if (typeEntry == null) {
                        string = this.btm.getBaseName(qName2);
                        typeEntry = string != null ? new BaseType(qName2) : new UndefinedType(qName2);
                        this.symbolTablePut(typeEntry);
                    }
                    string = "";
                    while (intHolder.value > 0) {
                        string = string + "[]";
                        --intHolder.value;
                    }
                    TypeEntry typeEntry2 = null;
                    if (bl) {
                        if (!bl2) {
                            typeEntry2 = new DefinedElement(qName, typeEntry, node, string);
                        }
                    } else {
                        typeEntry2 = new DefinedType(qName, typeEntry, node, string);
                    }
                    if (typeEntry2 != null) {
                        this.symbolTablePut(typeEntry2);
                    }
                } else {
                    String string = this.btm.getBaseName(qName);
                    if (string != null) {
                        this.symbolTablePut(new BaseType(qName));
                    } else {
                        TypeEntry typeEntry = null;
                        if (!bl) {
                            Node node2;
                            QName qName4;
                            Element element;
                            typeEntry = new DefinedType(qName, node);
                            if (qName.getLocalPart().indexOf(ANON_TOKEN) >= 0 && (element = this.getElement(qName4 = Utils.getNodeNameQName(node2 = node.getParentNode()))) != null) {
                                element.setRefType(typeEntry);
                            }
                        } else if (!bl2) {
                            typeEntry = new DefinedElement(qName, node);
                        }
                        if (typeEntry != null) {
                            if (SchemaUtils.isSimpleTypeOrSimpleContent(node)) {
                                typeEntry.setSimpleType(true);
                            }
                            this.symbolTablePut(typeEntry);
                        }
                    }
                }
            }
        }
    }

    private void createTypeFromRef(Node node) throws IOException {
        BooleanHolder booleanHolder = new BooleanHolder();
        QName qName = Utils.getTypeQName(node, booleanHolder, false);
        if (qName != null) {
            if (qName.getLocalPart().length() == 0) {
                String string = Utils.getAttribute(node, "name");
                if (string == null) {
                    string = "unknown";
                }
                throw new IOException(Messages.getMessage("emptyref00", string));
            }
            TypeEntry typeEntry = this.getTypeEntry(qName, booleanHolder.value);
            if (typeEntry == null) {
                if (qName.getLocalPart().indexOf("[") > 0) {
                    QName qName2 = Utils.getTypeQName(node, booleanHolder, true);
                    TypeEntry typeEntry2 = this.getTypeEntry(qName2, booleanHolder.value);
                    if (!booleanHolder.value) {
                        if (typeEntry2 == null) {
                            String string = this.btm.getBaseName(qName2);
                            typeEntry2 = string != null ? new BaseType(qName2) : new UndefinedType(qName2);
                            this.symbolTablePut(typeEntry2);
                        }
                        this.symbolTablePut(new CollectionType(qName, typeEntry2, node, "[]"));
                    } else {
                        if (typeEntry2 == null) {
                            typeEntry2 = new UndefinedElement(qName2);
                            this.symbolTablePut(typeEntry2);
                        }
                        this.symbolTablePut(new CollectionElement(qName, typeEntry2, node, "[]"));
                    }
                } else {
                    String string = this.btm.getBaseName(qName);
                    if (string != null) {
                        this.symbolTablePut(new BaseType(qName));
                    } else if (!booleanHolder.value) {
                        this.symbolTablePut(new UndefinedType(qName));
                    } else {
                        this.symbolTablePut(new UndefinedElement(qName));
                    }
                }
            }
        }
    }

    private void populateMessages(Definition definition) throws IOException {
        for (Message message : definition.getMessages().values()) {
            MessageEntry messageEntry = new MessageEntry(message);
            this.symbolTablePut(messageEntry);
        }
    }

    private void populatePortTypes(Definition definition) throws IOException {
        for (PortType portType : definition.getPortTypes().values()) {
            if (portType.isUndefined()) continue;
            PortTypeEntry portTypeEntry = new PortTypeEntry(portType);
            this.symbolTablePut(portTypeEntry);
        }
    }

    private void populateParameters() throws IOException {
        for (Vector vector : this.symbolTable.values()) {
            for (int i = 0; i < vector.size(); ++i) {
                if (!(vector.get(i) instanceof BindingEntry)) continue;
                BindingEntry bindingEntry = (BindingEntry)vector.get(i);
                Binding binding = bindingEntry.getBinding();
                PortType portType = binding.getPortType();
                HashMap<Operation, Parameters> hashMap = new HashMap<Operation, Parameters>();
                for (Operation operation : portType.getOperations()) {
                    String string = portType.getQName().getNamespaceURI();
                    Parameters parameters = this.getOperationParameters(operation, string, bindingEntry);
                    hashMap.put(operation, parameters);
                }
                bindingEntry.setParameters(hashMap);
            }
        }
    }

    public Parameters getOperationParameters(Operation operation, String string, BindingEntry bindingEntry) throws IOException {
        int n;
        int n2;
        Iterator iterator;
        int n3;
        Object object;
        Object object2;
        Input input;
        Parameters parameters = new Parameters();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        List list = operation.getParameterOrdering();
        if (list != null && list.isEmpty()) {
            list = null;
        }
        if (list != null && (input = operation.getInput()) != null) {
            Message message = input.getMessage();
            object2 = message.getParts();
            object = message.getOrderedParts(list);
            if (object2.size() != object.size()) {
                throw new IOException(Messages.getMessage("emitFail00", operation.getName()));
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        if (bindingEntry != null) {
            bl = bindingEntry.getInputBodyType(operation) == 1;
            boolean bl3 = bl2 = bindingEntry.getOutputBodyType(operation) == 1;
        }
        if ((object2 = operation.getInput()) != null) {
            this.getParametersFromParts(vector, object2.getMessage().getOrderedParts(null), bl, operation.getName(), bindingEntry);
        }
        if ((object = operation.getOutput()) != null) {
            this.getParametersFromParts(vector2, object.getMessage().getOrderedParts(null), bl2, operation.getName(), bindingEntry);
        }
        if (list != null) {
            for (n3 = 0; n3 < list.size(); ++n3) {
                iterator = (String)list.get(n3);
                n2 = this.getPartIndex((String)((Object)iterator), vector);
                n = this.getPartIndex((String)((Object)iterator), vector2);
                if (n2 >= 0) {
                    this.addInishParm(vector, vector2, n2, n, parameters, true);
                    continue;
                }
                if (n >= 0) {
                    this.addOutParm(vector2, n, parameters, true);
                    continue;
                }
                System.err.println(Messages.getMessage("noPart00", (String)((Object)iterator)));
            }
        }
        if (this.wrapped && vector.size() == 1 && vector2.size() == 1 && ((Parameter)vector.get(0)).getName().equals(((Parameter)vector2.get(0)).getName())) {
            this.addInishParm(vector, null, 0, -1, parameters, false);
        } else {
            for (n3 = 0; n3 < vector.size(); ++n3) {
                iterator = (Parameter)vector.get(n3);
                n2 = this.getPartIndex(((Parameter)((Object)iterator)).getName(), vector2);
                this.addInishParm(vector, vector2, n3, n2, parameters, false);
            }
        }
        if (vector2.size() == 1) {
            parameters.returnParam = (Parameter)vector2.get(0);
            if (parameters.returnParam.getType() instanceof DefinedElement) {
                parameters.returnParam.setQName(((DefinedElement)parameters.returnParam.getType()).getQName());
            }
            ++parameters.outputs;
        } else {
            for (n3 = 0; n3 < vector2.size(); ++n3) {
                this.addOutParm(vector2, n3, parameters, false);
            }
        }
        parameters.faults = operation.getFaults();
        Vector<String> vector3 = new Vector<String>(parameters.list.size());
        for (Parameter parameter : parameters.list) {
            n = 2;
            while (vector3.contains(parameter.getName())) {
                parameter.setName(parameter.getName() + Integer.toString(n++));
            }
            vector3.add(parameter.getName());
        }
        return parameters;
    }

    private int getPartIndex(String string, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!string.equals(((Parameter)vector.get(i)).getName())) continue;
            return i;
        }
        return -1;
    }

    private void addInishParm(Vector vector, Vector vector2, int n, int n2, Parameters parameters, boolean bl) {
        Object object;
        Parameter parameter = (Parameter)vector.get(n);
        if (parameter.getType() instanceof DefinedElement) {
            object = (DefinedElement)parameter.getType();
            parameter.setQName(((SymTabEntry)object).getQName());
        }
        if (parameter.getType() instanceof CollectionTE) {
            parameter.setQName(parameter.getType().getRefType().getQName());
        }
        if (bl) {
            vector.remove(n);
        }
        if (n2 >= 0) {
            object = (Parameter)vector2.get(n2);
            if (parameter.getType().equals(((Parameter)object).getType())) {
                vector2.remove(n2);
                parameter.setMode((byte)3);
                ++parameters.inouts;
            } else {
                ++parameters.inputs;
            }
        } else {
            ++parameters.inputs;
        }
        parameters.list.add(parameter);
    }

    private void addOutParm(Vector vector, int n, Parameters parameters, boolean bl) {
        Parameter parameter = (Parameter)vector.get(n);
        if (parameter.getType() instanceof DefinedElement) {
            DefinedElement definedElement = (DefinedElement)parameter.getType();
            parameter.setQName(definedElement.getQName());
        }
        if (parameter.getType() instanceof CollectionTE) {
            parameter.setQName(parameter.getType().getRefType().getQName());
        }
        if (bl) {
            vector.remove(n);
        }
        parameter.setMode((byte)2);
        ++parameters.outputs;
        parameters.list.add(parameter);
    }

    public void getParametersFromParts(Vector vector, Collection collection, boolean bl, String string, BindingEntry bindingEntry) throws IOException {
        int n = 0;
        boolean bl2 = false;
        for (Object object2 : collection) {
            if (object2.getElementName() == null) continue;
            ++n;
            if (!object2.getElementName().getLocalPart().equals(string)) continue;
            bl2 = true;
        }
        if (!this.nowrap && bl && n == 1 && bl2) {
            this.wrapped = true;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Vector vector2;
            Object object;
            Object object2;
            object2 = new Parameter();
            Part part = (Part)iterator.next();
            QName qName = part.getElementName();
            QName qName2 = part.getTypeName();
            String string2 = part.getName();
            if (!bl || !this.wrapped || qName == null) {
                ((Parameter)object2).setName(string2);
                if (qName2 != null) {
                    ((Parameter)object2).setType(this.getType(qName2));
                } else if (qName != null) {
                    ((Parameter)object2).setType(this.getElement(qName));
                } else {
                    throw new IOException(Messages.getMessage("noTypeOrElement00", new String[]{string2, string}));
                }
                this.setMIMEType((Parameter)object2, bindingEntry == null ? null : bindingEntry.getMIMEType(string, string2));
                vector.add(object2);
                continue;
            }
            Node node = null;
            if (qName2 != null && bindingEntry != null && bindingEntry.getMIMETypes().isEmpty()) {
                object = bindingEntry == null ? "unknown" : bindingEntry.getBinding().getQName().toString();
                throw new IOException(Messages.getMessage("literalTypePart00", new String[]{string2, string, object}));
            }
            node = this.getTypeEntry(qName, true).getNode();
            QName qName3 = Utils.getTypeQName(node, object = new BooleanHolder(), false);
            if (qName3 != null && !object.value) {
                node = this.getTypeEntry(qName3, false).getNode();
            }
            if (node == null) {
                throw new IOException(Messages.getMessage("badTypeNode", new String[]{string2, string, qName.toString()}));
            }
            Vector vector3 = SchemaUtils.getContainedAttributeTypes(node, this);
            if (vector3 != null) {
                this.wrapped = false;
            }
            if ((vector2 = SchemaUtils.getContainedElementDeclarations(node, this)) != null && this.wrapped) {
                for (int i = 0; i < vector2.size(); ++i) {
                    ElementDecl elementDecl = (ElementDecl)vector2.elementAt(i);
                    Parameter parameter = new Parameter();
                    parameter.setQName(elementDecl.getName());
                    parameter.setType(elementDecl.getType());
                    this.setMIMEType(parameter, bindingEntry == null ? null : bindingEntry.getMIMEType(string, string2));
                    vector.add(parameter);
                }
                continue;
            }
            ((Parameter)object2).setName(string2);
            if (qName2 != null) {
                ((Parameter)object2).setType(this.getType(qName2));
            } else if (qName != null) {
                ((Parameter)object2).setType(this.getElement(qName));
            }
            this.setMIMEType((Parameter)object2, bindingEntry == null ? null : bindingEntry.getMIMEType(string, string2));
            vector.add(object2);
        }
    }

    private void setMIMEType(Parameter parameter, String string) {
        QName qName;
        if (string == null && (qName = parameter.getType().getQName()).getNamespaceURI().equals("http://xml.apache.org/xml-soap")) {
            if (Constants.MIME_IMAGE.equals(qName)) {
                string = "image/jpeg";
            } else if (Constants.MIME_PLAINTEXT.equals(qName)) {
                string = "text/plain";
            } else if (Constants.MIME_MULTIPART.equals(qName)) {
                string = "multipart/related";
            } else if (Constants.MIME_SOURCE.equals(qName)) {
                string = "text/xml";
            }
        }
        parameter.setMIMEType(string);
    }

    private void populateBindings(Definition definition) throws IOException {
        Iterator iterator = definition.getBindings().values().iterator();
        while (iterator.hasNext()) {
            Object object;
            SOAPBinding sOAPBinding;
            int n = 1;
            int n2 = 3;
            Binding binding = (Binding)iterator.next();
            for (Object e : binding.getExtensibilityElements()) {
                if (e instanceof SOAPBinding) {
                    n2 = 0;
                    sOAPBinding = (SOAPBinding)e;
                    object = sOAPBinding.getStyle();
                    if (!"rpc".equalsIgnoreCase((String)object)) continue;
                    n = 0;
                    continue;
                }
                if (!(e instanceof HTTPBinding)) continue;
                sOAPBinding = (HTTPBinding)e;
                if ("post".equalsIgnoreCase(sOAPBinding.getVerb())) {
                    n2 = 2;
                    continue;
                }
                n2 = 1;
            }
            boolean bl = false;
            sOAPBinding = new HashMap();
            object = binding.getBindingOperations();
            HashMap hashMap = new HashMap();
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                Object object3;
                Iterator<Object> iterator22;
                String string;
                BindingOperation bindingOperation = (BindingOperation)object2.next();
                BindingInput bindingInput = bindingOperation.getBindingInput();
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                String string2 = bindingOperation.getName();
                String string3 = bindingInput == null ? null : bindingInput.getName();
                String string4 = string = bindingOutput == null ? null : bindingOutput.getName();
                if (binding.getPortType().getOperation(string2, string3, string) == null) {
                    throw new IOException(Messages.getMessage("unmatchedOp", new String[]{string2, string3, string}));
                }
                int n3 = 0;
                int n4 = 0;
                HashMap hashMap2 = new HashMap();
                hashMap.put(string2, hashMap2);
                if (bindingInput != null && bindingInput.getExtensibilityElements() != null) {
                    for (Iterator<Object> iterator22 : bindingInput.getExtensibilityElements()) {
                        if (iterator22 instanceof SOAPBody) {
                            object3 = ((SOAPBody)iterator22).getUse();
                            if (object3 == null) {
                                throw new IOException(Messages.getMessage("noUse", string2));
                            }
                            if (!"literal".equalsIgnoreCase((String)object3)) break;
                            n3 = 1;
                            break;
                        }
                        if (!(iterator22 instanceof MIMEMultipartRelated)) continue;
                        object3 = new IntHolder(n3);
                        hashMap2.putAll(this.collectMIMETypes((MIMEMultipartRelated)iterator22, (IntHolder)object3, bindingOperation));
                        n3 = object3.value;
                    }
                }
                if (bindingOutput != null && bindingOutput.getExtensibilityElements() != null) {
                    for (Iterator<Object> iterator22 : bindingOutput.getExtensibilityElements()) {
                        if (iterator22 instanceof SOAPBody) {
                            object3 = ((SOAPBody)iterator22).getUse();
                            if (object3 == null) {
                                throw new IOException(Messages.getMessage("noUse", string2));
                            }
                            if (!"literal".equalsIgnoreCase((String)object3)) break;
                            n4 = 1;
                            break;
                        }
                        if (!(iterator22 instanceof MIMEMultipartRelated)) continue;
                        object3 = new IntHolder(n4);
                        hashMap2.putAll(this.collectMIMETypes((MIMEMultipartRelated)iterator22, (IntHolder)object3, bindingOperation));
                        n4 = object3.value;
                    }
                }
                Iterator iterator3 = new HashMap();
                iterator22 = bindingOperation.getBindingFaults().values().iterator();
                while (iterator22.hasNext()) {
                    object3 = (BindingFault)iterator22.next();
                    String string5 = object3.getName();
                    int n5 = 0;
                    for (Object e : object3.getExtensibilityElements()) {
                        if (!(e instanceof SOAPBody)) continue;
                        String string6 = ((SOAPBody)e).getUse();
                        if (string6 == null) {
                            throw new IOException(Messages.getMessage("noUse", string2));
                        }
                        if (!"literal".equalsIgnoreCase(string6)) break;
                        n5 = 1;
                        break;
                    }
                    ((HashMap)((Object)iterator3)).put(string5, n5);
                }
                sOAPBinding.put(bindingOperation.getOperation(), new BindingEntry.OperationAttr(n3, n4, (HashMap)((Object)iterator3)));
                if (n3 != 1 && n4 != 1) continue;
                bl = true;
            }
            object2 = new BindingEntry(binding, n2, n, bl, (HashMap)sOAPBinding, hashMap);
            this.symbolTablePut((SymTabEntry)object2);
        }
    }

    private Map collectMIMETypes(MIMEMultipartRelated mIMEMultipartRelated, IntHolder intHolder, BindingOperation bindingOperation) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List list = mIMEMultipartRelated.getMIMEParts();
        for (MIMEPart mIMEPart : list) {
            List list2 = mIMEPart.getExtensibilityElements();
            for (Object e : list2) {
                Object object;
                if (e instanceof MIMEContent) {
                    object = (MIMEContent)e;
                    hashMap.put(object.getPart(), object.getType());
                    continue;
                }
                if (!(e instanceof SOAPBody)) continue;
                object = ((SOAPBody)e).getUse();
                if (object == null) {
                    throw new IOException(Messages.getMessage("noUse", bindingOperation.getName()));
                }
                if (!"literal".equalsIgnoreCase((String)object)) continue;
                intHolder.value = 1;
            }
        }
        return hashMap;
    }

    private void populateServices(Definition definition) throws IOException {
        for (Service service : definition.getServices().values()) {
            if (service.getQName() == null || service.getQName().getLocalPart() == null || "".equals(service.getQName().getLocalPart())) {
                throw new IOException(Messages.getMessage("BadServiceName00"));
            }
            ServiceEntry serviceEntry = new ServiceEntry(service);
            this.symbolTablePut(serviceEntry);
        }
    }

    private void setReferences(Definition definition, Document document) {
        Map map = definition.getServices();
        if (map.isEmpty()) {
            map = definition.getBindings();
            if (map.isEmpty()) {
                map = definition.getPortTypes();
                if (map.isEmpty()) {
                    map = definition.getMessages();
                    if (map.isEmpty()) {
                        for (int i = 0; i < this.types.size(); ++i) {
                            TypeEntry typeEntry = (TypeEntry)this.types.get(i);
                            this.setTypeReferences(typeEntry, document, false);
                        }
                    } else {
                        for (Message message : map.values()) {
                            MessageEntry messageEntry = this.getMessageEntry(message.getQName());
                            this.setMessageReferences(messageEntry, definition, document, false);
                        }
                    }
                } else {
                    for (PortType portType : map.values()) {
                        PortTypeEntry portTypeEntry = this.getPortTypeEntry(portType.getQName());
                        this.setPortTypeReferences(portTypeEntry, null, definition, document);
                    }
                }
            } else {
                for (Binding binding : map.values()) {
                    BindingEntry bindingEntry = this.getBindingEntry(binding.getQName());
                    this.setBindingReferences(bindingEntry, definition, document);
                }
            }
        } else {
            for (Service service : map.values()) {
                ServiceEntry serviceEntry = this.getServiceEntry(service.getQName());
                this.setServiceReferences(serviceEntry, definition, document);
            }
        }
    }

    private void setTypeReferences(TypeEntry typeEntry, Document document, boolean bl) {
        Serializable serializable;
        Object object;
        Object object2;
        if (typeEntry.isReferenced() && !bl || typeEntry.isOnlyLiteralReferenced() && bl) {
            return;
        }
        if (this.wrapped) {
            if (!typeEntry.isReferenced() && bl) {
                typeEntry.setOnlyLiteralReference(true);
            } else if (typeEntry.isOnlyLiteralReferenced() && !bl) {
                typeEntry.setOnlyLiteralReference(false);
            }
        }
        Node node = typeEntry.getNode();
        if (this.addImports || node == null || node.getOwnerDocument() == document) {
            typeEntry.setIsReferenced(true);
            if (typeEntry instanceof DefinedElement) {
                Type type;
                object2 = new BooleanHolder();
                object = Utils.getTypeQName(node, (BooleanHolder)object2, false);
                if (object != null && (serializable = this.getTypeEntry((QName)object, ((BooleanHolder)object2).value)) != null) {
                    this.setTypeReferences((TypeEntry)serializable, document, bl);
                }
                if ((serializable = SchemaUtils.getElementAnonQName(typeEntry.getNode())) != null && (type = this.getType((QName)serializable)) != null) {
                    this.setTypeReferences(type, document, bl);
                    return;
                }
            }
        }
        object2 = Utils.getNestedTypes(typeEntry, this, true);
        object = ((HashSet)object2).iterator();
        while (object.hasNext()) {
            serializable = (TypeEntry)object.next();
            if (((SymTabEntry)((Object)serializable)).isReferenced()) continue;
            this.setTypeReferences((TypeEntry)serializable, document, false);
        }
    }

    private void setMessageReferences(MessageEntry messageEntry, Definition definition, Document document, boolean bl) {
        Message message = messageEntry.getMessage();
        if (this.addImports) {
            messageEntry.setIsReferenced(true);
        } else {
            Map map = definition.getMessages();
            if (map.containsValue(message)) {
                messageEntry.setIsReferenced(true);
            }
        }
        for (Part part : message.getParts().values()) {
            TypeEntry typeEntry = this.getType(part.getTypeName());
            if (typeEntry != null) {
                this.setTypeReferences(typeEntry, document, bl);
            }
            if ((typeEntry = this.getElement(part.getElementName())) == null) continue;
            this.setTypeReferences(typeEntry, document, bl);
            TypeEntry typeEntry2 = typeEntry.getRefType();
            if (typeEntry2 == null) continue;
            this.setTypeReferences(typeEntry2, document, bl);
        }
    }

    private void setPortTypeReferences(PortTypeEntry portTypeEntry, BindingEntry bindingEntry, Definition definition, Document document) {
        PortType portType = portTypeEntry.getPortType();
        if (this.addImports) {
            portTypeEntry.setIsReferenced(true);
        } else {
            Map map = definition.getPortTypes();
            if (map.containsValue(portType)) {
                portTypeEntry.setIsReferenced(true);
            }
        }
        for (Operation operation : portType.getOperations()) {
            MessageEntry messageEntry;
            Object object;
            Input input = operation.getInput();
            Output output = operation.getOutput();
            boolean bl = false;
            boolean bl2 = false;
            if (bindingEntry != null) {
                bl = bindingEntry.getInputBodyType(operation) == 1;
                boolean bl3 = bl2 = bindingEntry.getOutputBodyType(operation) == 1;
            }
            if (input != null && (object = input.getMessage()) != null && (messageEntry = this.getMessageEntry(object.getQName())) != null) {
                this.setMessageReferences(messageEntry, definition, document, bl);
            }
            if (output != null && (object = output.getMessage()) != null && (messageEntry = this.getMessageEntry(object.getQName())) != null) {
                this.setMessageReferences(messageEntry, definition, document, bl2);
            }
            object = operation.getFaults().values().iterator();
            while (object.hasNext()) {
                MessageEntry messageEntry2;
                messageEntry = ((Fault)object.next()).getMessage();
                if (messageEntry == null || (messageEntry2 = this.getMessageEntry(messageEntry.getQName())) == null) continue;
                this.setMessageReferences(messageEntry2, definition, document, false);
            }
        }
    }

    private void setBindingReferences(BindingEntry bindingEntry, Definition definition, Document document) {
        if (bindingEntry.getBindingType() == 0) {
            Map map;
            Binding binding = bindingEntry.getBinding();
            if (this.addImports) {
                bindingEntry.setIsReferenced(true);
            } else {
                map = definition.getBindings();
                if (map.containsValue(binding)) {
                    bindingEntry.setIsReferenced(true);
                }
            }
            map = binding.getPortType();
            PortTypeEntry portTypeEntry = this.getPortTypeEntry(map.getQName());
            if (portTypeEntry != null) {
                this.setPortTypeReferences(portTypeEntry, bindingEntry, definition, document);
            }
        }
    }

    private void setServiceReferences(ServiceEntry serviceEntry, Definition definition, Document document) {
        Service service = serviceEntry.getService();
        if (this.addImports) {
            serviceEntry.setIsReferenced(true);
        } else {
            Map map = definition.getServices();
            if (map.containsValue(service)) {
                serviceEntry.setIsReferenced(true);
            }
        }
        for (Port port : service.getPorts().values()) {
            Binding binding = port.getBinding();
            BindingEntry bindingEntry = this.getBindingEntry(binding.getQName());
            if (bindingEntry == null) continue;
            this.setBindingReferences(bindingEntry, definition, document);
        }
    }

    private void symbolTablePut(SymTabEntry symTabEntry) throws IOException {
        QName qName = symTabEntry.getQName();
        if (this.get(qName, symTabEntry.getClass()) == null) {
            if (symTabEntry instanceof Type && this.get(qName, UndefinedType.class) != null) {
                if (((TypeEntry)this.get(qName, UndefinedType.class)).isSimpleType() && !((TypeEntry)symTabEntry).isSimpleType()) {
                    throw new IOException(Messages.getMessage("AttrNotSimpleType01", qName.toString()));
                }
                Vector vector = (Vector)this.symbolTable.get(qName);
                for (int i = 0; i < vector.size(); ++i) {
                    Object e = vector.elementAt(i);
                    if (!(e instanceof UndefinedType)) continue;
                    vector.setElementAt(symTabEntry, i);
                    for (int j = 0; j < this.types.size(); ++j) {
                        if (this.types.elementAt(j) != e) continue;
                        this.types.setElementAt(symTabEntry, j);
                    }
                    ((UndefinedType)e).update((Type)symTabEntry);
                }
            } else if (symTabEntry instanceof Element && this.get(qName, UndefinedElement.class) != null) {
                Vector vector = (Vector)this.symbolTable.get(qName);
                for (int i = 0; i < vector.size(); ++i) {
                    Object e = vector.elementAt(i);
                    if (!(e instanceof UndefinedElement)) continue;
                    vector.setElementAt(symTabEntry, i);
                    for (int j = 0; j < this.types.size(); ++j) {
                        if (this.types.elementAt(j) != e) continue;
                        this.types.setElementAt(symTabEntry, j);
                    }
                    ((Undefined)e).update((Element)symTabEntry);
                }
            } else {
                Vector<SymTabEntry> vector = (Vector<SymTabEntry>)this.symbolTable.get(qName);
                if (vector == null) {
                    vector = new Vector<SymTabEntry>();
                    this.symbolTable.put(qName, vector);
                }
                vector.add(symTabEntry);
                if (symTabEntry instanceof TypeEntry) {
                    this.types.add(symTabEntry);
                }
            }
        } else {
            System.out.println(Messages.getMessage("alreadyExists00", "" + qName));
        }
    }
}

