/*
 * Decompiled with CFR 0.152.
 */
package com.actional.soapapi.javaClient;

import com.actional.lg.db.LGNode;
import com.actional.lg.server.broker.ActiveAgentTO;
import com.actional.lg.server.broker.ProvisionInput;
import com.actional.soapapi.Config;
import com.actional.soapapi.Util;
import com.actional.soapapi.javaClient.ClientBase;
import com.actional.soapapi.javaClient.Input;
import com.actional.soapapi.server.AgentConfigTask;
import com.actional.soapapi.server.ServerConfig;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerClient
extends ClientBase {
    private static final Logger LOGGER = Logger.getLogger(ServerClient.class.getName());
    private static String DEFAULT_AGENT_NAME = "LocalHost";
    protected AgentConfigTask itsAgentConfigTask = new AgentConfigTask();

    public ServerClient(ServerConfig serverConfig) {
        super((Config)serverConfig);
        this.itsAgentConfigTask.setConfig(serverConfig);
        this.itsAgentConfigTask.setLog(this.getLog());
    }

    protected ServerConfig getConfig() {
        return (ServerConfig)this.itsConfig;
    }

    protected AgentConfigTask getAgentConfigTask() {
        return this.itsAgentConfigTask;
    }

    protected void promptAndProvisionAgent() throws Exception {
        String string = Input.read("Enter the member id of the agent to provision");
        try {
            ProvisionInput provisionInput = new ProvisionInput();
            provisionInput.setMemberIDs(new String[]{string});
            provisionInput.setCompletionTimeout(20000L);
            this.getConfig().activeAgentTask.provision(provisionInput);
            this.info("SUCCESS");
        }
        catch (Exception exception) {
            this.info("FAILED: Agent provisioning failed. Reason: " + exception.getMessage());
        }
    }

    protected void listNodes() throws Exception {
        this.info("Listing nodes...");
        this.listNodes(this.getConfig().lgCallSiteTask.getAllLGNodes());
    }

    protected void listAgents() throws Exception {
        this.info("Listing active agents...");
        this.listAgents(this.getConfig().activeAgentTask.getAllActiveAgents());
    }

    protected void listAgents(ActiveAgentTO[] activeAgentTOArray) throws Exception {
        int n = Util.length((Object[])activeAgentTOArray);
        this.info("Found " + n + " agents");
        for (int i = 0; i < n; ++i) {
            ActiveAgentTO activeAgentTO = activeAgentTOArray[i];
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append("- ");
            stringBuilder.append("Member Id:");
            stringBuilder.append(activeAgentTO.getAppID());
            stringBuilder.append(", Profile Name");
            stringBuilder.append(activeAgentTO.getProfileName());
            stringBuilder.append(", Hostname: ");
            stringBuilder.append(activeAgentTO.getHostName());
            this.info(stringBuilder.toString());
        }
    }

    protected void listNodes(LGNode[] lGNodeArray) throws Exception {
        int n = Util.length((Object[])lGNodeArray);
        this.info("Found " + n + " nodes (M = managed, U = unmanaged):");
        for (int i = 0; i < n; ++i) {
            LGNode lGNode = lGNodeArray[i];
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("- ");
            if (this.getAgentConfigTask().isManaged(lGNode)) {
                stringBuffer.append("[M] ");
            } else {
                stringBuffer.append("[U] ");
            }
            stringBuffer.append(lGNode.getKeyName());
            this.info(stringBuffer.toString());
        }
    }

    public void promptForInputAndPerformAction() throws Exception {
        block10: while (true) {
            try {
                while (true) {
                    this.info("");
                    this.info("-----------------------------------------");
                    this.info("Select action to perform:");
                    this.info("- [Pp] Provision agent.");
                    this.info("- [Ll] List nodes.");
                    this.info("- [Aa] List agents.");
                    this.info("- [Cc] Check nodes.");
                    this.info("- [Vv] Version");
                    this.info("- [Qq] Quit.");
                    String string = Input.read("Choice");
                    this.info("");
                    if (string == null || string.length() != 1) continue;
                    char c = string.charAt(0);
                    switch (c) {
                        case 'P': 
                        case 'p': {
                            this.promptAndProvisionAgent();
                            continue block10;
                        }
                        case 'L': 
                        case 'l': {
                            this.listNodes();
                            continue block10;
                        }
                        case 'A': 
                        case 'a': {
                            this.listAgents();
                            continue block10;
                        }
                        case 'C': 
                        case 'c': {
                            this.getAgentConfigTask().checkNodes();
                            continue block10;
                        }
                        case 'V': 
                        case 'v': {
                            this.displayVersion();
                            continue block10;
                        }
                        case 'Q': 
                        case 'q': {
                            return;
                        }
                    }
                    this.info("Invalid action: " + string);
                }
            }
            catch (Exception exception) {
                this.info("Error: " + exception.toString());
                LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                continue;
            }
            break;
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("");
            String string = Input.read("Server address", "http://localhost:4040/lgserver");
            String string2 = Input.read("UserName", "User_Admin");
            String string3 = Input.read("Password", true, "security");
            System.out.println("");
            System.out.println("Initializing connection...");
            ServerConfig serverConfig = new ServerConfig(string2, string3, string);
            ServerClient serverClient = new ServerClient(serverConfig);
            serverClient.init();
            serverClient.promptForInputAndPerformAction();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            System.exit(-1);
        }
    }
}

