/*
 * Decompiled with CFR 0.152.
 */
package com.actional.soapapi.anttask.soapstation;

import com.actional.classloader.DynamicClassLoaderEnvironment;
import com.actional.db.PluginProperty;
import com.actional.soapapi.Util;
import com.actional.soapapi.anttask.IBaseDataKeyID;
import com.actional.soapapi.anttask.soapstation.SOAPstationTaskBase;
import com.actional.soapstation.db.CRLConfig;
import com.actional.soapstation.db.KeyServiceLC;
import com.actional.soapstation.db.SecurityGlobalSettings;
import com.actional.soapstation.db.SecurityPluginLC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.types.Resource;

public class CreateCRLKeyServiceProviderTask
extends SOAPstationTaskBase
implements IBaseDataKeyID {
    private String itsKeyValidationServiceID;
    protected KeyServiceLC itsKeyValidationService = new KeyServiceLC();
    protected CRLConfig itsCRLConfig = new CRLConfig();
    protected List itsEndpointItems = new ArrayList();

    public void addEndpoint(Resource resource) {
        if (resource == null) {
            return;
        }
        this.itsEndpointItems.add(resource);
    }

    @Override
    public void executeEx() throws Exception {
        if (Util.isBlank((Collection)this.itsEndpointItems)) {
            throw new Exception("At least one endpoint must be specified.");
        }
        String[] stringArray = new String[this.itsEndpointItems.size()];
        for (int i = 0; i < this.itsEndpointItems.size(); ++i) {
            stringArray[i] = ((Resource)this.itsEndpointItems.get(i)).getName();
            this.log("CRL endpoint= " + stringArray[i]);
        }
        this.itsCRLConfig.setCRLEndpoints(stringArray);
        DynamicClassLoaderEnvironment dynamicClassLoaderEnvironment = new DynamicClassLoaderEnvironment();
        dynamicClassLoaderEnvironment.setKeyID("SecurityDefault_DynamicClassLoaderEnvironment");
        dynamicClassLoaderEnvironment.setDelegateToParentFirst(Boolean.TRUE);
        this.itsKeyValidationService.setEnvironment(dynamicClassLoaderEnvironment);
        this.itsKeyValidationService.setIsMgrCachable(Boolean.TRUE);
        this.itsKeyValidationService.setKeyID("CRLKeyService_KEY_ID");
        this.itsKeyValidationService.setKeyName("CRL Server Key Service Provider");
        this.itsKeyValidationService.setDescription("Key Service Provider using CRL");
        this.itsKeyValidationService.setClassName("com.actional.soapstation.security.crl.CRLService");
        PluginProperty pluginProperty = new PluginProperty();
        pluginProperty.setKeyName("SETTINGS");
        pluginProperty.setValue((Object)this.itsCRLConfig);
        this.itsKeyValidationService.setClassSettings(new PluginProperty[]{pluginProperty});
        this.itsKeyValidationServiceID = this._getSSTConfig().secTask.createPluginLC((SecurityPluginLC)this.itsKeyValidationService);
        this.log("Created Key Service Provider '" + this.itsKeyValidationService.getKeyName() + "' KeyID: " + this.getKeyID());
        SecurityGlobalSettings securityGlobalSettings = this._getSSTConfig().secTask.retrieveGlobalSettings();
        securityGlobalSettings.setSignatureValidationService(this.itsKeyValidationService);
        this._getSSTConfig().secTask.updateGlobalSettings(securityGlobalSettings);
        this.log("Updated Global Security Settings to use '" + this.itsKeyValidationService.getKeyName() + "' as Signature Validation Service");
    }

    @Override
    public String getKeyID() {
        return this.itsKeyValidationServiceID;
    }
}

