/*
 * Decompiled with CFR 0.152.
 */
package com.actional.axis;

import com.actional.APIException;
import com.actional.InternalErrorException;
import com.actional.Log;
import com.actional.StreamLogSink;
import com.actional.config.Util;
import com.actional.eventlog.ILogSink;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import org.apache.axis.AxisEngine;
import org.apache.axis.Constants;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDTypeMapping;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AxisServlet;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.fromJava.Emitter;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.axis_enum.Style;
import org.w3c.dom.Document;

public class SdkWsdlGenerator
extends HttpServlet {
    private String itsResource;
    private String itsPattern;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.itsResource = servletConfig.getInitParameter("wsdl.resource");
        this.itsPattern = servletConfig.getInitParameter("url.pattern");
    }

    public void destroy() {
    }

    public String getServletInfo() {
        return "Actional SDK WSDL servlet";
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendError(403);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try (InputStream inputStream = this.getServletContext().getResourceAsStream(this.itsResource);
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            httpServletResponse.setContentType("text/xml");
            PrintWriter printWriter = httpServletResponse.getWriter();
            String string = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString();
            string = string.substring(0, string.lastIndexOf(47) + 1);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                int n = string2.indexOf(this.itsPattern);
                if (n < 0) {
                    ((Writer)printWriter).write(string2);
                } else {
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + this.itsPattern.length());
                    ((Writer)printWriter).write(string3);
                    ((Writer)printWriter).write(string);
                    ((Writer)printWriter).write(string4);
                }
                string2 = bufferedReader.readLine();
            }
        }
    }

    private static void usage() {
        System.err.println(SdkWsdlGenerator.class.getName() + " [url of AxisServlet] [filename] [service_name | [-literal | -client | -all]*]?");
        System.err.println("\t-literal : generates only the document/literal web services.");
        System.err.println("\t-client  : generates a WSDL that contains the interfaces that a");
        System.err.println("\t\t   client application would call on our product as well as");
        System.err.println("\t\t   callback interfaces that a client can implement.");
        System.err.println("\t-all     : generates a WSDL for each target namespace found in the WSDD");
        System.err.println("\t\t   which means that [filename] is considered to be the basename");
        System.err.println("\t\t   for the WSDL files that are going to be created.");
        System.exit(-1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            SdkWsdlGenerator.usage();
        }
        try {
            Log.setLogLevel((int)0);
            Log.add((ILogSink)new StreamLogSink());
            OfflineGenerator offlineGenerator = new OfflineGenerator();
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = null;
            boolean bl = false;
            for (int i = 2; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                if ("-literal".equals(string4)) {
                    offlineGenerator.itGeneratesLiteralOnly = true;
                    continue;
                }
                if ("-rpc".equals(string4)) {
                    offlineGenerator.itGeneratesLiteralOnly = false;
                    continue;
                }
                if ("-server".equals(string4)) {
                    offlineGenerator.itIsClientWsdl = false;
                    continue;
                }
                if ("-client".equals(string4)) {
                    offlineGenerator.itIsClientWsdl = true;
                    continue;
                }
                if ("-all".equals(string4)) {
                    bl = true;
                    continue;
                }
                if (i > 2) {
                    SdkWsdlGenerator.usage();
                    continue;
                }
                string3 = stringArray[2];
            }
            if (bl) {
                offlineGenerator.generateWSDLs(string, string2);
            } else {
                offlineGenerator.generateWSDL(string, string2, string3);
            }
            System.exit(0);
        }
        catch (Throwable throwable) {
            Log.log((APIException)new InternalErrorException("SdkWsdlGenerator.main() : " + throwable.getMessage(), throwable));
            System.exit(-2);
        }
    }

    public static Document generateDocument(EmitterData emitterData, Definition definition) throws WSDLException {
        Document document = WSDLFactory.newInstance().newWSDLWriter().getDocument(definition);
        if (emitterData.types != null) {
            emitterData.types.insertTypesFragment(document);
        }
        return document;
    }

    public static void addService(EmitterData emitterData, AxisEngine axisEngine, Definition definition, ServiceDesc serviceDesc, String string, TypeMappingRegistry typeMappingRegistry) throws IOException, WSDLException, ClassNotFoundException {
        Emitter emitter = new Emitter();
        if (emitterData.namespaces != null) {
            emitter.namespaces = emitterData.namespaces;
            emitter.exceptionMsg = emitterData.exceptionMsg;
        }
        if (serviceDesc.getStyle() == Style.RPC) {
            emitter.setTypeMapping((TypeMapping)typeMappingRegistry.getTypeMapping(Constants.URI_DEFAULT_SOAP_ENC));
        } else {
            emitter.setTypeMapping((TypeMapping)typeMappingRegistry.getTypeMapping(""));
        }
        emitter.setDefaultTypeMapping((TypeMapping)typeMappingRegistry.getDefaultTypeMapping());
        emitter.setLocationUrl(string);
        emitter.setServicePortName(serviceDesc.getName());
        SdkWsdlGenerator.initEmitter(emitter, serviceDesc);
        emitter.writeDefinitions(definition, serviceDesc.getDefaultNamespace());
        if (emitterData.types == null) {
            emitterData.types = emitter.createTypes(definition);
        }
        emitter.types = emitterData.types;
        Binding binding = emitter.writeBinding(definition, true);
        emitter.writePortType(definition, binding);
        emitter.writeService(definition, binding);
        if (serviceDesc.getName().endsWith("Conversation")) {
            String string2 = serviceDesc.getName();
            string2 = string2.substring(0, string2.length() - "Conversation".length());
            string2 = string2 + "Callback";
            Iterator iterator = axisEngine.getConfig().getDeployedServices();
            while (iterator.hasNext()) {
                ServiceDesc serviceDesc2 = (ServiceDesc)iterator.next();
                if (!serviceDesc2.getName().equals(string2)) continue;
                for (OperationDesc operationDesc : serviceDesc2.getOperations()) {
                    BindingOperation bindingOperation = emitter.writeOperation(definition, binding, operationDesc);
                    Operation operation = bindingOperation.getOperation();
                    operation.setStyle(OperationType.SOLICIT_RESPONSE);
                    emitter.writeMessages(definition, operation, operationDesc, bindingOperation);
                    binding.getPortType().addOperation(operation);
                }
            }
        }
        if (emitterData.namespaces == null) {
            emitterData.namespaces = emitter.namespaces;
            emitterData.exceptionMsg = emitter.exceptionMsg;
        }
    }

    public static void initEmitter(Emitter emitter, ServiceDesc serviceDesc) throws ClassNotFoundException {
        if (serviceDesc.getStyle() == Style.RPC) {
            emitter.setMode(0);
        } else if (serviceDesc.getStyle() == Style.WRAPPED) {
            emitter.setMode(2);
        } else {
            throw new RuntimeException("Unsupported style");
        }
        emitter.setServiceDesc(serviceDesc);
        emitter.setCls(serviceDesc.getImplClass().getName());
        emitter.setIntfNamespace(serviceDesc.getDefaultNamespace());
        emitter.setImplNamespace(serviceDesc.getDefaultNamespace());
        emitter.setPortTypeName(serviceDesc.getName());
        emitter.setBindingName(serviceDesc.getName());
        emitter.init(0);
    }

    public static class OfflineGenerator
    extends AxisServlet {
        boolean itGeneratesLiteralOnly;
        boolean itIsClientWsdl;

        OfflineGenerator() {
            this.axisServer = new AxisServer();
        }

        public void generateWSDLs(String string, String string2) throws Exception {
            Object object;
            Iterator iterator = this.getEngine().getConfig().getDeployedServices();
            TreeSet<String> treeSet = new TreeSet<String>();
            while (iterator.hasNext()) {
                object = (ServiceDesc)iterator.next();
                String string3 = ((ServiceDesc)object).getDefaultNamespace();
                treeSet.add(string3);
            }
            object = treeSet.iterator();
            int n = 1;
            while (object.hasNext()) {
                File file;
                String string4;
                int n2;
                String string5 = (String)object.next();
                String string6 = treeSet.size() > 1 ? ((n2 = (string4 = (file = new File(string2)).getName()).lastIndexOf(46)) < 0 ? string2 + Integer.toString(n) : file.getParentFile() + File.separator + string4.substring(0, n2) + Integer.toString(n) + string4.substring(n2)) : string2;
                this.generateWSDL(string, string6, null, string5);
                ++n;
            }
        }

        public void generateWSDL(String string, Object object, String string2) throws Exception {
            this.generateWSDL(string, object, string2, null);
        }

        private void generateWSDL(String string, Object object, String string2, String string3) throws Exception {
            Object object2;
            Definition definition = WSDLFactory.newInstance().newDefinition();
            EmitterData emitterData = new EmitterData();
            boolean bl = true;
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            Iterator iterator = this.getEngine().getConfig().getDeployedServices();
            while (iterator.hasNext()) {
                object2 = (ServiceDesc)iterator.next();
                if (string2 != null && !string2.equals(((ServiceDesc)object2).getName())) continue;
                if (string2 == null) {
                    boolean bl2;
                    boolean bl3 = bl2 = ((ServiceDesc)object2).getStyle() != Style.RPC;
                    if (bl2 != this.itGeneratesLiteralOnly) continue;
                    String string4 = ((ServiceDesc)object2).getDefaultNamespace();
                    if (string3 != null ? !string3.equals(string4) : "http://soap.plugin.soapstation.actional.com".equals(string4)) continue;
                    if (((ServiceDesc)object2).getName().endsWith("Conversation") || !this.itIsClientWsdl && ((ServiceDesc)object2).getName().endsWith("Callback")) continue;
                }
                bl = false;
                SdkWsdlGenerator.addService(emitterData, this.getEngine(), definition, (ServiceDesc)object2, string + ((ServiceDesc)object2).getName() + ".aapi", this.getEngine().getTypeMappingRegistry());
            }
            if (string2 == null && emitterData.types != null) {
                if (this.getEngine().getConfig() instanceof WSDDEngineConfiguration) {
                    object2 = (WSDDEngineConfiguration)this.getEngine().getConfig();
                    WSDDTypeMapping[] wSDDTypeMappingArray = object2.getDeployment().getTypeMappings();
                    for (int i = 0; i < wSDDTypeMappingArray.length; ++i) {
                        WSDDTypeMapping wSDDTypeMapping = wSDDTypeMappingArray[i];
                        boolean bl4 = Util.isBlank((CharSequence)wSDDTypeMapping.getEncodingStyle());
                        if (bl4 != this.itGeneratesLiteralOnly) continue;
                        emitterData.types.writeType(wSDDTypeMapping.getLanguageSpecificType(), wSDDTypeMapping.getQName());
                    }
                } else {
                    System.err.println("Unexpected: the engine configuration is not a WSDDEngineConfiguration.\nSome type definitions may be missing from the XML schemas.");
                }
            }
            if (!bl) {
                boolean bl5;
                OutputStream outputStream;
                object2 = SdkWsdlGenerator.generateDocument(emitterData, definition);
                if (object instanceof OutputStream) {
                    outputStream = (OutputStream)object;
                    bl5 = false;
                } else {
                    outputStream = new FileOutputStream((String)object);
                    bl5 = true;
                }
                XMLUtils.PrettyDocumentToWriter((Document)object2, new PrintWriter(outputStream));
                if (bl5) {
                    outputStream.close();
                }
            }
        }
    }

    static class EmitterData {
        Namespaces namespaces;
        Map exceptionMsg;
        Types types;
        ArrayList visited = new ArrayList();

        EmitterData() {
        }
    }
}

