/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Multipart;
import javax.mail.internet.MimeMultipart;
import javax.xml.soap.MimeHeaders;
import org.apache.axis.AxisFault;
import org.apache.axis.Part;
import org.apache.axis.SOAPPart;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.AttachmentUtils;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.attachments.DimeBodyPart;
import org.apache.axis.attachments.DimeMultiPart;
import org.apache.axis.attachments.DimeTypeNameFormat;
import org.apache.axis.attachments.ManagedMemoryDataSource;
import org.apache.axis.attachments.MimeUtils;
import org.apache.axis.attachments.MultiPartDimeInputStream;
import org.apache.axis.attachments.MultiPartInputStream;
import org.apache.axis.attachments.MultiPartRelatedInputStream;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class AttachmentsImpl
implements Attachments {
    private static final Log LOGGER = LogFactory.getLog(AttachmentsImpl.class.getName());
    private Map attachments = new HashMap();
    private List orderedAttachments = new LinkedList();
    protected SOAPPart soapPart;
    protected MultiPartInputStream mpartStream;
    protected int sendtype = 1;
    protected String contentLocation;
    MimeMultipart multipart = null;
    DimeMultiPart dimemultipart = null;

    public AttachmentsImpl(Object object, String string, String string2) throws AxisFault {
        StringTokenizer stringTokenizer;
        if (string2 != null && (string2 = string2.trim()).length() == 0) {
            string2 = null;
        }
        this.contentLocation = string2;
        if (string != null && !string.equals("  ") && (stringTokenizer = new StringTokenizer(string, " \t;")).hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equalsIgnoreCase("multipart/related")) {
                this.sendtype = 2;
                this.mpartStream = new MultiPartRelatedInputStream(string, (InputStream)object);
                this.soapPart = new SOAPPart(null, this.mpartStream, false);
            } else if (string3.equalsIgnoreCase("application/dime")) {
                try {
                    this.mpartStream = new MultiPartDimeInputStream((InputStream)object);
                    this.soapPart = new SOAPPart(null, this.mpartStream, false);
                }
                catch (Exception exception) {
                    throw AxisFault.makeFault(exception);
                }
                this.sendtype = 3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeinAttachments() throws AxisFault {
        if (this.mpartStream != null) {
            AttachmentsImpl attachmentsImpl = this;
            synchronized (attachmentsImpl) {
                if (this.mpartStream != null) {
                    Collection collection = this.mpartStream.getAttachments();
                    if (this.contentLocation == null) {
                        this.contentLocation = this.mpartStream.getContentLocation();
                    }
                    this.mpartStream = null;
                    this.setAttachmentParts(collection);
                }
            }
        }
    }

    @Override
    public Part removeAttachmentPart(String string) throws AxisFault {
        this.multipart = null;
        this.dimemultipart = null;
        this.mergeinAttachments();
        Part part = this.getAttachmentByReference(string);
        if (part != null) {
            this.attachments.remove(part.getContentId());
            this.attachments.remove(part.getContentLocation());
            this.orderedAttachments.remove(part);
        }
        return part;
    }

    @Override
    public Part addAttachmentPart(Part part) throws AxisFault {
        this.multipart = null;
        this.dimemultipart = null;
        this.mergeinAttachments();
        Part part2 = this.attachments.put(part.getContentId(), part);
        if (part2 != null) {
            this.orderedAttachments.remove(part2);
            this.attachments.remove(part2.getContentLocation());
        }
        this.orderedAttachments.add(part);
        if (part.getContentLocation() != null) {
            this.attachments.put(part.getContentLocation(), part);
        }
        return part2;
    }

    @Override
    public Part createAttachmentPart(Object object) throws AxisFault {
        this.multipart = null;
        this.dimemultipart = null;
        this.mergeinAttachments();
        if (!(object instanceof DataHandler)) {
            throw new AxisFault(Messages.getMessage("unsupportedAttach", object.getClass().getName(), DataHandler.class.getName()));
        }
        AttachmentPart attachmentPart = new AttachmentPart((DataHandler)object);
        this.addAttachmentPart(attachmentPart);
        return attachmentPart;
    }

    @Override
    public void setAttachmentParts(Collection collection) throws AxisFault {
        this.removeAllAttachments();
        if (collection != null && !collection.isEmpty()) {
            for (Part part : collection) {
                if (null == part) continue;
                this.addAttachmentPart(part);
            }
        }
    }

    @Override
    public Part getAttachmentByReference(String string) throws AxisFault {
        if (null == string) {
            return null;
        }
        if (0 == (string = string.trim()).length()) {
            return null;
        }
        this.mergeinAttachments();
        Part part = (Part)this.attachments.get(string);
        if (null != part) {
            return part;
        }
        if (!string.startsWith("cid:") && null != this.contentLocation) {
            String string2 = this.contentLocation;
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            string2 = string.startsWith("/") ? string2 + string.substring(1) : string2 + string;
            part = (AttachmentPart)this.attachments.get(string2);
        }
        if (null == part && string.startsWith("cid:")) {
            part = (Part)this.attachments.get(string.substring(4));
        }
        return part;
    }

    @Override
    public Collection getAttachments() throws AxisFault {
        this.mergeinAttachments();
        return new LinkedList(this.orderedAttachments);
    }

    @Override
    public Part getRootPart() {
        return this.soapPart;
    }

    @Override
    public void setRootPart(Part part) {
        try {
            this.soapPart = (SOAPPart)part;
            this.multipart = null;
            this.dimemultipart = null;
        }
        catch (ClassCastException classCastException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Method setRootPart failed.", (Throwable)classCastException);
            }
            throw new ClassCastException(Messages.getMessage("onlySOAPParts"));
        }
    }

    @Override
    public long getContentLength() throws AxisFault {
        this.mergeinAttachments();
        int n = this.sendtype == 1 ? 2 : this.sendtype;
        try {
            if (n == 2) {
                if (this.multipart == null) {
                    this.multipart = MimeUtils.createMP(this.soapPart.getAsString(), this.orderedAttachments);
                }
                return (int)MimeUtils.getContentLength((Multipart)this.multipart);
            }
            if (n == 3) {
                return this.createDimeMessage().getTransmissionSize();
            }
        }
        catch (Exception exception) {
            throw AxisFault.makeFault(exception);
        }
        return 0L;
    }

    protected DimeMultiPart createDimeMessage() throws AxisFault {
        int n;
        int n2 = n = this.sendtype == 1 ? 2 : this.sendtype;
        if (n == 3 && this.dimemultipart == null) {
            this.dimemultipart = new DimeMultiPart();
            this.dimemultipart.addBodyPart(new DimeBodyPart(this.soapPart.getAsBytes(), DimeTypeNameFormat.URI, "http://schemas.xmlsoap.org/soap/envelope/", "uuid:714C6C40-4531-442E-A498-3AC614200295"));
            for (AttachmentPart attachmentPart : this.orderedAttachments) {
                DataHandler dataHandler = AttachmentUtils.getActivationDataHandler(attachmentPart);
                this.dimemultipart.addBodyPart(new DimeBodyPart(dataHandler, attachmentPart.getContentId()));
            }
        }
        return this.dimemultipart;
    }

    public void cleanUpAttachments() throws AxisFault {
        try {
            int n = this.sendtype == 1 ? 2 : this.sendtype;
            this.mergeinAttachments();
            if (n == 2 || n == 3) {
                for (AttachmentPart attachmentPart : this.orderedAttachments) {
                    DataHandler dataHandler = AttachmentUtils.getActivationDataHandler(attachmentPart);
                    DataSource dataSource = dataHandler.getDataSource();
                    if (dataSource == null || !(dataSource instanceof ManagedMemoryDataSource)) continue;
                    ((ManagedMemoryDataSource)dataSource).delete();
                }
            }
        }
        catch (Exception exception) {
            throw AxisFault.makeFault(exception);
        }
    }

    @Override
    public void writeContentToStream(OutputStream outputStream) throws AxisFault {
        int n = this.sendtype == 1 ? 2 : this.sendtype;
        try {
            this.mergeinAttachments();
            if (n == 2) {
                if (this.multipart == null) {
                    this.multipart = MimeUtils.createMP(this.soapPart.getAsString(), this.orderedAttachments);
                }
                MimeUtils.writeToMultiPartStream(outputStream, this.multipart);
            } else if (n == 3) {
                this.createDimeMessage().write(outputStream);
            }
        }
        catch (Exception exception) {
            throw AxisFault.makeFault(exception);
        }
    }

    @Override
    public String getContentType() throws AxisFault {
        int n;
        this.mergeinAttachments();
        int n2 = n = this.sendtype == 1 ? 2 : this.sendtype;
        if (n == 2) {
            return MimeUtils.getContentType(this.multipart != null ? this.multipart : (this.multipart = MimeUtils.createMP(this.soapPart.getAsString(), this.orderedAttachments)));
        }
        return "application/dime";
    }

    @Override
    public int getAttachmentCount() {
        try {
            this.mergeinAttachments();
            return this.orderedAttachments.size();
        }
        catch (AxisFault axisFault) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Method getAttachmentCount() failed to count attachments.", (Throwable)axisFault);
            }
            return 0;
        }
    }

    @Override
    public boolean isAttachment(Object object) {
        return AttachmentUtils.isAttachment(object);
    }

    @Override
    public void removeAllAttachments() {
        block2: {
            try {
                this.multipart = null;
                this.dimemultipart = null;
                this.mergeinAttachments();
                this.attachments.clear();
                this.orderedAttachments.clear();
            }
            catch (AxisFault axisFault) {
                LOGGER.warn((Object)Messages.getMessage("exception00"));
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug((Object)"Method removeAllAttachments failed.", (Throwable)axisFault);
            }
        }
    }

    @Override
    public Iterator getAttachments(MimeHeaders mimeHeaders) {
        Vector<Part> vector = new Vector<Part>();
        for (Part part : this.attachments.values()) {
            if (!(part instanceof AttachmentPart) || !((AttachmentPart)part).matches(mimeHeaders)) continue;
            vector.add(part);
        }
        return vector.iterator();
    }

    @Override
    public Part createAttachmentPart() throws AxisFault {
        return new AttachmentPart();
    }

    @Override
    public void setSendType(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("");
        }
        if (n > 4) {
            throw new IllegalArgumentException("");
        }
        this.sendtype = n;
    }

    @Override
    public int getSendType() {
        return this.sendtype;
    }

    public static int getSendType(String string) {
        if ("MIME".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("DIME".equalsIgnoreCase(string)) {
            return 3;
        }
        if ("NONE".equalsIgnoreCase(string)) {
            return 4;
        }
        return 1;
    }

    public static String getSendTypeString(int n) {
        if (n == 2) {
            return "MIME";
        }
        if (n == 3) {
            return "DIME";
        }
        if (n == 4) {
            return "NONE";
        }
        return null;
    }
}

