/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.symbolTable;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.axis.Constants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.symbolTable.DefinedType;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Utils {
    protected Utils() {
    }

    public static QName getNillableQName(QName qName) {
        QName qName2 = qName;
        if (Constants.isSchemaXSD(qName2.getNamespaceURI())) {
            String string = qName2.getLocalPart();
            if ("int".equals(string) || "long".equals(string) || "short".equals(string) || "float".equals(string) || "double".equals(string) || "boolean".equals(string) || "byte".equals(string)) {
                qName2 = new QName(Constants.URI_DEFAULT_SOAP_ENC, qName.getLocalPart());
            } else if ("base64Binary".equals(string) || "hexBinary".equals(string)) {
                qName2 = new QName(Constants.URI_DEFAULT_SOAP_ENC, "base64");
            }
        }
        return qName2;
    }

    public static String getScopedAttribute(Node node, String string) {
        if (node == null) {
            return null;
        }
        if (node.getAttributes() == null) {
            return Utils.getScopedAttribute(node.getParentNode(), string);
        }
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return Utils.getScopedAttribute(node.getParentNode(), string);
    }

    public static String getAttribute(Node node, String string) {
        if (node == null || node.getAttributes() == null) {
            return null;
        }
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    public static Vector getAttributesWithLocalName(Node node, String string) {
        Vector<Node> vector = new Vector<Node>();
        if (node == null) {
            return vector;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                if (node2 == null || !node2.getLocalName().equals(string)) continue;
                vector.add(node2);
            }
        }
        return vector;
    }

    public static QName getNodeQName(Node node) {
        if (node == null) {
            return null;
        }
        String string = node.getLocalName();
        if (string == null) {
            return null;
        }
        String string2 = node.getNamespaceURI();
        return new QName(string2, string);
    }

    public static QName getNodeNameQName(Node node) {
        Object object;
        if (node == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        string = Utils.getAttribute(node, "name");
        if (string == null && (object = Utils.getTypeQNameFromAttr(node, "ref")) != null) {
            string = ((QName)object).getLocalPart();
            string2 = ((QName)object).getNamespaceURI();
        }
        if (string == null) {
            string = "";
            object = node.getParentNode();
            while (object != null) {
                QName qName = Utils.getNodeQName((Node)object);
                if ("schema".equals(qName.getLocalPart())) {
                    object = null;
                    continue;
                }
                if ("element".equals(qName.getLocalPart()) || "attribute".equals(qName.getLocalPart())) {
                    string = ">" + Utils.getNodeNameQName((Node)object).getLocalPart();
                    object = object.getParentNode();
                    continue;
                }
                if ("complexType".equals(qName.getLocalPart()) || "simpleType".equals(qName.getLocalPart())) {
                    string = Utils.getNodeNameQName((Node)object).getLocalPart() + string;
                    object = null;
                    continue;
                }
                object = object.getParentNode();
            }
        }
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = Utils.getScopedAttribute(node, "targetNamespace");
        }
        return new QName(string2, string);
    }

    public static QName getTypeQName(Node node, BooleanHolder booleanHolder, boolean bl) {
        if (node == null) {
            return null;
        }
        booleanHolder.value = false;
        QName qName = Utils.getTypeQNameFromAttr(node, "type");
        if (qName == null) {
            booleanHolder.value = true;
            qName = Utils.getTypeQNameFromAttr(node, "ref");
        }
        if (!bl && qName != null) {
            String string = Utils.getAttribute(node, "maxOccurs");
            String string2 = Utils.getAttribute(node, "minOccurs");
            if (string == null) {
                string = "1";
            }
            if (string2 == null) {
                string2 = "1";
            }
            if ("0".equals(string2) && "1".equals(string)) {
                qName = Utils.getNillableQName(qName);
            } else if (!"1".equals(string) || !"1".equals(string2)) {
                String string3 = qName.getLocalPart();
                string3 = string3 + "[" + string + "]";
                qName = new QName(qName.getNamespaceURI(), string3);
            }
        }
        if (qName == null) {
            booleanHolder.value = true;
            qName = Utils.getTypeQNameFromAttr(node, "element");
        }
        if (qName == null) {
            booleanHolder.value = false;
            qName = Utils.getTypeQNameFromAttr(node, "base");
        }
        return qName;
    }

    private static QName getTypeQNameFromAttr(Node node, String string) {
        QName qName;
        if (node == null) {
            return null;
        }
        String string2 = Utils.getAttribute(node, string);
        if (string2 == null && "type".equals(string) && Utils.getAttribute(node, "ref") == null && Utils.getAttribute(node, "base") == null && Utils.getAttribute(node, "element") == null) {
            qName = SchemaUtils.getElementAnonQName(node);
            if (qName == null) {
                qName = SchemaUtils.getAttributeAnonQName(node);
            }
            if (qName != null) {
                return qName;
            }
            QName qName2 = Utils.getNodeQName(node);
            if (qName2 != null && Constants.isSchemaXSD(qName2.getNamespaceURI()) && ("element".equals(qName2.getLocalPart()) || "attribute".equals(qName2.getLocalPart()))) {
                return Constants.XSD_ANYTYPE;
            }
        }
        if (string2 == null) {
            return null;
        }
        qName = Utils.getQNameFromPrefixedName(node, string2);
        if ("type".equals(string) && JavaUtils.isTrueExplicitly(Utils.getAttribute(node, "nillable"))) {
            qName = Utils.getNillableQName(qName);
        }
        return qName;
    }

    public static QName getQNameFromPrefixedName(Node node, String string) {
        String string2 = string.substring(string.lastIndexOf(":") + 1);
        String string3 = null;
        string3 = string.length() == string2.length() ? Utils.getScopedAttribute(node, "xmlns") : Utils.getScopedAttribute(node, "xmlns:" + string.substring(0, string.lastIndexOf(":")));
        return new QName(string3, string2);
    }

    public static HashSet getDerivedTypes(TypeEntry typeEntry, SymbolTable symbolTable) {
        HashSet hashSet = (HashSet)symbolTable.derivedSets.get(typeEntry);
        if (hashSet != null) {
            return hashSet;
        }
        hashSet = new HashSet();
        symbolTable.derivedSets.put(typeEntry, hashSet);
        if (typeEntry != null) {
            if (typeEntry.getNode() != null) {
                Utils.getDerivedTypes(typeEntry, hashSet, symbolTable);
            } else if (Constants.isSchemaXSD(typeEntry.getQName().getNamespaceURI()) && ("anyType".equals(typeEntry.getQName().getLocalPart()) || "any".equals(typeEntry.getQName().getLocalPart()))) {
                hashSet.addAll(symbolTable.getTypes());
            }
        }
        return hashSet;
    }

    private static void getDerivedTypes(TypeEntry typeEntry, Set set, SymbolTable symbolTable) {
        if (set.size() == symbolTable.getTypes().size()) {
            return;
        }
        Vector vector = symbolTable.getTypes();
        for (TypeEntry typeEntry2 : vector) {
            if (!(typeEntry2 instanceof DefinedType) || typeEntry2.getNode() == null || set.contains(typeEntry2) || SchemaUtils.getComplexElementExtensionBase(typeEntry2.getNode(), symbolTable) != typeEntry) continue;
            set.add(typeEntry2);
            HashSet hashSet = Utils.getDerivedTypes(typeEntry2, symbolTable);
            set.addAll(hashSet);
        }
    }

    public static HashSet getNestedTypes(TypeEntry typeEntry, SymbolTable symbolTable, boolean bl) {
        HashSet hashSet = new HashSet();
        Utils.getNestedTypes(typeEntry, hashSet, symbolTable, bl);
        return hashSet;
    }

    private static void getNestedTypes(TypeEntry typeEntry, Set set, SymbolTable symbolTable, boolean bl) {
        TypeEntry typeEntry2;
        Object object;
        Object object2;
        if (typeEntry == null) {
            return;
        }
        if (set.size() == symbolTable.getTypes().size()) {
            return;
        }
        if (bl) {
            object2 = Utils.getDerivedTypes(typeEntry, symbolTable);
            object = object2.iterator();
            while (object.hasNext()) {
                TypeEntry typeEntry3 = (TypeEntry)object.next();
                if (set.contains(typeEntry3)) continue;
                set.add(typeEntry3);
                Utils.getNestedTypes(typeEntry3, set, symbolTable, bl);
            }
        }
        if (typeEntry.getNode() == null) {
            return;
        }
        object2 = typeEntry.getNode();
        object = SchemaUtils.getContainedElementDeclarations((Node)object2, symbolTable);
        if (object != null) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                ElementDecl elementDecl = (ElementDecl)((Vector)object).get(i);
                if (set.contains(elementDecl.getType())) continue;
                set.add(elementDecl.getType());
                Utils.getNestedTypes(elementDecl.getType(), set, symbolTable, bl);
            }
        }
        if ((object = SchemaUtils.getContainedAttributeTypes((Node)object2, symbolTable)) != null) {
            for (int i = 0; i < ((Vector)object).size(); i += 2) {
                if (set.contains(((Vector)object).get(i))) continue;
                set.add(((Vector)object).get(i));
                Utils.getNestedTypes((TypeEntry)((Vector)object).get(i), set, symbolTable, bl);
            }
        }
        if (typeEntry.getRefType() != null && !set.contains(typeEntry.getRefType())) {
            set.add(typeEntry.getRefType());
            Utils.getNestedTypes(typeEntry.getRefType(), set, symbolTable, bl);
        }
        if ((typeEntry2 = SchemaUtils.getComplexElementExtensionBase((Node)object2, symbolTable)) != null && !set.contains(typeEntry2)) {
            set.add(typeEntry2);
            Utils.getNestedTypes(typeEntry2, set, symbolTable, bl);
        }
    }

    public static String genQNameAttributeString(QName qName, String string) {
        if (qName.getNamespaceURI() == null || "".equals(qName.getNamespaceURI())) {
            return qName.getLocalPart();
        }
        return string + ":" + qName.getLocalPart() + "\" xmlns:" + string + "=\"" + qName.getNamespaceURI();
    }
}

