/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.axis.Constants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionTE;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaEnumTypeWriter;
import org.apache.axis.wsdl.toJava.JavaGeneratorFactory;
import org.apache.axis.wsdl.toJava.Namespaces;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Utils
extends org.apache.axis.wsdl.symbolTable.Utils {
    private static final boolean USE_ORIGINAL_NAMESPACE_MAPPING = Boolean.getBoolean("org.apache.axis.wsdl.toJava.Utils.useOriginalNamespaceMapping");
    private static HashMap TYPES = new HashMap(7);
    private static HashMap constructorMap;
    private static HashMap constructorThrowMap;

    private Utils() {
    }

    public static String holder(String string, TypeEntry typeEntry, Emitter emitter) {
        String string2;
        if (string != null) {
            if ("image/gif".equals(string) || "image/jpeg".equals(string)) {
                return "org.apache.axis.holders.ImageHolder";
            }
            if ("text/plain".equals(string)) {
                return "javax.xml.rpc.holders.StringHolder";
            }
            if (string.startsWith("multipart/")) {
                return "org.apache.axis.holders.MimeMultipartHolder";
            }
            if ("text/xml".equals(string) || "application/xml".equals(string)) {
                return "org.apache.axis.holders.SourceHolder";
            }
        }
        if ("byte[]".equals(string2 = typeEntry.getName())) {
            return "javax.xml.rpc.holders.ByteArrayHolder";
        }
        if (string2.endsWith("[]")) {
            String string3 = emitter.getJavaName(typeEntry.getQName());
            string3 = JavaUtils.replace(string3, "[]", "Array");
            string3 = Utils.addPackageName(string3, "holders");
            return string3 + "Holder";
        }
        if ("String".equals(string2)) {
            return "javax.xml.rpc.holders.StringHolder";
        }
        if ("java.lang.String".equals(string2)) {
            return "javax.xml.rpc.holders.StringHolder";
        }
        if ("Object".equals(string2)) {
            return "javax.xml.rpc.holders.ObjectHolder";
        }
        if ("java.lang.Object".equals(string2)) {
            return "javax.xml.rpc.holders.ObjectHolder";
        }
        if ("int".equals(string2) || "long".equals(string2) || "short".equals(string2) || "float".equals(string2) || "double".equals(string2) || "boolean".equals(string2) || "byte".equals(string2)) {
            return "javax.xml.rpc.holders." + Utils.capitalizeFirstChar(string2) + "Holder";
        }
        if (string2.startsWith("java.lang.")) {
            return "javax.xml.rpc.holders" + string2.substring(string2.lastIndexOf(".")) + "WrapperHolder";
        }
        if (string2.indexOf(".") < 0) {
            return "javax.xml.rpc.holders" + string2 + "WrapperHolder";
        }
        if ("java.math.BigDecimal".equals(string2)) {
            return "javax.xml.rpc.holders.BigDecimalHolder";
        }
        if ("java.math.BigInteger".equals(string2)) {
            return "javax.xml.rpc.holders.BigIntegerHolder";
        }
        if ("java.util.Date".equals(string2)) {
            return "org.apache.axis.holders.DateHolder";
        }
        if ("java.util.Calendar".equals(string2)) {
            return "javax.xml.rpc.holders.CalendarHolder";
        }
        if ("javax.xml.namespace.QName".equals(string2)) {
            return "javax.xml.rpc.holders.QNameHolder";
        }
        if (string2.startsWith("org.apache.axis.types.")) {
            int n = string2.lastIndexOf(46);
            String string4 = string2.substring(n + 1);
            return "org.apache.axis.holders." + string4 + "Holder";
        }
        return Utils.addPackageName(string2, "holders") + "Holder";
    }

    public static String addPackageName(String string, String string2) {
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            return string.substring(0, n) + "." + string2 + string.substring(n);
        }
        return string2 + "." + string;
    }

    public static String getFullExceptionName(Fault fault, Emitter emitter) {
        Message message = fault.getMessage();
        MessageEntry messageEntry = emitter.getSymbolTable().getMessageEntry(message.getQName());
        return (String)messageEntry.getDynamicVar(JavaGeneratorFactory.EXCEPTION_CLASS_NAME);
    }

    public static Vector getEnumerationBaseAndValues(Node node, SymbolTable symbolTable) {
        Serializable serializable;
        int n;
        Node node2;
        NodeList nodeList;
        if (node == null) {
            return null;
        }
        QName qName = Utils.getNodeQName(node);
        if (qName != null && "element".equals(qName.getLocalPart()) && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                serializable = Utils.getNodeQName(nodeList.item(n));
                if (serializable == null || !"simpleType".equals(((QName)serializable).getLocalPart()) || !Constants.isSchemaXSD(((QName)serializable).getNamespaceURI())) continue;
                node = node2 = nodeList.item(n);
            }
        }
        if ((qName = Utils.getNodeQName(node)) != null && "simpleType".equals(qName.getLocalPart()) && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            Object object;
            nodeList = node.getChildNodes();
            node2 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                serializable = Utils.getNodeQName(nodeList.item(n));
                if (serializable == null || !"restriction".equals(((QName)serializable).getLocalPart()) || !Constants.isSchemaXSD(((QName)serializable).getNamespaceURI())) continue;
                node2 = nodeList.item(n);
            }
            Type type = null;
            if (node2 != null && (type = symbolTable.getType((QName)(serializable = Utils.getTypeQName(node2, new BooleanHolder(), false)))) != null && ("boolean".equals(object = type.getName()) || !SchemaUtils.isSimpleSchemaType(type.getQName()))) {
                type = null;
            }
            if (type != null && node2 != null) {
                serializable = new Vector();
                object = node2.getChildNodes();
                for (int i = 0; i < object.getLength(); ++i) {
                    Node node3;
                    String string;
                    QName qName2 = Utils.getNodeQName(object.item(i));
                    if (qName2 == null || !"enumeration".equals(qName2.getLocalPart()) || !Constants.isSchemaXSD(qName2.getNamespaceURI()) || (string = Utils.getAttribute(node3 = object.item(i), "value")) == null) continue;
                    ((Vector)serializable).add(string);
                }
                if (((Vector)serializable).isEmpty()) {
                    return null;
                }
                ((Vector)serializable).add(0, type);
                return serializable;
            }
        }
        return null;
    }

    public static String capitalizeFirstChar(String string) {
        if (string == null || "".equals(string)) {
            return string;
        }
        char c = string.charAt(0);
        if (Character.isLowerCase(c)) {
            c = Character.toUpperCase(c);
            return c + string.substring(1);
        }
        return string;
    }

    public static String xmlNameToJava(String string) {
        return JavaUtils.xmlNameToJava(string);
    }

    public static String xmlNameToJavaClass(String string) {
        return Utils.capitalizeFirstChar(Utils.xmlNameToJava(string));
    }

    public static String makePackageName(String string) {
        CharSequence charSequence;
        String string2;
        String string3;
        Object object;
        try {
            object = new URL(string);
            string3 = ((URL)object).getHost();
            string2 = ((URL)object).getPath();
        }
        catch (MalformedURLException malformedURLException) {
            if (string.indexOf(":") > -1) {
                string3 = string.substring(string.indexOf(":") + 1);
                if (string3.indexOf("/") > -1) {
                    string3 = string3.substring(0, string3.indexOf("/"));
                }
            } else {
                string3 = string;
            }
            string2 = "";
        }
        if (string3 == null) {
            return null;
        }
        string3 = string3.replace('-', '_');
        object = new StringTokenizer(string3, ".");
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        while (((StringTokenizer)object).hasMoreTokens()) {
            charSequence = ((StringTokenizer)object).nextToken();
            if ("www".equals(charSequence)) continue;
            arrayList.add(0, charSequence);
        }
        if (!USE_ORIGINAL_NAMESPACE_MAPPING) {
            object = new StringTokenizer(string2, "/");
            while (((StringTokenizer)object).hasMoreTokens()) {
                charSequence = ((StringTokenizer)object).nextToken();
                arrayList.add(charSequence);
            }
        }
        charSequence = new StringBuilder(80);
        boolean bl = false;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string4 = (String)arrayList.get(i);
            if (JavaUtils.isJavaKeyword(string4)) {
                string4 = JavaUtils.makeNonJavaKeyword(string4);
            }
            if (bl) {
                ((StringBuilder)charSequence).append('.');
            } else {
                bl = true;
            }
            if (Character.isDigit(string4.charAt(0))) {
                ((StringBuilder)charSequence).append('_');
            }
            ((StringBuilder)charSequence).append(string4);
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static String getJavaLocalName(String string) {
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static String getJavaPackageName(String string) {
        if (string.lastIndexOf(46) > 0) {
            return string.substring(0, string.lastIndexOf(46));
        }
        return "";
    }

    public static boolean fileExists(String string, String string2, Namespaces namespaces) throws IOException {
        String string3 = namespaces.getAsDir(string2);
        String string4 = string3 + string;
        return new File(string4).exists();
    }

    public static String wrapPrimitiveType(TypeEntry typeEntry, String string) {
        String string2;
        String string3 = string2 = typeEntry == null ? null : (String)TYPES.get(typeEntry.getName());
        if (string2 != null) {
            return "new " + string2 + "(" + string + ")";
        }
        if (typeEntry != null && "byte[]".equals(typeEntry.getName()) && "hexBinary".equals(typeEntry.getQName().getLocalPart())) {
            return "new org.apache.axis.types.HexBinary(" + string + ")";
        }
        return string;
    }

    public static String getResponseString(TypeEntry typeEntry, String string, String string2) {
        if (typeEntry == null) {
            return ";";
        }
        if (string != null) {
            if ("image/jpeg".equals(string)) {
                return "(java.awt.Image) " + string2 + ";";
            }
            if ("text/plain".equals(string)) {
                return "(java.lang.String) " + string2 + ";";
            }
            if ("text/xml".equals(string) || "application/xml".equals(string)) {
                return "(javax.xml.transform.Source) " + string2 + ";";
            }
            if (string.startsWith("multipart/")) {
                return "(javax.mail.internet.MimeMultipart) " + string2 + ";";
            }
            return "(" + typeEntry.getName() + ") " + string2 + ";";
        }
        String string3 = (String)TYPES.get(typeEntry.getName());
        if (string3 != null) {
            return "((" + string3 + ") " + string2 + ")." + typeEntry.getName() + "Value();";
        }
        return "(" + typeEntry.getName() + ") " + string2 + ";";
    }

    public static boolean isPrimitiveType(TypeEntry typeEntry) {
        return TYPES.get(typeEntry.getName()) != null;
    }

    public static QName getOperationQName(BindingOperation bindingOperation) {
        Object object;
        Object object2;
        Input input;
        Operation operation = bindingOperation.getOperation();
        String string = operation.getName();
        QName qName = null;
        String string2 = null;
        BindingInput bindingInput = bindingOperation.getBindingInput();
        if (bindingInput != null) {
            input = bindingInput.getExtensibilityElements().iterator();
            while (input.hasNext()) {
                object2 = (ExtensibilityElement)input.next();
                if (!(object2 instanceof SOAPBody)) continue;
                object = (SOAPBody)object2;
                string2 = object.getNamespaceURI();
                break;
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        if ((input = operation.getInput()) != null && (object2 = input.getMessage().getParts()) != null && !object2.isEmpty()) {
            object = object2.values().iterator();
            Part part = (Part)object.next();
            qName = part.getElementName();
        }
        if (qName == null) {
            qName = new QName(string2, string);
        }
        return qName;
    }

    public static String getNewQName(QName qName) {
        return "new javax.xml.namespace.QName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\")";
    }

    public static String getParameterTypeName(Parameter parameter) {
        String string;
        String string2 = parameter.getMIMEType();
        if (string2 == null) {
            string = parameter.getType().getName();
        } else {
            string = JavaUtils.mimeToJava(string2);
            if (string == null) {
                string = parameter.getType().getName();
            }
        }
        return string;
    }

    public static QName getXSIType(Parameter parameter) {
        if (parameter.getMIMEType() != null) {
            return Utils.getMIMETypeQName(parameter.getMIMEType());
        }
        return Utils.getXSIType(parameter.getType());
    }

    public static QName getXSIType(TypeEntry typeEntry) {
        QName qName = null;
        if (typeEntry != null && typeEntry instanceof Element && typeEntry.getRefType() != null) {
            typeEntry = typeEntry.getRefType();
        }
        if (typeEntry != null && typeEntry instanceof CollectionTE && typeEntry.getRefType() != null) {
            typeEntry = typeEntry.getRefType();
        }
        if (typeEntry != null) {
            qName = typeEntry.getQName();
        }
        return qName;
    }

    public static QName getMIMETypeQName(String string) {
        if ("text/plain".equals(string)) {
            return Constants.MIME_PLAINTEXT;
        }
        if ("image/gif".equals(string) || "image/jpeg".equals(string)) {
            return Constants.MIME_IMAGE;
        }
        if ("text/xml".equals(string) || "applications/xml".equals(string)) {
            return Constants.MIME_SOURCE;
        }
        if (string != null && string.startsWith("multipart/")) {
            return Constants.MIME_MULTIPART;
        }
        return null;
    }

    public static boolean hasMIME(BindingEntry bindingEntry) {
        List list = bindingEntry.getBinding().getBindingOperations();
        for (int i = 0; i < list.size(); ++i) {
            BindingOperation bindingOperation = (BindingOperation)list.get(i);
            if (!Utils.hasMIME(bindingEntry, bindingOperation)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMIME(BindingEntry bindingEntry, BindingOperation bindingOperation) {
        Parameters parameters = bindingEntry.getParameters(bindingOperation.getOperation());
        if (parameters != null) {
            for (int i = 0; i < parameters.list.size(); ++i) {
                Parameter parameter = (Parameter)parameters.list.get(i);
                if (parameter.getMIMEType() == null) continue;
                return true;
            }
        }
        return false;
    }

    static String getConstructorForParam(Parameter parameter, SymbolTable symbolTable, BooleanHolder booleanHolder) {
        String string = parameter.getType().getName();
        String string2 = parameter.getMIMEType();
        String string3 = null;
        if (string2 != null) {
            if ("image/gif".equals(string2) || "image/jpeg".equals(string2)) {
                return "null";
            }
            if ("text/xml".equals(string2) || "application/xml".equals(string2)) {
                return "new javax.xml.transform.stream.StreamSource()";
            }
            return "new " + Utils.getParameterTypeName(parameter) + "()";
        }
        string3 = (String)constructorMap.get(string);
        if (string3 != null) {
            return string3;
        }
        string3 = (String)constructorThrowMap.get(string);
        if (string3 != null) {
            booleanHolder.value = true;
            return string3;
        }
        if (string.endsWith("[]")) {
            return "new " + JavaUtils.replace(string, "[]", "[0]");
        }
        Vector vector = Utils.getEnumerationBaseAndValues(parameter.getType().getNode(), symbolTable);
        if (vector != null) {
            String string4 = (String)JavaEnumTypeWriter.getEnumValueIds(vector).get(0);
            return string + "." + string4;
        }
        return "new " + string + "()";
    }

    static {
        TYPES.put("int", "java.lang.Integer");
        TYPES.put("float", "java.lang.Float");
        TYPES.put("boolean", "java.lang.Boolean");
        TYPES.put("double", "java.lang.Double");
        TYPES.put("byte", "java.lang.Byte");
        TYPES.put("short", "java.lang.Short");
        TYPES.put("long", "java.lang.Long");
        constructorMap = new HashMap(50);
        constructorThrowMap = new HashMap(50);
        constructorMap.put("int", "0");
        constructorMap.put("float", "0");
        constructorMap.put("boolean", "true");
        constructorMap.put("double", "0");
        constructorMap.put("byte", "(byte)0");
        constructorMap.put("short", "(short)0");
        constructorMap.put("long", "0");
        constructorMap.put("java.lang.Boolean", "new java.lang.Boolean(false)");
        constructorMap.put("java.lang.Byte", "new java.lang.Byte((byte)0)");
        constructorMap.put("java.lang.Double", "new java.lang.Double(0)");
        constructorMap.put("java.lang.Float", "new java.lang.Float(0)");
        constructorMap.put("java.lang.Integer", "new java.lang.Integer(0)");
        constructorMap.put("java.lang.Long", "new java.lang.Long(0)");
        constructorMap.put("java.lang.Short", "new java.lang.Short((short)0)");
        constructorMap.put("java.math.BigDecimal", "new java.math.BigDecimal(0)");
        constructorMap.put("java.math.BigInteger", "new java.math.BigInteger(\"0\")");
        constructorMap.put("java.lang.Object", "new java.lang.String()");
        constructorMap.put("byte[]", "new byte[0]");
        constructorMap.put("java.util.Calendar", "java.util.Calendar.getInstance()");
        constructorMap.put("javax.xml.namespace.QName", "new javax.xml.namespace.QName(\"http://double-double\", \"toil-and-trouble\")");
        constructorMap.put("org.apache.axis.types.NonNegativeInteger", "new org.apache.axis.types.NonNegativeInteger(\"0\")");
        constructorMap.put("org.apache.axis.types.PositiveInteger", "new org.apache.axis.types.PositiveInteger(\"1\")");
        constructorMap.put("org.apache.axis.types.NonPositiveInteger", "new org.apache.axis.types.NonPositiveInteger(\"0\")");
        constructorMap.put("org.apache.axis.types.NegativeInteger", "new org.apache.axis.types.NegativeInteger(\"-1\")");
        constructorThrowMap.put("org.apache.axis.types.Time", "new org.apache.axis.types.Time(\"15:45:45.275Z\")");
        constructorThrowMap.put("org.apache.axis.types.UnsignedLong", "new org.apache.axis.types.UnsignedLong(0)");
        constructorThrowMap.put("org.apache.axis.types.UnsignedInt", "new org.apache.axis.types.UnsignedInt(0)");
        constructorThrowMap.put("org.apache.axis.types.UnsignedShort", "new org.apache.axis.types.UnsignedShort(0)");
        constructorThrowMap.put("org.apache.axis.types.UnsignedByte", "new org.apache.axis.types.UnsignedByte(0)");
        constructorThrowMap.put("org.apache.axis.types.URI", "new org.apache.axis.types.URI(\"urn:testing\")");
        constructorThrowMap.put("org.apache.axis.types.Year", "new org.apache.axis.types.Year(2000)");
        constructorThrowMap.put("org.apache.axis.types.Month", "new org.apache.axis.types.Month(1)");
        constructorThrowMap.put("org.apache.axis.types.Day", "new org.apache.axis.types.Day(1)");
        constructorThrowMap.put("org.apache.axis.types.YearMonth", "new org.apache.axis.types.YearMonth(2000,1)");
        constructorThrowMap.put("org.apache.axis.types.MonthDay", "new org.apache.axis.types.MonthDay(1, 1)");
    }
}

