/*
 * Decompiled with CFR 0.152.
 */
package com.actional.soapapi.jetty;

import com.actional.jetty.task.IListenersTask;
import com.actional.jetty.task.IListenersTaskServiceLocator;
import com.actional.jetty.task.ISettingsTask;
import com.actional.jetty.task.ISettingsTaskServiceLocator;
import com.actional.soapapi.Config;
import com.actional.soapapi.jetty.JettyTask;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.Call;
import javax.xml.rpc.ServiceException;

public class JettyConfig
extends Config {
    protected IListenersTaskServiceLocator listenersTaskLocator = new IListenersTaskServiceLocator(){

        public Call createCall() throws ServiceException {
            return JettyConfig.this.prepareCall(super.createCall());
        }
    };
    protected ISettingsTaskServiceLocator settingsTaskLocator = new ISettingsTaskServiceLocator(){

        public Call createCall() throws ServiceException {
            return JettyConfig.this.prepareCall(super.createCall());
        }
    };
    private IListenersTask listenersTask;
    private ISettingsTask settingsTask;
    protected static JettyConfig itsDefaultConfig;
    protected Map itsTaskCache = new HashMap();

    public static synchronized JettyConfig getDefaultConfig() {
        return itsDefaultConfig;
    }

    public static synchronized void setDefaultConfig(JettyConfig jettyConfig) {
        itsDefaultConfig = jettyConfig;
    }

    public static synchronized boolean setDefaultConfigIfNotSet(JettyConfig jettyConfig) {
        if (itsDefaultConfig == null) {
            itsDefaultConfig = jettyConfig;
            return true;
        }
        return false;
    }

    public IListenersTask getListenersTask() {
        return this.listenersTask;
    }

    public ISettingsTask getSettingsTask() {
        return this.settingsTask;
    }

    public JettyConfig() {
        super(null, null, null);
    }

    public JettyConfig(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    @Override
    protected void prepareTasks() throws ServiceException, MalformedURLException {
        super.prepareTasks();
        this.listenersTask = this.listenersTaskLocator.getIListenersTask(this.proxyUrl(this.listenersTaskLocator.getIListenersTaskAddress()));
        this.prepareStub(this.listenersTask);
        this.settingsTask = this.settingsTaskLocator.getISettingsTask(this.proxyUrl(this.settingsTaskLocator.getISettingsTaskAddress()));
        this.prepareStub(this.settingsTask);
    }

    public synchronized JettyTask createTask(Class clazz) throws Exception {
        JettyTask jettyTask = (JettyTask)this.itsTaskCache.get(clazz);
        if (jettyTask != null) {
            return jettyTask;
        }
        try {
            jettyTask = (JettyTask)clazz.newInstance();
            jettyTask.setConfig(this);
            this.itsTaskCache.put(clazz, jettyTask);
            return jettyTask;
        }
        catch (Exception exception) {
            throw new Exception("Failed to instanciate class: " + clazz.getName(), exception);
        }
    }
}

