/*
 * Decompiled with CFR 0.152.
 */
package com.actional.soapapi.soapstation;

import com.actional.soapapi.Util;
import com.actional.soapapi.soapstation.SSTTask;
import com.actional.soapstation.db.ExportItem;
import com.actional.soapstation.task.FileDefTO;
import com.actional.soapstation.task.ImportDef;
import java.io.File;
import java.io.FileOutputStream;

public class DeploymentTask
extends SSTTask {
    private static final String NO_FILES = "No files specified for import.";

    public String importCustom(ImportDef importDef, String[] stringArray, File file) throws Exception {
        if (Util.isBlank(stringArray)) {
            return NO_FILES;
        }
        int n = stringArray.length;
        FileDefTO[] fileDefTOArray = new FileDefTO[n];
        for (int i = 0; i < n; ++i) {
            FileDefTO fileDefTO = new FileDefTO();
            fileDefTO.setContent(Util.readFileAsBytes(new File(file, stringArray[i])));
            fileDefTO.setName(stringArray[i]);
            fileDefTOArray[i] = fileDefTO;
        }
        importDef.setFiles(fileDefTOArray);
        return this.config().deployTask.importCustom(importDef);
    }

    public String export(ExportItem[] exportItemArray, File file) throws Exception {
        FileDefTO fileDefTO = this.config().deployTask.export(exportItemArray);
        if (fileDefTO == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        this.doExport(fileDefTO, file, stringBuffer);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport(FileDefTO fileDefTO, File file, StringBuffer stringBuffer) throws Exception {
        if (fileDefTO == null) {
            return;
        }
        File file2 = new File(file, fileDefTO.getName());
        if (stringBuffer.length() != 0) {
            stringBuffer.append(", ");
        }
        stringBuffer.append(fileDefTO.getName());
        if (Util.isBlank(fileDefTO.getContent())) {
            throw new Exception("File is Empty: " + fileDefTO.getName());
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
            fileOutputStream.write(fileDefTO.getContent());
        }
    }
}

