/*
 * Decompiled with CFR 0.152.
 */
package com.actional.soapapi.anttask.soapstation;

import com.actional.soapapi.Config;
import com.actional.soapapi.Util;
import com.actional.soapapi.anttask.soapstation.ExportItemType;
import com.actional.soapapi.anttask.soapstation.SOAPstationTaskBase;
import com.actional.soapapi.soapstation.DeploymentTask;
import com.actional.soapstation.db.ExportItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExportConfigTask
extends SOAPstationTaskBase {
    protected List itsExportItems = new ArrayList();
    protected File itsOutputDir;

    public void setOutputDir(File file) {
        this.itsOutputDir = file;
    }

    public void addExport(ExportItemType exportItemType) {
        this.itsExportItems.add(exportItemType);
    }

    @Override
    public void executeEx() throws Exception {
        ExportItemType exportItemType;
        if (Util.isBlank((Collection)this.itsExportItems)) {
            this.log("No configuration has been specified for export.");
            return;
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.itsExportItems.size(); ++i) {
            exportItemType = (ExportItemType)((Object)this.itsExportItems.get(i));
            exportItemType.populate((Config)this._getSSTConfig(), arrayList);
        }
        ExportItem[] exportItemArray = arrayList.toArray(new ExportItem[arrayList.size()]);
        exportItemType = (DeploymentTask)this.createTask(DeploymentTask.class);
        String string = exportItemType.export(exportItemArray, this.itsOutputDir);
        if (string == null) {
            this.log("No configuration has been exported");
        } else {
            this.log("Successfully exported the configuration to the following file(s): " + string);
        }
    }
}

