/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import javax.xml.namespace.QName;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.message.BodyBuilder;
import org.apache.axis.message.HeaderBuilder;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EnvelopeBuilder
extends SOAPHandler {
    private SOAPEnvelope envelope;
    private SOAPConstants soapConstants = SOAPConstants.SOAP11_CONSTANTS;
    private boolean gotHeader = false;
    private boolean gotBody = false;

    public EnvelopeBuilder(String messageType, SOAPConstants soapConstants) {
        this.envelope = new SOAPEnvelope(false, soapConstants);
        this.envelope.setMessageType(messageType);
        this.myElement = this.envelope;
    }

    public EnvelopeBuilder(SOAPEnvelope env, String messageType) {
        this.envelope = env;
        this.envelope.setMessageType(messageType);
        this.myElement = this.envelope;
    }

    public SOAPEnvelope getEnvelope() {
        return this.envelope;
    }

    public void startElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        if (!localName.equals("Envelope")) {
            throw new SAXException(Messages.getMessage("badTag00", localName));
        }
        if (namespace.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            this.soapConstants = SOAPConstants.SOAP11_CONSTANTS;
        } else if (namespace.equals("http://www.w3.org/2002/06/soap-envelope")) {
            this.soapConstants = SOAPConstants.SOAP12_CONSTANTS;
        } else {
            throw new SAXException(Messages.getMessage("badNamespace00", namespace));
        }
        if (context.getMessageContext() != null) {
            context.getMessageContext().setSOAPConstants(this.soapConstants);
        }
        this.envelope.setPrefix(prefix);
        this.envelope.setNamespaceURI(namespace);
        this.envelope.setNSMappings(context.getCurrentNSMappings());
        context.pushNewElement(this.envelope);
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        QName thisQName = new QName(namespace, localName);
        if (thisQName.equals(this.soapConstants.getHeaderQName())) {
            if (this.gotHeader) {
                throw new SAXException(Messages.getMessage("only1Header00"));
            }
            this.gotHeader = true;
            return new HeaderBuilder(this.envelope);
        }
        if (thisQName.equals(this.soapConstants.getBodyQName())) {
            if (this.gotBody) {
                throw new SAXException(Messages.getMessage("only1Body00"));
            }
            this.gotBody = true;
            return new BodyBuilder(this.envelope);
        }
        if (!this.gotBody) {
            throw new SAXException(Messages.getMessage("noCustomElems00"));
        }
        MessageElement element = new MessageElement(namespace, localName, prefix, attributes, context);
        if (element.getFixupDeserializer() != null) {
            return (SOAPHandler)((Object)element.getFixupDeserializer());
        }
        return null;
    }

    public void onEndChild(String namespace, String localName, DeserializationContext context) {
    }

    public void endElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        this.envelope.setDirty(false);
    }
}

