/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.symbolTable;

import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import org.apache.axis.Constants;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.symbolTable.Utils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaUtils {
    private static String[] schemaTypes = new String[]{"string", "normalizedString", "token", "byte", "unsignedByte", "base64Binary", "hexBinary", "integer", "positiveInteger", "negativeInteger", "nonNegativeInteger", "nonPositiveInteger", "int", "unsignedInt", "long", "unsignedLong", "short", "unsignedShort", "decimal", "float", "double", "boolean", "time", "dateTime", "duration", "date", "gMonth", "gYear", "gYearMonth", "gDay", "gMonthDay", "Name", "QName", "NCName", "anyURI", "language", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NOTATION", "NMTOKEN", "NMTOKENS"};

    private SchemaUtils() {
    }

    public static Vector getContainedElementDeclarations(Node object, SymbolTable symbolTable) {
        Object object2;
        Object object3;
        Object object4;
        if (object == null) {
            return null;
        }
        QName qName = Utils.getNodeQName((Node)object);
        if (qName != null && "element".equals(qName.getLocalPart()) && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            object4 = object.getChildNodes();
            object3 = null;
            for (int i = 0; i < object4.getLength() && object3 == null; ++i) {
                object2 = Utils.getNodeQName(object4.item(i));
                if (object2 == null || !"complexType".equals(((QName)object2).getLocalPart()) || !Constants.isSchemaXSD(((QName)object2).getNamespaceURI())) continue;
                object = object3 = object4.item(i);
            }
        }
        if ((qName = Utils.getNodeQName((Node)object)) != null && "complexType".equals(qName.getLocalPart()) && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            QName qName2;
            int n;
            object4 = object.getChildNodes();
            object3 = null;
            Node node = null;
            object2 = null;
            for (n = 0; n < object4.getLength() && object3 == null; ++n) {
                qName2 = Utils.getNodeQName(object4.item(n));
                if (qName2 == null || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                if ("complexContent".equals(qName2.getLocalPart())) {
                    object3 = object4.item(n);
                    continue;
                }
                if (!"simpleContent".equals(qName2.getLocalPart())) continue;
                node = object4.item(n);
            }
            if (object3 != null) {
                object4 = object3.getChildNodes();
                for (n = 0; n < object4.getLength() && object2 == null; ++n) {
                    qName2 = Utils.getNodeQName(object4.item(n));
                    if (qName2 == null || !"extension".equals(qName2.getLocalPart()) || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                    object2 = object4.item(n);
                }
            }
            if (node != null) {
                object4 = node.getChildNodes();
                for (n = 0; n < object4.getLength() && object2 == null; ++n) {
                    qName2 = Utils.getNodeQName(object4.item(n));
                    if (qName2 == null || !"extension".equals(qName2.getLocalPart()) || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                    QName qName3 = Utils.getTypeQName(object4.item(n), new BooleanHolder(), false);
                    Vector<ElementDecl> vector = new Vector<ElementDecl>();
                    ElementDecl elementDecl = new ElementDecl();
                    elementDecl.setType(symbolTable.getTypeEntry(qName3, false));
                    elementDecl.setName(new QName("", "value"));
                    vector.add(elementDecl);
                    return vector;
                }
            }
            if (object2 != null) {
                object = object2;
            }
            object4 = object.getChildNodes();
            Vector vector = new Vector();
            for (int i = 0; i < object4.getLength(); ++i) {
                QName qName4 = Utils.getNodeQName(object4.item(i));
                if (qName4 == null || !Constants.isSchemaXSD(qName4.getNamespaceURI())) continue;
                if ("sequence".equals(qName4.getLocalPart())) {
                    vector.addAll(SchemaUtils.processSequenceNode(object4.item(i), symbolTable));
                    continue;
                }
                if ("all".equals(qName4.getLocalPart())) {
                    vector.addAll(SchemaUtils.processAllNode(object4.item(i), symbolTable));
                    continue;
                }
                if ("choice".equals(qName4.getLocalPart())) {
                    vector.addAll(SchemaUtils.processChoiceNode(object4.item(i), symbolTable));
                    continue;
                }
                if (!"group".equals(qName4.getLocalPart())) continue;
                vector.addAll(SchemaUtils.processGroupNode(object4.item(i), symbolTable));
            }
            return vector;
        }
        object4 = SchemaUtils.getSimpleTypeBase((Node)object);
        if (object4 != null && (object3 = symbolTable.getType((QName)object4)) != null) {
            Vector<Object> vector = new Vector<Object>();
            object2 = new ElementDecl();
            ((ElementDecl)object2).setType((TypeEntry)object3);
            ((ElementDecl)object2).setName(new QName("", "value"));
            vector.add(object2);
            return vector;
        }
        return null;
    }

    private static Vector processChoiceNode(Node node, SymbolTable symbolTable) {
        Vector<ElementDecl> vector = new Vector<ElementDecl>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            QName qName = Utils.getNodeQName(nodeList.item(i));
            if (qName == null || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
            if ("choice".equals(qName.getLocalPart())) {
                vector.addAll(SchemaUtils.processChoiceNode(nodeList.item(i), symbolTable));
                continue;
            }
            if ("sequence".equals(qName.getLocalPart())) {
                vector.addAll(SchemaUtils.processSequenceNode(nodeList.item(i), symbolTable));
                continue;
            }
            if ("group".equals(qName.getLocalPart())) {
                vector.addAll(SchemaUtils.processGroupNode(nodeList.item(i), symbolTable));
                continue;
            }
            if (!"element".equals(qName.getLocalPart())) continue;
            ElementDecl elementDecl = SchemaUtils.processChildElementNode(nodeList.item(i), symbolTable);
            elementDecl.setMinOccursIs0(true);
            if (elementDecl == null) continue;
            vector.add(elementDecl);
        }
        return vector;
    }

    private static Vector processSequenceNode(Node node, SymbolTable symbolTable) {
        Vector<Object> vector = new Vector<Object>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            QName qName = Utils.getNodeQName(nodeList.item(i));
            if (qName == null || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
            if ("choice".equals(qName.getLocalPart())) {
                vector.addAll(SchemaUtils.processChoiceNode(nodeList.item(i), symbolTable));
                continue;
            }
            if ("sequence".equals(qName.getLocalPart())) {
                vector.addAll(SchemaUtils.processSequenceNode(nodeList.item(i), symbolTable));
                continue;
            }
            if ("group".equals(qName.getLocalPart())) {
                vector.addAll(SchemaUtils.processGroupNode(nodeList.item(i), symbolTable));
                continue;
            }
            if ("any".equals(qName.getLocalPart())) {
                object = symbolTable.getType(Constants.XSD_ANY);
                ElementDecl elementDecl = new ElementDecl((TypeEntry)object, new QName("", "any"));
                elementDecl.setAnyElement(true);
                vector.add(elementDecl);
                continue;
            }
            if (!"element".equals(qName.getLocalPart()) || (object = SchemaUtils.processChildElementNode(nodeList.item(i), symbolTable)) == null) continue;
            vector.add(object);
        }
        return vector;
    }

    private static Vector processGroupNode(Node node, SymbolTable symbolTable) {
        Vector vector = new Vector();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            QName qName = Utils.getNodeQName(nodeList.item(i));
            if (qName == null || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
            if ("choice".equals(qName.getLocalPart())) {
                vector.addAll(SchemaUtils.processChoiceNode(nodeList.item(i), symbolTable));
                continue;
            }
            if ("sequence".equals(qName.getLocalPart())) {
                vector.addAll(SchemaUtils.processSequenceNode(nodeList.item(i), symbolTable));
                continue;
            }
            if (!"all".equals(qName.getLocalPart())) continue;
            vector.addAll(SchemaUtils.processAllNode(nodeList.item(i), symbolTable));
        }
        return vector;
    }

    private static Vector processAllNode(Node node, SymbolTable symbolTable) {
        Vector<ElementDecl> vector = new Vector<ElementDecl>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ElementDecl elementDecl;
            QName qName = Utils.getNodeQName(nodeList.item(i));
            if (qName == null || !Constants.isSchemaXSD(qName.getNamespaceURI()) || !"element".equals(qName.getLocalPart()) || (elementDecl = SchemaUtils.processChildElementNode(nodeList.item(i), symbolTable)) == null) continue;
            vector.add(elementDecl);
        }
        return vector;
    }

    private static ElementDecl processChildElementNode(Node node, SymbolTable symbolTable) {
        Object object;
        Object object2;
        QName qName = Utils.getNodeNameQName(node);
        BooleanHolder booleanHolder = new BooleanHolder();
        QName qName2 = Utils.getTypeQName(node, booleanHolder, false);
        Object object3 = symbolTable.getTypeEntry(qName2, booleanHolder.value);
        if (!booleanHolder.value) {
            object2 = Utils.getAttribute(node, "form");
            if (object2 != null && "unqualified".equals(object2)) {
                qName = new QName("", qName.getLocalPart());
            } else if (object2 == null && ((object = Utils.getScopedAttribute(node, "elementFormDefault")) == null || "unqualified".equals(object))) {
                qName = new QName("", qName.getLocalPart());
            }
        }
        if (object3 != null) {
            if (object3 instanceof Element) {
                object2 = (Element)object3;
                if (((Element)object2).dims != null && ((Element)object2).dims.length() == 0 && (object = ((TypeEntry)object2).getRefType()) != null) {
                    object3 = object;
                }
            }
            object2 = new ElementDecl((TypeEntry)object3, qName);
            object = Utils.getAttribute(node, "minOccurs");
            if (object != null && "0".equals(object)) {
                ((ElementDecl)object2).setMinOccursIs0(true);
            }
            return object2;
        }
        return null;
    }

    public static QName getElementAnonQName(Node node) {
        QName qName = Utils.getNodeQName(node);
        if (qName != null && "element".equals(qName.getLocalPart()) && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                QName qName2 = Utils.getNodeQName(nodeList.item(i));
                if (qName2 == null || !"complexType".equals(qName2.getLocalPart()) && !"simpleType".equals(qName2.getLocalPart()) || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                return Utils.getNodeNameQName(nodeList.item(i));
            }
        }
        return null;
    }

    public static QName getAttributeAnonQName(Node node) {
        QName qName = Utils.getNodeQName(node);
        if (qName != null && "attribute".equals(qName.getLocalPart()) && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                QName qName2 = Utils.getNodeQName(nodeList.item(i));
                if (qName2 == null || !"complexType".equals(qName2.getLocalPart()) && !"simpleType".equals(qName2.getLocalPart()) || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                return Utils.getNodeNameQName(nodeList.item(i));
            }
        }
        return null;
    }

    public static boolean isSimpleTypeOrSimpleContent(Node node) {
        Node node2;
        NodeList nodeList;
        if (node == null) {
            return false;
        }
        QName qName = Utils.getNodeQName(node);
        if (qName != null && "element".equals(qName.getLocalPart()) && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (int i = 0; i < nodeList.getLength() && node2 == null; ++i) {
                QName qName2 = Utils.getNodeQName(nodeList.item(i));
                if (qName2 != null && "complexType".equals(qName2.getLocalPart()) && Constants.isSchemaXSD(qName2.getNamespaceURI())) {
                    node = node2 = nodeList.item(i);
                }
                if (qName2 == null || !"simpleType".equals(qName2.getLocalPart()) || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                return true;
            }
        }
        if ((qName = Utils.getNodeQName(node)) != null && "simpleType".equals(qName.getLocalPart()) && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            return true;
        }
        if (qName != null && "complexType".equals(qName.getLocalPart()) && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            Node node3 = null;
            for (int i = 0; i < nodeList.getLength() && node2 == null; ++i) {
                QName qName3 = Utils.getNodeQName(nodeList.item(i));
                if (qName3 == null || !Constants.isSchemaXSD(qName3.getNamespaceURI())) continue;
                if ("complexContent".equals(qName3.getLocalPart())) {
                    node2 = nodeList.item(i);
                    continue;
                }
                if (!"simpleContent".equals(qName3.getLocalPart())) continue;
                node3 = nodeList.item(i);
            }
            if (node2 != null) {
                return false;
            }
            if (node3 != null) {
                return true;
            }
        }
        return false;
    }

    public static TypeEntry getComplexElementExtensionBase(Node node, SymbolTable symbolTable) {
        Node node2;
        NodeList nodeList;
        if (node == null) {
            return null;
        }
        QName qName = Utils.getNodeQName(node);
        if (qName != null && "element".equals(qName.getLocalPart()) && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (int i = 0; i < nodeList.getLength() && node2 == null; ++i) {
                QName qName2 = Utils.getNodeQName(nodeList.item(i));
                if (qName2 == null || !"complexType".equals(qName2.getLocalPart()) || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                node = node2 = nodeList.item(i);
            }
        }
        if ((qName = Utils.getNodeQName(node)) != null && "complexType".equals(qName.getLocalPart()) && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            QName qName3;
            int n;
            nodeList = node.getChildNodes();
            node2 = null;
            Node node3 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                qName3 = Utils.getNodeQName(nodeList.item(n));
                if (qName3 != null && "complexContent".equals(qName3.getLocalPart()) && Constants.isSchemaXSD(qName3.getNamespaceURI())) {
                    node2 = nodeList.item(n);
                }
                if (qName3 == null || !"simpleContent".equals(qName3.getLocalPart()) || !Constants.isSchemaXSD(qName3.getNamespaceURI())) continue;
                node2 = nodeList.item(n);
            }
            if (node2 != null) {
                nodeList = node2.getChildNodes();
                for (n = 0; n < nodeList.getLength() && node3 == null; ++n) {
                    qName3 = Utils.getNodeQName(nodeList.item(n));
                    if (qName3 == null || !"extension".equals(qName3.getLocalPart()) || !Constants.isSchemaXSD(qName3.getNamespaceURI())) continue;
                    node3 = nodeList.item(n);
                }
            }
            if (node3 == null) {
                return null;
            }
            QName qName4 = Utils.getTypeQName(node3, new BooleanHolder(), false);
            if (qName4 == null) {
                return null;
            }
            return symbolTable.getType(qName4);
        }
        return null;
    }

    public static QName getSimpleTypeBase(Node node) {
        QName qName;
        int n;
        Node node2;
        NodeList nodeList;
        QName qName2 = null;
        if (node == null) {
            return null;
        }
        QName qName3 = Utils.getNodeQName(node);
        if (qName3 != null && "element".equals(qName3.getLocalPart()) && Constants.isSchemaXSD(qName3.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                qName = Utils.getNodeQName(nodeList.item(n));
                if (qName == null || !"simpleType".equals(qName.getLocalPart()) || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
                node = node2 = nodeList.item(n);
            }
        }
        if ((qName3 = Utils.getNodeQName(node)) != null && "simpleType".equals(qName3.getLocalPart()) && Constants.isSchemaXSD(qName3.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                qName = Utils.getNodeQName(nodeList.item(n));
                if (qName == null || !"restriction".equals(qName.getLocalPart()) || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
                node2 = nodeList.item(n);
            }
            if (node2 != null) {
                qName2 = Utils.getTypeQName(node2, new BooleanHolder(), false);
            }
            if (qName2 != null && node2 != null) {
                NodeList nodeList2 = node2.getChildNodes();
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    QName qName4 = Utils.getNodeQName(nodeList2.item(i));
                    if (qName4 == null || !"enumeration".equals(qName4.getLocalPart()) || !Constants.isSchemaXSD(qName4.getNamespaceURI())) continue;
                    return null;
                }
            }
        }
        return qName2;
    }

    public static Node getRestrictionOrExtensionNode(Node node) {
        QName qName;
        int n;
        Node node2;
        NodeList nodeList;
        Node node3 = null;
        if (node == null) {
            return node3;
        }
        QName qName2 = Utils.getNodeQName(node);
        if (qName2 != null && "element".equals(qName2.getLocalPart()) && Constants.isSchemaXSD(qName2.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                qName = Utils.getNodeQName(nodeList.item(n));
                if (qName == null || !"simpleType".equals(qName.getLocalPart()) && !"complexType".equals(qName.getLocalPart()) && !"simpleContent".equals(qName.getLocalPart()) || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
                node = node2 = nodeList.item(n);
            }
        }
        if ((qName2 = Utils.getNodeQName(node)) != null && ("simpleType".equals(qName2.getLocalPart()) || "complexType".equals(qName2.getLocalPart())) && Constants.isSchemaXSD(qName2.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            if ("complexType".equals(qName2.getLocalPart())) {
                for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                    qName = Utils.getNodeQName(nodeList.item(n));
                    if (qName == null || !"complexContent".equals(qName.getLocalPart()) && !"simpleContent".equals(qName.getLocalPart()) || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
                    node2 = nodeList.item(n);
                }
                node = node2;
            }
            if (node != null) {
                nodeList = node.getChildNodes();
                for (n = 0; n < nodeList.getLength() && node3 == null; ++n) {
                    qName = Utils.getNodeQName(nodeList.item(n));
                    if (qName == null || !"extension".equals(qName.getLocalPart()) && !"restriction".equals(qName.getLocalPart()) || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
                    node3 = nodeList.item(n);
                }
            }
        }
        return node3;
    }

    public static QName getArrayComponentQName(Node node, IntHolder intHolder) {
        intHolder.value = 1;
        QName qName = SchemaUtils.getCollectionComponentQName(node);
        if (qName == null) {
            qName = SchemaUtils.getArrayComponentQName_JAXRPC(node, intHolder);
        }
        return qName;
    }

    private static QName getCollectionComponentQName(Node node) {
        QName qName;
        BooleanHolder booleanHolder;
        QName qName2;
        if (node == null) {
            return null;
        }
        QName qName3 = Utils.getNodeQName(node);
        if (qName3 != null && "element".equals(qName3.getLocalPart()) && Constants.isSchemaXSD(qName3.getNamespaceURI()) && (qName2 = Utils.getTypeQName(node, booleanHolder = new BooleanHolder(), true)) != null && !qName2.equals(qName = Utils.getTypeQName(node, booleanHolder, false))) {
            return qName2;
        }
        return null;
    }

    private static QName getArrayComponentQName_JAXRPC(Node node, IntHolder intHolder) {
        QName qName;
        int n;
        Node node2;
        NodeList nodeList;
        intHolder.value = 0;
        if (node == null) {
            return null;
        }
        QName qName2 = Utils.getNodeQName(node);
        if (qName2 != null && "element".equals(qName2.getLocalPart()) && Constants.isSchemaXSD(qName2.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                qName = Utils.getNodeQName(nodeList.item(n));
                if (qName == null || !"complexType".equals(qName.getLocalPart()) || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
                node = node2 = nodeList.item(n);
            }
        }
        if ((qName2 = Utils.getNodeQName(node)) != null && "complexType".equals(qName2.getLocalPart()) && Constants.isSchemaXSD(qName2.getNamespaceURI())) {
            Object object;
            Object object2;
            Object object3;
            nodeList = node.getChildNodes();
            node2 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                qName = Utils.getNodeQName(nodeList.item(n));
                if (qName == null || !"complexContent".equals(qName.getLocalPart()) && !"simpleContent".equals(qName.getLocalPart()) || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
                node2 = nodeList.item(n);
            }
            Node node3 = null;
            if (node2 != null) {
                nodeList = node2.getChildNodes();
                for (int i = 0; i < nodeList.getLength() && node3 == null; ++i) {
                    object3 = Utils.getNodeQName(nodeList.item(i));
                    if (object3 == null || !"restriction".equals(((QName)object3).getLocalPart()) || !Constants.isSchemaXSD(((QName)object3).getNamespaceURI())) continue;
                    node3 = nodeList.item(i);
                }
            }
            QName qName3 = null;
            if (!(node3 == null || (qName3 = Utils.getTypeQName(node3, new BooleanHolder(), false)) != null && "Array".equals(qName3.getLocalPart()) && Constants.isSOAP_ENC(qName3.getNamespaceURI()))) {
                qName3 = null;
            }
            object3 = null;
            Node node4 = null;
            if (qName3 != null) {
                nodeList = node3.getChildNodes();
                for (int i = 0; i < nodeList.getLength() && object3 == null && node4 == null; ++i) {
                    object2 = Utils.getNodeQName(nodeList.item(i));
                    if (object2 != null && ("sequence".equals(((QName)object2).getLocalPart()) || "all".equals(((QName)object2).getLocalPart())) && Constants.isSchemaXSD(((QName)object2).getNamespaceURI()) && (object3 = nodeList.item(i)).getChildNodes().getLength() == 0) {
                        object3 = null;
                    }
                    if (object2 == null || !"attribute".equals(((QName)object2).getLocalPart()) || !Constants.isSchemaXSD(((QName)object2).getNamespaceURI())) continue;
                    BooleanHolder booleanHolder = new BooleanHolder();
                    object = Utils.getTypeQName(nodeList.item(i), booleanHolder, false);
                    if (object == null || !booleanHolder.value || !"arrayType".equals(((QName)object).getLocalPart()) || !Constants.isSOAP_ENC(((QName)object).getNamespaceURI())) continue;
                    node4 = nodeList.item(i);
                }
            }
            if (node4 != null) {
                String string;
                int n2;
                String string2 = null;
                object2 = Utils.getAttributesWithLocalName(node4, "arrayType");
                for (n2 = 0; n2 < ((Vector)object2).size() && string2 == null; ++n2) {
                    object = (Node)((Vector)object2).elementAt(n2);
                    string = object.getNodeName();
                    QName qName4 = Utils.getQNameFromPrefixedName(node4, string);
                    if (!Constants.isWSDL(qName4.getNamespaceURI())) continue;
                    string2 = object.getNodeValue();
                }
                if (string2 != null && (n2 = string2.indexOf(91)) > 0) {
                    object = string2.substring(0, n2);
                    string = string2.replace(',', '[');
                    intHolder.value = 0;
                    int n3 = string.indexOf(91);
                    while (n3 > 0) {
                        ++intHolder.value;
                        n3 = string.indexOf(91, n3 + 1);
                    }
                    return Utils.getQNameFromPrefixedName(node3, (String)object);
                }
            } else if (object3 != null) {
                String string;
                NodeList nodeList2 = object3.getChildNodes();
                object2 = null;
                for (int i = 0; i < nodeList2.getLength() && object2 == null; ++i) {
                    object = Utils.getNodeQName(nodeList2.item(i));
                    if (object == null || !"element".equals(((QName)object).getLocalPart()) || !Constants.isSchemaXSD(((QName)object).getNamespaceURI())) continue;
                    object2 = nodeList2.item(i);
                }
                if (object2 != null && (string = Utils.getAttribute((Node)object2, "maxOccurs")) != null && "unbounded".equalsIgnoreCase(string)) {
                    intHolder.value = 1;
                    return Utils.getTypeQName((Node)object2, new BooleanHolder(), true);
                }
            }
        }
        return null;
    }

    public static Vector getContainedAttributeTypes(Node node, SymbolTable symbolTable) {
        Node node2;
        NodeList nodeList;
        Vector<Object> vector = null;
        if (node == null) {
            return null;
        }
        QName qName = Utils.getNodeQName(node);
        if (qName != null && "element".equals(qName.getLocalPart()) && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (int i = 0; i < nodeList.getLength() && node2 == null; ++i) {
                QName qName2 = Utils.getNodeQName(nodeList.item(i));
                if (qName2 == null || !"complexType".equals(qName2.getLocalPart()) || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                node = node2 = nodeList.item(i);
            }
        }
        if ((qName = Utils.getNodeQName(node)) != null && "complexType".equals(qName.getLocalPart()) && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            Object object;
            int n;
            nodeList = node.getChildNodes();
            node2 = null;
            Node node3 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                object = Utils.getNodeQName(nodeList.item(n));
                if (object == null || !Constants.isSchemaXSD(((QName)object).getNamespaceURI()) || !"complexContent".equals(((QName)object).getLocalPart()) && !"simpleContent".equals(((QName)object).getLocalPart())) continue;
                node2 = nodeList.item(n);
            }
            if (node2 != null) {
                nodeList = node2.getChildNodes();
                for (n = 0; n < nodeList.getLength(); ++n) {
                    object = Utils.getNodeQName(nodeList.item(n));
                    if (object == null || !"extension".equals(((QName)object).getLocalPart()) || !Constants.isSchemaXSD(((QName)object).getNamespaceURI())) continue;
                    node3 = nodeList.item(n);
                    break;
                }
            }
            if (node3 != null) {
                node = node3;
            }
            nodeList = node.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                Object object2;
                object = nodeList.item(n);
                qName = Utils.getNodeQName((Node)object);
                if (qName == null || !"attribute".equals(qName.getLocalPart())) continue;
                if (vector == null) {
                    vector = new Vector<Object>();
                }
                QName qName3 = Utils.getNodeNameQName((Node)object);
                BooleanHolder booleanHolder = new BooleanHolder();
                QName qName4 = Utils.getTypeQName((Node)object, booleanHolder, false);
                if (!booleanHolder.value) {
                    String string;
                    object2 = Utils.getAttribute((Node)object, "form");
                    if (object2 != null && "unqualified".equals(object2)) {
                        qName3 = new QName("", qName3.getLocalPart());
                    } else if (object2 == null && ((string = Utils.getScopedAttribute((Node)object, "attributeFormDefault")) == null || "unqualified".equals(string))) {
                        qName3 = new QName("", qName3.getLocalPart());
                    }
                } else {
                    qName3 = qName4;
                }
                object2 = symbolTable.getTypeEntry(qName4, booleanHolder.value);
                if (object2 == null || qName3 == null) continue;
                vector.add(object2);
                vector.add(qName3);
            }
        }
        return vector;
    }

    private static boolean isSimpleSchemaType(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < schemaTypes.length; ++i) {
            if (!schemaTypes[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSimpleSchemaType(QName qName) {
        if (qName == null || !Constants.isSchemaXSD(qName.getNamespaceURI())) {
            return false;
        }
        return SchemaUtils.isSimpleSchemaType(qName.getLocalPart());
    }
}

