//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

import org.apache.axis.encoding.Base64;

/** <!-- ========================================================================================================== -->
 * This class allows downloading "support.zip" from AMS. This class could easily be extended over time (and if need be) 
 * to download from any Actional product (i.e. Agent or Intermediary).<p>
 * 
 * It is done the most efficient way by doing a HTTP/GET to the support.zip servlet as opposed to going through the
 * SOAP task (the latter would result in base64 encoding of the ZIP and could be streamed).
 *
 * @lastrev fix41419 - unit test for testing interceptor SDK xpath evaluator
 * <!-- -------------------------------------------------------------------------------------------------------- --> */
public final class SupportZipDownload
{
	private static final String DELETE_AGENT_FILES = "&deleventfiles=true";

	private final String itsUrl;
	private final String itsUsername;
	private final String itsPassword;
	private boolean itMustDeleteAgentEventFiles;

	/** <!-- ================================================================================================== -->
	 * @lastrev fix41419 - unit test for testing interceptor SDK xpath evaluator
	 * <!-- ------------------------------------------------------------------------------------------------ --> */

	public SupportZipDownload(final String url, final String username, final String password)
	{
		itsUrl = url;
		itsUsername = username;
		itsPassword = password;
	}

	/** <!-- ================================================================================================== -->
	 * @lastrev fix41419 - unit test for testing interceptor SDK xpath evaluator
	 * <!-- ------------------------------------------------------------------------------------------------ --> */

	public SupportZipDownload withDeleteAgentEventFiles(final boolean val)
	{
		itMustDeleteAgentEventFiles = val;
		return this;
	}

	/** <!-- ================================================================================================== -->
	 * @lastrev fix41419 - unit test for testing interceptor SDK xpath evaluator
	 * <!-- ------------------------------------------------------------------------------------------------ --> */

	public void toFile(final File f) throws IOException
	{
		final InputStream is = asBytes();

		try
		{
			final FileOutputStream fos = new FileOutputStream(f);

			try
			{
				final byte[] buf = new byte[8192];

				while (true)
				{
					final int avail = is.read(buf);

					if (avail < 0)
						break;

					fos.write(buf, 0, avail);
				}
			}
			finally
			{
				fos.close();
			}
		}
		finally
		{
			is.close();
		}
	}

	/** <!-- ================================================================================================== -->
	 * @lastrev fix41419 - unit test for testing interceptor SDK xpath evaluator
	 * <!-- ------------------------------------------------------------------------------------------------ --> */

	public InputStream asBytes()
		throws IOException
	{
		final String supportUrlSuffix = "admin/deployment/support.jsp?generate=true";
		final StringBuilder sb = new StringBuilder(itsUrl.length() + 1 + supportUrlSuffix.length() +
											DELETE_AGENT_FILES.length());

		sb.append(itsUrl);

		if (!itsUrl.endsWith("/"))
			sb.append('/');

		sb.append(supportUrlSuffix);

		if (itMustDeleteAgentEventFiles)
			sb.append(DELETE_AGENT_FILES);

		final URL url = new URL(sb.toString());
		final HttpURLConnection conn = (HttpURLConnection) url.openConnection();
		final String cred = "Basic " + Base64.encode((itsUsername + ':' + itsPassword).getBytes(UTF_8));

		conn.setRequestProperty("Authorization", cred);
		conn.setAllowUserInteraction(false);

		return conn.getInputStream();
	}
}