//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.anttask.soapstation;

import com.actional.db.PluginProperty;
import com.actional.classloader.DynamicClassLoaderEnvironment;
import com.actional.soapapi.anttask.IBaseDataKeyID;
import com.actional.soapapi.Util;
import com.actional.soapstation.db.CRLConfig;
import com.actional.soapstation.db.KeyServiceLC;
import com.actional.soapstation.db.SecurityGlobalSettings;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.types.Resource;

/** <!-- ========================================================================================================== -->
* Create a new {@link com.actional.soapstation.db.KeyServiceLC}.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class CreateCRLKeyServiceProviderTask extends SOAPstationTaskBase implements IBaseDataKeyID
{
	/** Keep track of the KeyValidationService ID that we created in case we need it. */
	private String itsKeyValidationServiceID;

	//=============================================================================================================
	// The ant task Properties
	//=============================================================================================================

	protected KeyServiceLC	itsKeyValidationService = new KeyServiceLC();
	protected CRLConfig	itsCRLConfig = new CRLConfig();
	protected List		itsEndpointItems = new ArrayList();

	public void addEndpoint(Resource val)
	{
		if (val == null)
			return;

		itsEndpointItems.add(val);
	}

	/** <!-- ================================================================================================== -->
	* Do the work
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	@Override
	public void executeEx() throws Exception
	{
		if (Util.isBlank(itsEndpointItems))
		{
			throw new Exception("At least one endpoint must be specified.");
		}

		String[] endpoints = new String[itsEndpointItems.size()];

		for (int i=0; i < itsEndpointItems.size(); i++)
		{
			endpoints[i] = ((Resource)itsEndpointItems.get(i)).getName();
			log("CRL endpoint= " + endpoints[i]);
		}

		itsCRLConfig.setCRLEndpoints(endpoints);

		DynamicClassLoaderEnvironment env = new DynamicClassLoaderEnvironment();
		env.setKeyID("SecurityDefault_DynamicClassLoaderEnvironment");
		env.setDelegateToParentFirst(Boolean.TRUE);

		itsKeyValidationService.setEnvironment(env);
		itsKeyValidationService.setIsMgrCachable(Boolean.TRUE);
		itsKeyValidationService.setKeyID("CRLKeyService_KEY_ID");
		itsKeyValidationService.setKeyName("CRL Server Key Service Provider");
		itsKeyValidationService.setDescription("Key Service Provider using CRL");
		itsKeyValidationService.setClassName("com.actional.soapstation.security.crl.CRLService");

		PluginProperty pluginProp = new PluginProperty();
		pluginProp.setKeyName("SETTINGS");
		pluginProp.setValue(itsCRLConfig);
		itsKeyValidationService.setClassSettings(new PluginProperty[]{pluginProp});

		itsKeyValidationServiceID = _getSSTConfig().secTask.createPluginLC(itsKeyValidationService);

		log("Created Key Service Provider '" + itsKeyValidationService.getKeyName() + "' KeyID: " + getKeyID());

		// Update the global settings
		SecurityGlobalSettings settings = _getSSTConfig().secTask.retrieveGlobalSettings();
		settings.setSignatureValidationService(itsKeyValidationService);

		_getSSTConfig().secTask.updateGlobalSettings(settings);

		log("Updated Global Security Settings to use '" + itsKeyValidationService.getKeyName() +
			"' as Signature Validation Service");
	}

	/** <!-- ================================================================================================== -->
	* IBaseDataKeyID interface
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public String getKeyID()
	{
		return itsKeyValidationServiceID;
	}
}

