//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.anttask.soapstation;

import org.apache.tools.ant.types.Reference;
import com.actional.config.BaseData;
import com.actional.soapapi.anttask.BaseDataType;
import com.actional.soapapi.anttask.TaskBase;
import com.actional.soapapi.Config;
import com.actional.soapapi.soapstation.SSTConfig;
import com.actional.soapapi.soapstation.TransportsTask;
import com.actional.soapapi.Util;
import com.actional.soapstation.db.HeartBeat;
import com.actional.soapstation.db.Transport;

/** <!-- ========================================================================================================== -->
* Base class for actional ant tasks.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class HeartBeatType extends BaseDataType
{
	//=============================================================================================================
	// The ant task Properties
	//=============================================================================================================

	protected HeartBeat itsVal;
	protected Reference itsSender;

	public void setType(String val)
	{
		_getHeartBeat(true).setType(com.actional.soapstation.db.HeartBeatType.fromString(val));
	}

	public void setFrequencySec(Integer val){ _getHeartBeat(true).setFrequencySec(val); }
	public void setEndpointUrl(String val)	{ _getHeartBeat(true).setEndPointUrl(val); }
	public void setSenderRef(Reference val) { itsSender = val; }
	public void setEmailAlerts(Boolean val)
	{
		_getHeartBeat(true).setNoEmailAlert(Util.BooleanValue(!Util.booleanValue(val)));
	}

	//=============================================================================================================
	// BaseDataType methods
	//=============================================================================================================

	public HeartBeat _getHeartBeat(boolean create)
	{
		if ((itsVal == null) && create)
			itsVal = new HeartBeat();

		return itsVal;
	}

	public BaseData _getBaseData()
	{
		return _getHeartBeat(true);
	}

	/** Perform any final configuration. */
	@Override
	public void execute(Config config) throws Exception
	{
		Transport sender;

		if (itsSender != null)
			sender = (Transport)TaskBase.locateBaseData(getProject(), config, itsSender);
		else
		{
			TransportsTask tTask = (TransportsTask)((SSTConfig)config).createTask(TransportsTask.class);
			sender = tTask.getDefaultSender();
		}

		if (sender != null)
			_getHeartBeat(true).setSender(sender);
	}
}
