//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================


package com.actional.soapapi.jetty;

import com.actional.config.BaseData;
import com.actional.soapapi.Util;

/** <!-- ========================================================================================================= -->
 * BaseClass for all tasks that talk to Actional Jetty Application Server.
 * <!-- ------------------------------------------------------------------------------------------------------- --> */

public class JettyTask
{
	protected JettyConfig itsConfig;

	public void		setConfig(JettyConfig config)	{ itsConfig = config; }
	public JettyConfig	getConfig()			{ return itsConfig; }

	public JettyConfig config() throws Exception
	{
		if (itsConfig != null)
			return itsConfig;

		JettyConfig config = JettyConfig.getDefaultConfig();

		if (config == null)
		{
			// Use the default configuration
			config = new JettyConfig();
			config.init();
		}

		return config;
	}

	protected BaseData findFirst(Class clazz, String name) throws Exception
	{
		if (Util.isBlank(name))
			return null;

		return Util.createLeaf(config().findFirst(clazz, name));
	}

	public JettyTask createTask(Class taskClass) throws Exception
	{
		return config().createTask(taskClass);
	}
}
