/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.Part;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.DeserializationContextImpl;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.message.InputStreamBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.transport.http.SocketInputStream;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.SessionUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SOAPPart
extends javax.xml.soap.SOAPPart
implements Part {
    private static final Log LOGGER = LogFactory.getLog(SOAPPart.class.getName());
    private static final int FORM_STRING = 1;
    private static final int FORM_INPUTSTREAM = 2;
    private static final int FORM_SOAPENVELOPE = 3;
    private static final int FORM_BYTES = 4;
    private static final int FORM_BODYINSTREAM = 5;
    private static final int FORM_FAULT = 6;
    private int currentForm;
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private static final String[] formNames = new String[]{"", "FORM_STRING", "FORM_INPUTSTREAM", "FORM_SOAPENVELOPE", "FORM_BYTES", "FORM_BODYINSTREAM", "FORM_FAULT"};
    private Object currentMessage;
    private String currentMessageAsString = null;
    private byte[] currentMessageAsBytes = null;
    private SOAPEnvelope currentMessageAsEnvelope = null;
    private Message msgObject;
    private Source contentSource = null;

    public SOAPPart(Message message, Object object, boolean bl) {
        this.setMimeHeader("Content-Id", SessionUtils.generateSessionId());
        this.setMimeHeader("Content-Type", "text/xml");
        this.msgObject = message;
        int n = 1;
        if (object instanceof SOAPEnvelope) {
            n = 3;
        } else if (object instanceof InputStream) {
            n = bl ? 5 : 2;
        } else if (object instanceof byte[]) {
            n = 4;
        } else if (object instanceof AxisFault) {
            n = 6;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Enter: SOAPPart ctor(" + formNames[n] + ")"));
        }
        this.setCurrentMessage(object, n);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exit: SOAPPart ctor()");
        }
    }

    public Message getMessage() {
        return this.msgObject;
    }

    public void setMessage(Message message) {
        this.msgObject = message;
    }

    @Override
    public String getContentType() {
        return "text/xml";
    }

    public int getContentLength() {
        try {
            byte[] byArray = this.getAsBytes();
            return byArray.length;
        }
        catch (AxisFault axisFault) {
            return 0;
        }
    }

    public void setSOAPEnvelope(SOAPEnvelope sOAPEnvelope) {
        this.setCurrentMessage(sOAPEnvelope, 3);
    }

    public int getSize() {
        return this.getContentLength();
    }

    public void writeTo(Writer writer) throws IOException {
        if (this.currentForm == 6) {
            AxisFault axisFault = (AxisFault)this.currentMessage;
            try {
                axisFault.output(new SerializationContextImpl(writer, this.getMessage().getMessageContext()));
            }
            catch (Exception exception) {
                LOGGER.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                throw axisFault;
            }
            return;
        }
        if (this.currentForm == 3) {
            SOAPEnvelope sOAPEnvelope = (SOAPEnvelope)this.currentMessage;
            try {
                sOAPEnvelope.output(new SerializationContextImpl(writer, this.getMessage().getMessageContext()));
            }
            catch (Exception exception) {
                throw AxisFault.makeFault(exception);
            }
            return;
        }
        writer.write(this.getAsString());
    }

    public Object getCurrentMessage() {
        return this.currentMessage;
    }

    private void setCurrentMessage(Object object, int n) {
        this.currentMessageAsString = null;
        this.currentMessageAsBytes = null;
        this.currentMessageAsEnvelope = null;
        this.setCurrentForm(object, n);
    }

    private void setCurrentForm(Object object, int n) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("setCurrentForm(" + object + ", " + n));
            String string = object instanceof String ? (String)object : object.getClass().getName();
            LOGGER.debug((Object)Messages.getMessage("setMsgForm", formNames[n], "" + string));
        }
        this.currentMessage = object;
        this.currentForm = n;
        if (this.currentForm == 3) {
            this.currentMessageAsEnvelope = (SOAPEnvelope)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAsBytes() throws AxisFault {
        LOGGER.debug((Object)"Enter: SOAPPart::getAsBytes");
        if (this.currentForm == 4) {
            LOGGER.debug((Object)"Exit: SOAPPart::getAsBytes");
            return (byte[])this.currentMessage;
        }
        if (this.currentForm == 5) {
            try {
                this.getAsSOAPEnvelope();
            }
            catch (Exception exception) {
                throw AxisFault.makeFault(exception);
            }
        }
        if (this.currentForm == 2) {
            try {
                InputStream inputStream = null;
                byte[] byArray = null;
                try {
                    int n;
                    inputStream = (InputStream)this.currentMessage;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byArray = new byte[4096];
                    while ((n = inputStream.read(byArray, 0, 4096)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                }
                finally {
                    if (inputStream != null && this.currentMessage instanceof SocketInputStream) {
                        inputStream.close();
                    }
                }
                this.setCurrentForm(byArray, 4);
                LOGGER.debug((Object)"Exit: SOAPPart::getAsBytes");
                return (byte[])this.currentMessage;
            }
            catch (Exception exception) {
                throw AxisFault.makeFault(exception);
            }
        }
        if (this.currentForm == 3 || this.currentForm == 6) {
            this.getAsString();
        }
        if (this.currentForm == 1) {
            if (this.currentMessage == this.currentMessageAsString && this.currentMessageAsBytes != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Exit: SOAPPart::getAsBytes()");
                }
                return this.currentMessageAsBytes;
            }
            this.currentMessageAsString = (String)this.currentMessage;
            try {
                this.setCurrentForm(((String)this.currentMessage).getBytes("UTF-8"), 4);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.setCurrentForm(((String)this.currentMessage).getBytes(), 4);
            }
            this.currentMessageAsBytes = (byte[])this.currentMessage;
            LOGGER.debug((Object)"Exit: SOAPPart::getAsBytes");
            return (byte[])this.currentMessage;
        }
        LOGGER.error((Object)Messages.getMessage("cantConvert00", "" + this.currentForm));
        LOGGER.debug((Object)"Exit: SOAPPart::getAsBytes");
        return null;
    }

    public String getAsString() throws AxisFault {
        LOGGER.debug((Object)"Enter: SOAPPart::getAsString");
        if (this.currentForm == 1) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Exit: SOAPPart::getAsString(): " + this.currentMessage));
            }
            return (String)this.currentMessage;
        }
        if (this.currentForm == 2 || this.currentForm == 5) {
            this.getAsBytes();
        }
        if (this.currentForm == 4) {
            if (this.currentMessage == this.currentMessageAsBytes && this.currentMessageAsString != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Exit: SOAPPart::getAsString(): " + this.currentMessageAsString));
                }
                return this.currentMessageAsString;
            }
            this.currentMessageAsBytes = (byte[])this.currentMessage;
            try {
                this.setCurrentForm(new String((byte[])this.currentMessage, "UTF-8"), 1);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.setCurrentForm(new String((byte[])this.currentMessage), 1);
            }
            this.currentMessageAsString = (String)this.currentMessage;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Exit: SOAPPart::getAsString(): " + this.currentMessage));
            }
            return (String)this.currentMessage;
        }
        if (this.currentForm == 6) {
            StringWriter stringWriter = new StringWriter();
            try {
                this.writeTo(stringWriter);
            }
            catch (Exception exception) {
                LOGGER.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                return null;
            }
            this.setCurrentForm(stringWriter.getBuffer().toString(), 1);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Exit: SOAPPart::getAsString(): " + this.currentMessage));
            }
            return (String)this.currentMessage;
        }
        if (this.currentForm == 3) {
            StringWriter stringWriter = new StringWriter();
            try {
                this.writeTo(stringWriter);
            }
            catch (Exception exception) {
                throw AxisFault.makeFault(exception);
            }
            this.setCurrentForm(stringWriter.getBuffer().toString(), 1);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Exit: SOAPPart::getAsString(): " + this.currentMessage));
            }
            return (String)this.currentMessage;
        }
        LOGGER.error((Object)Messages.getMessage("cantConvert01", "" + this.currentForm));
        LOGGER.debug((Object)"Exit: SOAPPart::getAsString()");
        return null;
    }

    public SOAPEnvelope getAsSOAPEnvelope() throws AxisFault {
        InputSource inputSource;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Enter: SOAPPart::getAsSOAPEnvelope()");
            LOGGER.debug((Object)Messages.getMessage("currForm", formNames[this.currentForm]));
        }
        if (this.currentForm == 3) {
            return (SOAPEnvelope)this.currentMessage;
        }
        if (this.currentForm == 5) {
            InputStreamBody inputStreamBody = new InputStreamBody((InputStream)this.currentMessage);
            SOAPEnvelope sOAPEnvelope = new SOAPEnvelope();
            sOAPEnvelope.addBodyElement(inputStreamBody);
            this.setCurrentForm(sOAPEnvelope, 3);
            return sOAPEnvelope;
        }
        LOGGER.debug((Object)"yup533");
        if (this.currentForm == 2) {
            inputSource = new InputSource((InputStream)this.currentMessage);
        } else {
            LOGGER.debug((Object)"yup637");
            inputSource = new InputSource(new StringReader(this.getAsString()));
        }
        DeserializationContextImpl deserializationContextImpl = new DeserializationContextImpl(inputSource, this.getMessage().getMessageContext(), this.getMessage().getMessageType());
        try {
            deserializationContextImpl.parse();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception == null) {
                exception = sAXException;
            }
            throw AxisFault.makeFault(exception);
        }
        SOAPEnvelope sOAPEnvelope = deserializationContextImpl.getEnvelope();
        if (this.currentMessageAsEnvelope != null) {
            Vector vector = sOAPEnvelope.getHeaders();
            Vector vector2 = this.currentMessageAsEnvelope.getHeaders();
            if (null != vector && null != vector2) {
                Iterator iterator = vector2.iterator();
                Iterator iterator2 = vector.iterator();
                while (iterator.hasNext() && iterator2.hasNext()) {
                    SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)iterator2.next();
                    SOAPHeaderElement sOAPHeaderElement2 = (SOAPHeaderElement)iterator.next();
                    if (!sOAPHeaderElement2.isProcessed()) continue;
                    sOAPHeaderElement.setProcessed(true);
                }
            }
        }
        this.setCurrentForm(sOAPEnvelope, 3);
        LOGGER.debug((Object)"Exit: SOAPPart::getAsSOAPEnvelope");
        return (SOAPEnvelope)this.currentMessage;
    }

    @Override
    public void addMimeHeader(String string, String string2) {
        this.mimeHeaders.addHeader(string, string2);
    }

    private String getFirstMimeHeader(String string) {
        String[] stringArray = this.mimeHeaders.getHeader(string);
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    @Override
    public String getContentLocation() {
        return this.getFirstMimeHeader("Content-Location");
    }

    @Override
    public void setContentLocation(String string) {
        this.setMimeHeader("Content-Location", string);
    }

    @Override
    public void setContentId(String string) {
        this.setMimeHeader("Content-Id", string);
    }

    @Override
    public String getContentId() {
        return this.getFirstMimeHeader("Content-Id");
    }

    @Override
    public String getContentIdRef() {
        return "cid:" + this.getContentId();
    }

    @Override
    public Iterator getMatchingMimeHeaders(String[] stringArray) {
        return this.mimeHeaders.getMatchingHeaders(stringArray);
    }

    @Override
    public Iterator getNonMatchingMimeHeaders(String[] stringArray) {
        return this.mimeHeaders.getNonMatchingHeaders(stringArray);
    }

    public void setContent(Source source) throws SOAPException {
        if (source == null) {
            throw new SOAPException(Messages.getMessage("illegalArgumentException00"));
        }
        this.contentSource = source;
        InputSource inputSource = XMLUtils.sourceToInputSource(this.contentSource);
        this.setCurrentMessage(inputSource.getByteStream(), 2);
    }

    public Source getContent() throws SOAPException {
        return this.contentSource;
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public void setMimeHeader(String string, String string2) {
        this.mimeHeaders.setHeader(string, string2);
    }

    @Override
    public String[] getMimeHeader(String string) {
        return this.mimeHeaders.getHeader(string);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public void removeMimeHeader(String string) {
        this.mimeHeaders.removeHeader(string);
    }

    public javax.xml.soap.SOAPEnvelope getEnvelope() throws SOAPException {
        try {
            return this.getAsSOAPEnvelope();
        }
        catch (AxisFault axisFault) {
            throw new SOAPException((Throwable)axisFault);
        }
    }

    public Node renameNode(Node node, String string, String string2) throws DOMException {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public void normalizeDocument() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public DOMConfiguration getDomConfig() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Node adoptNode(Node node) throws DOMException {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public void setDocumentURI(String string) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public String getDocumentURI() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public void setStrictErrorChecking(boolean bl) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public boolean getStrictErrorChecking() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public void setXmlVersion(String string) throws DOMException {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public String getXmlVersion() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public boolean getXmlStandalone() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public void setXmlStandalone(boolean bl) throws DOMException {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public String getXmlEncoding() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public String getInputEncoding() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Element getElementById(String string) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Attr createAttribute(String string) throws DOMException {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public NodeList getElementsByTagName(String string) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Comment createComment(String string) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Text createTextNode(String string) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public DocumentFragment createDocumentFragment() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Element createElement(String string) throws DOMException {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Element getDocumentElement() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public DOMImplementation getImplementation() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public DocumentType getDoctype() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Object getUserData(String string) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Node appendChild(Node node) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Node cloneNode(boolean bl) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public short compareDocumentPosition(Node node) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public NamedNodeMap getAttributes() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public String getBaseURI() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public NodeList getChildNodes() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Object getFeature(String string, String string2) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Node getFirstChild() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Node getLastChild() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public String getLocalName() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public String getNamespaceURI() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Node getNextSibling() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public String getNodeName() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public short getNodeType() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public String getNodeValue() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Document getOwnerDocument() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Node getParentNode() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public String getPrefix() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Node getPreviousSibling() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public String getTextContent() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public boolean hasAttributes() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public boolean hasChildNodes() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Node insertBefore(Node node, Node node2) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public boolean isDefaultNamespace(String string) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public boolean isEqualNode(Node node) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public boolean isSameNode(Node node) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public boolean isSupported(String string, String string2) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public String lookupNamespaceURI(String string) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public String lookupPrefix(String string) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public void normalize() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Node removeChild(Node node) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public Node replaceChild(Node node, Node node2) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public void setNodeValue(String string) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public void setPrefix(String string) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public void setTextContent(String string) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public void detachNode() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public SOAPElement getParentElement() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public String getValue() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public void recycleNode() {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public void setParentElement(SOAPElement sOAPElement) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }

    public void setValue(String string) {
        throw new RuntimeException("This is a JDK 1.5 API that is not supposed to be called by Axis.");
    }
}

