/*
 * Decompiled with CFR 0.152.
 */
package com.actional.soapapi.anttask.soapstation;

import com.actional.config.BaseData;
import com.actional.deployment.ExportProfile;
import com.actional.soapapi.Config;
import com.actional.soapapi.Util;
import com.actional.soapapi.anttask.TaskBase;
import com.actional.soapstation.db.ExportItem;
import com.actional.soapstation.db.ExportItemEntry;
import com.actional.soapstation.task.ExportType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Reference;

public class ExportItemType
extends ProjectComponent {
    protected ExportType itsExportType;
    protected List itsIds;
    private String itsProfileName;

    public void setType(String string) {
        this.itsExportType = ExportType.fromString((String)string);
    }

    public void setProfileName(String string) {
        this.itsProfileName = string;
    }

    public void addBaseData(Reference reference) {
        if (this.itsIds == null) {
            this.itsIds = new ArrayList();
        }
        this.itsIds.add(reference);
    }

    public void populate(Config config, List list) throws Exception {
        if (this.itsExportType == null && this.itsProfileName == null) {
            throw new IllegalStateException("Missing requirement type or profileName attribute");
        }
        if (this.itsExportType == null) {
            if (this.itsIds != null && !this.itsIds.isEmpty()) {
                throw new IllegalStateException("The elements to export cannot be specified along with the profileName attribute");
            }
            ExportProfile exportProfile = new ExportProfile();
            exportProfile.setKeyName(this.itsProfileName);
            BaseData[] baseDataArray = config.configTask.find((BaseData)exportProfile);
            if (baseDataArray == null || baseDataArray.length == 0) {
                throw new IllegalStateException("Could not find the profile of name \"" + this.itsProfileName + "\"");
            }
            if (baseDataArray.length != 1) {
                throw new IllegalStateException("Ambiguous profile name \"" + this.itsProfileName + "\": found " + baseDataArray.length + " profiles");
            }
            ExportProfile exportProfile2 = (ExportProfile)config.configTask.get(baseDataArray[0].getKeyID());
            ExportItem[] exportItemArray = exportProfile2.getItems();
            if (exportItemArray == null || exportItemArray.length == 0) {
                return;
            }
            for (int i = 0; i < exportItemArray.length; ++i) {
                ExportItem exportItem = new ExportItem();
                exportItem.setKeyID(exportItemArray[i].getKeyID());
                Util.setAsLeaf((BaseData)exportItem);
                list.add(exportItem);
            }
        } else {
            ExportItem exportItem = new ExportItem();
            exportItem.setType(this.itsExportType);
            if (Util.isBlank((Collection)this.itsIds)) {
                ExportItemEntry[] exportItemEntryArray = new ExportItemEntry[]{new ExportItemEntry()};
                exportItem.setEntries(exportItemEntryArray);
            } else {
                ExportItemEntry[] exportItemEntryArray = new ExportItemEntry[this.itsIds.size()];
                for (int i = 0; i < this.itsIds.size(); ++i) {
                    ExportItemEntry exportItemEntry = new ExportItemEntry();
                    exportItemEntry.setId(TaskBase.locateBaseDataID(this.getProject(), (Reference)this.itsIds.get(i)));
                    exportItemEntryArray[i] = exportItemEntry;
                }
                exportItem.setEntries(exportItemEntryArray);
            }
            list.add(exportItem);
        }
    }
}

