/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.Part;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.DeserializationContextImpl;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.message.InputStreamBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.transport.http.SocketInputStream;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.SessionUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SOAPPart
extends javax.xml.soap.SOAPPart
implements Part {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$SOAPPart == null ? (class$org$apache$axis$SOAPPart = SOAPPart.class$("org.apache.axis.SOAPPart")) : class$org$apache$axis$SOAPPart).getName());
    private static final int FORM_STRING = 1;
    private static final int FORM_INPUTSTREAM = 2;
    private static final int FORM_SOAPENVELOPE = 3;
    private static final int FORM_BYTES = 4;
    private static final int FORM_BODYINSTREAM = 5;
    private static final int FORM_FAULT = 6;
    private int currentForm;
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private String contentId;
    private String contentLocation;
    private static final String[] formNames = new String[]{"", "FORM_STRING", "FORM_INPUTSTREAM", "FORM_SOAPENVELOPE", "FORM_BYTES", "FORM_BODYINSTREAM", "FORM_FAULT"};
    private Object currentMessage;
    private String currentMessageAsString = null;
    private byte[] currentMessageAsBytes = null;
    private SOAPEnvelope currentMessageAsEnvelope = null;
    private Message msgObject;
    private Source contentSource = null;
    static /* synthetic */ Class class$org$apache$axis$SOAPPart;

    public SOAPPart(Message parent, Object initialContents, boolean isBodyStream) {
        this.setMimeHeader("Content-Id", SessionUtils.generateSessionId());
        this.setMimeHeader("Content-Type", "text/xml");
        this.msgObject = parent;
        int form = 1;
        if (initialContents instanceof SOAPEnvelope) {
            form = 3;
        } else if (initialContents instanceof InputStream) {
            form = isBodyStream ? 5 : 2;
        } else if (initialContents instanceof byte[]) {
            form = 4;
        } else if (initialContents instanceof AxisFault) {
            form = 6;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: SOAPPart ctor(" + formNames[form] + ")"));
        }
        this.setCurrentMessage(initialContents, form);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: SOAPPart ctor()");
        }
    }

    public Message getMessage() {
        return this.msgObject;
    }

    public void setMessage(Message msg) {
        this.msgObject = msg;
    }

    public String getContentType() {
        return "text/xml";
    }

    public int getContentLength() {
        try {
            byte[] bytes = this.getAsBytes();
            return bytes.length;
        }
        catch (AxisFault fault) {
            return 0;
        }
    }

    public void setSOAPEnvelope(SOAPEnvelope env) {
        this.setCurrentMessage(env, 3);
    }

    public int getSize() {
        return this.getContentLength();
    }

    public void writeTo(Writer writer) throws IOException {
        if (this.currentForm == 6) {
            AxisFault env = (AxisFault)this.currentMessage;
            try {
                env.output(new SerializationContextImpl(writer, this.getMessage().getMessageContext()));
            }
            catch (Exception e) {
                log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
                throw env;
            }
            return;
        }
        if (this.currentForm == 3) {
            SOAPEnvelope env = (SOAPEnvelope)this.currentMessage;
            try {
                env.output(new SerializationContextImpl(writer, this.getMessage().getMessageContext()));
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
            return;
        }
        writer.write(this.getAsString());
    }

    public Object getCurrentMessage() {
        return this.currentMessage;
    }

    private void setCurrentMessage(Object currMsg, int form) {
        this.currentMessageAsString = null;
        this.currentMessageAsBytes = null;
        this.currentMessageAsEnvelope = null;
        this.setCurrentForm(currMsg, form);
    }

    private void setCurrentForm(Object currMsg, int form) {
        log.debug((Object)("setCurrentForm(" + currMsg + ", " + form));
        if (log.isDebugEnabled()) {
            String msgStr = currMsg instanceof String ? (String)currMsg : currMsg.getClass().getName();
            log.debug((Object)Messages.getMessage("setMsgForm", formNames[form], "" + msgStr));
        }
        this.currentMessage = currMsg;
        this.currentForm = form;
        if (this.currentForm == 3) {
            this.currentMessageAsEnvelope = (SOAPEnvelope)currMsg;
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getAsBytes() throws AxisFault {
        block17: {
            log.debug((Object)"Enter: SOAPPart::getAsBytes");
            if (this.currentForm == 4) {
                log.debug((Object)"Exit: SOAPPart::getAsBytes");
                return (byte[])this.currentMessage;
            }
            if (this.currentForm == 5) {
                try {
                    this.getAsSOAPEnvelope();
                }
                catch (Exception e) {
                    log.fatal((Object)Messages.getMessage("makeEnvFail00"), (Throwable)e);
                    log.debug((Object)"Exit: SOAPPart::getAsBytes");
                    return null;
                }
            }
            if (this.currentForm != 2) break block17;
            try {
                InputStream inp = null;
                byte[] buf = null;
                try {
                    int len;
                    inp = (InputStream)this.currentMessage;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    buf = new byte[4096];
                    while ((len = inp.read(buf, 0, 4096)) != -1) {
                        void var4_7;
                        baos.write(buf, 0, (int)var4_7);
                    }
                    buf = baos.toByteArray();
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    if (inp != null && this.currentMessage instanceof SocketInputStream) {
                        inp.close();
                    }
                    throw throwable;
                }
                if (inp != null && this.currentMessage instanceof SocketInputStream) {
                    inp.close();
                }
                this.setCurrentForm(buf, 4);
                log.debug((Object)"Exit: SOAPPart::getAsBytes");
                return (byte[])this.currentMessage;
            }
            catch (Exception e) {
                log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
                log.debug((Object)"Exit: SOAPPart::getAsBytes");
                return null;
            }
        }
        if (this.currentForm == 3 || this.currentForm == 6) {
            this.getAsString();
        }
        if (this.currentForm == 1) {
            if (this.currentMessage == this.currentMessageAsString && this.currentMessageAsBytes != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exit: SOAPPart::getAsBytes()");
                }
                return this.currentMessageAsBytes;
            }
            this.currentMessageAsString = (String)this.currentMessage;
            try {
                this.setCurrentForm(((String)this.currentMessage).getBytes("UTF-8"), 4);
            }
            catch (UnsupportedEncodingException ue) {
                this.setCurrentForm(((String)this.currentMessage).getBytes(), 4);
            }
            this.currentMessageAsBytes = (byte[])this.currentMessage;
            log.debug((Object)"Exit: SOAPPart::getAsBytes");
            return (byte[])this.currentMessage;
        }
        log.error((Object)Messages.getMessage("cantConvert00", "" + this.currentForm));
        log.debug((Object)"Exit: SOAPPart::getAsBytes");
        return null;
    }

    public String getAsString() throws AxisFault {
        log.debug((Object)"Enter: SOAPPart::getAsString");
        if (this.currentForm == 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exit: SOAPPart::getAsString(): " + this.currentMessage));
            }
            return (String)this.currentMessage;
        }
        if (this.currentForm == 2 || this.currentForm == 5) {
            this.getAsBytes();
        }
        if (this.currentForm == 4) {
            if (this.currentMessage == this.currentMessageAsBytes && this.currentMessageAsString != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Exit: SOAPPart::getAsString(): " + this.currentMessageAsString));
                }
                return this.currentMessageAsString;
            }
            this.currentMessageAsBytes = (byte[])this.currentMessage;
            try {
                this.setCurrentForm(new String((byte[])this.currentMessage, "UTF-8"), 1);
            }
            catch (UnsupportedEncodingException ue) {
                this.setCurrentForm(new String((byte[])this.currentMessage), 1);
            }
            this.currentMessageAsString = (String)this.currentMessage;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exit: SOAPPart::getAsString(): " + this.currentMessage));
            }
            return (String)this.currentMessage;
        }
        if (this.currentForm == 6) {
            StringWriter writer = new StringWriter();
            AxisFault env = (AxisFault)this.currentMessage;
            try {
                this.writeTo(writer);
            }
            catch (Exception e) {
                log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
                return null;
            }
            this.setCurrentForm(writer.getBuffer().toString(), 1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exit: SOAPPart::getAsString(): " + this.currentMessage));
            }
            return (String)this.currentMessage;
        }
        if (this.currentForm == 3) {
            StringWriter writer = new StringWriter();
            SOAPEnvelope env = (SOAPEnvelope)this.currentMessage;
            try {
                this.writeTo(writer);
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
            this.setCurrentForm(writer.getBuffer().toString(), 1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exit: SOAPPart::getAsString(): " + this.currentMessage));
            }
            return (String)this.currentMessage;
        }
        log.error((Object)Messages.getMessage("cantConvert01", "" + this.currentForm));
        log.debug((Object)"Exit: SOAPPart::getAsString()");
        return null;
    }

    public SOAPEnvelope getAsSOAPEnvelope() throws AxisFault {
        InputSource is;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: SOAPPart::getAsSOAPEnvelope()");
            log.debug((Object)Messages.getMessage("currForm", formNames[this.currentForm]));
        }
        if (this.currentForm == 3) {
            return (SOAPEnvelope)this.currentMessage;
        }
        if (this.currentForm == 5) {
            InputStreamBody bodyEl = new InputStreamBody((InputStream)this.currentMessage);
            SOAPEnvelope env = new SOAPEnvelope();
            env.addBodyElement(bodyEl);
            this.setCurrentForm(env, 3);
            return env;
        }
        log.debug((Object)"yup533");
        if (this.currentForm == 2) {
            is = new InputSource((InputStream)this.currentMessage);
        } else {
            log.debug((Object)"yup637");
            is = new InputSource(new StringReader(this.getAsString()));
        }
        DeserializationContextImpl dser = new DeserializationContextImpl(is, this.getMessage().getMessageContext(), this.getMessage().getMessageType());
        try {
            dser.parse();
        }
        catch (SAXException e) {
            Exception real = e.getException();
            if (real == null) {
                real = e;
            }
            throw AxisFault.makeFault(real);
        }
        SOAPEnvelope nse = dser.getEnvelope();
        if (this.currentMessageAsEnvelope != null) {
            Vector newHeaders = nse.getHeaders();
            Vector oldHeaders = this.currentMessageAsEnvelope.getHeaders();
            if (null != newHeaders && null != oldHeaders) {
                Iterator ohi = ((AbstractList)oldHeaders).iterator();
                Iterator nhi = ((AbstractList)newHeaders).iterator();
                while (ohi.hasNext() && nhi.hasNext()) {
                    SOAPHeaderElement nhe = (SOAPHeaderElement)nhi.next();
                    SOAPHeaderElement ohe = (SOAPHeaderElement)ohi.next();
                    if (!ohe.isProcessed()) continue;
                    nhe.setProcessed(true);
                }
            }
        }
        this.setCurrentForm(nse, 3);
        log.debug((Object)"Exit: SOAPPart::getAsSOAPEnvelope");
        return (SOAPEnvelope)this.currentMessage;
    }

    public void addMimeHeader(String header, String value) {
        this.mimeHeaders.addHeader(header, value);
    }

    private String getFirstMimeHeader(String header) {
        String[] values = this.mimeHeaders.getHeader(header);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public String getContentLocation() {
        return this.getFirstMimeHeader("Content-Location");
    }

    public void setContentLocation(String loc) {
        this.setMimeHeader("Content-Location", loc);
    }

    public void setContentId(String newCid) {
        this.setMimeHeader("Content-Id", newCid);
    }

    public String getContentId() {
        return this.getFirstMimeHeader("Content-Id");
    }

    public String getContentIdRef() {
        return "cid:" + this.getContentId();
    }

    public Iterator getMatchingMimeHeaders(String[] match) {
        return this.mimeHeaders.getMatchingHeaders(match);
    }

    public Iterator getNonMatchingMimeHeaders(String[] match) {
        return this.mimeHeaders.getNonMatchingHeaders(match);
    }

    public void setContent(Source source) throws SOAPException {
        if (source == null) {
            throw new SOAPException(Messages.getMessage("illegalArgumentException00"));
        }
        this.contentSource = source;
        InputSource in = XMLUtils.sourceToInputSource(this.contentSource);
        this.setCurrentMessage(in.getByteStream(), 2);
    }

    public Source getContent() throws SOAPException {
        return this.contentSource;
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public void setMimeHeader(String name, String value) {
        this.mimeHeaders.setHeader(name, value);
    }

    public String[] getMimeHeader(String name) {
        return this.mimeHeaders.getHeader(name);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public void removeMimeHeader(String header) {
        this.mimeHeaders.removeHeader(header);
    }

    public javax.xml.soap.SOAPEnvelope getEnvelope() throws SOAPException {
        try {
            return this.getAsSOAPEnvelope();
        }
        catch (AxisFault af) {
            throw new SOAPException((Throwable)af);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

