/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.AxisClient;
import org.apache.axis.client.AxisClientProxy;
import org.apache.axis.client.Call;
import org.apache.axis.client.Stub;
import org.apache.axis.client.Transport;
import org.apache.axis.configuration.EngineConfigurationFactoryFinder;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.WSDLUtils;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Document;

public class Service
implements javax.xml.rpc.Service,
Serializable,
Referenceable {
    private transient AxisEngine engine = null;
    private transient EngineConfiguration config = EngineConfigurationFactoryFinder.newFactory().getClientEngineConfig();
    private QName serviceName = null;
    private URL wsdlLocation = null;
    private Definition wsdlDefinition = null;
    private javax.wsdl.Service wsdlService = null;
    private boolean maintainSession = false;
    private HandlerRegistryImpl registry = new HandlerRegistryImpl();
    private static ThreadLocal previousCall = new ThreadLocal();
    private static HashMap cachedWSDL = new HashMap();
    private static boolean cachingWSDL = true;
    private Hashtable transportImpls = new Hashtable();
    static /* synthetic */ Class class$javax$xml$rpc$Service;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$javax$xml$rpc$Stub;

    Definition getWSDLDefinition() {
        return this.wsdlDefinition;
    }

    javax.wsdl.Service getWSDLService() {
        return this.wsdlService;
    }

    protected AxisClient getAxisClient() {
        return new AxisClient(this.config);
    }

    public Service() {
        this.engine = this.getAxisClient();
    }

    public Service(QName serviceName) {
        this.serviceName = serviceName;
        this.engine = this.getAxisClient();
    }

    public Service(EngineConfiguration config) {
        this.config = config;
        this.engine = this.getAxisClient();
    }

    public Service(URL wsdlDoc, QName serviceName) throws ServiceException {
        this.serviceName = serviceName;
        this.engine = this.getAxisClient();
        this.wsdlLocation = wsdlDoc;
        Definition def = null;
        if (cachingWSDL && (def = (Definition)cachedWSDL.get(this.wsdlLocation.toString())) != null) {
            this.initService(def, serviceName);
        } else {
            Document doc = XMLUtils.newDocument(wsdlDoc.toString());
            this.initService(doc, serviceName);
        }
    }

    public Service(String wsdlLocation, QName serviceName) throws ServiceException {
        this.serviceName = serviceName;
        this.engine = this.getAxisClient();
        try {
            this.wsdlLocation = new URL(wsdlLocation);
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        Definition def = null;
        if (cachingWSDL && (def = (Definition)cachedWSDL.get(this.wsdlLocation.toString())) != null) {
            this.initService(def, serviceName);
        } else {
            Document doc = XMLUtils.newDocument(this.wsdlLocation.toString());
            this.initService(doc, serviceName);
        }
    }

    public Service(InputStream wsdlInputStream, QName serviceName) throws ServiceException {
        this.engine = this.getAxisClient();
        Document doc = XMLUtils.newDocument(wsdlInputStream);
        this.initService(doc, serviceName);
    }

    private void initService(Document doc, QName serviceName) throws ServiceException {
        try {
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            Definition def = reader.readWSDL(null, doc);
            if (cachingWSDL && this.wsdlLocation != null) {
                cachedWSDL.put(this.wsdlLocation.toString(), def);
            }
            this.initService(def, serviceName);
        }
        catch (Exception exp) {
            throw new ServiceException(Messages.getMessage("wsdlError00", "", "\n" + exp));
        }
    }

    private void initService(Definition def, QName serviceName) throws ServiceException {
        try {
            this.wsdlDefinition = def;
            this.wsdlService = def.getService(serviceName);
            if (this.wsdlService == null) {
                throw new ServiceException(Messages.getMessage("noService00", "" + serviceName));
            }
        }
        catch (Exception exp) {
            throw new ServiceException(Messages.getMessage("wsdlError00", "", "\n" + exp));
        }
    }

    public Remote getPort(QName portName, Class proxyInterface) throws ServiceException {
        if (this.wsdlService == null) {
            throw new ServiceException(Messages.getMessage("wsdlMissing00"));
        }
        Port port = this.wsdlService.getPort(portName.getLocalPart());
        if (port == null) {
            throw new ServiceException(Messages.getMessage("noPort00", "" + portName));
        }
        Remote stub = this.getGeneratedStub(portName, proxyInterface);
        return stub != null ? stub : this.getPort(null, portName, proxyInterface);
    }

    private Remote getGeneratedStub(QName portName, Class proxyInterface) {
        try {
            String pkg = proxyInterface.getName();
            pkg = pkg.substring(0, pkg.lastIndexOf(46));
            Port port = this.wsdlService.getPort(portName.getLocalPart());
            String binding = port.getBinding().getQName().getLocalPart();
            Class stubClass = ClassUtils.forName(pkg + "." + binding + "Stub");
            if (proxyInterface.isAssignableFrom(stubClass)) {
                Class[] formalArgs = new Class[]{class$javax$xml$rpc$Service == null ? (class$javax$xml$rpc$Service = Service.class$("javax.xml.rpc.Service")) : class$javax$xml$rpc$Service};
                Object[] actualArgs = new Object[]{this};
                Constructor ctor = stubClass.getConstructor(formalArgs);
                Stub stub = (Stub)ctor.newInstance(actualArgs);
                stub._setProperty("javax.xml.rpc.service.endpoint.address", WSDLUtils.getAddressFromPort(port));
                stub.setPortName(portName);
                return (Remote)((Object)stub);
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Remote getPort(Class proxyInterface) throws ServiceException {
        if (this.wsdlService == null) {
            throw new ServiceException(Messages.getMessage("wsdlMissing00"));
        }
        return this.getPort(null, null, proxyInterface);
    }

    public Remote getPort(String endpoint, Class proxyInterface) throws ServiceException {
        return this.getPort(endpoint, null, proxyInterface);
    }

    private Remote getPort(String endpoint, QName portName, Class proxyInterface) throws ServiceException {
        if (!proxyInterface.isInterface()) {
            throw new ServiceException(Messages.getMessage("mustBeIface00"));
        }
        if (!(class$java$rmi$Remote == null ? (class$java$rmi$Remote = Service.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(proxyInterface)) {
            throw new ServiceException(Messages.getMessage("mustExtendRemote00"));
        }
        try {
            Call call = null;
            if (portName == null) {
                call = (Call)this.createCall();
                if (endpoint != null) {
                    call.setTargetEndpointAddress(new URL(endpoint));
                }
            } else {
                call = (Call)this.createCall(portName);
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return (Remote)Proxy.newProxyInstance(classLoader, new Class[]{proxyInterface, class$javax$xml$rpc$Stub == null ? (class$javax$xml$rpc$Stub = Service.class$("javax.xml.rpc.Stub")) : class$javax$xml$rpc$Stub}, (InvocationHandler)new AxisClientProxy(call));
        }
        catch (Exception e) {
            throw new ServiceException(e.toString());
        }
    }

    public javax.xml.rpc.Call createCall(QName portName) throws ServiceException {
        Call call = (Call)this.createCall();
        call.setPortName(portName);
        if (this.wsdlDefinition == null) {
            return call;
        }
        Port port = this.wsdlService.getPort(portName.getLocalPart());
        if (port == null) {
            throw new ServiceException(Messages.getMessage("noPort00", "" + portName));
        }
        Binding binding = port.getBinding();
        PortType portType = binding.getPortType();
        if (portType == null) {
            throw new ServiceException(Messages.getMessage("noPortType00", "" + portName));
        }
        List list = port.getExtensibilityElements();
        int i = 0;
        while (list != null && i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof SOAPAddress) {
                try {
                    SOAPAddress addr = (SOAPAddress)obj;
                    URL url = new URL(addr.getLocationURI());
                    call.setTargetEndpointAddress(url);
                }
                catch (Exception exp) {
                    throw new ServiceException(Messages.getMessage("cantSetURI00", "" + exp));
                }
            }
            ++i;
        }
        return call;
    }

    public javax.xml.rpc.Call createCall(QName portName, String operationName) throws ServiceException {
        Call call = (Call)this.createCall();
        call.setOperation(portName, operationName);
        return call;
    }

    public javax.xml.rpc.Call createCall(QName portName, QName operationName) throws ServiceException {
        Call call = (Call)this.createCall();
        call.setOperation(portName, operationName.getLocalPart());
        return call;
    }

    public javax.xml.rpc.Call createCall() throws ServiceException {
        Call call = new Call(this);
        previousCall.set(call);
        return call;
    }

    public javax.xml.rpc.Call[] getCalls(QName portName) throws ServiceException {
        if (portName == null) {
            throw new ServiceException(Messages.getMessage("badPort00"));
        }
        if (this.wsdlService == null) {
            throw new ServiceException(Messages.getMessage("wsdlMissing00"));
        }
        javax.xml.rpc.Call[] array = new javax.xml.rpc.Call[]{this.createCall(portName)};
        return array;
    }

    public HandlerRegistry getHandlerRegistry() {
        return this.registry;
    }

    public URL getWSDLDocumentLocation() {
        return this.wsdlLocation;
    }

    public QName getServiceName() {
        if (this.serviceName != null) {
            return this.serviceName;
        }
        if (this.wsdlService == null) {
            return null;
        }
        QName qn = this.wsdlService.getQName();
        return new QName(qn.getNamespaceURI(), qn.getLocalPart());
    }

    public Iterator getPorts() throws ServiceException {
        if (this.wsdlService == null || this.wsdlService.getPorts() == null) {
            return ((AbstractList)new Vector()).iterator();
        }
        return this.wsdlService.getPorts().keySet().iterator();
    }

    public void setTypeMappingRegistry(TypeMappingRegistry registry) throws ServiceException {
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        return this.engine.getTypeMappingRegistry();
    }

    public Reference getReference() {
        String classname = this.getClass().getName();
        Reference reference = new Reference(classname, "org.apache.axis.client.ServiceFactory", null);
        StringRefAddr addr = null;
        if (!classname.equals("org.apache.axis.client.Service")) {
            addr = new StringRefAddr("service classname", classname);
            reference.add(addr);
        } else {
            QName serviceName;
            if (this.wsdlLocation != null) {
                addr = new StringRefAddr("WSDL location", this.wsdlLocation.toString());
                reference.add(addr);
            }
            if ((serviceName = this.getServiceName()) != null) {
                addr = new StringRefAddr("service namespace", serviceName.getNamespaceURI());
                reference.add(addr);
                addr = new StringRefAddr("service local part", serviceName.getLocalPart());
                reference.add(addr);
            }
        }
        if (this.maintainSession) {
            addr = new StringRefAddr("maintain session", "true");
            reference.add(addr);
        }
        return reference;
    }

    public void setEngine(AxisEngine engine) {
        this.engine = engine;
    }

    public AxisEngine getEngine() {
        return this.engine;
    }

    public void setEngineConfiguration(EngineConfiguration config) {
        this.config = config;
    }

    public void setMaintainSession(boolean yesno) {
        this.maintainSession = yesno;
    }

    public boolean getMaintainSession() {
        return this.maintainSession;
    }

    public Call getCall() throws ServiceException {
        Call call = (Call)previousCall.get();
        return call;
    }

    public boolean getCacheWSDL() {
        return cachingWSDL;
    }

    public void setCacheWSDL(boolean flag) {
        cachingWSDL = flag;
    }

    void registerTransportForURL(URL url, Transport transport) {
        this.transportImpls.put(url, transport);
    }

    Transport getTransportForURL(URL url) {
        return (Transport)this.transportImpls.get(url);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class HandlerRegistryImpl
    implements HandlerRegistry {
        Map map = new HashMap();

        protected HandlerRegistryImpl() {
        }

        public List getHandlerChain(QName portName) {
            ArrayList list = (ArrayList)this.map.get(portName);
            if (list == null) {
                list = new ArrayList();
                this.setHandlerChain(portName, list);
            }
            return list;
        }

        public void setHandlerChain(QName portName, List chain) {
            this.map.put(portName, chain);
        }
    }
}

