/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.fromJava;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.symbolTable.BaseTypeMapping;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Types {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$wsdl$fromJava$Types == null ? (class$org$apache$axis$wsdl$fromJava$Types = Types.class$("org.apache.axis.wsdl.fromJava.Types")) : class$org$apache$axis$wsdl$fromJava$Types).getName());
    Definition def;
    Namespaces namespaces = null;
    TypeMapping tm;
    TypeMapping defaultTM;
    String targetNamespace;
    org.w3c.dom.Element wsdlTypesElem = null;
    HashMap schemaTypes = null;
    HashMap schemaElementNames = null;
    HashMap schemaUniqueElementNames = null;
    HashMap wrapperMap = new HashMap();
    List stopClasses = null;
    List beanCompatErrs = new ArrayList();
    Document docHolder;
    static /* synthetic */ Class class$org$apache$axis$wsdl$fromJava$Types;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$axis$encoding$SimpleType;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$org$apache$axis$AxisFault;

    public Types(Definition def, TypeMapping tm, TypeMapping defaultTM, Namespaces namespaces, String targetNamespace, List stopClasses) {
        this.def = def;
        this.createDocumentFragment();
        this.tm = tm;
        this.defaultTM = defaultTM;
        this.namespaces = namespaces;
        this.targetNamespace = targetNamespace;
        this.stopClasses = stopClasses;
        this.schemaElementNames = new HashMap();
        this.schemaUniqueElementNames = new HashMap();
        this.schemaTypes = new HashMap();
    }

    public Namespaces getNamespaces() {
        return this.namespaces;
    }

    public void loadInputTypes(String inputWSDL) throws IOException, WSDLException {
        Document doc = XMLUtils.newDocument(inputWSDL);
        NodeList elements = doc.getChildNodes();
        if (elements.getLength() > 0 && elements.item(0).getLocalName().equals("definitions")) {
            elements = elements.item(0).getChildNodes();
            int i = 0;
            while (i < elements.getLength() && this.wsdlTypesElem == null) {
                Node node = elements.item(i);
                if (node.getLocalName() != null && node.getLocalName().equals("types")) {
                    this.wsdlTypesElem = (org.w3c.dom.Element)node;
                }
                ++i;
            }
        }
        if (this.wsdlTypesElem == null) {
            return;
        }
        this.wsdlTypesElem = (org.w3c.dom.Element)this.docHolder.importNode(this.wsdlTypesElem, true);
        this.docHolder.appendChild(this.wsdlTypesElem);
        BaseTypeMapping btm = new BaseTypeMapping(){

            public String getBaseName(QName qNameIn) {
                QName qName = new QName(qNameIn.getNamespaceURI(), qNameIn.getLocalPart());
                Class cls = Types.this.defaultTM.getClassForQName(qName);
                if (cls == null) {
                    return null;
                }
                return JavaUtils.getTextClassName(cls.getName());
            }
        };
        SymbolTable symbolTable = new SymbolTable(btm, true, false, false);
        symbolTable.populate(null, doc);
        Vector v = symbolTable.getTypes();
        int i = 0;
        while (i < v.size()) {
            TypeEntry te = (TypeEntry)v.elementAt(i);
            if (te instanceof Element) {
                this.addToElementsList(te.getQName());
            } else if (te instanceof Type) {
                this.addToTypesList(te.getQName());
            }
            ++i;
        }
    }

    public QName writeTypeForPart(Class type, QName qname) throws AxisFault {
        if (type.getName().equals("void")) {
            return null;
        }
        if ((class$javax$xml$rpc$holders$Holder == null ? (class$javax$xml$rpc$holders$Holder = Types.class$("javax.xml.rpc.holders.Holder")) : class$javax$xml$rpc$holders$Holder).isAssignableFrom(type)) {
            type = JavaUtils.getHolderValueType(type);
        }
        if ((qname == null || Constants.isSOAP_ENC(qname.getNamespaceURI()) && "Array".equals(qname.getLocalPart())) && (qname = this.getTypeQName(type)) == null) {
            throw new AxisFault("Class:" + type.getName());
        }
        if (this.wsdlTypesElem == null) {
            this.writeWsdlTypesElement();
        }
        if (this.writeType(type, qname) == null) {
            qname = Constants.XSD_ANYTYPE;
        }
        return qname;
    }

    public QName writeElementForPart(Class type, QName qname) throws AxisFault {
        if (type.getName().equals("void")) {
            return null;
        }
        if ((class$javax$xml$rpc$holders$Holder == null ? (class$javax$xml$rpc$holders$Holder = Types.class$("javax.xml.rpc.holders.Holder")) : class$javax$xml$rpc$holders$Holder).isAssignableFrom(type)) {
            type = JavaUtils.getHolderValueType(type);
        }
        if ((qname == null || Constants.isSOAP_ENC(qname.getNamespaceURI()) && "Array".equals(qname.getLocalPart())) && (qname = this.getTypeQName(type)) == null) {
            throw new AxisFault("Class:" + type.getName());
        }
        String nsURI = qname.getNamespaceURI();
        if (Constants.isSchemaXSD(nsURI) || Constants.isSOAP_ENC(nsURI) && !"Array".equals(qname.getLocalPart())) {
            return null;
        }
        if (this.wsdlTypesElem == null) {
            this.writeWsdlTypesElement();
        }
        if (this.writeTypeAsElement(type, qname) == null) {
            qname = null;
        }
        return qname;
    }

    public boolean writeWrapperForPart(QName wrapper, String name, QName type) throws AxisFault {
        boolean isNew;
        if (this.wsdlTypesElem == null) {
            this.writeWsdlTypesElement();
        }
        this.writeTypeNamespace(wrapper);
        org.w3c.dom.Element sequence = (org.w3c.dom.Element)this.wrapperMap.get(wrapper);
        boolean bl = isNew = sequence == null;
        if (isNew) {
            org.w3c.dom.Element wrapperElement = this.docHolder.createElement("element");
            this.writeSchemaElement(wrapper, wrapperElement);
            wrapperElement.setAttribute("name", wrapper.getLocalPart());
            org.w3c.dom.Element complexType = this.docHolder.createElement("complexType");
            wrapperElement.appendChild(complexType);
            sequence = this.docHolder.createElement("sequence");
            complexType.appendChild(sequence);
            this.wrapperMap.put(wrapper, sequence);
        }
        org.w3c.dom.Element childElem = this.docHolder.createElement("element");
        childElem.setAttribute("name", name);
        String prefix = this.namespaces.getCreatePrefix(type.getNamespaceURI());
        String prefixedName = prefix + ":" + type.getLocalPart();
        childElem.setAttribute("type", prefixedName);
        sequence.appendChild(childElem);
        return isNew;
    }

    private QName writeTypeAsElement(Class type, QName qName) throws AxisFault {
        if (qName == null || Constants.equals(Constants.SOAP_ARRAY, qName)) {
            qName = this.getTypeQName(type);
        }
        QName typeQName = this.writeTypeNamespace(type, qName);
        String elementType = this.writeType(type, qName);
        if (elementType != null) {
            org.w3c.dom.Element element = this.createElementDecl(qName, elementType, this.isNullable(type));
            if (element != null) {
                this.writeSchemaElement(typeQName, element);
            }
            return qName;
        }
        return null;
    }

    private QName writeTypeNamespace(Class type, QName qName) {
        if (qName == null) {
            qName = this.getTypeQName(type);
        }
        this.writeTypeNamespace(qName);
        return qName;
    }

    private void writeTypeNamespace(QName qName) {
        String pref;
        if (qName != null && (pref = this.def.getPrefix(qName.getNamespaceURI())) == null) {
            this.def.addNamespace(this.namespaces.getCreatePrefix(qName.getNamespaceURI()), qName.getNamespaceURI());
        }
    }

    public QName getTypeQName(Class javaType) {
        QName qName = null;
        QName dQName = null;
        if (this.defaultTM != null) {
            dQName = this.defaultTM.getTypeQName(javaType);
        }
        if (this.tm != null) {
            qName = this.tm.getTypeQName(javaType);
        }
        if (qName == null) {
            qName = dQName;
        } else if (qName != null && qName != dQName && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            qName = dQName;
        }
        if (javaType.isArray() && qName != null && Constants.equals(Constants.SOAP_ARRAY, qName)) {
            Class<?> componentType = javaType.getComponentType();
            QName cqName = this.getTypeQName(componentType);
            if (this.targetNamespace.equals(cqName.getNamespaceURI())) {
                qName = new QName(this.targetNamespace, "ArrayOf" + cqName.getLocalPart());
            } else {
                String pre = this.namespaces.getCreatePrefix(cqName.getNamespaceURI());
                qName = new QName(this.targetNamespace, "ArrayOf_" + pre + "_" + cqName.getLocalPart());
            }
            return qName;
        }
        if (qName == null) {
            String pkg = Types.getPackageNameFromFullName(javaType.getName());
            String lcl = Types.getLocalNameFromFullName(javaType.getName());
            String ns = this.namespaces.getCreate(pkg);
            this.namespaces.getCreatePrefix(ns);
            String localPart = lcl.replace('$', '_');
            qName = new QName(ns, localPart);
        }
        return qName;
    }

    public static String getPackageNameFromFullName(String full) {
        if (full.lastIndexOf(46) < 0) {
            return "";
        }
        return full.substring(0, full.lastIndexOf(46));
    }

    public static String getLocalNameFromFullName(String full) {
        if (full.lastIndexOf(46) < 0) {
            return full;
        }
        return full.substring(full.lastIndexOf(46) + 1);
    }

    public void writeSchemaElement(QName qName, org.w3c.dom.Element element) {
        if (this.wsdlTypesElem == null) {
            try {
                this.writeWsdlTypesElement();
            }
            catch (Exception e) {
                log.error((Object)e);
                return;
            }
        }
        Node schemaElem = null;
        NodeList nl = this.wsdlTypesElem.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            NamedNodeMap attrs = nl.item(i).getAttributes();
            if (attrs != null) {
                int n = 0;
                while (n < attrs.getLength()) {
                    Attr a = (Attr)attrs.item(n);
                    if (a.getName().equals("targetNamespace") && a.getValue().equals(qName.getNamespaceURI())) {
                        schemaElem = (org.w3c.dom.Element)nl.item(i);
                    }
                    ++n;
                }
            }
            ++i;
        }
        if (schemaElem == null) {
            schemaElem = this.docHolder.createElement("schema");
            this.wsdlTypesElem.appendChild(schemaElem);
            schemaElem.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
            schemaElem.setAttribute("targetNamespace", qName.getNamespaceURI());
            org.w3c.dom.Element importElem = this.docHolder.createElement("import");
            schemaElem.appendChild(importElem);
            importElem.setAttribute("namespace", Constants.URI_DEFAULT_SOAP_ENC);
        }
        schemaElem.appendChild(element);
    }

    private void writeWsdlTypesElement() {
        if (this.wsdlTypesElem == null) {
            this.wsdlTypesElem = this.docHolder.createElementNS("http://schemas.xmlsoap.org/wsdl/", "types");
            this.wsdlTypesElem.setPrefix("wsdl");
        }
    }

    public String writeType(Class type) throws AxisFault {
        return this.writeType(type, null);
    }

    public String writeType(Class type, QName qName) throws AxisFault {
        if (qName == null || Constants.equals(Constants.SOAP_ARRAY, qName)) {
            qName = this.getTypeQName(type);
        }
        if (Constants.isSchemaXSD(qName.getNamespaceURI())) {
            return "xsd:" + qName.getLocalPart();
        }
        if (Constants.isSOAP_ENC(qName.getNamespaceURI()) && !"Array".equals(qName.getLocalPart())) {
            return "soapenc:" + qName.getLocalPart();
        }
        Serializer ser = null;
        SerializerFactory factory = null;
        factory = this.tm != null ? (SerializerFactory)this.tm.getSerializer(type) : (SerializerFactory)this.defaultTM.getSerializer(type);
        if (factory == null) {
            if (this.isBeanCompatible(type, true)) {
                factory = new BeanSerializerFactory(type, qName);
            } else {
                return null;
            }
        }
        if (factory != null) {
            ser = (Serializer)factory.getSerializerAs("Axis SAX Mechanism");
        }
        if (ser == null) {
            throw new AxisFault(Messages.getMessage("NoSerializer00", type.getName()));
        }
        this.writeTypeNamespace(type, qName);
        String componentTypeName = null;
        Class<?> componentType = null;
        if (type.isArray()) {
            String dimString = "[]";
            componentType = type.getComponentType();
            if (componentType.isArray()) {
                while (componentType.isArray()) {
                    dimString = dimString + "[]";
                    componentType = componentType.getComponentType();
                }
            }
            componentTypeName = this.writeType(componentType, null) + dimString;
        }
        String prefix = this.namespaces.getCreatePrefix(qName.getNamespaceURI());
        String prefixedName = prefix + ":" + qName.getLocalPart();
        if (!this.addToTypesList(qName)) {
            return prefixedName;
        }
        if (type.isArray()) {
            org.w3c.dom.Element complexType = this.docHolder.createElement("complexType");
            this.writeSchemaElement(qName, complexType);
            complexType.setAttribute("name", qName.getLocalPart());
            org.w3c.dom.Element complexContent = this.docHolder.createElement("complexContent");
            complexType.appendChild(complexContent);
            org.w3c.dom.Element restriction = this.docHolder.createElement("restriction");
            complexContent.appendChild(restriction);
            restriction.setAttribute("base", "soapenc:Array");
            org.w3c.dom.Element attribute = this.docHolder.createElement("attribute");
            restriction.appendChild(attribute);
            attribute.setAttribute("ref", "soapenc:arrayType");
            attribute.setAttribute("wsdl:arrayType", componentTypeName);
        } else {
            try {
                if (Types.isEnumClass(type)) {
                    this.writeEnumType(qName, type);
                } else {
                    ser.writeSchema(this);
                }
            }
            catch (Exception e) {
                throw new AxisFault(Messages.getMessage("writeSchemaProblem00", type.getName()), e);
            }
        }
        return prefixedName;
    }

    public static boolean isEnumClass(Class cls) {
        try {
            Method m = cls.getMethod("getValue", null);
            Method m2 = cls.getMethod("toString", null);
            if (m != null && m2 != null) {
                Method m3 = cls.getDeclaredMethod("fromString", class$java$lang$String == null ? (class$java$lang$String = Types.class$("java.lang.String")) : class$java$lang$String);
                Method m4 = cls.getDeclaredMethod("fromValue", m.getReturnType());
                if (m3 != null && Modifier.isStatic(m3.getModifiers()) && Modifier.isPublic(m3.getModifiers()) && m4 != null && Modifier.isStatic(m4.getModifiers()) && Modifier.isPublic(m4.getModifiers())) {
                    try {
                        return cls.getMethod("setValue", m.getReturnType()) == null;
                    }
                    catch (NoSuchMethodException e) {
                        return true;
                    }
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    private void writeEnumType(QName qName, Class cls) throws NoSuchMethodException, IllegalAccessException, AxisFault {
        if (!Types.isEnumClass(cls)) {
            return;
        }
        Method m = cls.getMethod("getValue", null);
        Class<?> base = m.getReturnType();
        org.w3c.dom.Element simpleType = this.docHolder.createElement("simpleType");
        this.writeSchemaElement(qName, simpleType);
        simpleType.setAttribute("name", qName.getLocalPart());
        org.w3c.dom.Element restriction = this.docHolder.createElement("restriction");
        simpleType.appendChild(restriction);
        String baseType = this.writeType(base, null);
        restriction.setAttribute("base", baseType);
        Field[] fields = cls.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            int mod = field.getModifiers();
            if (Modifier.isPublic(mod) && Modifier.isStatic(mod) && Modifier.isFinal(mod) && field.getType() == base) {
                org.w3c.dom.Element enumeration = this.docHolder.createElement("enumeration");
                enumeration.setAttribute("value", field.get(null).toString());
                restriction.appendChild(enumeration);
            }
            ++i;
        }
    }

    private org.w3c.dom.Element createElementDecl(QName qName, String elementType, boolean nullable) {
        if (!this.addToElementsList(qName)) {
            return null;
        }
        org.w3c.dom.Element element = this.docHolder.createElement("element");
        element.setAttribute("name", qName.getLocalPart());
        if (nullable) {
            element.setAttribute("nillable", "true");
        }
        element.setAttribute("type", elementType);
        return element;
    }

    public org.w3c.dom.Element createElement(String elementName, String elementType, boolean nullable, boolean omittable, Document docHolder) {
        org.w3c.dom.Element element = docHolder.createElement("element");
        element.setAttribute("name", elementName);
        if (nullable) {
            element.setAttribute("nillable", "true");
        }
        if (omittable) {
            element.setAttribute("minOccurs", "0");
            element.setAttribute("maxOccurs", "1");
        }
        element.setAttribute("type", elementType);
        return element;
    }

    public org.w3c.dom.Element createAttributeElement(String elementName, String elementType, boolean nullable, Document docHolder) {
        org.w3c.dom.Element element = docHolder.createElement("attribute");
        element.setAttribute("name", elementName);
        if (nullable) {
            element.setAttribute("nillable", "true");
        }
        element.setAttribute("type", elementType);
        return element;
    }

    boolean isSimpleType(Class type) {
        QName qname = this.tm.getTypeQName(type);
        if (qname == null) {
            return false;
        }
        String nsURI = qname.getNamespaceURI();
        return Constants.isSchemaXSD(nsURI) || Constants.isSOAP_ENC(nsURI);
    }

    public boolean isAcceptableAsAttribute(Class type) {
        return this.isSimpleType(type) || Types.isEnumClass(type) || this.implementsSimpleType(type);
    }

    boolean implementsSimpleType(Class type) {
        Class<?>[] impls = type.getInterfaces();
        int i = 0;
        while (i < impls.length) {
            if (impls[i] == (class$org$apache$axis$encoding$SimpleType == null ? Types.class$("org.apache.axis.encoding.SimpleType") : class$org$apache$axis$encoding$SimpleType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean addToTypesList(QName qName) {
        boolean added = false;
        ArrayList<String> types = (ArrayList<String>)this.schemaTypes.get(qName.getNamespaceURI());
        if (types == null) {
            types = new ArrayList<String>();
            types.add(qName.getLocalPart());
            this.schemaTypes.put(qName.getNamespaceURI(), types);
            added = true;
        } else if (!types.contains(qName.getLocalPart())) {
            types.add(qName.getLocalPart());
            added = true;
        }
        if (added) {
            String prefix = this.namespaces.getCreatePrefix(qName.getNamespaceURI());
            return !prefix.equals("soapenv") && !prefix.equals("soapenc") && !prefix.equals("xsd") && !prefix.equals("wsdl") && !prefix.equals("wsdlsoap");
        }
        return false;
    }

    private boolean addToElementsList(QName qName) {
        if (qName == null) {
            return false;
        }
        boolean added = false;
        ArrayList<String> elements = (ArrayList<String>)this.schemaElementNames.get(qName.getNamespaceURI());
        if (elements == null) {
            elements = new ArrayList<String>();
            elements.add(qName.getLocalPart());
            this.schemaElementNames.put(qName.getNamespaceURI(), elements);
            added = true;
        } else if (!elements.contains(qName.getLocalPart())) {
            elements.add(qName.getLocalPart());
            added = true;
        }
        return added;
    }

    public boolean isNullable(Class type) {
        return !type.isPrimitive() && (!type.isArray() || type.getComponentType() != Byte.TYPE);
    }

    private void createDocumentFragment() {
        this.docHolder = XMLUtils.newDocument();
    }

    public void insertTypesFragment(Document doc) {
        if (this.wsdlTypesElem != null) {
            Node node = doc.importNode(this.wsdlTypesElem, true);
            doc.getDocumentElement().insertBefore(node, doc.getDocumentElement().getFirstChild());
        }
    }

    public List getStopClasses() {
        return this.stopClasses;
    }

    public org.w3c.dom.Element createElement(String elementName) {
        return this.docHolder.createElement(elementName);
    }

    protected boolean isBeanCompatible(Class javaType, boolean issueErrors) {
        Class superClass;
        if (javaType.isArray() || javaType.isPrimitive()) {
            if (issueErrors && !this.beanCompatErrs.contains(javaType)) {
                log.warn((Object)Messages.getMessage("beanCompatType00", javaType.getName()));
                this.beanCompatErrs.add(javaType);
            }
            return false;
        }
        if (javaType.getName().startsWith("java.") || javaType.getName().startsWith("javax.")) {
            if (issueErrors && !this.beanCompatErrs.contains(javaType)) {
                log.warn((Object)Messages.getMessage("beanCompatPkg00", javaType.getName()));
                this.beanCompatErrs.add(javaType);
            }
            return false;
        }
        if (JavaUtils.isEnumClass(javaType)) {
            return true;
        }
        if (!(class$java$lang$Throwable == null ? (class$java$lang$Throwable = Types.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(javaType)) {
            try {
                javaType.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                if (issueErrors && !this.beanCompatErrs.contains(javaType)) {
                    log.warn((Object)Messages.getMessage("beanCompatConstructor00", javaType.getName()));
                    this.beanCompatErrs.add(javaType);
                }
                return false;
            }
        }
        if (!((superClass = javaType.getSuperclass()) == null || superClass == (class$java$lang$Object == null ? (class$java$lang$Object = Types.class$("java.lang.Object")) : class$java$lang$Object) || superClass == (class$java$lang$Exception == null ? (class$java$lang$Exception = Types.class$("java.lang.Exception")) : class$java$lang$Exception) || superClass == (class$java$lang$Throwable == null ? (class$java$lang$Throwable = Types.class$("java.lang.Throwable")) : class$java$lang$Throwable) || superClass == (class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = Types.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException) || superClass == (class$org$apache$axis$AxisFault == null ? (class$org$apache$axis$AxisFault = Types.class$("org.apache.axis.AxisFault")) : class$org$apache$axis$AxisFault) || this.stopClasses != null && this.stopClasses.contains(superClass.getName()) || this.isBeanCompatible(superClass, false))) {
            if (issueErrors && !this.beanCompatErrs.contains(javaType)) {
                log.warn((Object)Messages.getMessage("beanCompatExtends00", javaType.getName(), superClass.getName(), javaType.getName()));
                this.beanCompatErrs.add(javaType);
            }
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

