/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.axis.Constants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionTE;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaEnumTypeWriter;
import org.apache.axis.wsdl.toJava.JavaGeneratorFactory;
import org.apache.axis.wsdl.toJava.Namespaces;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Utils
extends org.apache.axis.wsdl.symbolTable.Utils {
    private static HashMap TYPES = new HashMap(7);
    private static HashMap constructorMap;
    private static HashMap constructorThrowMap;

    public static String holder(String mimeType, TypeEntry type, Emitter emitter) {
        String typeValue;
        if (mimeType != null) {
            if (mimeType.equals("image/gif") || mimeType.equals("image/jpeg")) {
                return "org.apache.axis.holders.ImageHolder";
            }
            if (mimeType.equals("text/plain")) {
                return "javax.xml.rpc.holders.StringHolder";
            }
            if (mimeType.startsWith("multipart/")) {
                return "org.apache.axis.holders.MimeMultipartHolder";
            }
            if (mimeType.equals("text/xml") || mimeType.equals("application/xml")) {
                return "org.apache.axis.holders.SourceHolder";
            }
        }
        if ((typeValue = type.getName()).equals("byte[]")) {
            return "javax.xml.rpc.holders.ByteArrayHolder";
        }
        if (typeValue.endsWith("[]")) {
            String name = emitter.getJavaName(type.getQName());
            name = JavaUtils.replace(name, "[]", "Array");
            name = Utils.addPackageName(name, "holders");
            return name + "Holder";
        }
        if (typeValue.equals("String")) {
            return "javax.xml.rpc.holders.StringHolder";
        }
        if (typeValue.equals("java.lang.String")) {
            return "javax.xml.rpc.holders.StringHolder";
        }
        if (typeValue.equals("Object")) {
            return "javax.xml.rpc.holders.ObjectHolder";
        }
        if (typeValue.equals("java.lang.Object")) {
            return "javax.xml.rpc.holders.ObjectHolder";
        }
        if (typeValue.equals("int") || typeValue.equals("long") || typeValue.equals("short") || typeValue.equals("float") || typeValue.equals("double") || typeValue.equals("boolean") || typeValue.equals("byte")) {
            return "javax.xml.rpc.holders." + Utils.capitalizeFirstChar(typeValue) + "Holder";
        }
        if (typeValue.startsWith("java.lang.")) {
            return "javax.xml.rpc.holders" + typeValue.substring(typeValue.lastIndexOf(".")) + "WrapperHolder";
        }
        if (typeValue.indexOf(".") < 0) {
            return "javax.xml.rpc.holders" + typeValue + "WrapperHolder";
        }
        if (typeValue.equals("java.math.BigDecimal")) {
            return "javax.xml.rpc.holders.BigDecimalHolder";
        }
        if (typeValue.equals("java.math.BigInteger")) {
            return "javax.xml.rpc.holders.BigIntegerHolder";
        }
        if (typeValue.equals("java.util.Date")) {
            return "org.apache.axis.holders.DateHolder";
        }
        if (typeValue.equals("java.util.Calendar")) {
            return "javax.xml.rpc.holders.CalendarHolder";
        }
        if (typeValue.equals("javax.xml.namespace.QName")) {
            return "javax.xml.rpc.holders.QNameHolder";
        }
        if (typeValue.startsWith("org.apache.axis.types.")) {
            int i = typeValue.lastIndexOf(46);
            String t = typeValue.substring(i + 1);
            return "org.apache.axis.holders." + t + "Holder";
        }
        return Utils.addPackageName(typeValue, "holders") + "Holder";
    }

    public static String addPackageName(String className, String newPkg) {
        int index = className.lastIndexOf(".");
        if (index >= 0) {
            return className.substring(0, index) + "." + newPkg + className.substring(index);
        }
        return newPkg + "." + className;
    }

    public static String getFullExceptionName(Fault fault, Emitter emitter) {
        Message faultMessage = fault.getMessage();
        MessageEntry me = emitter.getSymbolTable().getMessageEntry(faultMessage.getQName());
        return (String)me.getDynamicVar(JavaGeneratorFactory.EXCEPTION_CLASS_NAME);
    }

    public static Vector getEnumerationBaseAndValues(Node node, SymbolTable symbolTable) {
        int j;
        NodeList children;
        if (node == null) {
            return null;
        }
        QName nodeKind = org.apache.axis.wsdl.symbolTable.Utils.getNodeQName(node);
        if (nodeKind != null && nodeKind.getLocalPart().equals("element") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            children = node.getChildNodes();
            Node simpleNode = null;
            j = 0;
            while (j < children.getLength() && simpleNode == null) {
                QName simpleKind = org.apache.axis.wsdl.symbolTable.Utils.getNodeQName(children.item(j));
                if (simpleKind != null && simpleKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(simpleKind.getNamespaceURI())) {
                    node = simpleNode = children.item(j);
                }
                ++j;
            }
        }
        if ((nodeKind = org.apache.axis.wsdl.symbolTable.Utils.getNodeQName(node)) != null && nodeKind.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(nodeKind.getNamespaceURI())) {
            String javaName;
            QName baseType;
            children = node.getChildNodes();
            Node restrictionNode = null;
            j = 0;
            while (j < children.getLength() && restrictionNode == null) {
                QName restrictionKind = org.apache.axis.wsdl.symbolTable.Utils.getNodeQName(children.item(j));
                if (restrictionKind != null && restrictionKind.getLocalPart().equals("restriction") && Constants.isSchemaXSD(restrictionKind.getNamespaceURI())) {
                    restrictionNode = children.item(j);
                }
                ++j;
            }
            Type baseEType = null;
            if (restrictionNode != null && (baseEType = symbolTable.getType(baseType = org.apache.axis.wsdl.symbolTable.Utils.getTypeQName(restrictionNode, new BooleanHolder(), false))) != null && ((javaName = baseEType.getName()).equals("boolean") || !SchemaUtils.isSimpleSchemaType(baseEType.getQName()))) {
                baseEType = null;
            }
            if (baseEType != null && restrictionNode != null) {
                Vector<Object> v = new Vector<Object>();
                NodeList enums = restrictionNode.getChildNodes();
                int i = 0;
                while (i < enums.getLength()) {
                    Node enumNode;
                    String value;
                    QName enumKind = org.apache.axis.wsdl.symbolTable.Utils.getNodeQName(enums.item(i));
                    if (enumKind != null && enumKind.getLocalPart().equals("enumeration") && Constants.isSchemaXSD(enumKind.getNamespaceURI()) && (value = org.apache.axis.wsdl.symbolTable.Utils.getAttribute(enumNode = enums.item(i), "value")) != null) {
                        v.add(value);
                    }
                    ++i;
                }
                if (v.isEmpty()) {
                    return null;
                }
                v.add(0, baseEType);
                return v;
            }
        }
        return null;
    }

    public static String capitalizeFirstChar(String name) {
        if (name == null || name.equals("")) {
            return name;
        }
        char start = name.charAt(0);
        if (Character.isLowerCase(start)) {
            start = Character.toUpperCase(start);
            return start + name.substring(1);
        }
        return name;
    }

    public static String xmlNameToJava(String name) {
        return JavaUtils.xmlNameToJava(name);
    }

    public static String xmlNameToJavaClass(String name) {
        return Utils.capitalizeFirstChar(Utils.xmlNameToJava(name));
    }

    public static String makePackageName(String namespace) {
        String hostname = null;
        try {
            hostname = new URL(namespace).getHost();
        }
        catch (MalformedURLException e) {
            if (namespace.indexOf(":") > -1) {
                hostname = namespace.substring(namespace.indexOf(":") + 1);
                if (hostname.indexOf("/") > -1) {
                    hostname = hostname.substring(0, hostname.indexOf("/"));
                }
            }
            hostname = namespace;
        }
        if (hostname == null) {
            return null;
        }
        hostname = hostname.replace('-', '_');
        StringTokenizer st = new StringTokenizer(hostname, ".");
        String[] words = new String[st.countTokens()];
        int i = 0;
        while (i < words.length) {
            words[i] = st.nextToken();
            ++i;
        }
        StringBuffer sb = new StringBuffer(80);
        int i2 = words.length - 1;
        while (i2 >= 0) {
            String word = words[i2];
            if (JavaUtils.isJavaKeyword(word)) {
                word = JavaUtils.makeNonJavaKeyword(word);
            }
            if (i2 != words.length - 1) {
                sb.append('.');
            }
            if (Character.isDigit(word.charAt(0))) {
                sb.append('_');
            }
            sb.append(word);
            --i2;
        }
        return sb.toString();
    }

    public static String getJavaLocalName(String fullName) {
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    public static String getJavaPackageName(String fullName) {
        if (fullName.lastIndexOf(46) > 0) {
            return fullName.substring(0, fullName.lastIndexOf(46));
        }
        return "";
    }

    public static boolean fileExists(String name, String namespace, Namespaces namespaces) throws IOException {
        String packageName = namespaces.getAsDir(namespace);
        String fullName = packageName + name;
        return new File(fullName).exists();
    }

    public static String wrapPrimitiveType(TypeEntry type, String var) {
        String objType;
        String string = objType = type == null ? null : (String)TYPES.get(type.getName());
        if (objType != null) {
            return "new " + objType + "(" + var + ")";
        }
        if (type != null && type.getName().equals("byte[]") && type.getQName().getLocalPart().equals("hexBinary")) {
            return "new org.apache.axis.types.HexBinary(" + var + ")";
        }
        return var;
    }

    public static String getResponseString(TypeEntry type, String mimeType, String var) {
        if (type == null) {
            return ";";
        }
        if (mimeType != null) {
            if (mimeType.equals("image/jpeg")) {
                return "(java.awt.Image) " + var + ";";
            }
            if (mimeType.equals("text/plain")) {
                return "(java.lang.String) " + var + ";";
            }
            if (mimeType.equals("text/xml") || mimeType.equals("application/xml")) {
                return "(javax.xml.transform.Source) " + var + ";";
            }
            if (mimeType.startsWith("multipart/")) {
                return "(javax.mail.internet.MimeMultipart) " + var + ";";
            }
            return "(" + type.getName() + ") " + var + ";";
        }
        String objType = (String)TYPES.get(type.getName());
        if (objType != null) {
            return "((" + objType + ") " + var + ")." + type.getName() + "Value();";
        }
        return "(" + type.getName() + ") " + var + ";";
    }

    public static boolean isPrimitiveType(TypeEntry type) {
        return TYPES.get(type.getName()) != null;
    }

    public static QName getOperationQName(BindingOperation bindingOper) {
        Map parts;
        Input input;
        Operation operation = bindingOper.getOperation();
        String operationName = operation.getName();
        QName elementQName = null;
        String ns = null;
        BindingInput bindInput = bindingOper.getBindingInput();
        if (bindInput != null) {
            Iterator it = bindInput.getExtensibilityElements().iterator();
            while (it.hasNext()) {
                ExtensibilityElement elem = (ExtensibilityElement)it.next();
                if (!(elem instanceof SOAPBody)) continue;
                SOAPBody body = (SOAPBody)elem;
                ns = body.getNamespaceURI();
                break;
            }
        }
        if (ns == null) {
            ns = "";
        }
        if ((input = operation.getInput()) != null && (parts = input.getMessage().getParts()) != null && !parts.isEmpty()) {
            Iterator i = parts.values().iterator();
            Part p = (Part)i.next();
            elementQName = p.getElementName();
        }
        if (elementQName == null) {
            elementQName = new QName(ns, operationName);
        }
        return elementQName;
    }

    public static String getNewQName(QName qname) {
        return "new javax.xml.namespace.QName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\")";
    }

    public static String getParameterTypeName(Parameter parm) {
        String ret;
        String mime = parm.getMIMEType();
        if (mime == null) {
            ret = parm.getType().getName();
        } else {
            ret = JavaUtils.mimeToJava(mime);
            if (ret == null) {
                ret = parm.getType().getName();
            }
        }
        return ret;
    }

    public static QName getXSIType(Parameter param) {
        if (param.getMIMEType() != null) {
            return Utils.getMIMETypeQName(param.getMIMEType());
        }
        return Utils.getXSIType(param.getType());
    }

    public static QName getXSIType(TypeEntry te) {
        QName xmlType = null;
        if (te != null && te instanceof Element && te.getRefType() != null) {
            te = te.getRefType();
        }
        if (te != null && te instanceof CollectionTE && te.getRefType() != null) {
            te = te.getRefType();
        }
        if (te != null) {
            xmlType = te.getQName();
        }
        return xmlType;
    }

    public static QName getMIMETypeQName(String mimeName) {
        if ("text/plain".equals(mimeName)) {
            return Constants.MIME_PLAINTEXT;
        }
        if ("image/gif".equals(mimeName) || "image/jpeg".equals(mimeName)) {
            return Constants.MIME_IMAGE;
        }
        if ("text/xml".equals(mimeName) || "applications/xml".equals(mimeName)) {
            return Constants.MIME_SOURCE;
        }
        if (mimeName != null && mimeName.startsWith("multipart/")) {
            return Constants.MIME_MULTIPART;
        }
        return null;
    }

    public static boolean hasMIME(BindingEntry bEntry) {
        List operations = bEntry.getBinding().getBindingOperations();
        int i = 0;
        while (i < operations.size()) {
            BindingOperation operation = (BindingOperation)operations.get(i);
            if (Utils.hasMIME(bEntry, operation)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasMIME(BindingEntry bEntry, BindingOperation operation) {
        Parameters parameters = bEntry.getParameters(operation.getOperation());
        if (parameters != null) {
            int idx = 0;
            while (idx < parameters.list.size()) {
                Parameter p = (Parameter)parameters.list.get(idx);
                if (p.getMIMEType() != null) {
                    return true;
                }
                ++idx;
            }
        }
        return false;
    }

    static String getConstructorForParam(Parameter param, SymbolTable symbolTable, BooleanHolder bThrow) {
        String paramType = param.getType().getName();
        String mimeType = param.getMIMEType();
        String out = null;
        if (mimeType != null) {
            if (mimeType.equals("image/gif") || mimeType.equals("image/jpeg")) {
                return "null";
            }
            if (mimeType.equals("text/xml") || mimeType.equals("application/xml")) {
                return "new javax.xml.transform.stream.StreamSource()";
            }
            return "new " + Utils.getParameterTypeName(param) + "()";
        }
        out = (String)constructorMap.get(paramType);
        if (out != null) {
            return out;
        }
        out = (String)constructorThrowMap.get(paramType);
        if (out != null) {
            bThrow.value = true;
            return out;
        }
        if (paramType.endsWith("[]")) {
            return "new " + JavaUtils.replace(paramType, "[]", "[0]");
        }
        Vector v = Utils.getEnumerationBaseAndValues(param.getType().getNode(), symbolTable);
        if (v != null) {
            String enumeration = (String)JavaEnumTypeWriter.getEnumValueIds(v).get(0);
            return paramType + "." + enumeration;
        }
        return "new " + paramType + "()";
    }

    static {
        TYPES.put("int", "java.lang.Integer");
        TYPES.put("float", "java.lang.Float");
        TYPES.put("boolean", "java.lang.Boolean");
        TYPES.put("double", "java.lang.Double");
        TYPES.put("byte", "java.lang.Byte");
        TYPES.put("short", "java.lang.Short");
        TYPES.put("long", "java.lang.Long");
        constructorMap = new HashMap(50);
        constructorThrowMap = new HashMap(50);
        constructorMap.put("int", "0");
        constructorMap.put("float", "0");
        constructorMap.put("boolean", "true");
        constructorMap.put("double", "0");
        constructorMap.put("byte", "(byte)0");
        constructorMap.put("short", "(short)0");
        constructorMap.put("long", "0");
        constructorMap.put("java.lang.Boolean", "new java.lang.Boolean(false)");
        constructorMap.put("java.lang.Byte", "new java.lang.Byte((byte)0)");
        constructorMap.put("java.lang.Double", "new java.lang.Double(0)");
        constructorMap.put("java.lang.Float", "new java.lang.Float(0)");
        constructorMap.put("java.lang.Integer", "new java.lang.Integer(0)");
        constructorMap.put("java.lang.Long", "new java.lang.Long(0)");
        constructorMap.put("java.lang.Short", "new java.lang.Short((short)0)");
        constructorMap.put("java.math.BigDecimal", "new java.math.BigDecimal(0)");
        constructorMap.put("java.math.BigInteger", "new java.math.BigInteger(\"0\")");
        constructorMap.put("java.lang.Object", "new java.lang.String()");
        constructorMap.put("byte[]", "new byte[0]");
        constructorMap.put("java.util.Calendar", "java.util.Calendar.getInstance()");
        constructorMap.put("javax.xml.namespace.QName", "new javax.xml.namespace.QName(\"http://double-double\", \"toil-and-trouble\")");
        constructorMap.put("org.apache.axis.types.NonNegativeInteger", "new org.apache.axis.types.NonNegativeInteger(\"0\")");
        constructorMap.put("org.apache.axis.types.PositiveInteger", "new org.apache.axis.types.PositiveInteger(\"1\")");
        constructorMap.put("org.apache.axis.types.NonPositiveInteger", "new org.apache.axis.types.NonPositiveInteger(\"0\")");
        constructorMap.put("org.apache.axis.types.NegativeInteger", "new org.apache.axis.types.NegativeInteger(\"-1\")");
        constructorThrowMap.put("org.apache.axis.types.Time", "new org.apache.axis.types.Time(\"15:45:45.275Z\")");
        constructorThrowMap.put("org.apache.axis.types.UnsignedLong", "new org.apache.axis.types.UnsignedLong(0)");
        constructorThrowMap.put("org.apache.axis.types.UnsignedInt", "new org.apache.axis.types.UnsignedInt(0)");
        constructorThrowMap.put("org.apache.axis.types.UnsignedShort", "new org.apache.axis.types.UnsignedShort(0)");
        constructorThrowMap.put("org.apache.axis.types.UnsignedByte", "new org.apache.axis.types.UnsignedByte(0)");
        constructorThrowMap.put("org.apache.axis.types.URI", "new org.apache.axis.types.URI(\"urn:testing\")");
        constructorThrowMap.put("org.apache.axis.types.Year", "new org.apache.axis.types.Year(2000)");
        constructorThrowMap.put("org.apache.axis.types.Month", "new org.apache.axis.types.Month(1)");
        constructorThrowMap.put("org.apache.axis.types.Day", "new org.apache.axis.types.Day(1)");
        constructorThrowMap.put("org.apache.axis.types.YearMonth", "new org.apache.axis.types.YearMonth(2000,1)");
        constructorThrowMap.put("org.apache.axis.types.MonthDay", "new org.apache.axis.types.MonthDay(1, 1)");
    }
}

