/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.RPCElement;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class RPCParam
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(RPCParam.class.getName());
    RPCElement myCall;
    private transient QName qname;
    private Object value;
    private int countSetCalls = 0;
    private ParameterDesc paramDesc;
    private Boolean wantXSIType;
    private static Method valueSetMethod;

    public RPCParam(String string, Object object) {
        this.qname = new QName("", string);
        this.value = object;
    }

    public RPCParam(QName qName, Object object) {
        this.qname = qName;
        this.value = object;
    }

    public RPCParam(String string, String string2, Object object) {
        this.qname = new QName(string, string2);
        this.value = object;
    }

    public void setRPCCall(RPCElement rPCElement) {
        this.myCall = rPCElement;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public void set(Object object) {
        ++this.countSetCalls;
        if (this.countSetCalls == 1) {
            this.value = object;
            return;
        }
        if (this.countSetCalls == 2) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(this.value);
            this.value = arrayList;
        }
        ((ArrayList)this.value).add(object);
    }

    public String getName() {
        return this.qname.getLocalPart();
    }

    public QName getQName() {
        return this.qname;
    }

    public static Method getValueSetMethod() {
        return valueSetMethod;
    }

    public ParameterDesc getParamDesc() {
        return this.paramDesc;
    }

    public void setParamDesc(ParameterDesc parameterDesc) {
        this.paramDesc = parameterDesc;
    }

    public void setXSITypeGeneration(Boolean bl) {
        this.wantXSIType = bl;
    }

    public Boolean getXSITypeGeneration() {
        return this.wantXSIType;
    }

    public void serialize(SerializationContext serializationContext) throws IOException {
        Class clazz = this.value == null ? null : this.value.getClass();
        QName qName = null;
        if (this.paramDesc != null) {
            if (clazz == null) {
                clazz = this.paramDesc.getJavaType() != null ? this.paramDesc.getJavaType() : clazz;
            } else if (!clazz.equals(this.paramDesc.getJavaType())) {
                this.wantXSIType = Boolean.TRUE;
            }
            qName = this.paramDesc.getTypeQName();
        }
        if (clazz == null && this.value != null ? ClassUtils.callContextClass().isAssignableFrom(this.value.getClass()) : clazz != null && ClassUtils.callContextClass().isAssignableFrom(clazz)) {
            return;
        }
        serializationContext.serialize(this.qname, null, this.value, qName, true, this.wantXSIType);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.qname == null) {
            objectOutputStream.writeBoolean(false);
        } else {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.qname.getNamespaceURI());
            objectOutputStream.writeObject(this.qname.getLocalPart());
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.qname = objectInputStream.readBoolean() ? new QName((String)objectInputStream.readObject(), (String)objectInputStream.readObject()) : null;
        objectInputStream.defaultReadObject();
    }

    static {
        Class<RPCParam> clazz = RPCParam.class;
        try {
            valueSetMethod = clazz.getMethod("set", Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.error((Object)Messages.getMessage("noValue00", "" + noSuchMethodException));
            System.exit(-1);
        }
    }
}

