/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.security.servlet.ServletSecurityProvider;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AxisHttpSession;
import org.apache.axis.transport.http.AxisServletBase;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.transport.http.ServletEndpointContextImpl;
import org.apache.axis.utils.Admin;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class AxisServlet
extends AxisServletBase {
    private static final Log LOGGER = LogFactory.getLog(AxisServlet.class.getName());
    private static final Log TIME_LOGGER = LogFactory.getLog("org.apache.axis.TIME");
    public static final String INIT_PROPERTY_TRANSPORT_NAME = "transport.name";
    public static final String INIT_PROPERTY_USE_SECURITY = "use-servlet-security";
    public static final String INIT_PROPERTY_ENABLE_LIST = "axis.enableListQuery";
    public static final String INIT_PROPERTY_JWS_CLASS_DIR = "axis.jws.servletClassDir";
    private String transportName;
    private ServletSecurityProvider securityProvider = null;
    private static boolean isDebug = false;
    private boolean enableList = false;
    private String jwsClassDir = null;

    protected String getJWSClassDir() {
        return this.jwsClassDir;
    }

    @Override
    public void init() {
        super.init();
        ServletContext servletContext = this.getServletConfig().getServletContext();
        isDebug = LOGGER.isDebugEnabled();
        if (isDebug) {
            LOGGER.debug((Object)"In servlet init");
        }
        this.transportName = this.getOption(servletContext, INIT_PROPERTY_TRANSPORT_NAME, "http");
        if (JavaUtils.isTrueExplicitly(this.getOption(servletContext, INIT_PROPERTY_USE_SECURITY, null))) {
            this.securityProvider = new ServletSecurityProvider();
        }
        this.enableList = JavaUtils.isTrueExplicitly(this.getOption(servletContext, INIT_PROPERTY_ENABLE_LIST, null));
        this.jwsClassDir = this.getOption(servletContext, INIT_PROPERTY_JWS_CLASS_DIR, null);
        if (this.jwsClassDir != null) {
            if (this.getHomeDir() != null) {
                this.jwsClassDir = this.getHomeDir() + this.jwsClassDir;
            }
        } else {
            this.jwsClassDir = this.getDefaultJWSClassDir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block21: {
            if (isDebug) {
                LOGGER.debug((Object)"Enter: doGet()");
            }
            PrintWriter printWriter = httpServletResponse.getWriter();
            try {
                boolean bl;
                String string;
                AxisServer axisServer = this.getEngine();
                ServletContext servletContext = this.getServletConfig().getServletContext();
                String string2 = httpServletRequest.getPathInfo();
                String string3 = servletContext.getRealPath(httpServletRequest.getServletPath());
                if (string3 == null) {
                    string3 = httpServletRequest.getServletPath();
                }
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = httpServletRequest.getParameterNames().hasMoreElements();
                boolean bl5 = httpServletRequest.getRequestURI().endsWith(".jws");
                if (bl5) {
                    string2 = httpServletRequest.getServletPath();
                }
                if ((string = httpServletRequest.getQueryString()) != null) {
                    if ("wsdl".equalsIgnoreCase(string)) {
                        bl2 = true;
                    } else if ("list".equalsIgnoreCase(string)) {
                        bl3 = true;
                    }
                }
                boolean bl6 = bl = string2 == null || "".equals(string2);
                if (!bl2 && !bl3 && bl) {
                    this.reportAvailableServices(httpServletResponse, printWriter, httpServletRequest);
                    break block21;
                }
                if (string3 != null) {
                    MessageContext messageContext = this.createMessageContext(axisServer, httpServletRequest, httpServletResponse);
                    try {
                        String string4 = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString();
                        messageContext.setProperty(MessageContext.TRANS_URL, string4);
                        if (bl2) {
                            this.processWsdlRequest(messageContext, httpServletResponse, printWriter);
                            break block21;
                        }
                        if (bl3) {
                            this.processListRequest(httpServletResponse, printWriter);
                            break block21;
                        }
                        if (bl4) {
                            this.processMethodRequest(messageContext, httpServletRequest, httpServletResponse, printWriter);
                            break block21;
                        }
                        String string5 = string2.startsWith("/") ? string2.substring(1) : string2;
                        SOAPService sOAPService = axisServer.getService(string5);
                        if (sOAPService == null) {
                            httpServletResponse.setStatus(404);
                            httpServletResponse.setContentType("text/html");
                            printWriter.println("<h2>" + Messages.getMessage("error00") + "</h2>");
                            printWriter.println("<p>" + Messages.getMessage("noService06") + "</p>");
                            break block21;
                        }
                        this.reportServiceInfo(httpServletResponse, printWriter, sOAPService, string5);
                    }
                    catch (AxisFault axisFault) {
                        LOGGER.error((Object)Messages.getMessage("exception00"), (Throwable)axisFault);
                        httpServletResponse.setContentType("text/html");
                        httpServletResponse.setStatus(500);
                        printWriter.println("<h2>" + Messages.getMessage("error00") + "</h2>");
                        printWriter.println("<p>" + Messages.getMessage("somethingWrong00") + "</p>");
                        printWriter.println("<pre>Fault - " + axisFault.toString() + " </pre>");
                        printWriter.println("<pre>" + axisFault.dumpToString() + " </pre>");
                    }
                    catch (Exception exception) {
                        LOGGER.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                        httpServletResponse.setContentType("text/html");
                        httpServletResponse.setStatus(500);
                        printWriter.println("<h2>" + Messages.getMessage("error00") + "</h2>");
                        printWriter.println("<p>" + Messages.getMessage("somethingWrong00") + "</p>");
                        printWriter.println("<pre>Exception - " + exception + "<br>");
                        if (this.isDevelopment()) {
                            printWriter.println(JavaUtils.stackToString(exception));
                        }
                        printWriter.println("</pre>");
                    }
                    break block21;
                }
                httpServletResponse.setContentType("text/html");
                printWriter.println("<html><h1>Axis HTTP Servlet</h1>");
                printWriter.println(Messages.getMessage("reachedServlet00"));
                printWriter.println("<p>" + Messages.getMessage("transportName00", "<b>" + this.transportName + "</b>"));
                printWriter.println("</html>");
            }
            finally {
                printWriter.close();
                if (isDebug) {
                    LOGGER.debug((Object)"Exit: doGet()");
                }
            }
        }
    }

    protected void processMethodRequest(MessageContext messageContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws AxisFault {
        String string;
        Enumeration enumeration = httpServletRequest.getParameterNames();
        String string2 = null;
        StringBuilder stringBuilder = new StringBuilder();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if ("method".equalsIgnoreCase(string)) {
                string2 = httpServletRequest.getParameter(string);
                continue;
            }
            stringBuilder.append("<").append(string).append(">").append(httpServletRequest.getParameter(string)).append("</").append(string).append(">");
        }
        string = stringBuilder.toString();
        if (string2 == null) {
            httpServletResponse.setContentType("text/html");
            printWriter.println("<h2>" + Messages.getMessage("error00") + ":  " + Messages.getMessage("invokeGet00") + "</h2>");
            printWriter.println("<p>" + Messages.getMessage("noMethod01") + "</p>");
        } else {
            this.invokeEndpointFromGet(messageContext, httpServletResponse, printWriter, string2, string);
        }
    }

    protected void processWsdlRequest(MessageContext messageContext, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws AxisFault {
        AxisServer axisServer = this.getEngine();
        try {
            ((BasicHandler)axisServer).generateWSDL(messageContext);
            Document document = (Document)messageContext.getProperty("WSDL");
            if (document != null) {
                httpServletResponse.setContentType("text/xml");
                XMLUtils.DocumentToWriter(document, printWriter);
            } else {
                this.reportNoWSDL(httpServletResponse, printWriter);
            }
        }
        catch (AxisFault axisFault) {
            if (axisFault.getFaultCode().equals(Constants.QNAME_NO_SERVICE_FAULT_CODE)) {
                this.reportNoWSDL(httpServletResponse, printWriter);
            }
            throw axisFault;
        }
    }

    protected void invokeEndpointFromGet(MessageContext messageContext, HttpServletResponse httpServletResponse, PrintWriter printWriter, String string, String string2) throws AxisFault {
        AxisServer axisServer = this.getEngine();
        String string3 = "<" + string + ">" + string2 + "</" + string + ">";
        String string4 = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Body>" + string3 + "</SOAP-ENV:Body></SOAP-ENV:Envelope>";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string4.getBytes());
        Message message = new Message((Object)byteArrayInputStream, false);
        messageContext.setRequestMessage(message);
        ((BasicHandler)axisServer).invoke(messageContext);
        Message message2 = messageContext.getResponseMessage();
        if (message2 != null) {
            httpServletResponse.setContentType("text/xml");
            printWriter.println(message2.getSOAPPartAsString());
        } else {
            printWriter.println("<p>" + Messages.getMessage("noResponse01") + "</p>");
        }
    }

    protected void reportServiceInfo(HttpServletResponse httpServletResponse, PrintWriter printWriter, SOAPService sOAPService, String string) {
        httpServletResponse.setContentType("text/html");
        printWriter.println("<h1>" + sOAPService.getName() + "</h1>");
        printWriter.println("<p>" + Messages.getMessage("axisService00") + "</p>");
        printWriter.println("<i>" + Messages.getMessage("perhaps00") + "</i>");
    }

    protected void processListRequest(HttpServletResponse httpServletResponse, PrintWriter printWriter) throws AxisFault {
        AxisServer axisServer = this.getEngine();
        if (this.enableList) {
            Document document = Admin.listConfig(axisServer);
            if (document != null) {
                httpServletResponse.setContentType("text/xml");
                XMLUtils.DocumentToWriter(document, printWriter);
            } else {
                httpServletResponse.setStatus(404);
                httpServletResponse.setContentType("text/html");
                printWriter.println("<h2>" + Messages.getMessage("error00") + "</h2>");
                printWriter.println("<p>" + Messages.getMessage("noDeploy00") + "</p>");
            }
        } else {
            httpServletResponse.setStatus(403);
            httpServletResponse.setContentType("text/html");
            printWriter.println("<h2>" + Messages.getMessage("error00") + "</h2>");
            printWriter.println("<p><i>?list</i>" + Messages.getMessage("disabled00") + "</p>");
        }
    }

    protected void reportNoWSDL(HttpServletResponse httpServletResponse, PrintWriter printWriter) {
        httpServletResponse.setStatus(404);
        httpServletResponse.setContentType("text/html");
        printWriter.println("<h2>" + Messages.getMessage("error00") + "</h2>");
        printWriter.println("<p>" + Messages.getMessage("noWSDL00") + "</p>");
    }

    protected void reportAvailableServices(HttpServletResponse httpServletResponse, PrintWriter printWriter, HttpServletRequest httpServletRequest) throws ConfigurationException, AxisFault {
        AxisServer axisServer = this.getEngine();
        httpServletResponse.setContentType("text/html");
        printWriter.println("<h2>And now... Some Services</h2>");
        Iterator iterator = axisServer.getConfig().getDeployedServices();
        String string = this.getWebappBase(httpServletRequest) + httpServletRequest.getServletPath() + "/";
        printWriter.println("<ul>");
        while (iterator.hasNext()) {
            ServiceDesc serviceDesc = (ServiceDesc)iterator.next();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<li>");
            String string2 = serviceDesc.getName();
            stringBuilder.append(string2);
            stringBuilder.append(" <a href=\"");
            stringBuilder.append(string);
            stringBuilder.append(string2);
            stringBuilder.append("?wsdl\"><i>(wsdl)</i></a></li>");
            printWriter.println(stringBuilder.toString());
            ArrayList arrayList = serviceDesc.getOperations();
            if (arrayList.isEmpty()) continue;
            printWriter.println("<ul>");
            for (OperationDesc operationDesc : arrayList) {
                printWriter.println("<li>" + operationDesc.getName());
            }
            printWriter.println("</ul>");
        }
        printWriter.println("</ul>");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        String string = null;
        MessageContext messageContext = null;
        if (isDebug) {
            LOGGER.debug((Object)"Enter: doPost()");
        }
        if (TIME_LOGGER.isDebugEnabled()) {
            l = System.currentTimeMillis();
        }
        Message message = null;
        String string2 = null;
        try {
            AxisServer axisServer = this.getEngine();
            if (axisServer == null) {
                ServletException servletException = new ServletException(Messages.getMessage("noEngine00"));
                LOGGER.debug((Object)"No Engine!", (Throwable)servletException);
                throw servletException;
            }
            httpServletResponse.setBufferSize(8192);
            messageContext = this.createMessageContext(axisServer, httpServletRequest, httpServletResponse);
            if (this.securityProvider != null) {
                if (isDebug) {
                    LOGGER.debug((Object)("securityProvider:" + this.securityProvider));
                }
                messageContext.setProperty("securityProvider", this.securityProvider);
            }
            Message message2 = new Message(httpServletRequest.getInputStream(), false, httpServletRequest.getHeader("Content-Type"), httpServletRequest.getHeader("Content-Location"));
            if (isDebug) {
                LOGGER.debug((Object)("Request Message:" + message2));
            }
            messageContext.setRequestMessage(message2);
            try {
                string = this.getSoapAction(httpServletRequest);
                if (string != null) {
                    messageContext.setUseSOAPAction(true);
                    messageContext.setSOAPActionURI(string);
                }
                messageContext.setSession(new AxisHttpSession(httpServletRequest));
                if (TIME_LOGGER.isDebugEnabled()) {
                    l2 = System.currentTimeMillis();
                }
                if (isDebug) {
                    LOGGER.debug((Object)"Invoking Axis Engine.");
                }
                ((BasicHandler)axisServer).invoke(messageContext);
                if (isDebug) {
                    LOGGER.debug((Object)"Return from Axis Engine.");
                }
                if (TIME_LOGGER.isDebugEnabled()) {
                    l3 = System.currentTimeMillis();
                }
                message = messageContext.getResponseMessage();
                string2 = message.getContentType(messageContext.getSOAPConstants());
            }
            catch (AxisFault axisFault) {
                int n = this.getHttpServletResponseStatus(axisFault);
                if (n == 401) {
                    httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"AXIS\"");
                } else {
                    LOGGER.error((Object)Messages.getMessage("exception00"), (Throwable)axisFault);
                }
                httpServletResponse.setStatus(n);
                message = messageContext.getResponseMessage();
                if (message == null) {
                    message = new Message(axisFault);
                }
                string2 = message.getContentType(messageContext.getSOAPConstants());
            }
            catch (Exception exception) {
                LOGGER.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                httpServletResponse.setStatus(500);
                message = messageContext.getResponseMessage();
                if (message == null) {
                    message = new Message(AxisFault.makeFault(exception));
                }
                string2 = message.getContentType(messageContext.getSOAPConstants());
            }
        }
        catch (AxisFault axisFault) {
            LOGGER.error((Object)Messages.getMessage("axisFault00"), (Throwable)axisFault);
            message = messageContext.getResponseMessage();
            if (message == null) {
                message = new Message(axisFault);
            }
            string2 = message.getContentType(messageContext.getSOAPConstants());
        }
        if (TIME_LOGGER.isDebugEnabled()) {
            l4 = System.currentTimeMillis();
        }
        if (message != null) {
            this.sendResponse(this.getProtocolVersion(httpServletRequest), string2, httpServletResponse, message);
        }
        if (isDebug) {
            LOGGER.debug((Object)"Response sent.");
            LOGGER.debug((Object)"Exit: doPost()");
        }
        if (TIME_LOGGER.isDebugEnabled()) {
            l5 = System.currentTimeMillis();
            TIME_LOGGER.debug((Object)("axisServlet.doPost: " + string + " pre=" + (l2 - l) + " invoke=" + (l3 - l2) + " post=" + (l4 - l3) + " send=" + (l5 - l4) + " " + messageContext.getTargetService() + "." + (messageContext.getOperation() == null ? "" : messageContext.getOperation().getName())));
        }
    }

    protected int getHttpServletResponseStatus(AxisFault axisFault) {
        return axisFault.getFaultCode().getLocalPart().startsWith("Server.Unauth") ? 401 : 500;
    }

    private void sendResponse(String string, String string2, HttpServletResponse httpServletResponse, Message message) throws AxisFault, IOException {
        if (message == null) {
            httpServletResponse.setStatus(204);
            if (isDebug) {
                LOGGER.debug((Object)"NO AXIS MESSAGE TO RETURN!");
            }
        } else {
            if (isDebug) {
                LOGGER.debug((Object)("Returned Content-Type:" + string2));
            }
            try {
                httpServletResponse.setContentType(string2);
                message.writeTo((OutputStream)httpServletResponse.getOutputStream());
            }
            catch (SOAPException sOAPException) {
                LOGGER.error((Object)Messages.getMessage("exception00"), (Throwable)sOAPException);
            }
        }
        if (!httpServletResponse.isCommitted()) {
            httpServletResponse.flushBuffer();
        }
    }

    private MessageContext createMessageContext(AxisEngine axisEngine, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        MessageContext messageContext = new MessageContext(axisEngine);
        if (isDebug) {
            LOGGER.debug((Object)("MessageContext:" + messageContext));
            LOGGER.debug((Object)("HEADER_CONTENT_TYPE:" + httpServletRequest.getHeader("Content-Type")));
            LOGGER.debug((Object)("HEADER_CONTENT_LOCATION:" + httpServletRequest.getHeader("Content-Location")));
            LOGGER.debug((Object)("Constants.MC_HOME_DIR:" + this.getHomeDir()));
            LOGGER.debug((Object)("Constants.MC_RELATIVE_PATH:" + httpServletRequest.getServletPath()));
            LOGGER.debug((Object)("HTTPConstants.MC_HTTP_SERVLETLOCATION:" + this.getWebInfPath()));
            LOGGER.debug((Object)("HTTPConstants.MC_HTTP_SERVLETPATHINFO:" + httpServletRequest.getPathInfo()));
            LOGGER.debug((Object)("HTTPConstants.HEADER_AUTHORIZATION:" + httpServletRequest.getHeader("Authorization")));
            LOGGER.debug((Object)("Constants.MC_REMOTE_ADDR:" + httpServletRequest.getRemoteAddr()));
            LOGGER.debug((Object)("configPath:" + this.getWebInfPath()));
        }
        messageContext.setTransportName(this.transportName);
        messageContext.setProperty("jws.classDir", this.jwsClassDir);
        messageContext.setProperty("home.dir", this.getHomeDir());
        messageContext.setProperty("path", httpServletRequest.getServletPath());
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, (Object)this);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, httpServletRequest);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, httpServletResponse);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION, this.getWebInfPath());
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, httpServletRequest.getPathInfo());
        messageContext.setProperty("Authorization", httpServletRequest.getHeader("Authorization"));
        messageContext.setProperty("remoteaddr", httpServletRequest.getRemoteAddr());
        ServletEndpointContextImpl servletEndpointContextImpl = new ServletEndpointContextImpl();
        messageContext.setProperty("servletEndpointContext", servletEndpointContextImpl);
        String string = this.getServletConfig().getServletContext().getRealPath(httpServletRequest.getServletPath());
        if (string != null) {
            messageContext.setProperty("realpath", string);
        }
        messageContext.setProperty("configPath", this.getWebInfPath());
        return messageContext;
    }

    private String getSoapAction(HttpServletRequest httpServletRequest) throws AxisFault {
        String string = httpServletRequest.getHeader("SOAPAction");
        if (isDebug) {
            LOGGER.debug((Object)("HEADER_SOAP_ACTION:" + string));
        }
        if (string == null) {
            AxisFault axisFault = new AxisFault("Client.NoSOAPAction", Messages.getMessage("noHeader00", "SOAPAction"), null, null);
            LOGGER.error((Object)Messages.getMessage("genFault00"), (Throwable)axisFault);
            throw axisFault;
        }
        if (string.length() == 0) {
            string = httpServletRequest.getContextPath();
        }
        return string;
    }

    protected String getDefaultJWSClassDir() {
        return this.getWebInfPath() == null ? null : this.getWebInfPath() + File.separator + "jwsClasses";
    }

    protected String getProtocolVersion(HttpServletRequest httpServletRequest) {
        String string;
        int n;
        String string2 = HTTPConstants.HEADER_PROTOCOL_V10;
        String string3 = httpServletRequest.getProtocol();
        if (string3 != null && -1 != (n = string3.indexOf(47)) && HTTPConstants.HEADER_PROTOCOL_V11.equals((string = string3.substring(n + 1)).trim())) {
            string2 = HTTPConstants.HEADER_PROTOCOL_V11;
        }
        return string2;
    }
}

