/*
 * Decompiled with CFR 0.152.
 */
package com.actional.soapapi.javaClient;

import com.actional.config.BaseData;
import com.actional.config.Blob;
import com.actional.db.QName;
import com.actional.soapapi.Config;
import com.actional.soapapi.Util;
import com.actional.soapapi.javaClient.ClientBase;
import com.actional.soapapi.javaClient.Input;
import com.actional.soapapi.soapstation.SSTConfig;
import com.actional.soapapi.soapstation.SdlTask;
import com.actional.soapapi.soapstation.WsdlTask;
import com.actional.soapstation.db.AccessPointNode;
import com.actional.soapstation.db.Application;
import com.actional.soapstation.db.AuthenticatorLC;
import com.actional.soapstation.db.CertificateEncodingType;
import com.actional.soapstation.db.CertificateEntry;
import com.actional.soapstation.db.Credentials;
import com.actional.soapstation.db.Endpoint;
import com.actional.soapstation.db.HTTPListener;
import com.actional.soapstation.db.HttpSender;
import com.actional.soapstation.db.HttpTransport;
import com.actional.soapstation.db.HttpsTransport;
import com.actional.soapstation.db.JavaPluginType;
import com.actional.soapstation.db.ManagedServiceNode;
import com.actional.soapstation.db.SSTRole;
import com.actional.soapstation.db.SvcGroup;
import com.actional.soapstation.db.SvcGroupRevisions;
import com.actional.soapstation.db.Transport;
import com.actional.soapstation.db.UserEntity;
import com.actional.soapstation.db.WsdlBinding;
import com.actional.soapstation.db.XmlProcessorLC;
import com.actional.soapstation.task.AccessPointDef;
import com.actional.soapstation.task.CertificateDef;
import com.actional.soapstation.task.DirectoryFilterType;
import com.actional.soapstation.task.OperationSelection;
import com.actional.soapstation.task.ServiceDescriptionLanguageParseInput;
import com.actional.soapstation.task.WsdlBindingDef;
import com.actional.soapstation.task.WsdlContentDef;
import com.actional.soapstation.task.WsdlPortDef;
import com.actional.ws.db.WsMetadata;
import com.actional.ws.db.WsResource;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class SSTClient
extends ClientBase {
    private static final Logger LOGGER = Logger.getLogger(SSTClient.class.getName());

    public SSTClient(SSTConfig sSTConfig) {
        super((Config)sSTConfig);
    }

    protected SSTConfig getConfig() {
        return (SSTConfig)this.itsConfig;
    }

    protected void failed(String string) {
        this.info("Failed: " + string);
    }

    protected SdlTask getSdlAPITask() throws Exception {
        return (SdlTask)this.getConfig().createTask(SdlTask.class);
    }

    public void test() throws Exception {
        this.info("Performing tests...");
        this.info("");
        this.displayVersion();
        this.displayKeyCertificates();
        String string = this.createApplication();
        this.listApplications();
        String string2 = this.createWebService();
        this.updateWebservice(string2);
        this.listSvcGroups();
        this.findServiceGroup();
        this.deleteExamples(string2);
        String string3 = this.createRESTService();
        this.listSvcGroups();
        this.findServiceGroup();
        this.deleteExamples(string3);
        this.info("DONE");
    }

    protected void deleteExamples(String string) throws Exception {
        this.deleteExamples(string, false);
    }

    protected void deleteExamples(String string, boolean bl) throws Exception {
        this.info("---------");
        this.info("Deleting the Service Group we created:" + string);
        this.getConfig().serviceTask.deleteServiceGroupRevisions(string);
        if (bl) {
            this.info("---------");
            this.info("Delete application:");
            String string2 = this.selectApplication("Select application to delete").getKeyID();
            this.getConfig().appTask.deleteApplication(string2);
        }
    }

    protected String createApplication() throws Exception {
        this.info("---------");
        this.info("Creating application:");
        Application application = new Application();
        application.setKeyName(Input.read("Application name", "Default Application"));
        application.setDescription(Input.read("Application description", "Default Application"));
        return this.getConfig().appTask.createApplication(application);
    }

    protected Application selectApplication(String string) throws Exception {
        int n;
        Object[] objectArray = this.getConfig().appTask.getAllApplications();
        this.getConfig().acervate((BaseData[])objectArray);
        Arrays.sort(objectArray, Util.COMPARATOR_BASEDATA_KEYNAME);
        int n2 = Util.length((Object[])objectArray);
        for (n = 0; n < n2; ++n) {
            Object object = objectArray[n];
            String string2 = n + ") " + object.getKeyName();
            if (this.getConfig().canWrite((BaseData)object)) {
                string2 = string2 + " - writeable";
            }
            this.info(string2);
        }
        n = Input.readInteger(string, new Integer(0));
        return objectArray[n];
    }

    protected void listApplications() throws Exception {
        this.info("---------");
        this.info("Select Application to display its details:");
        this.displayApplication(this.selectApplication("Details for application"));
    }

    protected void displayApplication(String string) throws Exception {
        this.displayApplication(this.getConfig().appTask.retrieveApplication(string));
    }

    protected void displayApplication(Application application) throws Exception {
        application = (Application)this.getConfig().acervate((BaseData)application);
        this.infoField("Name", application.getKeyName());
        this.infoField("Description", application.getDescription());
    }

    protected void listExistingTransport() throws Exception {
        this.info("---------");
        this.info("Existing transports: ");
        Transport transport = this.selectExistingTransport("Select transport");
    }

    protected Transport selectExistingTransport(String string) throws Exception {
        int n;
        Object[] objectArray = this.getConfig().transportsTask.getAllTransports();
        this.getConfig().acervate((BaseData[])objectArray);
        Arrays.sort(objectArray, Util.COMPARATOR_BASEDATA_KEYNAME);
        int n2 = Util.length((Object[])objectArray);
        for (n = 0; n < n2; ++n) {
            HttpSender httpSender;
            HTTPListener hTTPListener;
            HttpTransport httpTransport;
            Object object = objectArray[n];
            String string2 = n + ") " + object.getKeyName();
            if (object instanceof HttpTransport) {
                httpTransport = (HttpTransport)object;
                hTTPListener = (HTTPListener)this.getConfig().acervate((BaseData)httpTransport.getListener());
                if (hTTPListener != null && !Util.booleanValue((Boolean)hTTPListener.getIsDisabled())) {
                    string2 = string2 + " - Listener";
                }
                if ((httpSender = (HttpSender)this.getConfig().acervate((BaseData)httpTransport.getSender())) != null && !Util.booleanValue((Boolean)httpSender.getIsDisabled())) {
                    string2 = string2 + " - Sender";
                }
            } else if (object instanceof HttpsTransport) {
                httpTransport = (HttpsTransport)object;
                hTTPListener = (HTTPListener)this.getConfig().acervate((BaseData)httpTransport.getListener());
                if (hTTPListener != null && !Util.booleanValue((Boolean)hTTPListener.getIsDisabled())) {
                    string2 = string2 + " - Listener";
                }
                if ((httpSender = (HttpSender)this.getConfig().acervate((BaseData)httpTransport.getSender())) != null && !Util.booleanValue((Boolean)httpSender.getIsDisabled())) {
                    string2 = string2 + " - Sender";
                }
            } else {
                this.failed("Unexpected transport type: " + object.getClass().getName());
            }
            this.info(string2);
        }
        n = Input.readInteger(string, new Integer(0));
        return objectArray[n];
    }

    protected void listSvcGroups() throws Exception {
        int n;
        this.info("---------");
        this.info("All Service Groups:");
        Object[] objectArray = this.getConfig().serviceTask.getActiveOrMostRecentRevisions();
        this.getConfig().acervate((BaseData[])objectArray);
        Arrays.sort(objectArray, Util.COMPARATOR_BASEDATA_KEYNAME);
        int n2 = Util.length((Object[])objectArray);
        for (n = 0; n < n2; ++n) {
            Object object = objectArray[n];
            String string = n + ") " + object.getKeyName();
            if (this.getConfig().serviceTask.isServiceGroupActive(object.getKeyID())) {
                string = string + " - active";
            }
            if (this.getConfig().serviceTask.isServiceGroupLocked(object.getKeyID())) {
                string = string + " - locked";
            }
            this.info(string);
        }
        n = Input.readInteger("Details for SvcGroup", new Integer(0));
        this.displaySvcGroup((SvcGroup)objectArray[n]);
    }

    protected void displaySvcGroup(SvcGroup svcGroup) throws Exception {
        Endpoint endpoint;
        Object object;
        svcGroup = (SvcGroup)this.getConfig().acervate((BaseData)svcGroup);
        this.infoField("Name", svcGroup.getKeyName());
        this.infoField("Description", svcGroup.getDescription());
        this.infoField("Revision Number", svcGroup.getRevisionNumber());
        this.infoField("Revision Comment", svcGroup.getRevisionComment());
        this.infoField("Version Number", svcGroup.getVersionNumber());
        this.infoField("Version Comment", svcGroup.getVersionComment());
        Object[] objectArray = this.getConfig().serviceTask.getAccessPoints(svcGroup.getKeyID());
        this.getConfig().acervate((BaseData[])objectArray);
        Arrays.sort(objectArray, Util.COMPARATOR_BASEDATA_KEYNAME);
        int n = Util.length((Object[])objectArray);
        for (int i = 0; i < n; ++i) {
            byte[] byArray;
            Object object2 = objectArray[i];
            this.infoField("AccessPoint", object2.getKeyName());
            this.infoField(2, "UniqueKey", object2.getUniqueKey());
            this.infoField(2, "Documentation", object2.getDocumentation());
            this.infoField(2, "Listener", Util.getKeyName((BaseData)object2.getTransport()));
            this.infoField(2, "Client WSDL/WADL", this.getConfig().apTask.getWsdlFileUrl(object2.getKeyID()));
            this.infoField(2, "Endpoint", this.getConfig().apTask.getSoapEndpointUrl(object2.getKeyID()));
            this.displaySdl(2, object2.getWsdlBinding());
            this.displayAPSvcOperations((AccessPointNode)object2);
            if (this.getConfig().sdlTask.isRESTDescriptionLanguage(object2.getWsdlBinding())) {
                return;
            }
            object = this.getConfig().apTask.generateWSDL(object2.getKeyID());
            if (object == null || (endpoint = object.getContent()) == null || (byArray = endpoint.getBytes()) == null) continue;
            this.infoField(2, "WSDLContent", new String(byArray));
        }
        Object[] objectArray2 = this.getConfig().serviceTask.getManagedServices(svcGroup.getKeyID());
        this.getConfig().acervate((BaseData[])objectArray2);
        Arrays.sort(objectArray2, Util.COMPARATOR_BASEDATA_KEYNAME);
        int n2 = Util.length((Object[])objectArray2);
        for (n = 0; n < n2; ++n) {
            object = objectArray2[n];
            this.infoField("ManagedService", object.getKeyName());
            this.infoField(2, "Application", Util.getKeyName((BaseData)object.getApplication()));
            endpoint = (Endpoint)this.getConfig().acervate((BaseData)object.getEndpoint());
            this.infoField(2, "Sender", Util.getKeyName((BaseData)endpoint.getTransport()));
            this.infoField(2, "Endpoint", endpoint.getAddress());
            this.displaySdl(2, object.getWsdlBinding());
        }
    }

    protected void displaySdl(int n, WsdlBinding wsdlBinding) throws Exception {
        wsdlBinding = (WsdlBinding)this.getConfig().acervate((BaseData)wsdlBinding);
        this.infoField(2, "WSDL/WADL Binding Name", this.toString(wsdlBinding.getQName()));
        WsMetadata wsMetadata = (WsMetadata)this.getConfig().acervate((BaseData)wsdlBinding.getMetadata());
        this.infoField(2, "WSDL/WADL File From", wsMetadata.getLocation());
    }

    protected void displayAPSvcOperations(AccessPointNode accessPointNode) throws Exception {
        accessPointNode = (AccessPointNode)this.getConfig().acervate((BaseData)accessPointNode);
        OperationSelection[] operationSelectionArray = this.getConfig().serviceTask.getAccessPointOperationSelection(accessPointNode);
        int n = operationSelectionArray.length;
        for (int i = 0; i < n; ++i) {
            if (!operationSelectionArray[i].isSelected()) continue;
            this.infoField(3, "Operation: ", operationSelectionArray[i].getOperation().getKeyName());
        }
    }

    protected String[] selectSvcOperations(WsdlBinding wsdlBinding) throws Exception {
        if (wsdlBinding != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            AccessPointNode accessPointNode = new AccessPointNode();
            accessPointNode.setWsdlBinding(wsdlBinding);
            OperationSelection[] operationSelectionArray = this.getConfig().serviceTask.getAccessPointOperationSelection(accessPointNode);
            int n = operationSelectionArray.length;
            for (int i = 0; i < n; ++i) {
                this.infoField(2, "Operation: ", operationSelectionArray[i].getOperation().getKeyName());
                if (!"y".equals(Input.read("Select this operation?", "y"))) continue;
                arrayList.add(operationSelectionArray[i].getOperation().getKeyName());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    protected WsdlBinding constructSdlBinding(String string, String string2, String string3, String string4, boolean bl, boolean bl2) throws Exception {
        Object object;
        WsResource[] wsResourceArray;
        BufferedInputStream bufferedInputStream;
        URL uRL;
        this.info("");
        this.info("--------------");
        this.info("Constructing WsdlBinding");
        this.info("--------------");
        this.info("");
        Blob blob = new Blob();
        String string5 = null;
        if (string != null && string.length() > 0) {
            int n;
            if ("URL".equalsIgnoreCase(string2)) {
                this.info("WSDL defined at the following URL : " + string);
                try {
                    uRL = new URL(string);
                    bufferedInputStream = new BufferedInputStream(uRL.openStream());
                    wsResourceArray = new ByteArrayOutputStream();
                    object = new byte[1024];
                    n = 0;
                    while (-1 != (n = ((InputStream)bufferedInputStream).read((byte[])object))) {
                        wsResourceArray.write((byte[])object, 0, n);
                    }
                    wsResourceArray.close();
                    ((InputStream)bufferedInputStream).close();
                    string5 = wsResourceArray.toString();
                }
                catch (IOException iOException) {
                    this.info("==> Unable to open specified URL");
                    LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
                    System.exit(1);
                }
            }
            if ("FILE_LOCAL".equalsIgnoreCase(string2)) {
                this.info("Attempting to retrieve WSDL/WADL from file : " + string);
                string5 = this.convertXMLFileToString(string);
            } else if ("FILE_REMOTE".equalsIgnoreCase(string2)) {
                this.info("Attempting to retrieve WSDL/WADL from URL : " + string);
                try {
                    uRL = new URL(string);
                    bufferedInputStream = new BufferedInputStream(uRL.openStream());
                    wsResourceArray = new ByteArrayOutputStream();
                    object = new byte[1024];
                    n = 0;
                    while (-1 != (n = ((InputStream)bufferedInputStream).read((byte[])object))) {
                        wsResourceArray.write((byte[])object, 0, n);
                    }
                    wsResourceArray.close();
                    ((InputStream)bufferedInputStream).close();
                    string5 = wsResourceArray.toString();
                }
                catch (IOException iOException) {
                    this.info("==> Unable to open specified remote file");
                    LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
                    System.exit(1);
                }
            } else if ("CLASSPATH_RESOURCE".equalsIgnoreCase(string2)) {
                this.info("Attempting to retrieve WSDL/WADL from file : " + string);
                try {
                    uRL = ClassLoader.getSystemResource(string);
                    bufferedInputStream = new BufferedInputStream(uRL.openStream());
                    wsResourceArray = new ByteArrayOutputStream();
                    object = new byte[1024];
                    n = 0;
                    while (-1 != (n = ((InputStream)bufferedInputStream).read((byte[])object))) {
                        wsResourceArray.write((byte[])object, 0, n);
                    }
                    wsResourceArray.close();
                    ((InputStream)bufferedInputStream).close();
                    string5 = wsResourceArray.toString();
                }
                catch (IOException iOException) {
                    this.info("==> Unable to open specified CLASSPATH resource");
                    LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
                    System.exit(1);
                }
            }
        }
        if (string5 != null) {
            this.info("");
            this.info("Retrieved WSDL/WADL :");
            this.info("");
            if (bl) {
                this.info(string5);
            }
        } else {
            this.info("==> Unable to retrieve WSDL/WADL !!");
            System.exit(1);
        }
        blob.setBytes(string5.getBytes());
        blob.setCode(new Integer(81936));
        blob.setVersion(new Integer(1));
        if (bl2) {
            this.info("");
            this.info("- Description type = WADL");
            this.info("");
        } else {
            this.info("");
            this.info("- Description type = WSDL");
            this.info("");
        }
        uRL = new WsMetadata();
        bufferedInputStream = new WsResource();
        wsResourceArray = new WsResource[1];
        object = new ServiceDescriptionLanguageParseInput();
        object.setMetadata((WsMetadata)uRL);
        object.setReturnXmlTypes(false);
        object.setReturnMetadata(true);
        uRL.setIgnoreProxySettings(Boolean.TRUE);
        uRL.setIsMexLocation(Boolean.FALSE);
        bufferedInputStream.setCode(new Integer(81936));
        bufferedInputStream.setVersion(new Integer(1));
        bufferedInputStream.setLocation(string);
        uRL.setLocation(string);
        bufferedInputStream.setContent(blob);
        wsResourceArray[0] = bufferedInputStream;
        uRL.setResources(wsResourceArray);
        if (bl2) {
            uRL.setAddFallbackOperations(Boolean.FALSE);
            uRL.setExposeAsRest(Boolean.FALSE);
            bufferedInputStream.setDialect("wadl");
            bufferedInputStream.setNamespace(string4);
            uRL.setBaseWSDL((WsResource)bufferedInputStream);
        } else {
            bufferedInputStream.setDialect("http://schemas.xmlsoap.org/wsdl/");
        }
        WsdlContentDef wsdlContentDef = this.getConfig().sdlTask.parse((ServiceDescriptionLanguageParseInput)object);
        boolean bl3 = false;
        if (wsdlContentDef != null && wsdlContentDef.getMetadata() != null) {
            this.info("");
            this.info("- Parsed specified WSDL/WADL!");
            this.info("");
            bl3 = true;
        }
        if (!bl3) {
            this.info("==> Unable to parse WSDL/WADL !!");
            System.exit(1);
        }
        WsResource wsResource = new WsResource();
        WsResource[] wsResourceArray2 = new WsResource[1];
        wsResource.setCode(new Integer(81936));
        wsResource.setVersion(new Integer(1));
        wsResource.setContent(blob);
        wsResource.setLocation(string);
        wsResourceArray2[0] = wsResource;
        if (bl2) {
            wsResource.setDialect("wadl");
        } else {
            wsResource.setDialect("http://schemas.xmlsoap.org/wsdl/");
        }
        WsMetadata wsMetadata = new WsMetadata();
        wsMetadata.setBaseWSDL(wsResource);
        wsMetadata.setCode(new Integer(81936));
        wsMetadata.setResources(wsResourceArray2);
        wsMetadata.setVersion(new Integer(1));
        wsMetadata.setIgnoreProxySettings(Boolean.TRUE);
        wsMetadata.setIsMexLocation(Boolean.FALSE);
        wsMetadata.setLocation(string);
        if (wsdlContentDef != null && wsdlContentDef.getMetadata() != null) {
            if (wsdlContentDef.getMetadata().getBaseWSDL() != null) {
                wsMetadata.setBaseWSDL(wsdlContentDef.getMetadata().getBaseWSDL());
                this.info("- Set BaseWSDL to parsed value");
            }
            if (wsdlContentDef.getMetadata().getResources() != null) {
                wsMetadata.setResources(wsdlContentDef.getMetadata().getResources());
                this.info("- Set Resources to parsed value(s)");
            }
        }
        QName qName = new QName();
        this.info("");
        this.info("==> Specified QName (LocalName) : " + string3);
        this.info("==> Specified QName (XmlNs) : " + string4);
        this.info("");
        qName.setLocalName(string3);
        qName.setXmlNs(string4);
        WsdlBinding wsdlBinding = new WsdlBinding();
        wsdlBinding.setCode(new Integer(81936));
        wsdlBinding.setMetadata(wsMetadata);
        wsdlBinding.setQName(qName);
        wsdlBinding.setVersion(new Integer(1));
        WsdlBindingDef wsdlBindingDef = null;
        this.info("Parsing WsdlBinding...");
        wsdlBindingDef = this.getConfig().sdlTask.getSdlBinding(wsdlBinding);
        if (wsdlBindingDef != null) {
            this.info("Parsing WsdlBindingDef...");
            QName qName2 = new QName();
            qName2 = this.getQNameFromWsdlBindingDef(wsdlBindingDef);
            if (qName2 != null) {
                qName = new QName();
                qName.setLocalName(qName2.getLocalName());
                qName.setXmlNs(qName2.getXmlNs());
                wsdlBinding.setQName(qName);
                return wsdlBinding;
            }
            this.info("Cannot retrieve QName details : QName appears to be null!");
        } else {
            this.info("Cannot determine QName : wsdlBindingDef appears to be null!");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String convertXMLFileToString(String string) throws Exception {
        if (string.length() <= 0) return null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try (FileInputStream fileInputStream = new FileInputStream(new File(string));){
                Document document = documentBuilderFactory.newDocumentBuilder().parse(fileInputStream);
                StringWriter stringWriter = new StringWriter();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
                String string2 = stringWriter.toString();
                return string2;
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return null;
    }

    protected QName getQNameFromWsdlBindingDef(WsdlBindingDef wsdlBindingDef) throws Exception {
        if (wsdlBindingDef != null) {
            if (wsdlBindingDef.getQName() != null) {
                return wsdlBindingDef.getQName();
            }
        } else {
            this.info("Invalid WsdlBindingDef specified");
        }
        return null;
    }

    protected String toString(QName qName) throws Exception {
        if (qName == null) {
            return null;
        }
        return Util.toString((Object)qName.getLocalName()) + "#" + Util.toString((Object)qName.getXmlNs());
    }

    protected WsdlChoice promptForSdl(String string) throws Exception {
        Object object;
        Object object2;
        String string2 = Input.read("Local WSDL/WADL path [For URL hit enter for next prompt]");
        String string3 = null;
        WsdlContentDef wsdlContentDef = null;
        this.info("Parsing WSDL/WADL...");
        if (Util.isBlank((String)string2)) {
            string3 = Input.read("WSDL/WADL URL", string);
            wsdlContentDef = this.getSdlAPITask().parseSDL(string3, false);
        } else {
            object2 = Util.readFileAsBytes((String)string2);
            wsdlContentDef = this.getSdlAPITask().parseSDL(object2);
        }
        object2 = null;
        List list = this.getSdlAPITask().expandPortsFromBindings(wsdlContentDef.getBindings());
        int n = Util.size((Collection)list);
        if (n <= 0) {
            throw new Exception("The WSDL/WADL did not contain any ports for the bindings.");
        }
        if (n == 1) {
            object2 = (WsdlTask.WsdlBindingPortDef)list.get(0);
        } else {
            int n2;
            this.info("WSDL/WADL contains multiple ports and / or multiple bindings:");
            for (n2 = 0; n2 < n; ++n2) {
                object = (WsdlTask.WsdlBindingPortDef)list.get(n2);
                this.info(1, n2 + ") " + this.toString(object.binding.getQName()) + " - " + object.port.getName());
            }
            n2 = Input.readInteger("Choose one", new Integer(0));
            object2 = (WsdlTask.WsdlBindingPortDef)list.get(n2);
        }
        WsdlBinding wsdlBinding = new WsdlBinding();
        wsdlBinding.setQName(object2.binding.getQName());
        wsdlBinding.setMetadata(wsdlContentDef.getMetadata());
        object = new WsdlChoice();
        object.binding = wsdlBinding;
        object.bindingDef = object2.binding;
        object.portDef = object2.port;
        return object;
    }

    protected String createWebService() throws Exception {
        this.info("---------");
        this.info("Creating Service Group...");
        String string = Input.read("Name", "SvcGroup");
        WsdlChoice wsdlChoice = this.promptForSdl("http://ws.cdyne.com/ip2geo/ip2geo.asmx?wsdl");
        Endpoint endpoint = this.getSdlAPITask().buildEndpoint(wsdlChoice.portDef);
        this.info("Configured Applications:");
        Application application = this.selectApplication("Select application for new Group.");
        application = (Application)Util.createLeaf((BaseData)application);
        this.info("Existing transports:");
        Transport transport = (Transport)Util.createLeaf((BaseData)this.selectExistingTransport("Select Transport to use as the listener / sender for the new service group"));
        transport = (Transport)Util.createLeaf((BaseData)transport);
        SvcGroup svcGroup = new SvcGroup();
        svcGroup.setKeyName(string);
        String string2 = this.getConfig().serviceTask.addSimpleServiceGroup(wsdlChoice.binding, wsdlChoice.portDef, new Object[]{svcGroup, application, transport, null, null, endpoint});
        this.getConfig().serviceTask.activateServiceGroupRevision(string2);
        return string2;
    }

    protected String createRESTService() throws Exception {
        this.info("---------");
        this.info("Creating REST Service Group...");
        String string = Input.read("Name", "REST SvcGroup");
        WsdlChoice wsdlChoice = this.promptForSdl("http://www.herongyang.com/Service/Hello_REST.wadl");
        Endpoint endpoint = this.getSdlAPITask().buildEndpoint(wsdlChoice.portDef);
        String[] stringArray = this.selectSvcOperations(wsdlChoice.binding);
        this.info("Configured Applications:");
        Application application = this.selectApplication("Select application for new Group.");
        application = (Application)Util.createLeaf((BaseData)application);
        this.info("Existing transports:");
        Transport transport = (Transport)Util.createLeaf((BaseData)this.selectExistingTransport("Select Transport to use as the listener / sender for the new service group"));
        transport = (Transport)Util.createLeaf((BaseData)transport);
        SvcGroup svcGroup = new SvcGroup();
        svcGroup.setKeyName(string);
        String string2 = this.getConfig().serviceTask.addSimpleServiceGroup(wsdlChoice.binding, wsdlChoice.portDef, new Object[]{svcGroup, application, transport, stringArray, null, endpoint});
        this.getConfig().serviceTask.activateServiceGroupRevision(string2);
        return string2;
    }

    public void updateWebservice(String string) throws Exception {
        this.info("---------");
        this.info("Creating a new revision of group: " + string);
        string = this.getConfig().serviceTask.addServiceGroupRevision(string);
        SvcGroup svcGroup = (SvcGroup)this.getConfig().configTask.get(string);
        this.info("Modifying service group: " + svcGroup.getKeyName());
        AccessPointNode accessPointNode = this.getConfig().serviceTask.getAccessPoints(string)[0];
        ManagedServiceNode managedServiceNode = this.getConfig().serviceTask.getManagedServices(string)[0];
        managedServiceNode = (ManagedServiceNode)this.getConfig().acervate((BaseData)managedServiceNode);
        AccessPointDef accessPointDef = this.getConfig().apTask.decomposeNode(accessPointNode);
        accessPointNode = accessPointDef.getNode();
        String string2 = Input.read("New Name", "SvcGroup_Renamed");
        svcGroup.setKeyName(string2);
        WsdlChoice wsdlChoice = this.promptForSdl("http://api.google.com/GoogleSearch.wsdl");
        accessPointNode.setWsdlBinding(wsdlChoice.binding);
        managedServiceNode.setWsdlBinding(wsdlChoice.binding);
        svcGroup.setIntermediateWsdl(wsdlChoice.binding);
        accessPointNode.setSvcOps(null);
        managedServiceNode.setEndpoint(this.getSdlAPITask().buildEndpoint(wsdlChoice.portDef));
        XmlProcessorLC xmlProcessorLC = this.getConfig().wsdlTask.suggestXmlProcessor(wsdlChoice.bindingDef);
        XmlProcessorLC xmlProcessorLC2 = accessPointNode.getXmlProcessor();
        XmlProcessorLC xmlProcessorLC3 = this.choseXmlProcessor(xmlProcessorLC, xmlProcessorLC2);
        accessPointNode.setXmlProcessor(xmlProcessorLC3);
        managedServiceNode.setXmlProcessor(xmlProcessorLC3);
        svcGroup.setXmlProcessor(xmlProcessorLC3);
        this.info("Existing transports:");
        Transport transport = (Transport)Util.createLeaf((BaseData)this.selectExistingTransport("Select Transport to use as the listener / sender for the modified service group"));
        transport = (Transport)Util.createLeaf((BaseData)transport);
        accessPointNode.setTransport(transport);
        managedServiceNode.getEndpoint().setTransport(transport);
        this.info("Configured Applications:");
        Application application = this.selectApplication("Select application for new Group.");
        application = (Application)Util.createLeaf((BaseData)application);
        managedServiceNode.setApplication(application);
        this.getConfig().serviceTask.updateAccessPoint(accessPointNode);
        this.getConfig().serviceTask.updateManagedService(managedServiceNode);
        this.getConfig().serviceTask.updateServiceGroup(svcGroup);
        this.getConfig().serviceTask.activateServiceGroupRevision(string);
    }

    public XmlProcessorLC choseXmlProcessor(XmlProcessorLC xmlProcessorLC, XmlProcessorLC xmlProcessorLC2) throws Exception {
        int n;
        Object[] objectArray;
        this.info("---------");
        this.info("Checking for XML Processors....");
        if (!Util.equals((String)Util.getKeyID((BaseData)xmlProcessorLC), (String)Util.getKeyID((BaseData)xmlProcessorLC2))) {
            objectArray = Util.getKeyName((BaseData)xmlProcessorLC2);
            String string = Util.getKeyName((BaseData)xmlProcessorLC);
            this.info("XML processor at access point : " + (String)objectArray);
            this.info("New XML processor : " + string);
        } else {
            this.info("Same XML processor at access point and new WSDL : " + Util.getKeyName((BaseData)xmlProcessorLC2));
        }
        objectArray = this.getConfig().javaPluginTask.getPlugins(JavaPluginType.XML_PROCESSOR);
        this.info("---------");
        this.info("Listing XML Processors....");
        int n2 = 0;
        int n3 = Util.length((Object[])objectArray);
        for (n = 0; n < n3; ++n) {
            XmlProcessorLC xmlProcessorLC3 = (XmlProcessorLC)objectArray[n];
            String string = n + ") " + Util.getKeyName((BaseData)xmlProcessorLC3);
            if (Util.equals((String)Util.getKeyID((BaseData)xmlProcessorLC), (String)Util.getKeyID((BaseData)xmlProcessorLC3))) {
                n2 = n;
                this.info(n + ") " + Util.getKeyName((BaseData)xmlProcessorLC3) + " (suggested)");
                continue;
            }
            this.info(string);
        }
        n = Input.readInteger("Choose the XML processor", new Integer(n2));
        this.info("---------");
        return (XmlProcessorLC)objectArray[n];
    }

    public void findServiceGroup() throws Exception {
        this.info("---------");
        String string = Input.read("Enter the name of the Service Group to find", "SvcGroup");
        SvcGroup svcGroup = new SvcGroup();
        svcGroup.setKeyName(string);
        svcGroup.setActiveRevision(new SvcGroupRevisions());
        Object[] objectArray = this.getConfig().configTask.find((BaseData)svcGroup);
        int n = Util.length((Object[])objectArray);
        if (n == 0) {
            this.info("No matches found.");
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.info("Match " + i + ":");
            this.displaySvcGroup((SvcGroup)objectArray[i]);
        }
    }

    public void listKeyCertificates() throws Exception {
        Object[] objectArray = this.getConfig().certTask.getAllKeyCertificateEntries();
        this.getConfig().acervate((BaseData[])objectArray);
        Arrays.sort(objectArray, Util.COMPARATOR_BASEDATA_KEYNAME);
        int n = Util.length((Object[])objectArray);
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            this.info(i + ") " + object.getKeyName());
        }
    }

    public CertificateEntry selectsKeyCertificate(String string) throws Exception {
        Object[] objectArray = this.getConfig().certTask.getAllKeyCertificateEntries();
        this.getConfig().acervate((BaseData[])objectArray);
        Arrays.sort(objectArray, Util.COMPARATOR_BASEDATA_KEYNAME);
        this.listKeyCertificates();
        this.info(Util.length((Object[])objectArray) + ") Quit");
        int n = Input.readInteger(string, new Integer(0));
        if (n < Util.length((Object[])objectArray)) {
            return objectArray[n];
        }
        return null;
    }

    public void displayKeyCertificates() throws Exception {
        this.info("---------");
        this.info("Certificate details.");
        boolean bl = false;
        do {
            CertificateEntry certificateEntry;
            if ((certificateEntry = this.selectsKeyCertificate("Details for Certificate")) != null) {
                this.displayCertificateInfo(certificateEntry.getKeyID());
                continue;
            }
            bl = true;
        } while (!bl);
    }

    private void displayCertificateInfo(Blob blob, Credentials credentials, CertificateEncodingType certificateEncodingType) throws Exception {
        this.displayCertificateInfo(this.getConfig().certTask.getKeyCertificateInfo(blob, credentials, certificateEncodingType));
    }

    private void displayCertificateInfo(String string) throws Exception {
        this.displayCertificateInfo(this.getConfig().certTask.getCertificateInfoFromID(string));
    }

    private void displayCertificateInfo(CertificateDef certificateDef) throws Exception {
        System.out.println("============= Certificate Information ==================");
        this.infoField(2, "Version", certificateDef.getVersion());
        this.infoField(2, "Serial Number", certificateDef.getSerialNumber());
        this.infoField(2, "Signature Algorithm", certificateDef.getSignatureAlgorithm());
        this.infoField(2, "Common Name", certificateDef.getCommonName());
        this.infoField(2, "Organization", certificateDef.getOrganization());
        this.infoField(2, "Organization Unit", certificateDef.getOrganizationalUnit());
        this.infoField(2, "Locality", certificateDef.getLocality());
        this.infoField(2, "State", certificateDef.getState());
        this.infoField(2, "Country", certificateDef.getCountry());
        this.infoField(2, "Email", certificateDef.getEmailAddress());
        this.infoField(2, "Issuer", certificateDef.getIssuer());
        this.infoField(2, "Valid From", certificateDef.getValidFrom());
        this.infoField(2, "Valid To", certificateDef.getValidTo());
    }

    public String createRole() throws Exception {
        AuthenticatorLC authenticatorLC = this.selectAuthenticationPlugin("Select the User Directory");
        UserEntity userEntity = this.selectUserEntity(authenticatorLC, "Select the user");
        UserEntity[] userEntityArray = new UserEntity[]{userEntity};
        SSTRole sSTRole = new SSTRole();
        sSTRole.setKeyName("Test user role: " + authenticatorLC.getKeyName() + "-" + userEntity.getKeyName());
        sSTRole.setDescription("SDK API created role");
        sSTRole.setUserDirectory(authenticatorLC);
        sSTRole.setAllowedEntities(userEntityArray);
        return this.getConfig().roleTask.createRole(sSTRole);
    }

    public void createRoles() throws Exception {
        AuthenticatorLC authenticatorLC = this.selectAuthenticationPlugin("Select the User Directory");
        UserEntity userEntity = this.selectUserEntity(authenticatorLC, "Select the user");
        UserEntity[] userEntityArray = new UserEntity[]{userEntity};
        SSTRole sSTRole = new SSTRole();
        sSTRole.setKeyName("Test user role");
        sSTRole.setDescription("SDK API created role");
        sSTRole.setUserDirectory(authenticatorLC);
        sSTRole.setAllowedEntities(userEntityArray);
        this.getConfig().roleTask.createRole(sSTRole);
        SSTRole sSTRole2 = new SSTRole();
        sSTRole2.setKeyName("Test user filtering role");
        sSTRole2.setDescription("SDK API created user filtering role");
        sSTRole2.setUserDirectory(authenticatorLC);
        sSTRole2.setUserMembershipFilter("sn=thien");
        this.getConfig().roleTask.createRole(sSTRole2);
    }

    public UserEntity selectUserEntity(AuthenticatorLC authenticatorLC, String string) throws Exception {
        int n;
        Object[] objectArray = this.getConfig().dirTask.getUserEntities(authenticatorLC.getKeyID(), "*", DirectoryFilterType.UID);
        this.getConfig().acervate((BaseData[])objectArray);
        Arrays.sort(objectArray, Util.COMPARATOR_BASEDATA_KEYNAME);
        int n2 = Util.length((Object[])objectArray);
        for (n = 0; n < n2; ++n) {
            Object object = objectArray[n];
            String string2 = n + ") " + object.getKeyName();
            this.info(string2);
        }
        n = Input.readInteger(string, new Integer(0));
        return objectArray[n];
    }

    public AuthenticatorLC selectAuthenticationPlugin(String string) throws Exception {
        int n;
        Object[] objectArray = this.getConfig().dirTask.getAllUserDirectory();
        this.getConfig().acervate((BaseData[])objectArray);
        Arrays.sort(objectArray, Util.COMPARATOR_BASEDATA_KEYNAME);
        int n2 = Util.length((Object[])objectArray);
        for (n = 0; n < n2; ++n) {
            Object object = objectArray[n];
            String string2 = n + ") " + object.getKeyName();
            this.info(string2);
        }
        n = Input.readInteger(string, new Integer(0));
        return objectArray[n];
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("");
            String string = Input.read("SOAPstation address", "http://localhost:4400/sst");
            String string2 = Input.read("UserName", "admin");
            String string3 = Input.read("Password", true, "secret");
            System.out.println("");
            System.out.println("Initializing connection...");
            SSTConfig sSTConfig = new SSTConfig(string2, string3, string);
            SSTClient sSTClient = new SSTClient(sSTConfig);
            sSTClient.init();
            sSTClient.test();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            System.exit(-1);
        }
    }

    protected static class WsdlChoice {
        WsdlBinding binding;
        WsdlBindingDef bindingDef;
        WsdlPortDef portDef;

        protected WsdlChoice() {
        }
    }
}

