/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.client;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.Handler;
import org.apache.axis.InternalException;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.client.Service;
import org.apache.axis.client.Transport;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.enum.Style;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.transport.http.HTTPTransport;
import org.apache.axis.transport.java.JavaTransport;
import org.apache.axis.transport.local.LocalTransport;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class Call
implements javax.xml.rpc.Call {
    private static final Log LOGGER = LogFactory.getLog(Call.class.getName());
    private static final Log TIME_LOGGER = LogFactory.getLog("org.apache.axis.TIME");
    private static final Log ENTERPRISE_LOGGER = LogFactory.getLog("org.apache.axis.enterprise");
    private boolean parmAndRetReq = true;
    private Service service = null;
    private QName portName = null;
    private QName operationName = null;
    private QName returnType = null;
    private MessageContext msgContext = null;
    private Hashtable callProperties = new Hashtable();
    private Hashtable scopedProperties = new Hashtable();
    private String username = null;
    private String password = null;
    private boolean maintainSession = false;
    private Style operationStyle = Style.DEFAULT;
    private boolean useSOAPAction = false;
    private String SOAPActionURI = null;
    private Integer timeout = null;
    private OperationDesc operation = new OperationDesc();
    private boolean invokeOneWay = false;
    private boolean isMsg = false;
    private Transport transport = null;
    private String transportName = null;
    private Map outParams = null;
    private List outParamsList = null;
    private Vector myHeaders = null;
    private Class returnJavaType = null;
    public static final String SEND_TYPE_ATTR = "send_type_attr";
    public static final String TRANSPORT_NAME = "transport_name";
    public static final String TRANSPORT_PROPERTY = "java.protocol.handler.pkgs";
    public static final String WSDL_SERVICE = "wsdl.service";
    public static final String WSDL_PORT_NAME = "wsdl.portName";
    public static final String JAXRPC_SERVICE = "wsdl.service";
    public static final String JAXRPC_PORTTYPE_NAME = "wsdl.portName";
    public static final boolean FAULT_ON_NO_RESPONSE = false;
    public static final String ATTACHMENT_ENCAPSULATION_FORMAT = "attachment_encapsulation_format";
    public static final String ATTACHMENT_ENCAPSULATION_FORMAT_MIME = "axis.attachment.style.mime";
    public static final String ATTACHMENT_ENCAPSULATION_FORMAT_DIME = "axis.attachment.style.dime";
    private static Map transports = new Hashtable();
    private static List propertyNames = new ArrayList();
    private static List transportPackages;
    private SOAPService myService = null;
    protected Vector attachmentParts = new Vector();

    public Call(Service service) {
        this.service = service;
        this.msgContext = new MessageContext(service.getEngine());
        this.maintainSession = service.getMaintainSession();
        Call.initialize();
    }

    public Call(String string) throws MalformedURLException {
        this(new Service());
        this.setTargetEndpointAddress(new URL(string));
    }

    public Call(URL uRL) {
        this(new Service());
        this.setTargetEndpointAddress(uRL);
    }

    public void setProperty(String string, Object object) {
        if (string == null || object == null) {
            throw new JAXRPCException(Messages.getMessage(string == null ? "badProp03" : "badProp04"));
        }
        if (string.equals("javax.xml.rpc.security.auth.username")) {
            if (!(object instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.setUsername((String)object);
        } else if (string.equals("javax.xml.rpc.security.auth.password")) {
            if (!(object instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.setPassword((String)object);
        } else if (string.equals("javax.xml.rpc.session.maintain")) {
            if (!(object instanceof Boolean)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.Boolean", object.getClass().getName()}));
            }
            this.setMaintainSession((Boolean)object);
        } else if (string.equals("javax.xml.rpc.soap.operation.style")) {
            if (!(object instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.setOperationStyle((String)object);
        } else if (string.equals("javax.xml.rpc.soap.http.soapaction.use")) {
            if (!(object instanceof Boolean)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.Boolean", object.getClass().getName()}));
            }
            this.setUseSOAPAction((Boolean)object);
        } else if (string.equals("javax.xml.rpc.soap.http.soapaction.uri")) {
            if (!(object instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.setSOAPActionURI((String)object);
        } else if (string.equals("javax.xml.rpc.encodingstyle.namespace.uri")) {
            if (!(object instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.setEncodingStyle((String)object);
        } else if (string.equals("javax.xml.rpc.service.endpoint.address")) {
            if (!(object instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.setTargetEndpointAddress((String)object);
        } else if (string.equals(TRANSPORT_NAME)) {
            if (!(object instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            this.transportName = (String)object;
            if (this.transport != null) {
                this.transport.setTransportName((String)object);
            }
        } else if (string.equals(ATTACHMENT_ENCAPSULATION_FORMAT)) {
            if (!(object instanceof String)) {
                throw new JAXRPCException(Messages.getMessage("badProp00", new String[]{string, "java.lang.String", object.getClass().getName()}));
            }
            if (!object.equals(ATTACHMENT_ENCAPSULATION_FORMAT_MIME) && !object.equals(ATTACHMENT_ENCAPSULATION_FORMAT_DIME)) {
                throw new JAXRPCException(Messages.getMessage("badattachmenttypeerr", new String[]{(String)object, "axis.attachment.style.mime axis.attachment.style.dime"}));
            }
        } else if (string.startsWith("java.") || string.startsWith("javax.")) {
            throw new JAXRPCException(Messages.getMessage("badProp05", string));
        }
        this.callProperties.put(string, object);
    }

    public Object getProperty(String string) {
        if (string == null || !this.isPropertySupported(string)) {
            throw new JAXRPCException(string == null ? Messages.getMessage("badProp03") : Messages.getMessage("badProp05", string));
        }
        return this.callProperties.get(string);
    }

    public void removeProperty(String string) {
        if (string == null || !this.isPropertySupported(string)) {
            throw new JAXRPCException(string == null ? Messages.getMessage("badProp03") : Messages.getMessage("badProp05", string));
        }
        this.callProperties.remove(string);
    }

    public void setScopedProperty(String string, Object object) {
        if (string == null || object == null) {
            throw new JAXRPCException(Messages.getMessage(string == null ? "badProp03" : "badProp04"));
        }
        this.scopedProperties.put(string, object);
    }

    public Object getScopedProperty(String string) {
        if (string != null) {
            return this.scopedProperties.get(string);
        }
        return null;
    }

    public void removeScopedProperty(String string) {
        if (string == null || this.scopedProperties == null) {
            return;
        }
        this.scopedProperties.remove(string);
    }

    public Iterator getPropertyNames() {
        return propertyNames.iterator();
    }

    public boolean isPropertySupported(String string) {
        return propertyNames.contains(string) || !string.startsWith("java.") && !string.startsWith("javax.");
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setMaintainSession(boolean bl) {
        this.maintainSession = bl;
    }

    public boolean getMaintainSession() {
        return this.maintainSession;
    }

    public void setOperationStyle(String string) {
        this.operationStyle = Style.getStyle(string, Style.DEFAULT);
    }

    public Style getOperationStyle() {
        return this.operationStyle;
    }

    public void setUseSOAPAction(boolean bl) {
        this.useSOAPAction = bl;
    }

    public boolean useSOAPAction() {
        return this.useSOAPAction;
    }

    public void setSOAPActionURI(String string) throws IllegalArgumentException {
        this.useSOAPAction = true;
        this.SOAPActionURI = string;
    }

    public String getSOAPActionURI() {
        return this.SOAPActionURI;
    }

    public void setEncodingStyle(String string) {
        this.msgContext.setEncodingStyle(string);
    }

    public String getEncodingStyle() {
        return this.msgContext.getEncodingStyle();
    }

    public void setTargetEndpointAddress(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new JAXRPCException((Throwable)malformedURLException);
        }
        this.setTargetEndpointAddress(uRL);
    }

    public void setTargetEndpointAddress(URL uRL) {
        try {
            URL uRL2;
            String string;
            Object object;
            if (uRL == null) {
                this.setTransport(null);
                return;
            }
            String string2 = uRL.getProtocol();
            if (this.transport != null && (object = this.transport.getUrl()) != null && !"".equals(object) && string2.equals(string = (uRL2 = new URL((String)object)).getProtocol())) {
                this.transport.setUrl(uRL.toString());
                return;
            }
            object = this.service.getTransportForURL(uRL);
            if (object != null) {
                this.setTransport((Transport)object);
            } else {
                object = this.getTransportForProtocol(string2);
                if (object == null) {
                    throw new AxisFault("Call.setTargetEndpointAddress", Messages.getMessage("noTransport01", string2), null, null);
                }
                ((Transport)object).setUrl(uRL.toString());
                this.setTransport((Transport)object);
                this.service.registerTransportForURL(uRL, (Transport)object);
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
        }
    }

    public String getTargetEndpointAddress() {
        try {
            if (this.transport == null) {
                return null;
            }
            return this.transport.getUrl();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer n) {
        this.timeout = n;
    }

    public boolean isParameterAndReturnSpecRequired(QName qName) {
        return this.parmAndRetReq;
    }

    public void addParameter(QName qName, QName qName2, ParameterMode parameterMode) {
        Class clazz = null;
        TypeMapping typeMapping = this.getTypeMapping();
        if (typeMapping != null) {
            clazz = typeMapping.getClassForQName(qName2);
        }
        this.addParameter(qName, qName2, clazz, parameterMode);
    }

    public void addParameter(QName qName, QName qName2, Class clazz, ParameterMode parameterMode) {
        ParameterDesc parameterDesc = new ParameterDesc();
        parameterDesc.setQName(qName);
        parameterDesc.setTypeQName(qName2);
        parameterDesc.setJavaType(clazz);
        byte by = 1;
        if (parameterMode == ParameterMode.INOUT) {
            by = 3;
        } else if (parameterMode == ParameterMode.OUT) {
            by = 2;
        }
        parameterDesc.setMode(by);
        this.operation.addParameter(parameterDesc);
        this.parmAndRetReq = true;
    }

    public void addParameter(String string, QName qName, ParameterMode parameterMode) {
        Class clazz = null;
        TypeMapping typeMapping = this.getTypeMapping();
        if (typeMapping != null) {
            clazz = typeMapping.getClassForQName(qName);
        }
        this.addParameter(new QName("", string), qName, clazz, parameterMode);
    }

    public void addParameter(String string, QName qName, Class clazz, ParameterMode parameterMode) {
        this.addParameter(new QName("", string), qName, clazz, parameterMode);
    }

    public QName getParameterTypeByName(String string) {
        QName qName = new QName("", string);
        return this.getParameterTypeByQName(qName);
    }

    public QName getParameterTypeByQName(QName qName) {
        ParameterDesc parameterDesc = this.operation.getParamByQName(qName);
        if (parameterDesc != null) {
            return parameterDesc.getTypeQName();
        }
        return null;
    }

    public void setReturnType(QName qName) {
        this.returnType = qName;
        this.operation.setReturnType(qName);
        TypeMapping typeMapping = this.getTypeMapping();
        this.operation.setReturnClass(typeMapping.getClassForQName(qName));
        this.parmAndRetReq = true;
    }

    public void setReturnType(QName qName, Class clazz) {
        this.setReturnType(qName);
        this.returnJavaType = clazz;
        this.operation.setReturnClass(clazz);
    }

    public QName getReturnType() {
        return this.returnType;
    }

    public void setReturnQName(QName qName) {
        this.operation.setReturnQName(qName);
    }

    public void setReturnClass(Class clazz) {
        this.returnJavaType = clazz;
    }

    public void removeAllParameters() {
        this.operation = new OperationDesc();
        this.parmAndRetReq = true;
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName qName) {
        this.operationName = qName;
        if (qName != null) {
            this.operation.setName(qName.getLocalPart());
        }
    }

    public void setOperationName(String string) {
        this.setOperationName(new QName(string));
    }

    public void setOperation(QName qName, String string) {
        Object object;
        String string2;
        int n;
        Object object2;
        Object object3;
        BindingInput bindingInput;
        String string3;
        Object object4;
        Object object5;
        if (this.service == null) {
            throw new JAXRPCException(Messages.getMessage("noService04"));
        }
        this.setPortName(qName);
        this.setOperationName(string);
        this.setTargetEndpointAddress((URL)null);
        this.setEncodingStyle(null);
        this.setReturnType(null);
        this.removeAllParameters();
        javax.wsdl.Service service = this.service.getWSDLService();
        if (service == null) {
            return;
        }
        Port port = service.getPort(qName.getLocalPart());
        if (port == null) {
            throw new JAXRPCException(Messages.getMessage("noPort00", "" + qName));
        }
        Binding binding = port.getBinding();
        PortType portType = binding.getPortType();
        if (portType == null) {
            throw new JAXRPCException(Messages.getMessage("noPortType00", "" + qName));
        }
        List list = portType.getOperations();
        if (list == null) {
            throw new JAXRPCException(Messages.getMessage("noOperation01", string));
        }
        Operation operation = null;
        for (int i = 0; i < list.size() && !string.equals((operation = (Operation)list.get(i)).getName()); ++i) {
            operation = null;
        }
        if (operation == null) {
            throw new JAXRPCException(Messages.getMessage("noOperation01", string));
        }
        List list2 = port.getExtensibilityElements();
        for (int i = 0; list2 != null && i < list2.size(); ++i) {
            Object e = list2.get(i);
            if (!(e instanceof SOAPAddress)) continue;
            try {
                object5 = (SOAPAddress)e;
                object4 = new URL(object5.getLocationURI());
                this.setTargetEndpointAddress((URL)object4);
                continue;
            }
            catch (Exception exception) {
                throw new JAXRPCException(Messages.getMessage("cantSetURI00", "" + exception));
            }
        }
        BindingOperation bindingOperation = binding.getBindingOperation(string, null, null);
        if (bindingOperation == null) {
            throw new JAXRPCException(Messages.getMessage("noOperation02", string));
        }
        list2 = bindingOperation.getExtensibilityElements();
        for (int i = 0; list2 != null && i < list2.size(); ++i) {
            object5 = list2.get(i);
            if (!(object5 instanceof SOAPOperation)) continue;
            object4 = (SOAPOperation)object5;
            string3 = object4.getSoapActionURI();
            if (string3 != null) {
                this.setUseSOAPAction(true);
                this.setSOAPActionURI(string3);
                break;
            }
            this.setUseSOAPAction(false);
            this.setSOAPActionURI(null);
            break;
        }
        if ((bindingInput = bindingOperation.getBindingInput()) != null) {
            list2 = bindingInput.getExtensibilityElements();
            for (int i = 0; list2 != null && i < list2.size(); ++i) {
                object4 = list2.get(i);
                if (object4 instanceof MIMEMultipartRelated) {
                    string3 = (MIMEMultipartRelated)object4;
                    object3 = null;
                    object2 = string3.getMIMEParts();
                    for (n = 0; object2 != null && n < object2.size() && object3 == null; ++n) {
                        string2 = (MIMEPart)object2.get(n);
                        object = string2.getExtensibilityElements();
                        for (int j = 0; object != null && j < object.size() && object3 == null; ++j) {
                            object3 = object.get(j);
                            if (object3 instanceof SOAPBody) continue;
                            object3 = null;
                        }
                    }
                    if (null != object3) {
                        object4 = object3;
                    }
                }
                if (!(object4 instanceof SOAPBody)) continue;
                string3 = (SOAPBody)object4;
                list2 = string3.getEncodingStyles();
                if (list2 != null && !list2.isEmpty()) {
                    this.setEncodingStyle((String)list2.get(0));
                }
                if ((object3 = string3.getNamespaceURI()) == null || "".equals(object3)) break;
                this.setOperationName(new QName((String)object3, string));
                break;
            }
        }
        List list3 = operation.getParameterOrdering();
        object4 = operation.getInput();
        string3 = null;
        object3 = null;
        if (object4 != null) {
            string3 = object4.getMessage();
        }
        if (string3 != null) {
            object3 = string3.getOrderedParts(list3);
        }
        if (object3 != null) {
            for (int i = 0; i < object3.size(); ++i) {
                Part part = (Part)object3.get(i);
                if (part == null) continue;
                string2 = part.getName();
                object = part.getTypeName();
                if (object == null) {
                    object = part.getElementName();
                    if (object != null) {
                        object = new QName("java", "org.w3c.dom.Element");
                    } else {
                        throw new JAXRPCException(Messages.getMessage("typeNotSet00", string2));
                    }
                }
                QName qName2 = new QName(((QName)object).getNamespaceURI(), ((QName)object).getLocalPart());
                ParameterMode parameterMode = ParameterMode.IN;
                this.addParameter(string2, qName2, parameterMode);
            }
        }
        object2 = operation.getOutput();
        string3 = null;
        if (object2 != null) {
            string3 = object2.getMessage();
        }
        if (string3 != null) {
            object3 = string3.getOrderedParts(null);
        }
        if (this.operation != null && this.operation.getNumParams() > 0) {
            this.setReturnType(XMLType.AXIS_VOID);
        }
        if (object3 != null) {
            for (n = 0; n < object3.size(); ++n) {
                string2 = (Part)object3.get(n);
                if (list3 != null && list3.contains(string2.getName())) continue;
                object = string2.getTypeName();
                if (object == null) {
                    object = string2.getElementName();
                    if (object != null) {
                        object = new QName("java", "org.w3c.dom.Element");
                    } else {
                        throw new JAXRPCException(Messages.getMessage("typeNotSet00", "<return>"));
                    }
                }
                QName qName3 = new QName(((QName)object).getNamespaceURI(), ((QName)object).getLocalPart());
                this.setReturnType(qName3);
                break;
            }
        }
        this.parmAndRetReq = false;
    }

    public QName getPortName() {
        return this.portName;
    }

    public void setPortName(QName qName) {
        this.portName = qName;
    }

    public QName getPortTypeName() {
        return this.portName == null ? new QName("") : this.portName;
    }

    public void setPortTypeName(QName qName) {
        this.setPortName(qName);
    }

    public void setSOAPVersion(SOAPConstants sOAPConstants) {
        this.msgContext.setSOAPConstants(sOAPConstants);
    }

    public Object invoke(QName qName, Object[] objectArray) throws RemoteException {
        QName qName2 = this.operationName;
        this.operationName = qName;
        try {
            return this.invoke(objectArray);
        }
        catch (RemoteException remoteException) {
            this.operationName = qName2;
            throw remoteException;
        }
        catch (RuntimeException runtimeException) {
            this.operationName = qName2;
            throw runtimeException;
        }
        catch (Error error) {
            this.operationName = qName2;
            throw error;
        }
    }

    public Object invoke(Object[] objectArray) throws RemoteException {
        int n;
        long l = 0L;
        long l2 = 0L;
        if (TIME_LOGGER.isDebugEnabled()) {
            l = System.currentTimeMillis();
        }
        SOAPEnvelope sOAPEnvelope = null;
        for (n = 0; objectArray != null && n < objectArray.length && objectArray[n] instanceof SOAPBodyElement; ++n) {
        }
        if (objectArray != null && objectArray.length > 0 && n == objectArray.length) {
            this.isMsg = true;
            sOAPEnvelope = new SOAPEnvelope(this.msgContext.getSOAPConstants());
            if (!(objectArray[0] instanceof SOAPEnvelope)) {
                for (n = 0; n < objectArray.length; ++n) {
                    sOAPEnvelope.addBodyElement((SOAPBodyElement)objectArray[n]);
                }
            }
            Message message = new Message(sOAPEnvelope);
            this.setRequestMessage(message);
            this.invoke();
            message = this.msgContext.getResponseMessage();
            if (message == null) {
                return null;
            }
            sOAPEnvelope = message.getSOAPEnvelope();
            return sOAPEnvelope.getBodyElements();
        }
        if (this.operationName == null) {
            throw new AxisFault(Messages.getMessage("noOperation00"));
        }
        try {
            Object object = this.invoke(this.operationName.getNamespaceURI(), this.operationName.getLocalPart(), objectArray);
            if (TIME_LOGGER.isDebugEnabled()) {
                l2 = System.currentTimeMillis();
                TIME_LOGGER.debug((Object)("axis.Call.invoke: " + (l2 - l) + " " + this.operationName));
            }
            return object;
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        catch (Exception exception) {
            ENTERPRISE_LOGGER.info((Object)Messages.getMessage("toAxisFault00"), (Throwable)exception);
            throw new AxisFault(Messages.getMessage("errorInvoking00", "\n" + exception));
        }
    }

    public void invokeOneWay(Object[] objectArray) {
        try {
            this.invokeOneWay = true;
            this.invoke(objectArray);
        }
        catch (Exception exception) {
            throw new JAXRPCException(exception.toString());
        }
        finally {
            this.invokeOneWay = false;
        }
    }

    public SOAPEnvelope invoke(SOAPEnvelope sOAPEnvelope) throws RemoteException {
        try {
            Message message = null;
            message = new Message(sOAPEnvelope);
            this.setRequestMessage(message);
            this.invoke();
            message = this.msgContext.getResponseMessage();
            if (message == null) {
                return null;
            }
            return message.getSOAPEnvelope();
        }
        catch (Exception exception) {
            if (exception instanceof AxisFault) {
                throw (AxisFault)exception;
            }
            ENTERPRISE_LOGGER.info((Object)Messages.getMessage("toAxisFault00"), (Throwable)exception);
            throw new AxisFault(Messages.getMessage("errorInvoking00", "\n" + exception));
        }
    }

    public static void setTransportForProtocol(String string, Class clazz) {
        if (!Transport.class.isAssignableFrom(clazz)) {
            throw new InternalException(clazz.toString());
        }
        transports.put(string, clazz);
    }

    public static synchronized void initialize() {
        Call.addTransportPackage("org.apache.axis.transport");
        Call.setTransportForProtocol("java", JavaTransport.class);
        Call.setTransportForProtocol("local", LocalTransport.class);
        Call.setTransportForProtocol("http", HTTPTransport.class);
        Call.setTransportForProtocol("https", HTTPTransport.class);
    }

    public static synchronized void addTransportPackage(String string) {
        CharSequence charSequence;
        if (transportPackages == null) {
            transportPackages = new ArrayList();
            charSequence = AxisProperties.getProperty(TRANSPORT_PROPERTY);
            if (charSequence != null) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)charSequence, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    transportPackages.add(stringTokenizer.nextToken());
                }
            }
        }
        if (transportPackages.contains(string)) {
            return;
        }
        transportPackages.add(string);
        charSequence = new StringBuilder();
        for (String string2 : transportPackages) {
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append('|');
        }
        System.setProperty(TRANSPORT_PROPERTY, ((StringBuilder)charSequence).toString());
    }

    private Object[] getParamList(Object[] objectArray) {
        LOGGER.debug((Object)("operation=" + this.operation));
        if (this.operation != null) {
            LOGGER.debug((Object)("operation.getNumParams()=" + this.operation.getNumParams()));
        }
        if (this.operation == null || this.operation.getNumParams() == 0) {
            return objectArray;
        }
        int n = this.operation.getNumInParams();
        if (objectArray == null || n != objectArray.length) {
            int n2 = objectArray == null ? 0 : objectArray.length;
            throw new JAXRPCException(Messages.getMessage("parmMismatch00", "" + n2, "" + n));
        }
        LOGGER.debug((Object)("getParamList number of params: " + objectArray.length));
        Vector<RPCParam> vector = new Vector<RPCParam>();
        int n3 = 0;
        ArrayList arrayList = this.operation.getParameters();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            ParameterDesc parameterDesc = (ParameterDesc)arrayList.get(i);
            if (parameterDesc.getMode() == 2) continue;
            QName qName = parameterDesc.getQName();
            RPCParam rPCParam = null;
            rPCParam = (object = objectArray[n3++]) instanceof RPCParam ? (RPCParam)object : new RPCParam(qName.getNamespaceURI(), qName.getLocalPart(), object);
            rPCParam.setParamDesc(parameterDesc);
            vector.add(rPCParam);
        }
        return vector.toArray();
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)Messages.getMessage("transport00", "" + this.transport));
        }
    }

    public Transport getTransportForProtocol(String string) {
        Class clazz = (Class)transports.get(string);
        Transport transport = null;
        if (clazz != null) {
            try {
                transport = (Transport)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return transport;
    }

    public void setRequestMessage(Message message) {
        Attachments attachments;
        String string = (String)this.getProperty(ATTACHMENT_ENCAPSULATION_FORMAT);
        if (null != string && null != (attachments = message.getAttachmentsImpl())) {
            if (null != string && string.equals(ATTACHMENT_ENCAPSULATION_FORMAT_MIME)) {
                attachments.setSendType(2);
            } else if (null != string && string.equals(ATTACHMENT_ENCAPSULATION_FORMAT_DIME)) {
                attachments.setSendType(3);
            }
        }
        if (null != this.attachmentParts && !this.attachmentParts.isEmpty()) {
            try {
                attachments = message.getAttachmentsImpl();
                if (null == attachments) {
                    throw new RuntimeException(Messages.getMessage("noAttachments"));
                }
                attachments.setAttachmentParts(this.attachmentParts);
            }
            catch (AxisFault axisFault) {
                LOGGER.info((Object)Messages.getMessage("axisFault00"), (Throwable)axisFault);
                throw new RuntimeException(axisFault.getMessage());
            }
            this.attachmentParts.clear();
        }
        this.msgContext.setRequestMessage(message);
    }

    public Message getResponseMessage() {
        return this.msgContext.getResponseMessage();
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    public void addHeader(SOAPHeaderElement sOAPHeaderElement) {
        if (this.myHeaders == null) {
            this.myHeaders = new Vector();
        }
        this.myHeaders.add(sOAPHeaderElement);
    }

    public void clearHeaders() {
        this.myHeaders = null;
    }

    public TypeMapping getTypeMapping() {
        TypeMappingRegistry typeMappingRegistry = this.msgContext.getTypeMappingRegistry();
        TypeMapping typeMapping = (TypeMapping)typeMappingRegistry.getTypeMapping(this.getEncodingStyle());
        TypeMapping typeMapping2 = (TypeMapping)typeMappingRegistry.getDefaultTypeMapping();
        if (typeMapping == null || typeMapping == typeMapping2) {
            typeMapping = (TypeMapping)typeMappingRegistry.createTypeMapping();
            typeMapping.setSupportedEncodings(new String[]{this.getEncodingStyle()});
            typeMappingRegistry.register(this.getEncodingStyle(), typeMapping);
        }
        return typeMapping;
    }

    public void registerTypeMapping(Class clazz, QName qName, SerializerFactory serializerFactory, DeserializerFactory deserializerFactory) {
        this.registerTypeMapping(clazz, qName, serializerFactory, deserializerFactory, true);
    }

    public void registerTypeMapping(Class clazz, QName qName, SerializerFactory serializerFactory, DeserializerFactory deserializerFactory, boolean bl) {
        TypeMapping typeMapping = this.getTypeMapping();
        if (!bl && typeMapping.isRegistered(clazz, qName)) {
            return;
        }
        typeMapping.register(clazz, qName, serializerFactory, deserializerFactory);
    }

    public void registerTypeMapping(Class clazz, QName qName, Class clazz2, Class clazz3) {
        this.registerTypeMapping(clazz, qName, clazz2, clazz3, true);
    }

    public void registerTypeMapping(Class clazz, QName qName, Class clazz2, Class clazz3, boolean bl) {
        SerializerFactory serializerFactory = BaseSerializerFactory.createFactory(clazz2, clazz, qName);
        DeserializerFactory deserializerFactory = BaseDeserializerFactory.createFactory(clazz3, clazz, qName);
        if (serializerFactory != null || deserializerFactory != null) {
            this.registerTypeMapping(clazz, qName, serializerFactory, deserializerFactory, bl);
        }
    }

    public Object invoke(String string, String string2, Object[] objectArray) throws AxisFault {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Enter: Call::invoke(ns, meth, args)");
        }
        if (this.returnType != null && objectArray != null && objectArray.length != 0 && this.operation == null) {
            throw new AxisFault(Messages.getMessage("mustSpecifyParms"));
        }
        RPCElement rPCElement = new RPCElement(string, string2, this.getParamList(objectArray));
        Object object = this.invoke(rPCElement);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exit: Call::invoke(ns, meth, args)");
        }
        return object;
    }

    public Object invoke(String string, Object[] objectArray) throws AxisFault {
        return this.invoke("", string, objectArray);
    }

    public Object invoke(RPCElement rPCElement) throws AxisFault {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Enter: Call::invoke(RPCElement)");
        }
        if (!this.invokeOneWay && this.operation.getNumParams() > 0 && this.returnType == null) {
            LOGGER.error((Object)Messages.getMessage("mustSpecifyReturnType"));
        }
        SOAPEnvelope sOAPEnvelope = new SOAPEnvelope(this.msgContext.getSOAPConstants());
        SOAPEnvelope sOAPEnvelope2 = null;
        Message message = new Message(sOAPEnvelope);
        Message message2 = null;
        Vector vector = null;
        Object object = null;
        this.outParams = new HashMap();
        this.outParamsList = new ArrayList();
        try {
            rPCElement.setEncodingStyle(this.getEncodingStyle());
            this.setRequestMessage(message);
            sOAPEnvelope.addBodyElement(rPCElement);
            sOAPEnvelope.setMessageType("request");
            this.invoke();
        }
        catch (Exception exception) {
            ENTERPRISE_LOGGER.info((Object)Messages.getMessage("toAxisFault00"), (Throwable)exception);
            throw AxisFault.makeFault(exception);
        }
        message2 = this.msgContext.getResponseMessage();
        if (message2 == null) {
            return null;
        }
        sOAPEnvelope2 = message2.getSOAPEnvelope();
        SOAPBodyElement sOAPBodyElement = sOAPEnvelope2.getFirstBody();
        if (sOAPBodyElement instanceof RPCElement) {
            try {
                vector = ((RPCElement)sOAPBodyElement).getParams();
            }
            catch (Exception exception) {
                LOGGER.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                throw AxisFault.makeFault(exception);
            }
            if (vector != null && !vector.isEmpty()) {
                int n = 0;
                boolean bl = false;
                if (!XMLType.AXIS_VOID.equals(this.returnType)) {
                    if (this.operation.getReturnQName() == null) {
                        RPCParam rPCParam = (RPCParam)vector.get(0);
                        object = rPCParam.getValue();
                        n = 1;
                    } else {
                        bl = true;
                    }
                }
                for (int i = n; i < vector.size(); ++i) {
                    RPCParam rPCParam = (RPCParam)vector.get(i);
                    Class clazz = this.getJavaTypeForQName(rPCParam.getQName());
                    Object object2 = rPCParam.getValue();
                    if (clazz != null && object2 != null && !clazz.isAssignableFrom(object2.getClass())) {
                        object2 = JavaUtils.convert(object2, clazz);
                    }
                    if (bl && this.operation.getReturnQName().equals(rPCParam.getQName())) {
                        object = object2;
                        bl = false;
                        continue;
                    }
                    this.outParams.put(rPCParam.getQName(), object2);
                    this.outParamsList.add(object2);
                }
            }
        } else {
            try {
                object = sOAPBodyElement.getValueAsType(this.returnType);
            }
            catch (Exception exception) {
                object = sOAPBodyElement;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exit: Call::invoke(RPCElement)");
        }
        if (this.returnJavaType != null) {
            object = JavaUtils.convert(object, this.returnJavaType);
        }
        return object;
    }

    private Class getJavaTypeForQName(QName qName) {
        ParameterDesc parameterDesc = this.operation.getOutputParamByQName(qName);
        return parameterDesc == null ? null : parameterDesc.getJavaType();
    }

    public void setOption(String string, Object object) {
        this.service.getEngine().setOption(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() throws AxisFault {
        Object object;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Enter: Call::invoke()");
        }
        Message message = null;
        SOAPEnvelope sOAPEnvelope = null;
        this.msgContext.reset();
        this.msgContext.setResponseMessage(null);
        this.msgContext.setProperty(MessageContext.CALL, this);
        this.msgContext.setProperty("wsdl.service", this.service);
        this.msgContext.setProperty("wsdl.portName", this.getPortName());
        if (this.isMsg) {
            this.msgContext.setProperty(MessageContext.IS_MSG, "true");
        }
        Enumeration enumeration = this.callProperties.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            this.msgContext.setProperty((String)object, this.getProperty((String)object));
        }
        if (this.username != null) {
            this.msgContext.setUsername(this.username);
        }
        if (this.password != null) {
            this.msgContext.setPassword(this.password);
        }
        this.msgContext.setMaintainSession(this.maintainSession);
        this.msgContext.setOperation(this.operation);
        this.operation.setStyle(this.getOperationStyle());
        this.msgContext.setOperationStyle(this.getOperationStyle());
        if (this.useSOAPAction) {
            this.msgContext.setUseSOAPAction(true);
        }
        if (this.SOAPActionURI != null) {
            this.msgContext.setSOAPActionURI(this.SOAPActionURI);
        }
        if (this.timeout != null) {
            this.msgContext.setTimeout(this.timeout);
        }
        if (this.myService != null) {
            this.msgContext.setService(this.myService);
        } else {
            if (this.portName != null) {
                this.msgContext.setTargetService(this.portName.getLocalPart());
            } else {
                message = this.msgContext.getRequestMessage();
                sOAPEnvelope = message.getSOAPEnvelope();
                object = sOAPEnvelope.getFirstBody();
                if (((MessageElement)object).getNamespaceURI() == null) {
                    throw new AxisFault("Call.invoke", Messages.getMessage("cantInvoke00", ((MessageElement)object).getName()), null, null);
                }
                this.msgContext.setTargetService(((MessageElement)object).getNamespaceURI());
            }
            object = this.msgContext.getService();
            if (object != null) {
                ((SOAPService)object).setPropertyParent(this.scopedProperties);
            } else {
                this.msgContext.setPropertyParent(this.scopedProperties);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)Messages.getMessage("targetService", this.msgContext.getTargetService()));
        }
        sOAPEnvelope = this.msgContext.getRequestMessage().getSOAPEnvelope();
        for (int i = 0; this.myHeaders != null && i < this.myHeaders.size(); ++i) {
            sOAPEnvelope.addHeader((SOAPHeaderElement)this.myHeaders.get(i));
        }
        if (this.transport != null) {
            this.transport.setupMessageContext(this.msgContext, this, this.service.getEngine());
        } else {
            this.msgContext.setTransportName(this.transportName);
        }
        if (LOGGER.isDebugEnabled()) {
            StringWriter stringWriter = new StringWriter();
            try {
                SerializationContextImpl serializationContextImpl = new SerializationContextImpl(stringWriter, this.msgContext);
                sOAPEnvelope.output(serializationContextImpl);
                stringWriter.close();
            }
            catch (Exception exception) {
                LOGGER.debug((Object)Messages.getMessage("exceptionPrinting"), (Throwable)exception);
            }
            finally {
                LOGGER.debug((Object)stringWriter.getBuffer().toString());
            }
        }
        if (!this.invokeOneWay) {
            this.invokeEngine(this.msgContext);
        } else {
            this.invokeEngineOneWay(this.msgContext);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exit: Call::invoke()");
        }
    }

    private void invokeEngine(MessageContext messageContext) throws AxisFault {
        Message message;
        this.service.getEngine().invoke(messageContext);
        if (this.transport != null) {
            this.transport.processReturnedMessageContext(messageContext);
        }
        if ((message = messageContext.getResponseMessage()) == null) {
            return;
        }
        message.setMessageType("response");
        SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
        SOAPBodyElement sOAPBodyElement = sOAPEnvelope.getFirstBody();
        if (sOAPBodyElement instanceof SOAPFault) {
            throw ((SOAPFault)sOAPBodyElement).getFault();
        }
    }

    private void invokeEngineOneWay(final MessageContext messageContext) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Call.this.service.getEngine().invoke(messageContext);
                }
                catch (AxisFault axisFault) {
                    LOGGER.debug((Object)Messages.getMessage("exceptionPrinting"), (Throwable)axisFault);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public Map getOutputParams() {
        return this.outParams;
    }

    public List getOutputValues() {
        return this.outParamsList;
    }

    public Service getService() {
        return this.service;
    }

    public void setSOAPService(SOAPService sOAPService) {
        this.myService = sOAPService;
        if (sOAPService != null) {
            sOAPService.setPropertyParent(this.scopedProperties);
            sOAPService.setEngine(this.service.getAxisClient());
        }
    }

    public void setClientHandlers(Handler handler, Handler handler2) {
        this.setSOAPService(new SOAPService(handler, null, handler2));
    }

    public void addAttachmentPart(Object object) {
        this.attachmentParts.add(object);
    }

    static {
        propertyNames.add("javax.xml.rpc.security.auth.username");
        propertyNames.add("javax.xml.rpc.security.auth.password");
        propertyNames.add("javax.xml.rpc.session.maintain");
        propertyNames.add(ATTACHMENT_ENCAPSULATION_FORMAT);
        propertyNames.add("javax.xml.rpc.soap.operation.style");
        propertyNames.add("javax.xml.rpc.soap.http.soapaction.use");
        propertyNames.add("javax.xml.rpc.soap.http.soapaction.uri");
        propertyNames.add("javax.xml.rpc.encodingstyle.namespace.uri");
        propertyNames.add(TRANSPORT_NAME);
        propertyNames.add(ATTACHMENT_ENCAPSULATION_FORMAT);
        transportPackages = null;
    }
}

