/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.deployment.wsdd;

import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDOperation;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.deployment.wsdd.providers.WSDDHandlerProvider;
import org.apache.axis.deployment.wsdd.providers.WSDDJavaEJBProvider;
import org.apache.axis.deployment.wsdd.providers.WSDDJavaMsgProvider;
import org.apache.axis.deployment.wsdd.providers.WSDDJavaRPCProvider;
import org.apache.axis.utils.Messages;

public abstract class WSDDProvider {
    private static Hashtable providers = new Hashtable();

    public static void registerProvider(QName uri, WSDDProvider prov) {
        providers.put(uri, prov);
    }

    public WSDDOperation[] getOperations() {
        return null;
    }

    public WSDDOperation getOperation(String name) {
        return null;
    }

    public static Handler getInstance(QName providerType, WSDDService service, EngineConfiguration registry) throws Exception {
        if (providerType == null) {
            throw new WSDDException(Messages.getMessage("nullProvider00"));
        }
        WSDDProvider provider = (WSDDProvider)providers.get(providerType);
        if (provider == null) {
            throw new WSDDException(Messages.getMessage("noMatchingProvider00", providerType.toString()));
        }
        return provider.newProviderInstance(service, registry);
    }

    public abstract Handler newProviderInstance(WSDDService var1, EngineConfiguration var2) throws Exception;

    static {
        providers.put(WSDDConstants.QNAME_JAVARPC_PROVIDER, new WSDDJavaRPCProvider());
        providers.put(WSDDConstants.QNAME_JAVAMSG_PROVIDER, new WSDDJavaMsgProvider());
        providers.put(WSDDConstants.QNAME_HANDLER_PROVIDER, new WSDDHandlerProvider());
        providers.put(WSDDConstants.QNAME_EJB_PROVIDER, new WSDDJavaEJBProvider());
    }
}

