/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import javax.xml.namespace.QName;
import org.apache.axis.encoding.Base64;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.schema.SchemaVersion1999;
import org.apache.axis.schema.SchemaVersion2000;
import org.apache.axis.schema.SchemaVersion2001;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Base64Deserializer
extends DeserializerImpl {
    public QName xmlType;
    public Class javaType;
    StringBuilder buf = null;
    boolean itIsNil;

    public Base64Deserializer(Class clazz, QName qName) {
        this.xmlType = qName;
        this.javaType = clazz;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        this.itIsNil = this.isNil(attributes, SchemaVersion2001.QNAME_NIL) || this.isNil(attributes, SchemaVersion2000.QNAME_NIL) || this.isNil(attributes, SchemaVersion1999.QNAME_NIL);
        super.startElement(string, string2, string3, attributes, deserializationContext);
    }

    boolean isNil(Attributes attributes, QName qName) {
        String string = attributes.getValue(qName.getNamespaceURI(), qName.getLocalPart());
        if (string == null) {
            return false;
        }
        if ("1".equals(string)) {
            return true;
        }
        return "true".equals(string);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.buf == null) {
            this.buf = new StringBuilder();
        }
        this.buf.append(cArray, n, n2);
    }

    @Override
    public void onEndElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        if (this.buf != null) {
            this.value = Base64.decode(this.buf.toString());
            if (this.javaType == Byte[].class) {
                Byte[] byteArray = new Byte[((byte[])this.value).length];
                for (int i = 0; i < byteArray.length; ++i) {
                    byte by = ((byte[])this.value)[i];
                    byteArray[i] = by;
                }
                this.value = byteArray;
            }
        }
        super.onEndElement(string, string2, deserializationContext);
        if (this.value == null && !this.itIsNil) {
            this.value = this.javaType == byte[].class ? (Object)new byte[0] : new Byte[0];
        }
    }
}

