/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.io.Serializable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.Target;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.ser.ArrayDeserializer;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanPropertyTarget;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BeanDeserializer
extends DeserializerImpl
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(BeanDeserializer.class.getName());
    QName xmlType;
    Class javaType;
    protected Map propertyMap;
    protected QName prevQName;
    protected TypeDesc typeDesc;
    protected int collectionIndex;
    protected SimpleDeserializer cacheStringDSer;
    protected QName cacheXMLType;

    public BeanDeserializer(Class clazz, QName qName) {
        this(clazz, qName, TypeDesc.getTypeDescForClass(clazz));
    }

    public BeanDeserializer(Class clazz, QName qName, TypeDesc typeDesc) {
        this(clazz, qName, typeDesc, BeanDeserializerFactory.getProperties(clazz, typeDesc));
    }

    public BeanDeserializer(Class clazz, QName qName, TypeDesc typeDesc, Map map) {
        block2: {
            this.propertyMap = null;
            this.typeDesc = null;
            this.collectionIndex = -1;
            this.cacheStringDSer = null;
            this.cacheXMLType = null;
            this.xmlType = qName;
            this.javaType = clazz;
            this.typeDesc = typeDesc;
            this.propertyMap = map;
            try {
                this.value = clazz.newInstance();
            }
            catch (Exception exception) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug((Object)"Constructing BeanDeserializer caught excpetion", (Throwable)exception);
            }
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        if (this.value == null && !deserializationContext.isNil(attributes)) {
            try {
                this.value = this.javaType.newInstance();
            }
            catch (Exception exception) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Method startElement failed.", (Throwable)exception);
                }
                throw new SAXException(Messages.getMessage("cantCreateBean00", this.javaType.getName(), exception.toString()));
            }
        }
        super.startElement(string, string2, string3, attributes, deserializationContext);
    }

    @Override
    public SOAPHandler onStartChild(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        Deserializer deserializer;
        Object object;
        BeanPropertyDescriptor beanPropertyDescriptor = null;
        FieldDesc fieldDesc = null;
        String string4 = deserializationContext.getMessageContext().getEncodingStyle();
        boolean bl = Constants.isSOAP_ENC(string4);
        QName qName = new QName(string, string2);
        if (this.prevQName == null || !this.prevQName.equals(qName)) {
            this.collectionIndex = -1;
        }
        this.prevQName = qName;
        if (this.typeDesc != null) {
            object = this.typeDesc.getFieldNameForElement(qName, bl);
            beanPropertyDescriptor = (BeanPropertyDescriptor)this.propertyMap.get(object);
            fieldDesc = this.typeDesc.getFieldByName((String)object);
        }
        if (beanPropertyDescriptor == null) {
            beanPropertyDescriptor = (BeanPropertyDescriptor)this.propertyMap.get(string2);
        }
        if (beanPropertyDescriptor == null && (beanPropertyDescriptor = this.getAnyPropertyDesc()) != null) {
            try {
                MessageElement messageElement;
                object = (MessageElement[])beanPropertyDescriptor.get(this.value);
                int n = 0;
                if (object != null) {
                    n = ((MessageElement[])object).length;
                }
                MessageElement[] messageElementArray = new MessageElement[n + 1];
                if (object != null) {
                    System.arraycopy(object, 0, messageElementArray, 0, n);
                }
                messageElementArray[n] = messageElement = deserializationContext.getCurElement();
                beanPropertyDescriptor.set(this.value, messageElementArray);
                return new SOAPHandler();
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
        if (beanPropertyDescriptor == null) {
            return null;
        }
        object = deserializationContext.getTypeFromXSITypeAttr(string, string2, attributes);
        String string5 = attributes.getValue("href");
        if (object == null && fieldDesc != null && string5 == null) {
            object = fieldDesc.getXmlType();
        }
        if ((deserializer = this.getDeserializer((QName)object, beanPropertyDescriptor.getType(), string5, deserializationContext)) == null) {
            deserializer = new DeserializerImpl();
            return (SOAPHandler)((Object)deserializer);
        }
        if (beanPropertyDescriptor.isWriteable()) {
            if (beanPropertyDescriptor.isIndexed() && !(deserializer instanceof ArrayDeserializer)) {
                ++this.collectionIndex;
                deserializer.registerValueTarget(this.createValueTarget(this.value, beanPropertyDescriptor, this.collectionIndex));
            } else {
                this.collectionIndex = -1;
                deserializer.registerValueTarget(this.createValueTarget(this.value, beanPropertyDescriptor, -1));
            }
        }
        return (SOAPHandler)((Object)deserializer);
    }

    public BeanPropertyDescriptor getAnyPropertyDesc() {
        if (this.typeDesc == null) {
            return null;
        }
        return this.typeDesc.getAnyDesc();
    }

    @Override
    public void onStartElement(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws SAXException {
        if (this.value == null) {
            try {
                this.value = this.javaType.newInstance();
            }
            catch (Exception exception) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Method onStartElement failed.", (Throwable)exception);
                }
                throw new SAXException(Messages.getMessage("cantCreateBean00", this.javaType.getName(), exception.toString()));
            }
        }
        if (this.typeDesc == null) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            BeanPropertyDescriptor beanPropertyDescriptor;
            QName qName = new QName(attributes.getURI(i), attributes.getLocalName(i));
            String string4 = this.typeDesc.getFieldNameForAttribute(qName);
            if (string4 == null || (beanPropertyDescriptor = (BeanPropertyDescriptor)this.propertyMap.get(string4)) == null || !beanPropertyDescriptor.isWriteable() || beanPropertyDescriptor.isIndexed()) continue;
            Deserializer deserializer = this.getDeserializer(null, beanPropertyDescriptor.getType(), null, deserializationContext);
            if (deserializer == null) {
                throw new SAXException(Messages.getMessage("unregistered00", beanPropertyDescriptor.getType().toString()));
            }
            if (!(deserializer instanceof SimpleDeserializer)) {
                throw new SAXException(Messages.getMessage("AttrNotSimpleType00", beanPropertyDescriptor.getName(), beanPropertyDescriptor.getType().toString()));
            }
            try {
                deserializer.onStartElement(string, string2, string3, attributes, deserializationContext);
                Object object = ((SimpleDeserializer)deserializer).makeValue(attributes.getValue(i));
                beanPropertyDescriptor.set(this.value, object);
                continue;
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
    }

    protected Deserializer getDeserializer(QName qName, Class clazz, String string, DeserializationContext deserializationContext) {
        if (this.cacheStringDSer != null && String.class.equals((Object)clazz) && string == null && (this.cacheXMLType == null && qName == null || this.cacheXMLType != null && this.cacheXMLType.equals(qName))) {
            this.cacheStringDSer.reset();
            return this.cacheStringDSer;
        }
        Deserializer deserializer = null;
        if (qName != null) {
            deserializer = deserializationContext.getDeserializerForType(qName);
        } else {
            TypeMapping typeMapping = deserializationContext.getTypeMapping();
            QName qName2 = typeMapping.getTypeQName(clazz);
            if (string == null) {
                deserializer = deserializationContext.getDeserializer(clazz, qName2);
            } else {
                deserializer = new DeserializerImpl();
                deserializer.setDefaultType(qName2);
            }
        }
        if (clazz.equals(String.class) && deserializer instanceof SimpleDeserializer) {
            this.cacheStringDSer = (SimpleDeserializer)deserializer;
            this.cacheXMLType = qName;
        }
        return deserializer;
    }

    protected Target createValueTarget(Object object, BeanPropertyDescriptor beanPropertyDescriptor, int n) {
        return new BeanPropertyTarget(object, beanPropertyDescriptor, n);
    }
}

