/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding.ser;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.utils.Messages;

public class CalendarDeserializer
extends SimpleDeserializer {
    private static SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public CalendarDeserializer(Class clazz, QName qName) {
        super(clazz, qName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object makeValue(String string) {
        Date date;
        Calendar calendar = Calendar.getInstance();
        boolean bl = false;
        if (string != null) {
            if (string.charAt(0) == '+') {
                string = string.substring(1);
            }
            if (string.charAt(0) == '-') {
                string = string.substring(1);
                bl = true;
            }
            if (string.length() < 19) {
                throw new NumberFormatException(Messages.getMessage("badDateTime00"));
            }
            if (string.charAt(4) != '-' || string.charAt(7) != '-' || string.charAt(10) != 'T') {
                throw new NumberFormatException(Messages.getMessage("badDate00"));
            }
            if (string.charAt(13) != ':' || string.charAt(16) != ':') {
                throw new NumberFormatException(Messages.getMessage("badTime00"));
            }
        }
        try {
            SimpleDateFormat simpleDateFormat = zulu;
            synchronized (simpleDateFormat) {
                date = zulu.parse(string == null ? null : string.substring(0, 19) + ".000Z");
            }
        }
        catch (Exception exception) {
            throw new NumberFormatException(exception.toString());
        }
        int n = 19;
        if (string != null) {
            int n2;
            int n3;
            if (n < string.length() && string.charAt(n) == '.') {
                n3 = 0;
                n2 = ++n;
                while (n < string.length() && Character.isDigit(string.charAt(n))) {
                    ++n;
                }
                String string2 = string.substring(n2, n);
                if (string2.length() == 3) {
                    n3 = Integer.parseInt(string2);
                } else if (string2.length() < 3) {
                    n3 = Integer.parseInt((string2 + "000").substring(0, 3));
                } else {
                    n3 = Integer.parseInt(string2.substring(0, 3));
                    if (string2.charAt(3) >= '5') {
                        ++n3;
                    }
                }
                date.setTime(date.getTime() + (long)n3);
            }
            if (n + 5 < string.length() && (string.charAt(n) == '+' || string.charAt(n) == '-')) {
                if (!(Character.isDigit(string.charAt(n + 1)) && Character.isDigit(string.charAt(n + 2)) && string.charAt(n + 3) == ':' && Character.isDigit(string.charAt(n + 4)) && Character.isDigit(string.charAt(n + 5)))) {
                    throw new NumberFormatException(Messages.getMessage("badTimezone00"));
                }
                n3 = (string.charAt(n + 1) - 48) * 10 + string.charAt(n + 2) - 48;
                n2 = (string.charAt(n + 4) - 48) * 10 + string.charAt(n + 5) - 48;
                int n4 = (n3 * 60 + n2) * 60 * 1000;
                if (string.charAt(n) == '+') {
                    n4 = -n4;
                }
                date.setTime(date.getTime() + (long)n4);
                n += 6;
            }
            if (n < string.length() && string.charAt(n) == 'Z') {
                ++n;
            }
            if (n < string.length()) {
                throw new NumberFormatException(Messages.getMessage("badChars00"));
            }
        }
        calendar.setTime(date);
        if (bl) {
            calendar.set(0, 0);
        }
        if (this.javaType == Date.class) {
            return date;
        }
        return calendar;
    }

    static {
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

