/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.SocketFactory;
import org.apache.axis.components.net.SocketFactoryFactory;
import org.apache.axis.encoding.Base64;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.transport.http.ChunkedInputStream;
import org.apache.axis.transport.http.ChunkedOutputStream;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.transport.http.SocketInputStream;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class HTTPSender
extends BasicHandler {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$transport$http$HTTPSender == null ? (class$org$apache$axis$transport$http$HTTPSender = HTTPSender.class$("org.apache.axis.transport.http.HTTPSender")) : class$org$apache$axis$transport$http$HTTPSender).getName());
    static /* synthetic */ Class class$org$apache$axis$transport$http$HTTPSender;

    public void invoke(MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("enter00", "HTTPSender::invoke"));
        }
        try {
            BooleanHolder useFullURL = new BooleanHolder(false);
            StringBuffer otherHeaders = new StringBuffer();
            URL targetURL = new URL(msgContext.getStrProp(MessageContext.TRANS_URL));
            String host = targetURL.getHost();
            int port = targetURL.getPort();
            Socket sock = null;
            sock = targetURL.getProtocol().equalsIgnoreCase("https") ? this.getSecureSocket(host, port, otherHeaders, useFullURL) : this.getSocket(host, port, otherHeaders, useFullURL);
            if (msgContext.getTimeout() != 0) {
                sock.setSoTimeout(msgContext.getTimeout());
            }
            InputStream inp = this.writeToSocket(sock, msgContext, targetURL, otherHeaders, host, port, useFullURL);
            this.readFromSocket(sock, msgContext, inp, null);
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw AxisFault.makeFault(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("exit00", "HTTPDispatchHandler::invoke"));
        }
    }

    private Socket getSecureSocket(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
        SocketFactory factory = SocketFactoryFactory.getSecureFactory(this.getOptions());
        return factory.create(host, port, otherHeaders, useFullURL);
    }

    private Socket getSocket(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
        SocketFactory factory = SocketFactoryFactory.getFactory(this.getOptions());
        return factory.create(host, port, otherHeaders, useFullURL);
    }

    private InputStream writeToSocket(Socket sock, MessageContext msgContext, URL tmpURL, StringBuffer otherHeaders, String host, int port, BooleanHolder useFullURL) throws IOException {
        String statusMessage;
        Integer Irc;
        Hashtable cheaders;
        Hashtable userHeaderTable;
        String action;
        String userID = null;
        String passwd = null;
        String reqEnv = null;
        InputStream inp = null;
        userID = msgContext.getUsername();
        passwd = msgContext.getPassword();
        String string = action = msgContext.useSOAPAction() ? msgContext.getSOAPActionURI() : "";
        if (action == null) {
            action = "";
        }
        if (userID == null && tmpURL.getUserInfo() != null) {
            String info = tmpURL.getUserInfo();
            int sep = info.indexOf(58);
            if (sep >= 0 && sep + 1 < info.length()) {
                userID = info.substring(0, sep);
                passwd = info.substring(sep + 1);
            } else {
                userID = info;
            }
        }
        if (userID != null) {
            StringBuffer tmpBuf = new StringBuffer();
            tmpBuf.append(userID).append(":").append(passwd == null ? "" : passwd);
            otherHeaders.append("Authorization").append(": Basic ").append(Base64.encode(tmpBuf.toString().getBytes())).append("\r\n");
        }
        if (msgContext.getMaintainSession()) {
            String cookie = msgContext.getStrProp("Cookie");
            String cookie2 = msgContext.getStrProp("Cookie2");
            if (cookie != null) {
                otherHeaders.append("Cookie").append(": ").append(cookie).append("\r\n");
            }
            if (cookie2 != null) {
                otherHeaders.append("Cookie2").append(": ").append(cookie2).append("\r\n");
            }
        }
        StringBuffer header = new StringBuffer();
        header.append("POST").append(" ");
        if (useFullURL.value) {
            header.append(tmpURL.toExternalForm());
        } else {
            header.append(tmpURL.getFile() == null || tmpURL.getFile().equals("") ? "/" : tmpURL.getFile());
        }
        Message reqMessage = msgContext.getRequestMessage();
        boolean http10 = true;
        boolean httpChunkStream = false;
        boolean httpContinueExpected = false;
        String httpConnection = null;
        String httpver = msgContext.getStrProp(MessageContext.HTTP_TRANSPORT_VERSION);
        if (null == httpver) {
            httpver = HTTPConstants.HEADER_PROTOCOL_V10;
        }
        if ((httpver = httpver.trim()).equals(HTTPConstants.HEADER_PROTOCOL_V11)) {
            http10 = false;
        }
        if ((userHeaderTable = (Hashtable)msgContext.getProperty("HTTP-Request-Headers")) != null) {
            if (null == otherHeaders) {
                otherHeaders = new StringBuffer(1024);
            }
            Iterator e = userHeaderTable.entrySet().iterator();
            while (e.hasNext()) {
                String val;
                Map.Entry me = e.next();
                Object keyObj = me.getKey();
                if (null == keyObj) continue;
                String key = keyObj.toString().trim();
                if (key.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING)) {
                    if (http10 || null == (val = me.getValue().toString()) || !val.trim().equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) continue;
                    httpChunkStream = true;
                    continue;
                }
                if (key.equalsIgnoreCase("Host") || key.equalsIgnoreCase("Content-Type") || key.equalsIgnoreCase("SOAPAction") || key.equalsIgnoreCase("Content-Length") || key.equalsIgnoreCase("Cookie") || key.equalsIgnoreCase("Cookie2") || key.equalsIgnoreCase("Authorization") || key.equalsIgnoreCase("Proxy-Authorization")) continue;
                if (key.equalsIgnoreCase("Connection")) {
                    if (http10 || !(val = me.getValue().toString()).trim().equalsIgnoreCase(HTTPConstants.HEADER_CONNECTION_CLOSE)) continue;
                    httpConnection = HTTPConstants.HEADER_CONNECTION_CLOSE;
                    continue;
                }
                if (!http10 && key.equalsIgnoreCase("Expect") && null != (val = me.getValue().toString()) && val.trim().equalsIgnoreCase("100-continue")) {
                    httpContinueExpected = true;
                }
                otherHeaders.append(key).append(": ").append(me.getValue()).append("\r\n");
            }
        }
        if (!http10) {
            httpConnection = HTTPConstants.HEADER_CONNECTION_CLOSE;
        }
        header.append(" ");
        header.append(http10 ? "HTTP/1.0" : "HTTP/1.1").append("\r\n").append("Content-Type").append(": ").append(reqMessage.getContentType(msgContext.getSOAPConstants())).append("\r\n").append("Accept").append(": ").append("application/soap+xml").append(", ").append("application/dime").append(", ").append("multipart/related").append(", ").append("text/*").append("\r\n").append("User-Agent").append(": ").append("Axis/1.0").append("\r\n").append("Host").append(": ").append(host).append(port == -1 ? "" : ":" + port).append("\r\n").append("Cache-Control").append(": ").append("no-cache").append("\r\n").append("Pragma").append(": ").append("no-cache").append("\r\n").append("SOAPAction").append(": \"").append(action).append("\"\r\n");
        if (!httpChunkStream) {
            header.append("Content-Length").append(": ").append(reqMessage.getContentLength()).append("\r\n");
        } else {
            header.append(HTTPConstants.HEADER_TRANSFER_ENCODING).append(": ").append(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED).append("\r\n");
        }
        if (null != httpConnection) {
            header.append("Connection");
            header.append(": ");
            header.append(httpConnection);
            header.append("\r\n");
        }
        if (null != otherHeaders) {
            header.append((Object)otherHeaders);
        }
        header.append("\r\n");
        OutputStream out = sock.getOutputStream();
        if (httpChunkStream) {
            out.write(header.toString().getBytes("iso-8859-1"));
            if (httpContinueExpected) {
                out.flush();
                cheaders = new Hashtable();
                inp = this.readFromSocket(sock, msgContext, null, cheaders);
                int returnCode = -1;
                Irc = (Integer)msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                if (null != Irc) {
                    returnCode = Irc;
                }
                if (100 == returnCode) {
                    msgContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                    msgContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                } else {
                    statusMessage = (String)msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                    AxisFault fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
                    fault.setFaultDetailString(Messages.getMessage("return01", "" + returnCode, ""));
                    throw fault;
                }
            }
            ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream(out);
            out = new BufferedOutputStream(chunkedOutputStream, 8192);
            try {
                reqMessage.writeTo(out);
            }
            catch (SOAPException e) {
                log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            }
            out.flush();
            chunkedOutputStream.eos();
        } else {
            if (httpContinueExpected) {
                out.flush();
                cheaders = new Hashtable();
                inp = this.readFromSocket(sock, msgContext, null, cheaders);
                int returnCode = -1;
                Irc = (Integer)msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                if (null != Irc) {
                    returnCode = Irc;
                }
                if (100 == returnCode) {
                    msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, null);
                    msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE, null);
                } else {
                    statusMessage = (String)msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                    AxisFault fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
                    fault.setFaultDetailString(Messages.getMessage("return01", "" + returnCode, ""));
                    throw fault;
                }
            }
            out = new BufferedOutputStream(out, 8192);
            try {
                out.write(header.toString().getBytes("iso-8859-1"));
                reqMessage.writeTo(out);
            }
            catch (SOAPException e) {
                log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            }
            out.flush();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("xmlSent00"));
            log.debug((Object)"---------------------------------------------------");
            log.debug((Object)(header + reqEnv));
        }
        return inp;
    }

    /*
     * Unable to fully structure code
     */
    private InputStream readFromSocket(Socket sock, MessageContext msgContext, InputStream inp, Hashtable headers) throws IOException {
        block20: {
            outMsg = null;
            len = 0;
            colonIndex = -1;
            headersOnly = false;
            if (null != headers) {
                headersOnly = true;
            } else {
                headers = new Hashtable<String, String>();
            }
            statusMessage = "";
            returnCode = 0;
            if (null == inp) {
                inp = new BufferedInputStream(sock.getInputStream());
            }
            readTooMuch = false;
            b = 0;
            buf = new ByteArrayOutputStream(4097);
            while (true) {
                if (!readTooMuch) {
                    b = (byte)inp.read();
                }
                if (b == -1) break;
                readTooMuch = false;
                if (b != 13 && b != 10) {
                    if (b == 58 && colonIndex == -1) {
                        colonIndex = len;
                    }
                    ++len;
                    buf.write(b);
                    continue;
                }
                if (b == 13) continue;
                if (len == 0) break;
                b = (byte)inp.read();
                readTooMuch = true;
                if (b == 32 || b == 9) continue;
                buf.close();
                hdata = buf.toByteArray();
                buf.reset();
                if (colonIndex != -1) {
                    name = new String(hdata, 0, colonIndex, "iso-8859-1");
                    value = new String(hdata, colonIndex + 1, len - 1 - colonIndex, "iso-8859-1");
                    colonIndex = -1;
                } else {
                    name = new String(hdata, 0, len, "iso-8859-1");
                    value = "";
                }
                if (HTTPSender.log.isDebugEnabled()) {
                    HTTPSender.log.debug((Object)(name + value));
                }
                if (msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE) == null) {
                    start = name.indexOf(32) + 1;
                    tmp = name.substring(start).trim();
                    end = tmp.indexOf(32);
                    if (end != -1) {
                        tmp = tmp.substring(0, end);
                    }
                    returnCode = Integer.parseInt(tmp);
                    msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, new Integer(returnCode));
                    statusMessage = name.substring(start + end + 1);
                    msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE, statusMessage);
                } else {
                    headers.put(name.toLowerCase(), value);
                }
                len = 0;
            }
            if (headersOnly) {
                return inp;
            }
            contentType = (String)headers.get("Content-Type".toLowerCase());
            v0 = contentType = null == contentType ? null : contentType.trim();
            if (returnCode > 199 && returnCode < 300 || contentType != null && !contentType.startsWith("text/html") && returnCode > 499 && returnCode < 600) break block20;
            buf = new ByteArrayOutputStream(4097);
            if (true) ** GOTO lbl68
            do {
                buf.write(b);
lbl68:
                // 2 sources

                v1 = (byte)inp.read();
                b = v1;
            } while (-1 != v1);
            fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
            fault.setFaultDetailString(Messages.getMessage("return01", "" + returnCode, buf.toString()));
            throw fault;
        }
        if (b != -1) {
            contentLocation = (String)headers.get("Content-Location".toLowerCase());
            contentLocation = null == contentLocation ? null : contentLocation.trim();
            contentLength = (String)headers.get("Content-Length".toLowerCase());
            contentLength = null == contentLength ? null : contentLength.trim();
            transferEncoding = (String)headers.get(HTTPConstants.HEADER_TRANSFER_ENCODING.toLowerCase());
            if (null != transferEncoding && transferEncoding.trim().equals(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) {
                inp = new ChunkedInputStream(inp);
            }
            outMsg = new Message(new SocketInputStream(inp, sock), false, contentType, contentLocation);
            outMsg.setMessageType("response");
            msgContext.setResponseMessage(outMsg);
            if (HTTPSender.log.isDebugEnabled()) {
                if (null == contentLength) {
                    HTTPSender.log.debug((Object)("\n" + Messages.getMessage("no00", "Content-Length")));
                }
                HTTPSender.log.debug((Object)("\n" + Messages.getMessage("xmlRecd00")));
                HTTPSender.log.debug((Object)"-----------------------------------------------");
                HTTPSender.log.debug((Object)outMsg.getSOAPPartAsString());
            }
        }
        if (msgContext.getMaintainSession()) {
            this.handleCookie("Cookie", "Set-Cookie", headers, msgContext);
            this.handleCookie("Cookie2", "Set-Cookie2", headers, msgContext);
        }
        return inp;
    }

    public void handleCookie(String cookieName, String setCookieName, Hashtable headers, MessageContext msgContext) {
        if (headers.containsKey(setCookieName.toLowerCase())) {
            String cookie = (String)headers.get(setCookieName.toLowerCase());
            int index = (cookie = cookie.trim()).indexOf(59);
            if (index != -1) {
                cookie = cookie.substring(0, index);
            }
            msgContext.setProperty(cookieName, cookie);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

