/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.awt.Image;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.rpc.holders.Holder;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.components.image.ImageIO;
import org.apache.axis.components.image.ImageIOFactory;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.types.HexBinary;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class JavaUtils {
    protected static Log log = LogFactory.getLog(JavaUtils.class.getName());
    public static final char NL = '\n';
    public static final char CR = '\r';
    public static final String LS = System.getProperty("line.separator", new Character('\n').toString());
    static final String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    static final Collator englishCollator = Collator.getInstance(Locale.ENGLISH);
    static final char keywordPrefix = '_';
    private static boolean checkForAttchmentSupport = true;
    private static boolean attachmentSupportEnabled = false;

    public static Class getWrapperClass(Class clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        return null;
    }

    public static String getWrapper(String string) {
        if (string.equals("int")) {
            return "Integer";
        }
        if (string.equals("short")) {
            return "Short";
        }
        if (string.equals("boolean")) {
            return "Boolean";
        }
        if (string.equals("byte")) {
            return "Byte";
        }
        if (string.equals("long")) {
            return "Long";
        }
        if (string.equals("double")) {
            return "Double";
        }
        if (string.equals("float")) {
            return "Float";
        }
        if (string.equals("char")) {
            return "Character";
        }
        return null;
    }

    public static Class getPrimitiveClass(Class clazz) {
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        return null;
    }

    public static Object convert(Object object, Class object2) {
        Object object3;
        Object object4;
        if (object2 == null) {
            return object;
        }
        Class clazz = null;
        if (object != null) {
            clazz = JavaUtils.getHolderValueType(object.getClass());
        }
        if (object != null && clazz == null && ((Class)object2).isAssignableFrom(object.getClass())) {
            return object;
        }
        if (log.isDebugEnabled()) {
            object4 = "null";
            if (object != null) {
                object4 = object.getClass().getName();
            }
            log.debug((Object)Messages.getMessage("convert00", (String)object4, ((Class)object2).getName()));
        }
        object4 = null;
        if (object instanceof ConvertCache && (object4 = ((ConvertCache)object).getConvertedValue((Class)object2)) != null) {
            return object4;
        }
        Class clazz2 = JavaUtils.getHolderValueType((Class)object2);
        if (object instanceof HexBinary && object2 == byte[].class) {
            return ((HexBinary)object).getBytes();
        }
        if (object instanceof byte[] && object2 == HexBinary.class) {
            return new HexBinary((byte[])object);
        }
        if (object instanceof Calendar && object2 == Date.class) {
            return ((Calendar)object).getTime();
        }
        if (object instanceof HashMap && object2 == Hashtable.class) {
            return new Hashtable((HashMap)object);
        }
        if (JavaUtils.isAttachmentSupported() && (object instanceof AttachmentPart || object instanceof DataHandler)) {
            try {
                object3 = ((Class)object2).getName();
                if (object2 == String.class || object2 == Image.class || object2 == Source.class || ((String)object3).equals("javax.mail.internet.MimeMultipart")) {
                    DataHandler dataHandler = object instanceof AttachmentPart ? ((AttachmentPart)object).getDataHandler() : (DataHandler)object;
                    if (object2 == Image.class) {
                        InputStream inputStream = (InputStream)dataHandler.getContent();
                        if (inputStream.available() == 0) {
                            return null;
                        }
                        ImageIO imageIO = ImageIOFactory.getImageIO();
                        if (imageIO != null) {
                            return JavaUtils.getImageFromStream(inputStream);
                        }
                        log.info((Object)Messages.getMessage("needImageIO"));
                        return object;
                    }
                    if (object2 == Source.class) {
                        return new StreamSource(new StringReader((String)dataHandler.getContent()));
                    }
                    return dataHandler.getContent();
                }
            }
            catch (IOException iOException) {
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
        }
        if (object != null && ((Class)object2).isArray() && !((Class)object2).getComponentType().equals(Object.class) && ((Class)object2).getComponentType().isAssignableFrom(object.getClass())) {
            object3 = Array.newInstance(((Class)object2).getComponentType(), 1);
            Array.set(object3, 0, object);
            return object3;
        }
        if (!(object instanceof Collection) && (object == null || !object.getClass().isArray()) && (clazz2 == null && clazz == null || clazz2 != null && clazz != null)) {
            return object;
        }
        if (clazz2 != null) {
            object3 = JavaUtils.convert(object, clazz2);
            Object var6_11 = null;
            try {
                var6_11 = ((Class)object2).newInstance();
                JavaUtils.setHolderValue(var6_11, object3);
                return var6_11;
            }
            catch (Exception exception) {
                return object;
            }
        }
        if (clazz != null) {
            try {
                object3 = JavaUtils.getHolderValue(object);
                return JavaUtils.convert(object3, (Class)object2);
            }
            catch (HolderException holderException) {
                return object;
            }
        }
        if (object instanceof ConvertCache && ((ConvertCache)object).getDestClass() != object2 && (object3 = ((ConvertCache)object).getDestClass()) != null && ((Class)object3).isArray() && ((Class)object2).isArray() && ((Class)object2).isAssignableFrom((Class<?>)object3) && (object4 = ((ConvertCache)object).getConvertedValue((Class)(object2 = object3))) != null) {
            return object4;
        }
        if (object == null) {
            return object;
        }
        int n = 0;
        n = object.getClass().isArray() ? Array.getLength(object) : ((Collection)object).size();
        if (((Class)object2).isArray()) {
            if (((Class)object2).getComponentType().isPrimitive()) {
                Object object5 = Array.newInstance(((Class)object2).getComponentType(), n);
                if (object.getClass().isArray()) {
                    for (int i = 0; i < n; ++i) {
                        Array.set(object5, i, Array.get(object, i));
                    }
                } else {
                    int n2 = 0;
                    Iterator iterator = ((Collection)object).iterator();
                    while (iterator.hasNext()) {
                        Array.set(object5, n2++, iterator.next());
                    }
                }
                object4 = object5;
            } else {
                Object[] objectArray;
                try {
                    objectArray = (Object[])Array.newInstance(((Class)object2).getComponentType(), n);
                }
                catch (Exception exception) {
                    return object;
                }
                if (object.getClass().isArray()) {
                    for (int i = 0; i < n; ++i) {
                        objectArray[i] = JavaUtils.convert(Array.get(object, i), ((Class)object2).getComponentType());
                    }
                } else {
                    int n3 = 0;
                    Iterator iterator = ((Collection)object).iterator();
                    while (iterator.hasNext()) {
                        objectArray[n3++] = JavaUtils.convert(iterator.next(), ((Class)object2).getComponentType());
                    }
                }
                object4 = objectArray;
            }
        } else if (Collection.class.isAssignableFrom((Class<?>)object2)) {
            Collection collection = null;
            try {
                collection = object2 == Collection.class || object2 == List.class ? new ArrayList() : (object2 == Set.class ? new HashSet() : (Collection)((Class)object2).newInstance());
            }
            catch (Exception exception) {
                return object;
            }
            if (object.getClass().isArray()) {
                for (int i = 0; i < n; ++i) {
                    collection.add(Array.get(object, i));
                }
            } else {
                Iterator iterator = ((Collection)object).iterator();
                while (iterator.hasNext()) {
                    collection.add(iterator.next());
                }
            }
            object4 = collection;
        } else {
            object4 = object;
        }
        if (object instanceof ConvertCache) {
            ((ConvertCache)object).setConvertedValue((Class)object2, object4);
        }
        return object4;
    }

    public static boolean isConvertable(Object object, Class clazz) {
        Class<?> clazz2 = null;
        if (object != null) {
            clazz2 = object instanceof Class ? (Class<?>)object : object.getClass();
        }
        if (clazz == null) {
            return false;
        }
        if (clazz2 != null) {
            if (clazz.isAssignableFrom(clazz2)) {
                return true;
            }
            if (JavaUtils.getWrapperClass(clazz2) == clazz) {
                return true;
            }
            if (JavaUtils.getWrapperClass(clazz) == clazz2) {
                return true;
            }
            if ((Collection.class.isAssignableFrom(clazz2) || clazz2.isArray()) && (Collection.class.isAssignableFrom(clazz) || clazz.isArray())) {
                return true;
            }
            if (clazz.isArray() && !clazz.getComponentType().equals(Object.class) && clazz.getComponentType().isAssignableFrom(clazz2)) {
                return true;
            }
            if (clazz2 == HexBinary.class && clazz == byte[].class || clazz2 == byte[].class && clazz == HexBinary.class) {
                return true;
            }
            if (clazz2 == HashMap.class && clazz == Hashtable.class) {
                return true;
            }
            if (Calendar.class.isAssignableFrom(clazz2) && clazz == Date.class) {
                return true;
            }
        }
        Class clazz3 = JavaUtils.getHolderValueType(clazz);
        if (clazz2 == null) {
            return clazz3 != null;
        }
        if (clazz3 != null && (clazz3.isAssignableFrom(clazz2) || JavaUtils.isConvertable(clazz2, clazz3))) {
            return true;
        }
        Class clazz4 = JavaUtils.getHolderValueType(clazz2);
        if (clazz4 != null && (clazz.isAssignableFrom(clazz4) || JavaUtils.isConvertable(clazz4, clazz))) {
            return true;
        }
        if (clazz.getName().equals("javax.activation.DataHandler")) {
            String string = clazz2.getName();
            if (clazz2 == String.class || clazz2 == Image.class || string.equals("javax.mail.internet.MimeMultipart") || string.equals("javax.xml.transform.Source")) {
                return true;
            }
        }
        if (clazz2.isPrimitive()) {
            return JavaUtils.isConvertable(JavaUtils.getWrapperClass(clazz2), clazz);
        }
        return false;
    }

    public static Image getImageFromStream(InputStream inputStream) {
        try {
            return ImageIOFactory.getImageIO().loadImage(inputStream);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean isJavaId(String string) {
        if (string == null || string.equals("") || JavaUtils.isJavaKeyword(string)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isJavaKeyword(String string) {
        return Arrays.binarySearch(keywords, string, englishCollator) >= 0;
    }

    public static String makeNonJavaKeyword(String string) {
        return '_' + string;
    }

    public static String getLoadableClassName(String string) {
        if (string == null || string.indexOf("[") < 0 || string.charAt(0) == '[') {
            return string;
        }
        String string2 = string.substring(0, string.indexOf("["));
        string2 = string2.equals("byte") ? "B" : (string2.equals("char") ? "C" : (string2.equals("double") ? "D" : (string2.equals("float") ? "F" : (string2.equals("int") ? "I" : (string2.equals("long") ? "J" : (string2.equals("short") ? "S" : (string2.equals("boolean") ? "Z" : "L" + string2 + ";")))))));
        int n = string.indexOf("]");
        while (n > 0) {
            string2 = "[" + string2;
            n = string.indexOf("]", n + 1);
        }
        return string2;
    }

    public static String getTextClassName(String string) {
        int n;
        if (string == null || string.indexOf("[") != 0) {
            return string;
        }
        String string2 = "";
        for (n = 0; n < string.length() && string.charAt(n) == '['; ++n) {
            string2 = string2 + "[]";
        }
        if (n < string.length()) {
            string2 = string.charAt(n) == 'B' ? "byte" + string2 : (string.charAt(n) == 'C' ? "char" + string2 : (string.charAt(n) == 'D' ? "double" + string2 : (string.charAt(n) == 'F' ? "float" + string2 : (string.charAt(n) == 'I' ? "int" + string2 : (string.charAt(n) == 'J' ? "long" + string2 : (string.charAt(n) == 'S' ? "short" + string2 : (string.charAt(n) == 'Z' ? "boolean" + string2 : string.substring(n + 1, string.indexOf(";")) + string2)))))));
        }
        return string2;
    }

    public static String xmlNameToJava(String string) {
        int n;
        if (string == null || string.equals("")) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        boolean bl = false;
        for (n = 0; n < n2 && (JavaUtils.isPunctuation(cArray[n]) || !Character.isJavaIdentifierStart(cArray[n])); ++n) {
        }
        if (n < n2) {
            stringBuffer.append(cArray[n]);
            bl = !Character.isLetter(cArray[n]);
        } else if (Character.isJavaIdentifierPart(cArray[0])) {
            stringBuffer.append("_" + cArray[0]);
        } else {
            stringBuffer.append("_" + cArray.length);
        }
        ++n;
        while (n < n2) {
            char c = cArray[n];
            if (JavaUtils.isPunctuation(c) || !Character.isJavaIdentifierPart(c)) {
                bl = true;
            } else {
                if (bl && Character.isLowerCase(c)) {
                    stringBuffer.append(Character.toUpperCase(c));
                } else {
                    stringBuffer.append(c);
                }
                bl = !Character.isLetter(c);
            }
            ++n;
        }
        String string2 = stringBuffer.toString();
        if (Character.isUpperCase(string2.charAt(0))) {
            string2 = Introspector.decapitalize(string2);
        }
        if (JavaUtils.isJavaKeyword(string2)) {
            string2 = JavaUtils.makeNonJavaKeyword(string2);
        }
        return string2;
    }

    private static boolean isPunctuation(char c) {
        return '-' == c || '.' == c || ':' == c || '\u00b7' == c || '\u0387' == c || '\u06dd' == c || '\u06de' == c;
    }

    public static final String replace(String string, String string2, String string3) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = string2.length();
        try {
            int n2 = 0;
            int n3 = string.indexOf(string2, n2);
            while (n3 >= 0) {
                stringBuffer.append(string.substring(n2, n3));
                stringBuffer.append(string3);
                n2 = n3 + n;
                n3 = string.indexOf(string2, n2);
            }
            if (n2 < string.length()) {
                stringBuffer.append(string.substring(n2));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return new String(stringBuffer);
    }

    public static Class getHolderValueType(Class clazz) {
        if (clazz != null) {
            Field field;
            Class<?>[] classArray = clazz.getInterfaces();
            boolean bl = false;
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] != Holder.class) continue;
                bl = true;
            }
            if (!bl) {
                return null;
            }
            try {
                field = clazz.getField("value");
            }
            catch (Exception exception) {
                field = null;
            }
            if (field != null) {
                return field.getType();
            }
        }
        return null;
    }

    public static Object getHolderValue(Object object) throws HolderException {
        if (!(object instanceof Holder)) {
            throw new HolderException(Messages.getMessage("badHolder00"));
        }
        try {
            Field field = object.getClass().getField("value");
            return field.get(object);
        }
        catch (Exception exception) {
            throw new HolderException(Messages.getMessage("exception01", exception.getMessage()));
        }
    }

    public static void setHolderValue(Object object, Object object2) throws HolderException {
        if (!(object instanceof Holder)) {
            throw new HolderException(Messages.getMessage("badHolder00"));
        }
        try {
            Field field = object.getClass().getField("value");
            if (field.getType().isPrimitive()) {
                if (object2 != null) {
                    field.set(object, object2);
                }
            } else {
                field.set(object, object2);
            }
        }
        catch (Exception exception) {
            throw new HolderException(Messages.getMessage("exception01", exception.getMessage()));
        }
    }

    public static boolean isEnumClass(Class clazz) {
        block6: {
            if (Enum.class.isAssignableFrom(clazz)) {
                return true;
            }
            Method method = clazz.getMethod("getValue", null);
            Method method2 = clazz.getMethod("toString", null);
            Method method3 = clazz.getMethod("fromString", String.class);
            if (method == null || method2 == null || method3 == null || clazz.getMethod("fromValue", method.getReturnType()) == null) break block6;
            try {
                return clazz.getMethod("setValue", method.getReturnType()) == null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static String stackToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter(1024);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public static final boolean isTrue(String string) {
        return !JavaUtils.isFalseExplicitly(string);
    }

    public static final boolean isTrueExplicitly(String string) {
        return string != null && (string.equalsIgnoreCase("true") || string.equals("1") || string.equalsIgnoreCase("yes"));
    }

    public static final boolean isTrueExplicitly(Object object, boolean bl) {
        if (object == null) {
            return bl;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Integer) {
            return (Integer)object != 0;
        }
        if (object instanceof String) {
            return JavaUtils.isTrueExplicitly((String)object);
        }
        return true;
    }

    public static final boolean isTrueExplicitly(Object object) {
        return JavaUtils.isTrueExplicitly(object, false);
    }

    public static final boolean isTrue(Object object, boolean bl) {
        return !JavaUtils.isFalseExplicitly(object, !bl);
    }

    public static final boolean isTrue(Object object) {
        return JavaUtils.isTrue(object, false);
    }

    public static final boolean isFalse(String string) {
        return JavaUtils.isFalseExplicitly(string);
    }

    public static final boolean isFalseExplicitly(String string) {
        return string == null || string.equalsIgnoreCase("false") || string.equals("0") || string.equalsIgnoreCase("no");
    }

    public static final boolean isFalseExplicitly(Object object, boolean bl) {
        if (object == null) {
            return bl;
        }
        if (object instanceof Boolean) {
            return (Boolean)object == false;
        }
        if (object instanceof Integer) {
            return (Integer)object == 0;
        }
        if (object instanceof String) {
            return JavaUtils.isFalseExplicitly((String)object);
        }
        return false;
    }

    public static final boolean isFalseExplicitly(Object object) {
        return JavaUtils.isFalseExplicitly(object, true);
    }

    public static final boolean isFalse(Object object, boolean bl) {
        return JavaUtils.isFalseExplicitly(object, bl);
    }

    public static final boolean isFalse(Object object) {
        return JavaUtils.isFalse(object, true);
    }

    public static String mimeToJava(String string) {
        if ("image/gif".equals(string) || "image/jpeg".equals(string)) {
            return "java.awt.Image";
        }
        if ("text/plain".equals(string)) {
            return "java.lang.String";
        }
        if ("text/xml".equals(string) || "application/xml".equals(string)) {
            return "javax.xml.transform.Source";
        }
        if (string != null && string.startsWith("multipart/")) {
            return "javax.mail.internet.MimeMultipart";
        }
        return null;
    }

    public static synchronized boolean isAttachmentSupported() {
        if (checkForAttchmentSupport) {
            checkForAttchmentSupport = false;
            try {
                ClassUtils.forName("javax.activation.DataHandler");
                ClassUtils.forName("javax.mail.internet.MimeMultipart");
                attachmentSupportEnabled = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.debug((Object)(Messages.getMessage("attachEnabled") + "  " + attachmentSupportEnabled));
        }
        return attachmentSupportEnabled;
    }

    public static class HolderException
    extends Exception {
        public HolderException(String string) {
            super(string);
        }
    }

    public static interface ConvertCache {
        public void setConvertedValue(Class var1, Object var2);

        public Object getConvertedValue(Class var1);

        public Class getDestClass();
    }
}

