/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class SessionUtils {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$utils$SessionUtils == null ? (class$org$apache$axis$utils$SessionUtils = SessionUtils.class$("org.apache.axis.utils.SessionUtils")) : class$org$apache$axis$utils$SessionUtils).getName());
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected static final int SESSION_ID_BYTES = 16;
    protected static String algorithm = "MD5";
    protected static MessageDigest digest = null;
    protected static Random random = null;
    protected static String randomClass = "java.security.SecureRandom";
    private static String thisHost = null;
    static /* synthetic */ Class class$org$apache$axis$utils$SessionUtils;

    public static synchronized String generateSessionId() {
        byte[] bytes = new byte[16];
        SessionUtils.getRandom().nextBytes(bytes);
        bytes = SessionUtils.getDigest().digest(bytes);
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            byte b1 = (byte)((bytes[i] & 0xF0) >> 4);
            byte b2 = (byte)(bytes[i] & 0xF);
            if (b1 < 10) {
                result.append((char)(48 + b1));
            } else {
                result.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                result.append((char)(48 + b2));
            } else {
                result.append((char)(65 + (b2 - 10)));
            }
            ++i;
        }
        return result.toString();
    }

    public static synchronized Long generateSession() {
        return new Long(SessionUtils.getRandom().nextLong());
    }

    private static synchronized MessageDigest getDigest() {
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException f) {
                    digest = null;
                }
            }
        }
        return digest;
    }

    private static synchronized Random getRandom() {
        if (random == null) {
            try {
                Class<?> clazz = Class.forName(randomClass);
                random = (Random)clazz.newInstance();
                long seed = System.currentTimeMillis();
                char[] entropy = SessionUtils.getEntropy().toCharArray();
                int i = 0;
                while (i < entropy.length) {
                    long update = (byte)entropy[i] << i % 8 * 8;
                    seed ^= update;
                    ++i;
                }
                random.setSeed(seed);
            }
            catch (Exception e) {
                random = new Random();
            }
        }
        return random;
    }

    private static String getEntropy() {
        if (null == thisHost) {
            try {
                thisHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                log.error((Object)Messages.getMessage("javaNetUnknownHostException00"), (Throwable)e);
                thisHost = "localhost";
            }
        }
        StringBuffer s = new StringBuffer();
        s.append(s.hashCode()).append('.').append(System.currentTimeMillis()).append(".AXIS@").append(thisHost);
        return s.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

