/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.fromJava;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.Holder;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.SimpleType;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.symbolTable.BaseTypeMapping;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Types {
    private static final Log LOGGER = LogFactory.getLog(Types.class.getName());
    Definition def;
    Namespaces namespaces = null;
    TypeMapping tm;
    TypeMapping defaultTM;
    String targetNamespace;
    org.w3c.dom.Element wsdlTypesElem = null;
    Map schemaTypes = null;
    Map schemaElementNames = null;
    Map schemaUniqueElementNames = null;
    Map wrapperMap = new HashMap();
    List stopClasses = null;
    List beanCompatErrs = new ArrayList();
    Document docHolder;

    public Types(Definition definition, TypeMapping typeMapping, TypeMapping typeMapping2, Namespaces namespaces, String string, List list) {
        this.def = definition;
        this.createDocumentFragment();
        this.tm = typeMapping;
        this.defaultTM = typeMapping2;
        this.namespaces = namespaces;
        this.targetNamespace = string;
        this.stopClasses = list;
        this.schemaElementNames = new HashMap();
        this.schemaUniqueElementNames = new HashMap();
        this.schemaTypes = new HashMap();
    }

    public Namespaces getNamespaces() {
        return this.namespaces;
    }

    public void loadInputTypes(String string) throws IOException, WSDLException {
        Object object;
        Document document = XMLUtils.newDocument(string);
        NodeList nodeList = document.getChildNodes();
        if (nodeList.getLength() > 0 && "definitions".equals(nodeList.item(0).getLocalName())) {
            nodeList = nodeList.item(0).getChildNodes();
            for (int i = 0; i < nodeList.getLength() && this.wsdlTypesElem == null; ++i) {
                object = nodeList.item(i);
                if (object.getLocalName() == null || !"types".equals(object.getLocalName())) continue;
                this.wsdlTypesElem = (org.w3c.dom.Element)object;
            }
        }
        if (this.wsdlTypesElem == null) {
            return;
        }
        this.wsdlTypesElem = (org.w3c.dom.Element)this.docHolder.importNode(this.wsdlTypesElem, true);
        this.docHolder.appendChild(this.wsdlTypesElem);
        BaseTypeMapping baseTypeMapping = new BaseTypeMapping(){

            @Override
            public String getBaseName(QName qName) {
                QName qName2 = new QName(qName.getNamespaceURI(), qName.getLocalPart());
                Class clazz = Types.this.defaultTM.getClassForQName(qName2);
                if (clazz == null) {
                    return null;
                }
                return JavaUtils.getTextClassName(clazz.getName());
            }
        };
        object = new SymbolTable(baseTypeMapping, true, false, false);
        ((SymbolTable)object).populate(null, document);
        Vector vector = ((SymbolTable)object).getTypes();
        for (int i = 0; i < vector.size(); ++i) {
            TypeEntry typeEntry = (TypeEntry)vector.elementAt(i);
            if (typeEntry instanceof Element) {
                this.addToElementsList(typeEntry.getQName());
                continue;
            }
            if (!(typeEntry instanceof Type)) continue;
            this.addToTypesList(typeEntry.getQName());
        }
    }

    public QName writeTypeForPart(Class clazz, QName qName) throws AxisFault {
        if ("void".equals(clazz.getName())) {
            return null;
        }
        if (Holder.class.isAssignableFrom(clazz)) {
            clazz = JavaUtils.getHolderValueType(clazz);
        }
        if ((qName == null || Constants.isSOAP_ENC(qName.getNamespaceURI()) && "Array".equals(qName.getLocalPart())) && (qName = this.getTypeQName(clazz)) == null) {
            throw new AxisFault("Class:" + clazz.getName());
        }
        if (this.wsdlTypesElem == null) {
            this.writeWsdlTypesElement();
        }
        if (this.writeType(clazz, qName) == null) {
            qName = Constants.XSD_ANYTYPE;
        }
        return qName;
    }

    public QName writeElementForPart(Class clazz, QName qName) throws AxisFault {
        if ("void".equals(clazz.getName())) {
            return null;
        }
        if (Holder.class.isAssignableFrom(clazz)) {
            clazz = JavaUtils.getHolderValueType(clazz);
        }
        if ((qName == null || Constants.isSOAP_ENC(qName.getNamespaceURI()) && "Array".equals(qName.getLocalPart())) && (qName = this.getTypeQName(clazz)) == null) {
            throw new AxisFault("Class:" + clazz.getName());
        }
        String string = qName.getNamespaceURI();
        if (Constants.isSchemaXSD(string) || Constants.isSOAP_ENC(string) && !"Array".equals(qName.getLocalPart())) {
            return null;
        }
        if (this.wsdlTypesElem == null) {
            this.writeWsdlTypesElement();
        }
        if (this.writeTypeAsElement(clazz, qName) == null) {
            qName = null;
        }
        return qName;
    }

    public org.w3c.dom.Element writeWrapperForPart(QName qName, String string, QName qName2, boolean bl) throws AxisFault {
        if (this.wsdlTypesElem == null) {
            this.writeWsdlTypesElement();
        }
        this.writeTypeNamespace(qName);
        org.w3c.dom.Element element = this.writeWrapper(qName);
        org.w3c.dom.Element element2 = this.docHolder.createElement("element");
        element2.setAttribute("name", string);
        if (bl) {
            element2.setAttribute("nillable", "true");
        }
        String string2 = this.namespaces.getCreatePrefix(qName2.getNamespaceURI());
        String string3 = string2 + ":" + qName2.getLocalPart();
        element2.setAttribute("type", string3);
        element.appendChild(element2);
        return element2;
    }

    public boolean wrapperExists(QName qName) {
        return this.wrapperMap.get(qName) != null;
    }

    public org.w3c.dom.Element writeWrapper(QName qName) {
        boolean bl;
        org.w3c.dom.Element element = (org.w3c.dom.Element)this.wrapperMap.get(qName);
        boolean bl2 = bl = element == null;
        if (bl) {
            org.w3c.dom.Element element2 = this.docHolder.createElement("element");
            this.writeSchemaElement(qName, element2);
            element2.setAttribute("name", qName.getLocalPart());
            org.w3c.dom.Element element3 = this.docHolder.createElement("complexType");
            element2.appendChild(element3);
            element = this.docHolder.createElement("sequence");
            element3.appendChild(element);
            this.wrapperMap.put(qName, element);
        }
        return element;
    }

    private QName writeTypeAsElement(Class clazz, QName qName) throws AxisFault {
        if (qName == null || Constants.equals(Constants.SOAP_ARRAY, qName)) {
            qName = this.getTypeQName(clazz);
        }
        QName qName2 = this.writeTypeNamespace(clazz, qName);
        String string = this.writeType(clazz, qName);
        if (string != null) {
            org.w3c.dom.Element element = this.createElementDecl(qName, string, this.isNullable(clazz));
            if (element != null) {
                this.writeSchemaElement(qName2, element);
            }
            return qName;
        }
        return null;
    }

    private QName writeTypeNamespace(Class clazz, QName qName) {
        if (qName == null) {
            qName = this.getTypeQName(clazz);
        }
        this.writeTypeNamespace(qName);
        return qName;
    }

    private void writeTypeNamespace(QName qName) {
        String string;
        if (qName != null && (string = this.def.getPrefix(qName.getNamespaceURI())) == null) {
            this.def.addNamespace(this.namespaces.getCreatePrefix(qName.getNamespaceURI()), qName.getNamespaceURI());
        }
    }

    public QName getTypeQName(Class clazz) {
        QName qName = null;
        QName qName2 = null;
        if (this.defaultTM != null) {
            qName2 = this.defaultTM.getTypeQName(clazz);
        }
        if (this.tm != null) {
            qName = this.tm.getTypeQName(clazz);
        }
        if (qName == null) {
            qName = qName2;
        } else if (qName != null && qName != qName2 && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            qName = qName2;
        }
        if (clazz.isArray() && qName != null && Constants.equals(Constants.SOAP_ARRAY, qName)) {
            Class<?> clazz2 = clazz.getComponentType();
            QName qName3 = this.getTypeQName(clazz2);
            if (this.targetNamespace.equals(qName3.getNamespaceURI())) {
                qName = new QName(this.targetNamespace, "ArrayOf" + qName3.getLocalPart());
            } else {
                String string = this.namespaces.getCreatePrefix(qName3.getNamespaceURI());
                qName = new QName(this.targetNamespace, "ArrayOf_" + string + "_" + qName3.getLocalPart());
            }
            return qName;
        }
        if (qName == null) {
            String string = Types.getPackageNameFromFullName(clazz.getName());
            String string2 = Types.getLocalNameFromFullName(clazz.getName());
            String string3 = this.namespaces.getCreate(string);
            this.namespaces.getCreatePrefix(string3);
            String string4 = string2.replace('$', '_');
            qName = new QName(string3, string4);
        }
        return qName;
    }

    public static String getPackageNameFromFullName(String string) {
        if (string.lastIndexOf(46) < 0) {
            return "";
        }
        return string.substring(0, string.lastIndexOf(46));
    }

    public static String getLocalNameFromFullName(String string) {
        if (string.lastIndexOf(46) < 0) {
            return string;
        }
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public void writeSchemaElement(QName qName, org.w3c.dom.Element element) {
        if (this.wsdlTypesElem == null) {
            try {
                this.writeWsdlTypesElement();
            }
            catch (Exception exception) {
                LOGGER.error((Object)exception);
                return;
            }
        }
        Node node = null;
        NodeList nodeList = this.wsdlTypesElem.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            if (namedNodeMap == null) continue;
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                Attr attr = (Attr)namedNodeMap.item(j);
                if (!"targetNamespace".equals(attr.getName()) || !attr.getValue().equals(qName.getNamespaceURI())) continue;
                node = (org.w3c.dom.Element)nodeList.item(i);
            }
        }
        if (node == null) {
            node = this.docHolder.createElement("schema");
            this.wsdlTypesElem.appendChild(node);
            node.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
            node.setAttribute("targetNamespace", qName.getNamespaceURI());
            org.w3c.dom.Element element2 = this.docHolder.createElement("import");
            node.appendChild(element2);
            element2.setAttribute("namespace", Constants.URI_DEFAULT_SOAP_ENC);
        }
        node.appendChild(element);
    }

    private void writeWsdlTypesElement() {
        if (this.wsdlTypesElem == null) {
            this.wsdlTypesElem = this.docHolder.createElementNS("http://schemas.xmlsoap.org/wsdl/", "types");
            this.wsdlTypesElem.setPrefix("wsdl");
        }
    }

    public String writeType(Class clazz) throws AxisFault {
        return this.writeType(clazz, null);
    }

    public String writeType(Class clazz, QName qName) throws AxisFault {
        String string;
        if (qName == null || Constants.equals(Constants.SOAP_ARRAY, qName)) {
            qName = this.getTypeQName(clazz);
        }
        if (Constants.isSchemaXSD(qName.getNamespaceURI())) {
            return "xsd:" + qName.getLocalPart();
        }
        if (Constants.isSOAP_ENC(qName.getNamespaceURI()) && !"Array".equals(qName.getLocalPart())) {
            return "soapenc:" + qName.getLocalPart();
        }
        Serializer serializer = null;
        SerializerFactory serializerFactory = null;
        serializerFactory = this.tm != null ? (SerializerFactory)this.tm.getSerializer(clazz) : (SerializerFactory)this.defaultTM.getSerializer(clazz);
        if (serializerFactory == null) {
            if (this.isBeanCompatible(clazz, true)) {
                serializerFactory = new BeanSerializerFactory(clazz, qName);
            } else {
                return null;
            }
        }
        if (serializerFactory != null) {
            serializer = (Serializer)serializerFactory.getSerializerAs("Axis SAX Mechanism");
        }
        if (serializer == null) {
            throw new AxisFault(Messages.getMessage("NoSerializer00", clazz.getName()));
        }
        this.writeTypeNamespace(clazz, qName);
        String string2 = null;
        Class<?> clazz2 = null;
        if (clazz.isArray()) {
            string = "[]";
            clazz2 = clazz.getComponentType();
            if (clazz2.isArray()) {
                while (clazz2.isArray()) {
                    string = string + "[]";
                    clazz2 = clazz2.getComponentType();
                }
            }
            string2 = this.writeType(clazz2, null) + string;
        }
        string = this.namespaces.getCreatePrefix(qName.getNamespaceURI());
        String string3 = string + ":" + qName.getLocalPart();
        if (!this.addToTypesList(qName)) {
            return string3;
        }
        if (clazz.isArray()) {
            org.w3c.dom.Element element = this.docHolder.createElement("complexType");
            this.writeSchemaElement(qName, element);
            element.setAttribute("name", qName.getLocalPart());
            org.w3c.dom.Element element2 = this.docHolder.createElement("complexContent");
            element.appendChild(element2);
            org.w3c.dom.Element element3 = this.docHolder.createElement("restriction");
            element2.appendChild(element3);
            element3.setAttribute("base", "soapenc:Array");
            org.w3c.dom.Element element4 = this.docHolder.createElement("attribute");
            element3.appendChild(element4);
            element4.setAttribute("ref", "soapenc:arrayType");
            element4.setAttribute("wsdl:arrayType", string2);
        } else {
            try {
                int n;
                if (Enum.class.isAssignableFrom(clazz)) {
                    this.writeJavaEnumType(qName, clazz);
                } else if (Types.isEnumClass(clazz)) {
                    this.writeEnumType(qName, clazz);
                } else {
                    serializer.writeSchema(this);
                }
                Class[] classArray = ClassUtils.getDependencies(clazz);
                int n2 = n = classArray == null ? 0 : classArray.length;
                for (int i = 0; i < n; ++i) {
                    this.writeType(classArray[i]);
                }
            }
            catch (Exception exception) {
                throw new AxisFault(Messages.getMessage("writeSchemaProblem00", clazz.getName()), exception);
            }
        }
        return string3;
    }

    public static boolean isEnumClass(Class clazz) {
        block6: {
            if (Enum.class.isAssignableFrom(clazz)) {
                return true;
            }
            Method method = clazz.getMethod("getValue", null);
            Method method2 = clazz.getMethod("toString", null);
            if (method == null || method2 == null) break block6;
            Method method3 = clazz.getDeclaredMethod("fromString", String.class);
            Method method4 = clazz.getDeclaredMethod("fromValue", method.getReturnType());
            if (method3 == null || !Modifier.isStatic(method3.getModifiers()) || !Modifier.isPublic(method3.getModifiers()) || method4 == null || !Modifier.isStatic(method4.getModifiers()) || !Modifier.isPublic(method4.getModifiers())) break block6;
            try {
                return clazz.getMethod("setValue", method.getReturnType()) == null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private void writeEnumType(QName qName, Class clazz) throws NoSuchMethodException, IllegalAccessException, AxisFault {
        if (!Types.isEnumClass(clazz)) {
            return;
        }
        Method method = clazz.getMethod("getValue", null);
        Class<?> clazz2 = method.getReturnType();
        org.w3c.dom.Element element = this.docHolder.createElement("simpleType");
        this.writeSchemaElement(qName, element);
        element.setAttribute("name", qName.getLocalPart());
        org.w3c.dom.Element element2 = this.docHolder.createElement("restriction");
        element.appendChild(element2);
        String string = this.writeType(clazz2, null);
        element2.setAttribute("base", string);
        org.w3c.dom.Element element3 = this.docHolder.createElement("enumeration");
        element3.setAttribute("value", "_null");
        element2.appendChild(element3);
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n = field.getModifiers();
            if (!Modifier.isPublic(n) || !Modifier.isStatic(n) || !Modifier.isFinal(n) || field.getType() != clazz2) continue;
            org.w3c.dom.Element element4 = this.docHolder.createElement("enumeration");
            element4.setAttribute("value", field.get(null).toString());
            element2.appendChild(element4);
        }
    }

    private void writeJavaEnumType(QName qName, Class clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, AxisFault {
        org.w3c.dom.Element element = this.docHolder.createElement("simpleType");
        this.writeSchemaElement(qName, element);
        element.setAttribute("name", qName.getLocalPart());
        org.w3c.dom.Element element2 = this.docHolder.createElement("restriction");
        element.appendChild(element2);
        Class<String> clazz2 = String.class;
        String string = this.writeType(clazz2, null);
        element2.setAttribute("base", string);
        org.w3c.dom.Element element3 = this.docHolder.createElement("enumeration");
        element3.setAttribute("value", "_null");
        element2.appendChild(element3);
        Object[] objectArray = (Object[])clazz.getMethod("values", null).invoke(null, null);
        for (int i = 0; i < objectArray.length; ++i) {
            org.w3c.dom.Element element4 = this.docHolder.createElement("enumeration");
            element4.setAttribute("value", objectArray[i].toString());
            element2.appendChild(element4);
        }
    }

    private org.w3c.dom.Element createElementDecl(QName qName, String string, boolean bl) {
        if (!this.addToElementsList(qName)) {
            return null;
        }
        org.w3c.dom.Element element = this.docHolder.createElement("element");
        element.setAttribute("name", qName.getLocalPart());
        if (bl) {
            element.setAttribute("nillable", "true");
        }
        element.setAttribute("type", string);
        return element;
    }

    public org.w3c.dom.Element createElement(String string, String string2, boolean bl, boolean bl2, Document document) {
        org.w3c.dom.Element element = document.createElement("element");
        element.setAttribute("name", string);
        if (bl) {
            element.setAttribute("nillable", "true");
        }
        if (bl2) {
            element.setAttribute("minOccurs", "0");
            element.setAttribute("maxOccurs", "1");
        }
        element.setAttribute("type", string2);
        return element;
    }

    public org.w3c.dom.Element createAttributeElement(String string, String string2, boolean bl, Document document) {
        org.w3c.dom.Element element = document.createElement("attribute");
        element.setAttribute("name", string);
        if (bl) {
            element.setAttribute("nillable", "true");
        }
        element.setAttribute("type", string2);
        return element;
    }

    boolean isSimpleType(Class clazz) {
        QName qName = this.tm.getTypeQName(clazz);
        if (qName == null) {
            return false;
        }
        String string = qName.getNamespaceURI();
        return Constants.isSchemaXSD(string) || Constants.isSOAP_ENC(string);
    }

    public boolean isAcceptableAsAttribute(Class clazz) {
        return this.isSimpleType(clazz) || Types.isEnumClass(clazz) || this.implementsSimpleType(clazz);
    }

    boolean implementsSimpleType(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] != SimpleType.class) continue;
            return true;
        }
        return false;
    }

    private boolean addToTypesList(QName qName) {
        boolean bl = false;
        ArrayList<String> arrayList = (ArrayList<String>)this.schemaTypes.get(qName.getNamespaceURI());
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            arrayList.add(qName.getLocalPart());
            this.schemaTypes.put(qName.getNamespaceURI(), arrayList);
            bl = true;
        } else if (!arrayList.contains(qName.getLocalPart())) {
            arrayList.add(qName.getLocalPart());
            bl = true;
        }
        if (bl) {
            String string = this.namespaces.getCreatePrefix(qName.getNamespaceURI());
            return !string.equals("soapenv") && !string.equals("soapenc") && !string.equals("xsd") && !string.equals("wsdl") && !string.equals("wsdlsoap");
        }
        return false;
    }

    private boolean addToElementsList(QName qName) {
        if (qName == null) {
            return false;
        }
        boolean bl = false;
        ArrayList<String> arrayList = (ArrayList<String>)this.schemaElementNames.get(qName.getNamespaceURI());
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            arrayList.add(qName.getLocalPart());
            this.schemaElementNames.put(qName.getNamespaceURI(), arrayList);
            bl = true;
        } else if (!arrayList.contains(qName.getLocalPart())) {
            arrayList.add(qName.getLocalPart());
            bl = true;
        }
        return bl;
    }

    public boolean isNullable(Class clazz) {
        return !clazz.isPrimitive() && (!clazz.isArray() || clazz.getComponentType() != Byte.TYPE);
    }

    private void createDocumentFragment() {
        this.docHolder = XMLUtils.newDocument();
    }

    public void insertTypesFragment(Document document) {
        if (this.wsdlTypesElem != null) {
            Node node = document.importNode(this.wsdlTypesElem, true);
            document.getDocumentElement().insertBefore(node, document.getDocumentElement().getFirstChild());
        }
    }

    public List getStopClasses() {
        return this.stopClasses;
    }

    public org.w3c.dom.Element createElement(String string) {
        return this.docHolder.createElement(string);
    }

    protected boolean isBeanCompatible(Class clazz, boolean bl) {
        Class clazz2;
        if (clazz.isArray() || clazz.isPrimitive()) {
            if (bl && !this.beanCompatErrs.contains(clazz)) {
                LOGGER.warn((Object)Messages.getMessage("beanCompatType00", clazz.getName()));
                this.beanCompatErrs.add(clazz);
            }
            return false;
        }
        if (clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.")) {
            if (bl && !this.beanCompatErrs.contains(clazz)) {
                LOGGER.warn((Object)Messages.getMessage("beanCompatPkg00", clazz.getName()));
                this.beanCompatErrs.add(clazz);
            }
            return false;
        }
        if (JavaUtils.isEnumClass(clazz)) {
            return true;
        }
        if (!Throwable.class.isAssignableFrom(clazz)) {
            try {
                clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (bl && !this.beanCompatErrs.contains(clazz)) {
                    LOGGER.warn((Object)Messages.getMessage("beanCompatConstructor00", clazz.getName()));
                    this.beanCompatErrs.add(clazz);
                }
                return false;
            }
        }
        if (!((clazz2 = clazz.getSuperclass()) == null || clazz2 == Object.class || clazz2 == Exception.class || clazz2 == Throwable.class || clazz2 == RemoteException.class || clazz2 == AxisFault.class || this.stopClasses != null && this.stopClasses.contains(clazz2.getName()) || this.isBeanCompatible(clazz2, false))) {
            if (bl && !this.beanCompatErrs.contains(clazz)) {
                LOGGER.warn((Object)Messages.getMessage("beanCompatExtends00", clazz.getName(), clazz2.getName(), clazz.getName()));
                this.beanCompatErrs.add(clazz);
            }
            return false;
        }
        return true;
    }
}

