/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionTE;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBeanHelperWriter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaStubWriter
extends JavaClassWriter {
    private BindingEntry bEntry;
    private Binding binding;
    private SymbolTable symbolTable;

    protected JavaStubWriter(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        super(emitter, bindingEntry.getName() + "Stub", "stub");
        this.bEntry = bindingEntry;
        this.binding = bindingEntry.getBinding();
        this.symbolTable = symbolTable;
    }

    @Override
    protected String getExtendsText() {
        return "extends org.apache.axis.client.Stub ";
    }

    @Override
    protected String getImplementsText() {
        return "implements " + this.bEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME) + " ";
    }

    @Override
    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        PortType portType = this.binding.getPortType();
        HashSet hashSet = this.getTypesInPortType(portType);
        boolean bl = Utils.hasMIME(this.bEntry);
        if (!hashSet.isEmpty() || bl) {
            printWriter.println("    private java.util.Vector cachedSerClasses = new java.util.Vector();");
            printWriter.println("    private java.util.Vector cachedSerQNames = new java.util.Vector();");
            printWriter.println("    private java.util.Vector cachedSerFactories = new java.util.Vector();");
            printWriter.println("    private java.util.Vector cachedDeserFactories = new java.util.Vector();");
        }
        printWriter.println();
        printWriter.println("    public " + this.className + "() throws org.apache.axis.AxisFault {");
        printWriter.println("         this(null);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public " + this.className + "(java.net.URL endpointURL, javax.xml.rpc.Service service) throws org.apache.axis.AxisFault {");
        printWriter.println("         this(service);");
        printWriter.println("         super.cachedEndpoint = endpointURL;");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    private void addSerial(String xmlns, String localname, java.lang.Class cls, Object serializer, Object deserializer)");
        printWriter.println("    {");
        printWriter.println("        cachedSerQNames.add(new javax.xml.namespace.QName(xmlns, localname));");
        printWriter.println("        cachedSerClasses.add(cls);");
        printWriter.println("        cachedSerFactories.add(serializer);");
        printWriter.println("        cachedDeserFactories.add(deserializer);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    public " + this.className + "(javax.xml.rpc.Service service) throws org.apache.axis.AxisFault {");
        printWriter.println("        if (service == null) {");
        printWriter.println("            super.service = new org.apache.axis.client.Service();");
        printWriter.println("        } else {");
        printWriter.println("            super.service = service;");
        printWriter.println("        }");
        int n = 0;
        if (!hashSet.isEmpty()) {
            for (TypeEntry typeEntry : hashSet) {
                if (typeEntry.getBaseType() != null && typeEntry.getRefType() == null || typeEntry instanceof CollectionTE || typeEntry instanceof Element || !typeEntry.isReferenced() || typeEntry.isOnlyLiteralReferenced()) continue;
                if (n == 0) {
                    this.writeSerializationDecls(printWriter, bl, this.binding.getQName().getNamespaceURI());
                }
                this.writeSerializationInit(printWriter, typeEntry);
                ++n;
            }
        }
        if (n == 0 && bl) {
            this.writeSerializationDecls(printWriter, bl, this.binding.getQName().getNamespaceURI());
            ++n;
        }
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    protected org.apache.axis.client.Call createCall() throws java.rmi.RemoteException {");
        printWriter.println("        try {");
        printWriter.println("            org.apache.axis.client.Call _call =");
        printWriter.println("                    (org.apache.axis.client.Call) super.service.createCall();");
        printWriter.println("            if (super.maintainSessionSet) {");
        printWriter.println("                _call.setMaintainSession(super.maintainSession);");
        printWriter.println("            }");
        printWriter.println("            if (super.cachedUsername != null) {");
        printWriter.println("                _call.setUsername(super.cachedUsername);");
        printWriter.println("            }");
        printWriter.println("            if (super.cachedPassword != null) {");
        printWriter.println("                _call.setPassword(super.cachedPassword);");
        printWriter.println("            }");
        printWriter.println("            if (super.cachedEndpoint != null) {");
        printWriter.println("                _call.setTargetEndpointAddress(super.cachedEndpoint);");
        printWriter.println("            }");
        printWriter.println("            if (super.cachedTimeout != null) {");
        printWriter.println("                _call.setTimeout(super.cachedTimeout);");
        printWriter.println("            }");
        printWriter.println("            if (super.cachedPortName != null) {");
        printWriter.println("                _call.setPortName(super.cachedPortName);");
        printWriter.println("            }");
        printWriter.println("            java.util.Enumeration keys = super.cachedProperties.keys();");
        printWriter.println("            while (keys.hasMoreElements()) {");
        printWriter.println("                java.lang.String key = (java.lang.String) keys.nextElement();");
        printWriter.println("                if(_call.isPropertySupported(key))");
        printWriter.println("                    _call.setProperty(key, super.cachedProperties.get(key));");
        printWriter.println("                else");
        printWriter.println("                    _call.setScopedProperty(key, super.cachedProperties.get(key));");
        printWriter.println("            }");
        if (n > 0) {
            printWriter.println("            // " + Messages.getMessage("typeMap00"));
            printWriter.println("            // " + Messages.getMessage("typeMap01"));
            printWriter.println("            // " + Messages.getMessage("typeMap02"));
            printWriter.println("            // " + Messages.getMessage("typeMap03"));
            printWriter.println("            // " + Messages.getMessage("typeMap04"));
            printWriter.println("            synchronized (this) {");
            printWriter.println("                if (firstCall()) {");
            printWriter.println("                    // " + Messages.getMessage("mustSetStyle"));
            if (this.bEntry.hasLiteral()) {
                printWriter.println("                    _call.setEncodingStyle(null);");
            } else {
                printWriter.println("                    _call.setEncodingStyle(org.apache.axis.Constants.URI_SOAP11_ENC);");
            }
            printWriter.println("                    for (int i = 0; i < cachedSerFactories.size(); ++i) {");
            printWriter.println("                        java.lang.Class cls = (java.lang.Class) cachedSerClasses.get(i);");
            printWriter.println("                        javax.xml.namespace.QName qName =");
            printWriter.println("                                (javax.xml.namespace.QName) cachedSerQNames.get(i);");
            printWriter.println("                        java.lang.Class sf = (java.lang.Class)");
            printWriter.println("                                 cachedSerFactories.get(i);");
            printWriter.println("                        java.lang.Class df = (java.lang.Class)");
            printWriter.println("                                 cachedDeserFactories.get(i);");
            printWriter.println("                        _call.registerTypeMapping(cls, qName, sf, df, false);");
            printWriter.println("                    }");
            printWriter.println("                }");
            printWriter.println("            }");
        }
        printWriter.println("            return _call;");
        printWriter.println("        }");
        printWriter.println("        catch (java.lang.Throwable t) {");
        printWriter.println("            throw new org.apache.axis.AxisFault(\"" + Messages.getMessage("badCall01") + "\", t);");
        printWriter.println("        }");
        printWriter.println("    }");
        printWriter.println();
        List list = this.binding.getBindingOperations();
        for (int i = 0; i < list.size(); ++i) {
            OperationType operationType;
            Object object2;
            BindingOperation bindingOperation = (BindingOperation)list.get(i);
            Parameters parameters = this.bEntry.getParameters(bindingOperation.getOperation());
            String string = "";
            String string2 = null;
            for (Object object2 : bindingOperation.getExtensibilityElements()) {
                if (!(object2 instanceof SOAPOperation)) continue;
                string = ((SOAPOperation)object2).getSoapActionURI();
                string2 = ((SOAPOperation)object2).getStyle();
                break;
            }
            if ((operationType = (object2 = bindingOperation.getOperation()).getStyle()) == OperationType.NOTIFICATION || operationType == OperationType.SOLICIT_RESPONSE) {
                printWriter.println(parameters.signature);
                printWriter.println();
                continue;
            }
            this.writeOperation(printWriter, bindingOperation, parameters, string, string2, operationType == OperationType.ONE_WAY);
        }
    }

    private HashSet getTypesInPortType(PortType portType) {
        HashSet<Operation> hashSet = new HashSet<Operation>();
        HashSet hashSet2 = new HashSet();
        List list = portType.getOperations();
        for (int i = 0; i < list.size(); ++i) {
            Object object = (Operation)list.get(i);
            hashSet2.addAll(this.getTypesInOperation((Operation)object));
        }
        for (Object object : hashSet2) {
            if (hashSet.contains(object)) continue;
            hashSet.add((Operation)object);
            hashSet.addAll(Utils.getNestedTypes((TypeEntry)object, this.symbolTable, true));
        }
        return hashSet;
    }

    private HashSet getTypesInOperation(Operation operation) {
        Map map;
        HashSet hashSet = new HashSet();
        Vector<TypeEntry> vector = new Vector<TypeEntry>();
        Parameters parameters = this.bEntry.getParameters(operation);
        for (int i = 0; i < parameters.list.size(); ++i) {
            Parameter parameter = (Parameter)parameters.list.get(i);
            vector.add(parameter.getType());
        }
        if (parameters.returnParam != null) {
            vector.add(parameters.returnParam.getType());
        }
        if ((map = operation.getFaults()) != null) {
            for (Fault fault : map.values()) {
                this.partTypes(vector, fault.getMessage().getOrderedParts(null), this.bEntry.getFaultBodyType(operation, fault.getName()) == 1);
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            hashSet.add(vector.get(i));
        }
        return hashSet;
    }

    private void partTypes(Vector vector, Collection collection, boolean bl) {
        for (Part part : collection) {
            QName qName = part.getTypeName();
            if (qName != null) {
                vector.add(this.symbolTable.getType(qName));
                continue;
            }
            qName = part.getElementName();
            if (qName == null) continue;
            vector.add(this.symbolTable.getElement(qName));
        }
    }

    private void writeSerializationDecls(PrintWriter printWriter, boolean bl, String string) {
        printWriter.println("            java.lang.Class cls;");
        printWriter.println("            javax.xml.namespace.QName qName;");
        printWriter.println("            java.lang.Class beansf = " + JavaBeanHelperWriter.DEFAULT_BEAN_SERIALIZER + "Factory.class;");
        printWriter.println("            java.lang.Class beandf = org.apache.axis.encoding.ser.BeanDeserializerFactory.class;");
        printWriter.println("            java.lang.Class enumsf = org.apache.axis.encoding.ser.EnumSerializerFactory.class;");
        printWriter.println("            java.lang.Class enumdf = org.apache.axis.encoding.ser.EnumDeserializerFactory.class;");
        printWriter.println("            java.lang.Class arraysf = org.apache.axis.encoding.ser.ArraySerializerFactory.class;");
        printWriter.println("            java.lang.Class arraydf = org.apache.axis.encoding.ser.ArrayDeserializerFactory.class;");
        printWriter.println("            java.lang.Class simplesf = org.apache.axis.encoding.ser.SimpleSerializerFactory.class;");
        printWriter.println("            java.lang.Class simpledf = org.apache.axis.encoding.ser.SimpleDeserializerFactory.class;");
        printWriter.println();
        if (bl) {
            printWriter.println("            java.lang.Class mimesf = org.apache.axis.encoding.ser.JAFDataHandlerSerializerFactory.class;");
            printWriter.println("            java.lang.Class mimedf = org.apache.axis.encoding.ser.JAFDataHandlerDeserializerFactory.class;");
            printWriter.println();
            QName qName = new QName(string, "DataHandler");
            printWriter.println("            qName = new javax.xml.namespace.QName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
            printWriter.println("            cachedSerQNames.add(qName);");
            printWriter.println("            cachedSerClasses.add(javax.activation.DataHandler.class);");
            printWriter.println("            cachedSerFactories.add(mimesf);");
            printWriter.println("            cachedDeserFactories.add(mimedf);");
            printWriter.println();
        }
    }

    private void writeSerializationInit(PrintWriter printWriter, TypeEntry typeEntry) throws IOException {
        String string;
        String string2;
        QName qName = typeEntry.getQName();
        if (typeEntry.getName().endsWith("[]")) {
            string2 = "arraysf";
            string = "arraydf";
        } else if (typeEntry.getNode() != null && Utils.getEnumerationBaseAndValues(typeEntry.getNode(), this.symbolTable) != null) {
            string2 = "enumsf";
            string = "enumdf";
        } else if (typeEntry.isSimpleType()) {
            string2 = "simplesf";
            string = "simpledf";
        } else if (typeEntry.getBaseType() != null) {
            string2 = "null";
            string = "simpledf";
        } else {
            string2 = "beansf";
            string = "beandf";
        }
        printWriter.println("        addSerial(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\",");
        printWriter.println("            " + typeEntry.getName() + ".class, " + string2 + ", " + string + ");");
        printWriter.println();
    }

    private void writeOperation(PrintWriter printWriter, BindingOperation bindingOperation, Parameters parameters, String string, String string2, boolean bl) throws IOException {
        Object object;
        Object object2;
        String string3;
        String string4;
        Object object3;
        this.writeComment(printWriter, bindingOperation.getDocumentationElement());
        printWriter.println(parameters.signature + " {");
        printWriter.println("        if (super.cachedEndpoint == null) {");
        printWriter.println("            throw new org.apache.axis.NoEndPointException();");
        printWriter.println("        }");
        printWriter.println("        org.apache.axis.client.Call _call = createCall();");
        for (int i = 0; i < parameters.list.size(); ++i) {
            object3 = (Parameter)parameters.list.get(i);
            string4 = ((Parameter)object3).getMIMEType();
            QName qName = Utils.getXSIType((Parameter)object3);
            string3 = null;
            string3 = string4 != null ? "javax.activation.DataHandler.class, " : ((string3 = ((Parameter)object3).getType().getName()) != null ? string3 + ".class, " : "");
            object2 = Utils.getNewQName(((Parameter)object3).getQName());
            object = Utils.getNewQName(qName);
            if (((Parameter)object3).getMode() == 1) {
                printWriter.println("        _call.addParameter(" + (String)object2 + ", " + (String)object + ", " + string3 + "javax.xml.rpc.ParameterMode.IN);");
                continue;
            }
            if (((Parameter)object3).getMode() == 3) {
                printWriter.println("        _call.addParameter(" + (String)object2 + ", " + (String)object + ", " + string3 + "javax.xml.rpc.ParameterMode.INOUT);");
                continue;
            }
            printWriter.println("        _call.addParameter(" + (String)object2 + ", " + (String)object + ", " + string3 + "javax.xml.rpc.ParameterMode.OUT);");
        }
        if (parameters.returnParam != null) {
            QName qName = Utils.getXSIType(parameters.returnParam);
            object3 = null;
            object3 = parameters.returnParam.getMIMEType() != null ? "javax.activation.DataHandler" : parameters.returnParam.getType().getName();
            if (object3 == null) {
                printWriter.println("        _call.setReturnType(" + Utils.getNewQName(qName) + ");");
            } else {
                printWriter.println("        _call.setReturnType(" + Utils.getNewQName(qName) + ", " + (String)object3 + ".class);");
            }
        } else {
            printWriter.println("        _call.setReturnType(org.apache.axis.encoding.XMLType.AXIS_VOID);");
        }
        if (string != null) {
            printWriter.println("        _call.setUseSOAPAction(true);");
            printWriter.println("        _call.setSOAPActionURI(\"" + string + "\");");
        }
        boolean bl2 = Utils.hasMIME(this.bEntry, bindingOperation);
        int n = this.bEntry.getInputBodyType(bindingOperation.getOperation());
        if (n == 1) {
            printWriter.println("        _call.setEncodingStyle(null);");
            printWriter.println("        _call.setScopedProperty(org.apache.axis.client.Call.SEND_TYPE_ATTR, Boolean.FALSE);");
        }
        if (bl2 || n == 1) {
            printWriter.println("        _call.setScopedProperty(org.apache.axis.AxisEngine.PROP_DOMULTIREFS, Boolean.FALSE);");
        }
        if ((string4 = string2) == null) {
            string4 = "rpc";
            int n2 = this.bEntry.getBindingStyle();
            if (n2 == 1) {
                string4 = "document";
            }
        }
        if ("document".equals(string4) && this.symbolTable.isWrapped()) {
            string4 = "wrapped";
        }
        if (!bl2) {
            printWriter.println("        _call.setOperationStyle(\"" + string4 + "\");");
        }
        if ("wrapped".equals(string4)) {
            Map map = bindingOperation.getOperation().getInput().getMessage().getParts();
            string3 = (Part)map.values().iterator().next();
            object2 = string3.getElementName();
            printWriter.println("        _call.setOperationName(" + Utils.getNewQName((QName)object2) + ");");
            if (parameters.returnParam != null && (object = parameters.returnParam.getQName()) != null) {
                printWriter.println("        _call.setReturnQName(" + Utils.getNewQName((QName)object) + ");");
            }
        } else {
            QName qName = Utils.getOperationQName(bindingOperation);
            if (qName != null) {
                printWriter.println("        _call.setOperationName(" + Utils.getNewQName(qName) + ");");
            }
        }
        printWriter.println();
        if (bl) {
            printWriter.print("        _call.invokeOneWay(");
        } else {
            printWriter.print("        java.lang.Object _resp = _call.invoke(");
        }
        printWriter.print("new java.lang.Object[] {");
        this.writeParameters(printWriter, parameters);
        printWriter.println("});");
        printWriter.println();
        if (!bl) {
            this.writeResponseHandling(printWriter, parameters);
        }
        printWriter.println("    }");
        printWriter.println();
    }

    private void writeParameters(PrintWriter printWriter, Parameters parameters) {
        boolean bl = false;
        for (int i = 0; i < parameters.list.size(); ++i) {
            Parameter parameter = (Parameter)parameters.list.get(i);
            if (parameter.getMode() == 2) continue;
            if (bl) {
                printWriter.print(", ");
            } else {
                bl = true;
            }
            String string = Utils.xmlNameToJava(parameter.getName());
            if (parameter.getMode() != 1) {
                string = string + ".value";
            }
            if (parameter.getMIMEType() == null) {
                string = Utils.wrapPrimitiveType(parameter.getType(), string);
            }
            printWriter.print(string);
        }
    }

    private void writeResponseHandling(PrintWriter printWriter, Parameters parameters) {
        printWriter.println("        if (_resp instanceof java.rmi.RemoteException) {");
        printWriter.println("            throw (java.rmi.RemoteException)_resp;");
        printWriter.println("        }");
        int n = parameters.outputs + parameters.inouts;
        if (n > 0) {
            printWriter.println("        else {");
            if (n == 1) {
                if (parameters.returnParam != null) {
                    this.writeOutputAssign(printWriter, "return ", parameters.returnParam.getType(), parameters.returnParam.getMIMEType(), "_resp");
                } else {
                    int n2 = 0;
                    Parameter parameter = (Parameter)parameters.list.get(n2);
                    while (parameter.getMode() == 1) {
                        parameter = (Parameter)parameters.list.get(++n2);
                    }
                    String string = Utils.xmlNameToJava(parameter.getName());
                    String string2 = Utils.getNewQName(parameter.getQName());
                    printWriter.println("            java.util.Map _output;");
                    printWriter.println("            _output = _call.getOutputParams();");
                    this.writeOutputAssign(printWriter, string + ".value = ", parameter.getType(), parameter.getMIMEType(), "_output.get(" + string2 + ")");
                }
            } else {
                printWriter.println("            java.util.Map _output;");
                printWriter.println("            _output = _call.getOutputParams();");
                for (int i = 0; i < parameters.list.size(); ++i) {
                    Parameter parameter = (Parameter)parameters.list.get(i);
                    String string = Utils.xmlNameToJava(parameter.getName());
                    String string3 = Utils.getNewQName(parameter.getQName());
                    if (parameter.getMode() == 1) continue;
                    this.writeOutputAssign(printWriter, string + ".value = ", parameter.getType(), parameter.getMIMEType(), "_output.get(" + string3 + ")");
                }
                if (parameters.returnParam != null) {
                    this.writeOutputAssign(printWriter, "return ", parameters.returnParam.getType(), parameters.returnParam.getMIMEType(), "_resp");
                }
            }
            printWriter.println("        }");
        }
    }

    private void writeOutputAssign(PrintWriter printWriter, String string, TypeEntry typeEntry, String string2, String string3) {
        if (typeEntry != null && typeEntry.getName() != null) {
            printWriter.println("            try {");
            printWriter.println("                " + string + Utils.getResponseString(typeEntry, string2, string3));
            printWriter.println("            } catch (java.lang.Exception _exception) {");
            printWriter.println("                " + string + Utils.getResponseString(typeEntry, string2, "org.apache.axis.utils.JavaUtils.convert(" + string3 + ", " + typeEntry.getName() + ".class)"));
            printWriter.println("            }");
        } else {
            printWriter.println("              " + string + Utils.getResponseString(typeEntry, string2, string3));
        }
    }
}

