/*
 * Decompiled with CFR 0.152.
 */
package com.actional.soapapi.soapstation;

import com.actional.config.Blob;
import com.actional.soapapi.Util;
import com.actional.soapapi.soapstation.SSTTask;
import com.actional.soapstation.db.Endpoint;
import com.actional.soapstation.db.JmsEndpoint;
import com.actional.soapstation.task.ParseOptions;
import com.actional.soapstation.task.WsdlBindingDef;
import com.actional.soapstation.task.WsdlContentDef;
import com.actional.soapstation.task.WsdlHttpPortDef;
import com.actional.soapstation.task.WsdlJmsPortDef;
import com.actional.soapstation.task.WsdlPortDef;
import com.actional.soapstation.task.WsifJmsAddress;
import com.actional.ws.db.WsMetadata;
import com.actional.ws.db.WsResource;
import java.util.ArrayList;
import java.util.List;

public class WsdlTask
extends SSTTask {
    public WsdlContentDef parseWsdl(String string) throws Exception {
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setMetadata(new WsMetadata());
        parseOptions.getMetadata().setLocation(string);
        parseOptions.setReturnMetadata(true);
        parseOptions.setReturnXmlTypes(false);
        return this.config().wsdlTask.parse(parseOptions);
    }

    public WsdlContentDef parseWsdl(byte[] byArray) throws Exception {
        Blob blob = new Blob();
        blob.setBytes(byArray);
        WsResource wsResource = new WsResource();
        wsResource.setContent(blob);
        WsMetadata wsMetadata = new WsMetadata();
        wsMetadata.setResources(new WsResource[1]);
        wsMetadata.getResources()[0] = wsResource;
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setMetadata(wsMetadata);
        parseOptions.setReturnMetadata(true);
        parseOptions.setReturnXmlTypes(false);
        WsdlContentDef wsdlContentDef = this.config().wsdlTask.parse(parseOptions);
        return wsdlContentDef;
    }

    public List expandPortsFromBindings(WsdlBindingDef[] wsdlBindingDefArray) throws Exception {
        int n = Util.length(wsdlBindingDefArray);
        if (n == 0) {
            return null;
        }
        ArrayList<WsdlBindingPortDef> arrayList = new ArrayList<WsdlBindingPortDef>();
        for (int i = 0; i < n; ++i) {
            WsdlBindingDef wsdlBindingDef = wsdlBindingDefArray[i];
            Object[] objectArray = wsdlBindingDef.getPorts();
            int n2 = Util.length(objectArray);
            for (int j = 0; j < n2; ++j) {
                Object object = objectArray[j];
                arrayList.add(new WsdlBindingPortDef(wsdlBindingDef, (WsdlPortDef)object));
            }
        }
        return arrayList;
    }

    public Endpoint buildEndpoint(WsdlPortDef wsdlPortDef) throws Exception {
        WsdlJmsPortDef wsdlJmsPortDef;
        if (wsdlPortDef instanceof WsdlHttpPortDef) {
            Endpoint endpoint = new Endpoint();
            endpoint.setAddress(((WsdlHttpPortDef)wsdlPortDef).getLocation());
            return endpoint;
        }
        if (wsdlPortDef instanceof WsdlJmsPortDef && (wsdlJmsPortDef = (WsdlJmsPortDef)wsdlPortDef).getWsifAddress() != null) {
            WsifJmsAddress wsifJmsAddress = wsdlJmsPortDef.getWsifAddress();
            JmsEndpoint jmsEndpoint = new JmsEndpoint();
            jmsEndpoint.setInitCxtFact(wsifJmsAddress.getInitCxtFact());
            jmsEndpoint.setJndiProvURL(wsifJmsAddress.getJndiProvURL());
            jmsEndpoint.setDestStyle(wsifJmsAddress.getDestStyle());
            jmsEndpoint.setJndiConnFactName(wsifJmsAddress.getJndiConnFactName());
            jmsEndpoint.setJndiDestName(wsifJmsAddress.getJndiDestName());
            jmsEndpoint.setProperties(wsifJmsAddress.getProperties());
            return jmsEndpoint;
        }
        throw new Exception("Failed to build endpoint: " + wsdlPortDef);
    }

    public static class WsdlBindingPortDef {
        public WsdlBindingDef binding;
        public WsdlPortDef port;

        public WsdlBindingPortDef(WsdlBindingDef wsdlBindingDef, WsdlPortDef wsdlPortDef) {
            this.binding = wsdlBindingDef;
            this.port = wsdlPortDef;
        }
    }
}

