/*
 * Decompiled with CFR 0.152.
 */
package com.actional.soapapi;

import com.actional.config.BaseData;
import com.actional.config.IDObjectHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class Util {
    static final IDObjectHolder IDOBJECT_ANY;
    public static final int BD_PUBLISHED = 2;
    public static final int BD_LEAF = 4;
    public static final int BD_NULL = 8;
    public static final int BD_EXPLICIT_NULL = 16384;
    public static final Comparator COMPARATOR_BASEDATA_KEYNAME;

    private Util() {
    }

    public static boolean isBitSet(Integer n, int n2) {
        if (n == null) {
            return false;
        }
        return (n & n2) != 0;
    }

    public static boolean isBitSet(BaseData baseData, int n) {
        return Util.isBitSet(baseData.getCode(), n);
    }

    public static int bitSet(Integer n, int n2) {
        if (n == null) {
            return n2;
        }
        return n | n2;
    }

    public static void setCode(BaseData baseData, int n) {
        baseData.setCode(new Integer(Util.bitSet(baseData.getCode(), n)));
    }

    public static void setAsPublished(BaseData baseData) {
        Util.setCode(baseData, 2);
    }

    public static void setAsNull(BaseData baseData) {
        Util.setCode(baseData, 8);
    }

    public static void setAsExplicitNull(BaseData baseData) {
        Util.setCode(baseData, 16384);
    }

    public static void setAsLeaf(BaseData baseData) {
        Util.setCode(baseData, 4);
    }

    public static boolean isLeaf(BaseData baseData) {
        return Util.isBitSet(baseData.getCode(), 4);
    }

    public static BaseData createLeaf(BaseData baseData) throws Exception {
        BaseData baseData2 = (BaseData)baseData.getClass().newInstance();
        baseData2.setKeyID(baseData.getKeyID());
        Util.setAsLeaf(baseData2);
        return baseData2;
    }

    public static String getKeyID(BaseData baseData) throws Exception {
        if (baseData == null) {
            return null;
        }
        return baseData.getKeyID();
    }

    public static String getKeyName(BaseData baseData) throws Exception {
        if (baseData == null) {
            return null;
        }
        return baseData.getKeyName();
    }

    public static boolean isBlank(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isBlank(BaseData baseData) {
        return baseData == null || Util.isBitSet(baseData, 8);
    }

    public static boolean isBlank(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static boolean isBlank(byte[] byArray) {
        return byArray == null || byArray.length == 0;
    }

    public static boolean isBlank(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean equals(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static int length(Object[] objectArray) {
        return objectArray == null ? 0 : objectArray.length;
    }

    public static int size(Collection collection) {
        return collection == null ? 0 : collection.size();
    }

    public static Object[] merge(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null || objectArray.length == 0) {
            return (Object[])objectArray2.clone();
        }
        if (objectArray2 == null || objectArray2.length == 0) {
            return (Object[])objectArray.clone();
        }
        List<Object> list = Arrays.asList(objectArray);
        List<Object> list2 = Arrays.asList(objectArray2);
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll(list);
        hashSet.addAll(list2);
        Object[] objectArray3 = (Object[])Array.newInstance(objectArray[0].getClass(), hashSet.size());
        return hashSet.toArray(objectArray3);
    }

    public static String[] extractKeyIDs(BaseData[] baseDataArray) {
        if (Util.isBlank(baseDataArray)) {
            return null;
        }
        String[] stringArray = new String[baseDataArray.length];
        for (int i = 0; i < baseDataArray.length; ++i) {
            stringArray[i] = baseDataArray[i].getKeyID();
        }
        return stringArray;
    }

    public static byte[] readFileAsBytes(String string) throws IOException {
        return Util.readFileAsBytes(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileAsBytes(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int n;
            int n2 = (int)file.length();
            byte[] byArray = new byte[n2];
            int n3 = 0;
            for (int i = n2; i > 0; i -= n) {
                n = fileInputStream.read(byArray, n3, i);
                if (n < 0) {
                    throw new IOException("Prematured end of request. Expected " + n2 + " bytes, received " + n3 + " bytes.");
                }
                n3 += n;
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    public static boolean booleanValue(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public static Boolean BooleanValue(boolean bl) {
        if (bl) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String toString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static Manifest loadManifest(Class clazz) throws Exception {
        String string = clazz.getName();
        string = string.replace('.', '/');
        string = "/" + string + ".class";
        URL uRL = clazz.getResource(string);
        if (uRL == null) {
            throw new Exception("Failed to find resource: " + string);
        }
        String string2 = uRL.toString();
        if (!string2.endsWith(string)) {
            throw new Exception("Resource URL for '" + string2 + "' does not end with: " + string);
        }
        string2 = string2.substring(0, string2.length() - string.length());
        URL uRL2 = new URL(string2 = string2 + "/META-INF/MANIFEST.MF");
        InputStream inputStream = uRL2.openStream();
        if (inputStream == null) {
            throw new Exception("Failed to load resource: " + string2);
        }
        return new Manifest(inputStream);
    }

    public static String getTaskAPISpecificationVersion() throws Exception {
        return Util.getSpecificationVersion(BaseData.class);
    }

    public static String getSpecificationVersion(Class clazz) throws Exception {
        Object object;
        Manifest manifest = Util.loadManifest(clazz);
        Map<String, Attributes> map = manifest.getEntries();
        Iterator<String> iterator = null;
        if (map != null && (object = map.keySet()) != null) {
            iterator = object.iterator();
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (object == null || !((String)object).startsWith("com/actional/")) continue;
                Attributes attributes = manifest.getAttributes((String)object);
                return attributes.getValue("Specification-Version");
            }
        }
        return null;
    }

    static {
        IDObjectHolder iDObjectHolder = new IDObjectHolder();
        iDObjectHolder.setPath(new String[]{"*"});
        IDOBJECT_ANY = iDObjectHolder;
        COMPARATOR_BASEDATA_KEYNAME = new CompareBaseDataKeyName();
    }

    public static class CompareBaseDataKeyName
    implements Comparator {
        public static String getName(Object object) {
            if (object == null) {
                return "";
            }
            if (((BaseData)object).getKeyName() == null) {
                return "";
            }
            return ((BaseData)object).getKeyName();
        }

        public int compare(Object object, Object object2) {
            try {
                return CompareBaseDataKeyName.getName(object).compareTo(CompareBaseDataKeyName.getName(object2));
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }
}

