//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.anttask.soapstation;

import com.actional.soapapi.anttask.TaskBase;
import org.apache.tools.ant.types.Reference;
import com.actional.soapapi.soapstation.SSTTask;
import com.actional.soapapi.soapstation.SSTConfig;
import com.actional.soapapi.Config;

/** <!-- ========================================================================================================== -->
* Base class for actional ant tasks.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class SOAPstationTaskBase extends TaskBase
{
	//=============================================================================================================
	// The ant task Properties
	//=============================================================================================================

	private Reference itsSOAPstationRef;
	
	public void setSOAPstationRef(Reference val)		{ itsSOAPstationRef = val; }

	/** <!-- ================================================================================================== -->
	* Prepare the task in the SDK.
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	public SSTTask createTask(Class taskClass) throws Exception
	{
		return _getSSTConfig().createTask(taskClass);
	}

	/** <!-- ================================================================================================== -->
	* Locate the configuration to use when talking to SOAPstation.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public SSTConfig _getSSTConfig()
	{
		return (SSTConfig)_getConfig();
	}

	@Override
	protected Config _getConfig()
	{
		if (itsSOAPstationRef != null)
		{
			SOAPstationTask soapstation = (SOAPstationTask)itsSOAPstationRef.
									getReferencedObject(getProject());

			if (soapstation != null)
			{
				SSTConfig config = soapstation.getConfig();
				
				if (config != null)
					return config;
			}
		}

		return SOAPstationTask.getDefaultConfig();
	}
}
