//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.javaClient;

// From the Task API
import com.actional.ProductVersion;

// From the SDK
import com.actional.soapapi.Log;
import com.actional.soapapi.Util;
import com.actional.soapapi.Config;

/** <!-- ========================================================================================================== -->
* Base Class to simplify client developement.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class ClientBase
{
	protected Config	itsConfig;

	/** <!-- ================================================================================================== -->
	* Constructor
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected ClientBase(Config config)
	{
		itsConfig = config;
	}

	/** <!-- ================================================================================================== -->
	* Retrieve the logger to use.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected Log getLog()
	{
		return Log.getInstance();
	}

	/** <!-- ================================================================================================== -->
	* Is debugging turned on?
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected boolean debugOn()
	{
		return getLog().debugOn();
	}

	/** <!-- ================================================================================================== -->
	* Helper function to dump some info messages to the console.
	*
	* @param msg	The message to display.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected void debug(String msg)
	{
		debug(0, msg);
	}

	/** <!-- ================================================================================================== -->
	* Helper function to dump some info messages to the console.
	*
	* @param msg	The message to display.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected void debug(int indent, String msg)
	{
		getLog().debug(indent, msg);
	}

	/** <!-- ================================================================================================== -->
	* Helper function to dump some info messages to the console.
	*
	* @param msg	The message to display.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected void info(String msg)
	{
		info(0, msg);
	}

	/** <!-- ================================================================================================== -->
	* Helper function to dump some info messages to the console.
	*
	* @param msg	The message to display.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected void info(int indent, String msg)
	{
		getLog().info(indent, msg);
	}

	/** <!-- ================================================================================================== -->
	* Helper function to dump some info messages to the console.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected void infoField(String name, boolean val)
	{
		infoField(1, name, val);
	}

	/** <!-- ================================================================================================== -->
	* Helper function to dump some info messages to the console.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected void infoField(int indent, String name, boolean val)
	{
		infoField(indent, name, Util.BooleanValue(val));
	}

	/** <!-- ================================================================================================== -->
	* Helper function to dump some info messages to the console.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected void infoField(String name, Object val)
	{
		infoField(1, name, val);
	}

	/** <!-- ================================================================================================== -->
	* Helper function to dump some info messages to the console.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected void infoField(int indent, String name, Object val)
	{
		info(indent, name + ": " + Util.toString(val));
	}

	/** <!-- ================================================================================================== -->
	 * This is the method that performs the different actions.
	 * <!-- ------------------------------------------------------------------------------------------------- --> */

	public void init() throws Exception
	{
		itsConfig.setMaintainSession(true);

		if ("y".equals(Input.read("Would you like to impersonate another user", "n")))
		{
			String username = Input.read("UserName", "User_Admin");
			String role = Input.read("role", "Admin");
			String group = Input.read("group");

			itsConfig.setImpersonate(username, role, group);
		}

		itsConfig.init();
	}


	/** <!-- ================================================================================================== -->
	 * Display the version of the client and server.
	 * <!-- ------------------------------------------------------------------------------------------------- --> */

	protected void displayVersion() throws Exception
	{
		// Due to rebuilds, etc. we may have trouble picking up the client version.
		String taskAPIVersion = Util.getTaskAPISpecificationVersion();

		// Ask the server for information about its version.
		ProductVersion serverVersion = itsConfig.productInfoTask.getVersion();

		info("SDK Version is: " + taskAPIVersion);
		info("Server Version is: " + serverVersion.getLogicalVersion());
	}
}