//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.soapstation;

import java.io.File;
import java.io.FileOutputStream;

import com.actional.soapapi.Util;
import com.actional.soapstation.db.ExportItem;
import com.actional.soapstation.task.FileDefTO;
import com.actional.soapstation.task.ImportDef;

/** <!-- ========================================================================================================== -->
* Helper methods for deploying information
*
* @lastrev fix41664 - Fix the ExportResult BaseData structure
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class DeploymentTask extends SSTTask
{
	private static final String NO_FILES = "No files specified for import.";

	/** <!-- ================================================================================================== -->
	* Import the specified files from disk
	*
	* @lastrev fix41664 - Fix the ExportResult BaseData structure
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public String importCustom(final ImportDef info, final String[] files, final File baseDir) throws Exception
	{
		if (Util.isBlank(files))
			return NO_FILES;

		int 		numFiles = files.length;
		FileDefTO[]	importFiles = new FileDefTO[numFiles];

		for (int i = 0; i < numFiles; i++)
		{
			FileDefTO file = new FileDefTO();

			file.setContent(Util.readFileAsBytes(new File(baseDir, files[i])));
			file.setName(files[i]);

			importFiles[i] = file;
		}

		info.setFiles(importFiles);

		return config().deployTask.importCustom(info);
	}

	/** <!-- ================================================================================================== -->
	* Export the information and save the results in the specified directory. The files will be
	* saved using the default names.
	*
	* @lastrev fix41718 - Make import/export feature human friendly
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	public String export(final ExportItem[] toExport, final File outputDir) throws Exception
	{
		final FileDefTO result = config().deployTask.export(toExport);
		if (result == null)
			return null;

		final StringBuffer fileNames = new StringBuffer(64);//NOSONAR Synchronized class used, compiled java 1.5
		doExport(result, outputDir, fileNames);

		return fileNames.toString();
	}

	/** <!-- ================================================================================================== -->
	* @lastrev fix41664 - Fix the ExportResult BaseData structure
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	private void doExport(final FileDefTO fileDef, final File outputDir, final StringBuffer fileNames) throws Exception
	{
		if (fileDef == null)
			return;

		final File outputFile = new File(outputDir, fileDef.getName());

		if (fileNames.length() != 0)
			fileNames.append(", ");

		fileNames.append(fileDef.getName());

		if (Util.isBlank(fileDef.getContent()))
			throw new Exception("File is Empty: " + fileDef.getName());

		final FileOutputStream output = new FileOutputStream(outputFile);
		try
		{
			output.write(fileDef.getContent());
		}
		finally
		{
			output.close();
		}
	}
}
