//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.soapstation;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;

import javax.xml.rpc.ServiceException;

import com.actional.soapapi.Config;
import com.actional.soapstation.task.IAccessPointTask;
import com.actional.soapstation.task.IAccessPointTaskServiceLocator;
import com.actional.soapstation.task.IAdminTask;
import com.actional.soapstation.task.IAdminTaskServiceLocator;
import com.actional.soapstation.task.IApplicationTask;
import com.actional.soapstation.task.IApplicationTaskServiceLocator;
import com.actional.soapstation.task.ICertificateTask;
import com.actional.soapstation.task.ICertificateTaskServiceLocator;
import com.actional.soapstation.task.IConditionTask;
import com.actional.soapstation.task.IConditionTaskServiceLocator;
import com.actional.soapstation.task.IConsumerViewTask;
import com.actional.soapstation.task.IConsumerViewTaskServiceLocator;
import com.actional.soapstation.task.IDeploymentTask;
import com.actional.soapstation.task.IDeploymentTaskServiceLocator;
import com.actional.soapstation.task.IDirectoryServiceTask;
import com.actional.soapstation.task.IDirectoryServiceTaskServiceLocator;
import com.actional.soapstation.task.IEventLogTask;
import com.actional.soapstation.task.IEventLogTaskServiceLocator;
import com.actional.soapstation.task.IExportProfileTask;
import com.actional.soapstation.task.IExportProfileTaskServiceLocator;
import com.actional.soapstation.task.IExposeAsRestTask;
import com.actional.soapstation.task.IExposeAsRestTaskServiceLocator;
import com.actional.soapstation.task.IInterceptorTask;
import com.actional.soapstation.task.IInterceptorTaskServiceLocator;
import com.actional.soapstation.task.IJavaPlugInTask;
import com.actional.soapstation.task.IJavaPlugInTaskServiceLocator;
import com.actional.soapstation.task.ILicenseTask;
import com.actional.soapstation.task.ILicenseTaskServiceLocator;
import com.actional.soapstation.task.ILoggingDatabaseTask;
import com.actional.soapstation.task.ILoggingDatabaseTaskServiceLocator;
import com.actional.soapstation.task.IMonitoringTask;
import com.actional.soapstation.task.IMonitoringTaskServiceLocator;
import com.actional.soapstation.task.IMsgFieldTask;
import com.actional.soapstation.task.IMsgFieldTaskServiceLocator;
import com.actional.soapstation.task.IOAuth10Task;
import com.actional.soapstation.task.IOAuth10TaskServiceLocator;
import com.actional.soapstation.task.IOAuth20Task;
import com.actional.soapstation.task.IOAuth20TaskServiceLocator;
import com.actional.soapstation.task.IPolicyGroupTask;
import com.actional.soapstation.task.IPolicyGroupTaskServiceLocator;
import com.actional.soapstation.task.IRoleTask;
import com.actional.soapstation.task.IRoleTaskServiceLocator;
import com.actional.soapstation.task.IRuleTask;
import com.actional.soapstation.task.IRuleTaskServiceLocator;
import com.actional.soapstation.task.ISecurityContract2Task;
import com.actional.soapstation.task.ISecurityContract2TaskServiceLocator;
import com.actional.soapstation.task.ISecurityContractTask;
import com.actional.soapstation.task.ISecurityContractTaskServiceLocator;
import com.actional.soapstation.task.ISecurityTask;
import com.actional.soapstation.task.ISecurityTaskServiceLocator;
import com.actional.soapstation.task.IServiceDescriptionLanguageTask;
import com.actional.soapstation.task.IServiceDescriptionLanguageTaskServiceLocator;
import com.actional.soapstation.task.IServiceTask;
import com.actional.soapstation.task.IServiceTaskServiceLocator;
import com.actional.soapstation.task.ISiteCriteriaTask;
import com.actional.soapstation.task.ISiteCriteriaTaskServiceLocator;
import com.actional.soapstation.task.ITransportsTask;
import com.actional.soapstation.task.ITransportsTaskServiceLocator;
import com.actional.soapstation.task.IUDDITask;
import com.actional.soapstation.task.IUDDITaskServiceLocator;
import com.actional.soapstation.task.IWsdlTask;
import com.actional.soapstation.task.IWsdlTaskServiceLocator;

/** <!-- ========================================================================================================== -->
* This class provides typical services exposed by SOAPstation.
* @lastrev fix41425 - Create runtime support for OAuth 2.0
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class SSTConfig extends Config
{
	/** <!-- ================================================================================================== -->
	* The Locators for the task services
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected IAccessPointTaskServiceLocator	apTaskLocator = new IAccessPointTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IAdminTaskServiceLocator		adminTaskLocator = new IAdminTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IApplicationTaskServiceLocator	appTaskLocator = new IApplicationTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected ICertificateTaskServiceLocator	certTaskLocator = new ICertificateTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IConditionTaskServiceLocator		condTaskLocator = new IConditionTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IConsumerViewTaskServiceLocator	consumerTaskLocator = new IConsumerViewTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IDeploymentTaskServiceLocator		deploymentTaskLocator = new IDeploymentTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IDirectoryServiceTaskServiceLocator	dirTaskLocator = new IDirectoryServiceTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IInterceptorTaskServiceLocator	interceptorTaskLocator = new IInterceptorTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IJavaPlugInTaskServiceLocator		javaPluginTaskLocator = new IJavaPlugInTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected ILicenseTaskServiceLocator		licenseTaskLocator = new ILicenseTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IMonitoringTaskServiceLocator		monitoringTaskLocator = new IMonitoringTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IMsgFieldTaskServiceLocator		msgFieldTaskLocator = new IMsgFieldTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IPolicyGroupTaskServiceLocator	policyGroupTaskLocator = new IPolicyGroupTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IRoleTaskServiceLocator		roleTaskLocator = new IRoleTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected ISecurityContractTaskServiceLocator	secContractTaskLocator = new ISecurityContractTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected ISecurityContract2TaskServiceLocator	secContract2TaskLocator = new ISecurityContract2TaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected ISecurityTaskServiceLocator		secTaskLocator = new ISecurityTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IServiceTaskServiceLocator		serviceTaskLocator = new IServiceTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected ITransportsTaskServiceLocator		transportsTaskLocator = new ITransportsTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IUDDITaskServiceLocator		uddiTaskLocator = new IUDDITaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IWsdlTaskServiceLocator		wsdlTaskLocator = new IWsdlTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IServiceDescriptionLanguageTaskServiceLocator	sdlTaskLocator =
								new IServiceDescriptionLanguageTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IRuleTaskServiceLocator	ruleTaskLocator = new IRuleTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IEventLogTaskServiceLocator	eventLogTaskLocator = new IEventLogTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected ISiteCriteriaTaskServiceLocator	siteCriteriaTaskLocator =
								new ISiteCriteriaTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected ILoggingDatabaseTaskServiceLocator	loggingDatabaseTaskLocator =
								new ILoggingDatabaseTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IExposeAsRestTaskServiceLocator	exposeAsRestTaskLocator =
								new IExposeAsRestTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IOAuth10TaskServiceLocator	oAuth10TaskLocator =
								new IOAuth10TaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};
	protected IOAuth20TaskServiceLocator	oAuth20TaskLocator =
								new IOAuth20TaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	protected IExportProfileTaskServiceLocator	exportProfileTaskLocator =
								new IExportProfileTaskServiceLocator()
								{
									@Override
									public javax.xml.rpc.Call createCall()
										throws ServiceException
									{
										return prepareCall(super.createCall());
									}
								};

	/** <!-- ================================================================================================== -->
	* The Tasks
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public IAccessPointTask			apTask;
	public IAdminTask			adminTask;
	public IApplicationTask			appTask;
	public ICertificateTask			certTask;
	public IConditionTask			condTask;
	public IConsumerViewTask		consumerTask;
	public IDeploymentTask			deployTask;
	public IDirectoryServiceTask		dirTask;
	public IInterceptorTask			interceptorTask;
	public IJavaPlugInTask			javaPluginTask;
	public ILicenseTask			licenseTask;
	public IMonitoringTask			monitoringTask;
	public IMsgFieldTask			msgFieldTask;
	public IPolicyGroupTask			policyGroupTask;
	public IRoleTask			roleTask;
	public ISecurityContractTask		secContractTask;
	public ISecurityContract2Task		secContract2Task;
	public ISecurityTask			secTask;
	public IServiceTask			serviceTask;
	public ITransportsTask			transportsTask;
	public IUDDITask			uddiTask;
	public IWsdlTask			wsdlTask;
	public IServiceDescriptionLanguageTask	sdlTask;
	public IRuleTask			ruleTask;
	public IEventLogTask			eventLogTask;
	public ISiteCriteriaTask		siteCriteriaTask;
	public ILoggingDatabaseTask		loggingDatabaseTask;
	public IExposeAsRestTask		exposeAsRestTask;
	public IOAuth10Task			oAuth10Task;
	public IOAuth20Task			oAuth20Task;
	public IExportProfileTask		exportProfileTask;

	/** <!-- ================================================================================================== -->
	 * The default configuration to use when talking to the server.
	 * <!-- ------------------------------------------------------------------------------------------------- --> */

	protected static SSTConfig	itsDefaultConfig;

	public static synchronized SSTConfig getDefaultConfig()
	{
		return itsDefaultConfig;
	}

	public static synchronized void	setDefaultConfig(SSTConfig config)
	{
		itsDefaultConfig = config;
	}

	public static synchronized boolean setDefaultConfigIfNotSet(SSTConfig config)
	{
		if (itsDefaultConfig == null)
		{
			itsDefaultConfig = config;
			return true;
		}
		else
			return false;
	}

	/** <!-- ================================================================================================== -->
	 * Constructor
	 * <!-- ------------------------------------------------------------------------------------------------- --> */

	public SSTConfig()
	{
		// Use the default configuration.
		super(null, null, null);
	}

	public SSTConfig(String userName, String password, String endpoint)
	{
		super(userName, password, endpoint);
	}

	/** <!-- ================================================================================================== -->
	* Initialize the axis stubs.
	* @lastrev fix41425 - Create runtime support for OAuth 2.0
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	@Override
	protected void prepareTasks()
		throws ServiceException, MalformedURLException
	{
//		System.out.println("Connecting as '" + itsUserName + "' to SOAPstation at: " + itsEndpoint);

		super.prepareTasks();

		adminTask	= adminTaskLocator.getIAdminTask(		proxyUrl(adminTaskLocator.getIAdminTaskAddress()) );
		apTask		= apTaskLocator.getIAccessPointTask(		proxyUrl(apTaskLocator.getIAccessPointTaskAddress()) );
		appTask		= appTaskLocator.getIApplicationTask(		proxyUrl(appTaskLocator.getIApplicationTaskAddress()) );
		certTask	= certTaskLocator.getICertificateTask(		proxyUrl(certTaskLocator.getICertificateTaskAddress()) );
		condTask	= condTaskLocator.getIConditionTask(		proxyUrl(condTaskLocator.getIConditionTaskAddress()) );
		consumerTask	= consumerTaskLocator.getIConsumerViewTask(	proxyUrl(consumerTaskLocator.getIConsumerViewTaskAddress()) );
		deployTask	= deploymentTaskLocator.getIDeploymentTask(	proxyUrl(deploymentTaskLocator.getIDeploymentTaskAddress()) );
		dirTask		= dirTaskLocator.getIDirectoryServiceTask(	proxyUrl(dirTaskLocator.getIDirectoryServiceTaskAddress()) );
		interceptorTask	= interceptorTaskLocator.getIInterceptorTask(	proxyUrl(interceptorTaskLocator.getIInterceptorTaskAddress()) );
		javaPluginTask	= javaPluginTaskLocator.getIJavaPlugInTask(	proxyUrl(javaPluginTaskLocator.getIJavaPlugInTaskAddress()) );
		licenseTask	= licenseTaskLocator.getILicenseTask(		proxyUrl(licenseTaskLocator.getILicenseTaskAddress()) );
		monitoringTask	= monitoringTaskLocator.getIMonitoringTask(	proxyUrl(monitoringTaskLocator.getIMonitoringTaskAddress()) );
		msgFieldTask	= msgFieldTaskLocator.getIMsgFieldTask(		proxyUrl(msgFieldTaskLocator.getIMsgFieldTaskAddress()) );
		policyGroupTask	= policyGroupTaskLocator.getIPolicyGroupTask(	proxyUrl(policyGroupTaskLocator.getIPolicyGroupTaskAddress()) );
		roleTask	= roleTaskLocator.getIRoleTask(			proxyUrl(roleTaskLocator.getIRoleTaskAddress()) );
		secContractTask	= secContractTaskLocator.getISecurityContractTask(proxyUrl(secContractTaskLocator.getISecurityContractTaskAddress()) );
		secContract2Task	= secContract2TaskLocator.getISecurityContract2Task(proxyUrl(secContract2TaskLocator.getISecurityContract2TaskAddress()) );
		secTask		= secTaskLocator.getISecurityTask(		proxyUrl(secTaskLocator.getISecurityTaskAddress()) );
		serviceTask	= serviceTaskLocator.getIServiceTask(		proxyUrl(serviceTaskLocator.getIServiceTaskAddress()) );
		transportsTask	= transportsTaskLocator.getITransportsTask(	proxyUrl(transportsTaskLocator.getITransportsTaskAddress()) );
		uddiTask	= uddiTaskLocator.getIUDDITask(			proxyUrl(uddiTaskLocator.getIUDDITaskAddress()) );
		wsdlTask	= wsdlTaskLocator.getIWsdlTask(			proxyUrl(wsdlTaskLocator.getIWsdlTaskAddress()) );
		sdlTask		= sdlTaskLocator.getIServiceDescriptionLanguageTask(proxyUrl(sdlTaskLocator.getIServiceDescriptionLanguageTaskAddress()) );
		ruleTask		= ruleTaskLocator.getIRuleTask(proxyUrl(ruleTaskLocator.getIRuleTaskAddress()) );
		eventLogTask	= eventLogTaskLocator.getIEventLogTask(proxyUrl(eventLogTaskLocator.getIEventLogTaskAddress()) );
		siteCriteriaTask = siteCriteriaTaskLocator.getISiteCriteriaTask(proxyUrl(siteCriteriaTaskLocator.getISiteCriteriaTaskAddress()));
		loggingDatabaseTask = loggingDatabaseTaskLocator.getILoggingDatabaseTask(proxyUrl(loggingDatabaseTaskLocator.getILoggingDatabaseTaskAddress()));
		exposeAsRestTask = exposeAsRestTaskLocator.getIExposeAsRestTask(proxyUrl(exposeAsRestTaskLocator.getIExposeAsRestTaskAddress()));
		oAuth10Task = oAuth10TaskLocator.getIOAuth10Task(proxyUrl(oAuth10TaskLocator.getIOAuth10TaskAddress()));
		oAuth20Task = oAuth20TaskLocator.getIOAuth20Task(proxyUrl(oAuth20TaskLocator.getIOAuth20TaskAddress()));
		exportProfileTask = exportProfileTaskLocator.getIExportProfileTask(proxyUrl(exportProfileTaskLocator.getIExportProfileTaskAddress()));

		prepareStub(adminTask);
		prepareStub(apTask);
		prepareStub(appTask);
		prepareStub(certTask);
		prepareStub(condTask);
		prepareStub(consumerTask);
		prepareStub(deployTask);
		prepareStub(dirTask);
		prepareStub(interceptorTask);
		prepareStub(javaPluginTask);
		prepareStub(licenseTask);
		prepareStub(monitoringTask);
		prepareStub(msgFieldTask);
		prepareStub(policyGroupTask);
		prepareStub(roleTask);
		prepareStub(secContractTask);
		prepareStub(secContract2Task);
		prepareStub(secTask);
		prepareStub(serviceTask);
		prepareStub(transportsTask);
		prepareStub(uddiTask);
		prepareStub(wsdlTask);
		prepareStub(sdlTask);
		prepareStub(ruleTask);
		prepareStub(eventLogTask);
		prepareStub(siteCriteriaTask);
		prepareStub(loggingDatabaseTask);
		prepareStub(exposeAsRestTask);
		prepareStub(oAuth10Task);
		prepareStub(oAuth20Task);
		prepareStub(exportProfileTask);
	}

	/** <!-- ================================================================================================== -->
	* Prepare the task in the SDK. These are tasks on the client side to simplify server operations.
	*
	* @param taskClass	Subclass of SSTTask
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public synchronized SSTTask createTask(Class taskClass) throws Exception
	{
		SSTTask task = (SSTTask)itsTaskCache.get(taskClass);

		if (task != null)
			return task;

		try
		{
			task = (SSTTask)taskClass.newInstance();
			task.setConfig(this);
			itsTaskCache.put(taskClass, task);

			return task;
		}
		catch (Exception e)
		{
			throw new Exception("Failed to instanciate class: " + taskClass.getName(), e);
		}
	}

	protected Map itsTaskCache = new HashMap();
}
