//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================
package com.actional.soapapi.soapstation;

import com.actional.config.Blob;
import com.actional.soapstation.task.ServiceDescriptionLanguageParseInput;
import com.actional.soapstation.task.WsdlContentDef;
import com.actional.ws.db.WsMetadata;
import com.actional.ws.db.WsResource;

/** <!-- ========================================================================================================== -->
* Helper methods for parsing WSDL and WADL.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class SdlTask extends WsdlTask
{
	/** <!-- ================================================================================================== -->
	* Load the specified WSDL/WADL file and ask AI to parse it.
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public WsdlContentDef parseSDL(String urlToSdl, boolean ignoreProxy) throws Exception
	{
		WsMetadata wsMetaData = new WsMetadata();
		wsMetaData.setLocation(urlToSdl);
		wsMetaData.setIgnoreProxySettings(Boolean.valueOf(ignoreProxy));
		
		ServiceDescriptionLanguageParseInput input = new ServiceDescriptionLanguageParseInput();
		input.setMetadata(wsMetaData);
		input.setReturnXmlTypes(true);
		input.setReturnMetadata(true);

		return config().sdlTask.parse(input);
	}

	/** <!-- ================================================================================================== -->
	* Load the specified WSDL/WADL file and ask AI to parse it.
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	public WsdlContentDef parseSDL(byte[] content) throws Exception
	{
		// Parse and extract all the ports.
		Blob wsdlContent = new Blob();
		wsdlContent.setBytes(content);

		WsResource wsresource = new WsResource();
		wsresource.setContent(wsdlContent);

		WsMetadata wsmetadata = new WsMetadata();
		wsmetadata.setResources(new WsResource[1]);
		wsmetadata.getResources()[0] = wsresource;
		
		ServiceDescriptionLanguageParseInput input = new ServiceDescriptionLanguageParseInput();
		input.setMetadata(wsmetadata);
		input.setReturnXmlTypes(true);
		input.setReturnMetadata(true);

		return config().sdlTask.parse(input);
	}
}