//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.anttask.soapstation;

import com.actional.soapapi.soapstation.ServiceTask;
import com.actional.soapapi.anttask.IBaseDataKeyID;

/** <!-- ========================================================================================================== -->
* Create a new {@link com.actional.soapstation.db.SvcGroup}.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class CreateSvcGroupTask extends SOAPstationTaskBase implements IBaseDataKeyID
{
	private String itsSvcGroupID;

	//=============================================================================================================
	// The ant task Properties
	//=============================================================================================================

	protected ServiceTask.GroupCreationInfo itsGroupConfig = new ServiceTask.GroupCreationInfo();

	public void setName(String val)			{ itsGroupConfig.groupName = val; }
	public void setCategory(String val)		{ itsGroupConfig.category = val; }
	public void setUniqueKey(String val)		{ itsGroupConfig.uniqueKey = val; }
	public void setWsdlUrl(String val)		{ itsGroupConfig.wsdlUrl = val; }
	public void setApplicationName(String val)	{ itsGroupConfig.applicationName = val; }
	public void setListenerName(String val)		{ itsGroupConfig.listenerName = val; }
	public void setSenderName(String val)		{ itsGroupConfig.senderName = val; }
	public void setIgnoreProxy(boolean val)	{itsGroupConfig.setIgnoreProxy(val); }

	public void addConfiguredApOperation(APOperation val)
	{
		if (val == null)
			return;

		if (itsGroupConfig.apOperations == null)
			itsGroupConfig.apOperations = new java.util.Vector();

		itsGroupConfig.apOperations.add(val.getName());
	}

	/** <!-- ========================================================================================================== -->
	* Configuration an AccessPoint operation name.
	* <!-- --------------------------------------------------------------------------------------------------------- --> */

	public static class APOperation extends org.apache.tools.ant.ProjectComponent
	{
		protected String	itsName;

		public void setName(String val)	{ itsName = val; }
		public String getName()		{ return itsName; }
	}

	/** <!-- ================================================================================================== -->
	* Do the work
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	@Override
	public void executeEx() throws Exception
	{
		ServiceTask svcTask = (ServiceTask)createTask(ServiceTask.class);

		itsSvcGroupID = svcTask.createPassThroughGroup(itsGroupConfig);

		log("Created Service Group '" + itsGroupConfig.groupName + "' KeyID: " + getKeyID());
	}

	/** <!-- ================================================================================================== -->
	* IBaseDataKeyID interface
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	public String getKeyID()
	{
		return itsSvcGroupID;
	}
}

