//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.anttask.soapstation;

import java.util.ArrayList;
import java.util.List;

import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Reference;

import com.actional.config.BaseData;
import com.actional.deployment.ExportProfile;
import com.actional.soapapi.Config;
import com.actional.soapapi.Util;
import com.actional.soapapi.anttask.TaskBase;
import com.actional.soapstation.db.ExportItem;
import com.actional.soapstation.db.ExportItemEntry;
import com.actional.soapstation.task.ExportType;

/** <!-- ========================================================================================================== -->
* Configuration for an item being exported.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class ExportItemType extends ProjectComponent
{
	//=============================================================================================================
	// The ant task Properties
	//=============================================================================================================

	protected ExportType	itsExportType;
	protected List		itsIds;
	private String		itsProfileName;

	public void setType(String val)
	{
		itsExportType = ExportType.fromString(val);
	}

	public void setProfileName(String profileName)
	{
		itsProfileName = profileName;
	}

	public void addBaseData(Reference val)
	{
		if (itsIds == null)
			itsIds = new ArrayList();

		itsIds.add(val);
	}

	//=============================================================================================================
	// DataType
	//=============================================================================================================

	/** <!-- ================================================================================================== -->
	* Populates the list of export items.
	* <!-- ------------------------------------------------------------------------------------------------- --> */
	public void populate(Config config, List exportItems) throws Exception
	{
		if (itsExportType == null && itsProfileName == null)
			throw new IllegalStateException("Missing requirement type or profileName attribute");

		if (itsExportType == null)
		{
			if (itsIds != null && !itsIds.isEmpty())
			{
				throw new IllegalStateException("The elements to export cannot be specified along " +
						"with the profileName attribute");
			}

			// Find the export profile by name
			ExportProfile epTpl = new ExportProfile();
			epTpl.setKeyName(itsProfileName);
			BaseData[] bds = config.configTask.find(epTpl);

			if (bds == null || bds.length == 0)
			{
				throw new IllegalStateException(
						"Could not find the profile of name \"" + itsProfileName + "\"");
			}

			if (bds.length != 1)
			{
				throw new IllegalStateException("Ambiguous profile name \"" + itsProfileName +
						"\": found " + bds.length + " profiles");
			}

			// Get the export items of the export profile, and them to the list of export items
			ExportProfile exportProfile = (ExportProfile)config.configTask.get(bds[0].getKeyID());

			ExportItem[] expItems = exportProfile.getItems();
			if (expItems == null || expItems.length == 0)
				return;

			for (int i = 0; i < expItems.length; ++i)
			{
				ExportItem expItem = new ExportItem();
				expItem.setKeyID(expItems[i].getKeyID());
				Util.setAsLeaf(expItem);
				exportItems.add(expItem);
			}
		}
		else
		{
			ExportItem exportItem = new ExportItem();
			exportItem.setType(itsExportType);

			if (Util.isBlank(itsIds))
			{
				ExportItemEntry[] entries = {new ExportItemEntry()};
				exportItem.setEntries(entries);
			}
			else
			{
				ExportItemEntry[] entries = new ExportItemEntry[itsIds.size()];

				for (int i = 0; i < itsIds.size(); i++)
				{
					ExportItemEntry entry = new ExportItemEntry();
					entry.setId(TaskBase.locateBaseDataID(getProject(), (Reference)itsIds.get(i)));
					entries[i] = entry;
				}

				exportItem.setEntries(entries);
			}

			exportItems.add(exportItem);
		}
	}
}
