//=====================================================================================================================
// Copyright (c) 2016-2017. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
//=====================================================================================================================

package com.actional.soapapi.anttask.soapstation;

import com.actional.config.BaseData;
import com.actional.soapstation.db.AccessPointNode;
import com.actional.soapstation.db.SvcGroup;
import org.apache.tools.ant.types.Reference;

/** <!-- ========================================================================================================== -->
* Find the first {@link com.actional.soapstation.db.AccessPointNode} which meets the criteria.
* <!-- --------------------------------------------------------------------------------------------------------- --> */

public class FindFirstAccessPointTask extends FindFirstTask
{
	public FindFirstAccessPointTask()
	{
		itsToFind = new AccessPointNode();
	}

	//=============================================================================================================
	// The ant task Properties
	//=============================================================================================================

	protected AccessPointNode itsToFind;

	public void setName(String val)			{ itsToFind.setKeyName(val); }
	public void setUniqueKey(String val)		{ itsToFind.setUniqueKey(val); }
	public void setSvcGroup(Reference val)
	{
		String keyID = locateBaseDataID(val);

		if (val == null)
			itsToFind.setSvcGroup(null);
		else
		{
			SvcGroup g = new SvcGroup();

			g.setKeyID(keyID);
			itsToFind.setSvcGroup(g);
		}
	}

	/** <!-- ================================================================================================== -->
	* Implement FindFirstTask
	* <!-- ------------------------------------------------------------------------------------------------- --> */

	protected BaseData toFind()
	{
		return itsToFind;
	}
}

